/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.instability;

import com.xcompwiz.mystcraft.api.instability.IInstabilityProvider;
import com.xcompwiz.mystcraft.config.MystConfig;
import com.xcompwiz.mystcraft.instability.Deck;
import com.xcompwiz.mystcraft.instability.InstabilityProfiler;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;

public class InstabilityManager {
    private static HashMap<String, IInstabilityProvider> providers = new HashMap();
    private static HashMap<String, Integer> cardcosts = new HashMap();
    private static HashMap<String, Integer> cardcounts = new HashMap();
    private static Configuration config;
    private static InstabilityProfiler profiler;
    private static HashSet<String> errored;
    private static HashSet<String> warned;
    private static HashMap<String, List<String>> deckcards;
    private static HashMap<String, Integer> deckcosts;
    private static int smallestcost;

    public static void setConfig(MystConfig mystconfig) {
        config = mystconfig;
    }

    public static boolean registerProvider(String identifier, IInstabilityProvider provider, int activationcost) {
        if (identifier == null || identifier.length() == 0) {
            LoggerUtils.error(String.format("Attempting to bind instability provider with null or zero length identifier.", new Object[0]), new Object[0]);
            return false;
        }
        if (providers.get(identifier) != null) {
            LoggerUtils.warn(String.format("Instability with Identifier %s already bound", identifier), new Object[0]);
        }
        if (config != null && !config.get("instability", identifier.toLowerCase().replace(' ', '_') + ".enabled", true).getBoolean(true)) {
            return false;
        }
        providers.put(identifier, provider);
        cardcosts.put(identifier, activationcost);
        if (activationcost > 0 && activationcost < smallestcost) {
            smallestcost = activationcost;
        }
        if (config != null && config.hasChanged()) {
            config.save();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void profile(String identifier) {
        IInstabilityProvider provider = providers.get(identifier);
        if (provider == null) {
            return;
        }
        profiler.startProfiling(provider);
        try {
            provider.addEffects(profiler, cardcounts.get(identifier));
        }
        catch (Exception e) {
            LoggerUtils.error(String.format("Exception encountered when profiling instability provider with identifier %s.", identifier), new Object[0]);
            LoggerUtils.error(e.toString(), new Object[0]);
            e.printStackTrace();
            errored.add(identifier);
            InstabilityManager.unregisterProvider(identifier, provider);
        }
        finally {
            profiler.endProfiling(provider);
        }
    }

    private static void unregisterProvider(String identifier, IInstabilityProvider provider) {
        if (providers.get(identifier) == provider) {
            providers.remove(identifier);
        }
    }

    public static int getSmallestCost() {
        return smallestcost;
    }

    public static IInstabilityProvider getProvider(String identifier) {
        IInstabilityProvider provider = providers.get(identifier);
        if (provider == null && warned.add(identifier)) {
            LoggerUtils.error(String.format("No Instability match for identifier %s.  Are all of the Instability Providers loaded?", identifier), new Object[0]);
        }
        return provider;
    }

    public static Collection<String> getAllProviders() {
        return Collections.unmodifiableCollection(providers.keySet());
    }

    public static void addCards(String deckname, List<String> cards) {
        if (!deckcosts.containsKey(deckname)) {
            throw new RuntimeException("Attempting to register card to unregistered deck");
        }
        List<String> deck = deckcards.get(deckname);
        if (deck == null) {
            deck = new ArrayList<String>();
            deckcards.put(deckname, deck);
        }
        HashSet<String> newcards = new HashSet<String>();
        for (String card : cards) {
            if (InstabilityManager.getProvider(card) == null) {
                LoggerUtils.error(String.format("Attempting to register card for unmatched identifier %s to deck %s.", card, deckname), new Object[0]);
                continue;
            }
            Integer v = cardcounts.get(card);
            if (v == null) {
                v = 0;
            }
            cardcounts.put(card, v + 1);
            deck.add(card);
            newcards.add(card);
        }
        for (String provider : newcards) {
            InstabilityManager.profile(provider);
        }
    }

    public static void addCards(String deckname, String ... cards) {
        InstabilityManager.addCards(deckname, Arrays.asList(cards));
    }

    public static void addCards(String deckname, String card, int count) {
        InstabilityManager.addCards(deckname, Collections.nCopies(count, card));
    }

    public static Collection<Deck> createDecks() {
        ArrayList<Deck> decks = new ArrayList<Deck>();
        for (Map.Entry<String, List<String>> entry : deckcards.entrySet()) {
            decks.add(new Deck(entry.getKey(), (Collection<String>)entry.getValue()));
        }
        return decks;
    }

    public static int getCardCost(String card) {
        Integer val = cardcosts.get(card);
        if (val == null) {
            return 0;
        }
        return val;
    }

    public static void setDeckCost(String deckname, int cost) {
        deckcosts.put(deckname, cost);
    }

    public static int getDeckCost(String deckname) {
        Integer val = deckcosts.get(deckname);
        if (val == null) {
            return 0;
        }
        return val;
    }

    public static Collection<String> getDecks() {
        return deckcosts.keySet();
    }

    static {
        profiler = new InstabilityProfiler();
        errored = new HashSet();
        warned = new HashSet();
        deckcards = new HashMap();
        deckcosts = new HashMap();
        smallestcost = 500;
    }
}

