/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.fluidconverters;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.fluidconverters.config.FluidElement;
import org.cyclops.fluidconverters.config.FluidGroup;
import org.cyclops.fluidconverters.config.FluidGroupRegistry$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.FloatRef;

public final class FluidColorAnalyzer$ {
    public static final FluidColorAnalyzer$ MODULE$;
    private final Map<Fluid, Object> colors;
    private final Map<FluidGroup, Object> groupColors;
    private final int DEFAULT;

    static {
        new FluidColorAnalyzer$();
    }

    public Map<Fluid, Object> colors() {
        return this.colors;
    }

    public Map<FluidGroup, Object> groupColors() {
        return this.groupColors;
    }

    public final int DEFAULT() {
        return 0xFFFFFF;
    }

    public void init() {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            this.colors().put((Object)fluid, (Object)BoxesRunTime.boxToInteger((int)this.calculateAverageColor(fluid)));
        }
        for (FluidGroup group : FluidGroupRegistry$.MODULE$.getGroups()) {
            this.groupColors().put((Object)group, (Object)BoxesRunTime.boxToInteger((int)this.calculateAverageColor(group)));
        }
    }

    public int getAverageColor(FluidGroup fluidGroup) {
        Option option;
        block4: {
            int n;
            block3: {
                block2: {
                    int i;
                    option = this.groupColors().get((Object)fluidGroup);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    n = i = BoxesRunTime.unboxToInt((Object)some.x());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                n = 0xFFFFFF;
            }
            return n;
        }
        throw new MatchError((Object)option);
    }

    private int calculateAverageColor(FluidGroup fluidGroup) {
        FloatRef r = FloatRef.create((float)0.0f);
        FloatRef g = FloatRef.create((float)0.0f);
        FloatRef b = FloatRef.create((float)0.0f);
        Predef$.MODULE$.refArrayOps((Object[])fluidGroup.getFluidElements()).foreach((Function1)new Serializable(r, g, b){
            private final FloatRef r$1;
            private final FloatRef g$1;
            private final FloatRef b$1;

            public final void apply(FluidElement element) {
                Fluid fluid = element.getFluid();
                int color = FluidColorAnalyzer$.MODULE$.getAverageColor(fluid);
                this.r$1.elem += (float)(-color >> 16 & 0xFF) / 255.0f;
                this.g$1.elem += (float)(-color >> 8 & 0xFF) / 255.0f;
                this.b$1.elem += (float)(-color & 0xFF) / 255.0f;
            }
            {
                this.r$1 = r$1;
                this.g$1 = g$1;
                this.b$1 = b$1;
            }
        });
        int l = fluidGroup.getFluidElements().length;
        r.elem /= (float)l;
        g.elem /= (float)l;
        b.elem /= (float)l;
        return (int)(r.elem * (float)255) << 16 | (int)(g.elem * (float)255) << 8 | (int)(b.elem * (float)255);
    }

    public int getAverageColor(Fluid fluid) {
        Option option;
        block4: {
            int n;
            block3: {
                block2: {
                    int i;
                    option = this.colors().get((Object)fluid);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    n = i = BoxesRunTime.unboxToInt((Object)some.x());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                n = 0xFFFFFF;
            }
            return n;
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    private int calculateAverageColor(Fluid fluid) {
        IIcon icon;
        int n;
        block5: {
            n = fluid.getColor();
            icon = null;
            try {
                icon = fluid.getIcon(new FluidStack(fluid, 1));
                if (icon == null) {
                    icon = fluid.getBlock().func_149691_a(0, 0);
                }
                if (icon != null) break block5;
                return n;
            }
            catch (NullPointerException nullPointerException) {
                void var2_2;
                return (int)var2_2;
            }
        }
        BufferedImage image = this.readIcon(icon);
        if (image == null) {
            return n;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int[] matrix = new int[width * height];
        image.getRGB(0, 0, width, height, matrix, 0, width);
        if (matrix.length == 0) {
            return n;
        }
        FloatRef r = FloatRef.create((float)0.0f);
        FloatRef g = FloatRef.create((float)0.0f);
        FloatRef b = FloatRef.create((float)0.0f);
        Predef$.MODULE$.intArrayOps(matrix).foreach((Function1)new Serializable(r, g, b){
            private final FloatRef r$2;
            private final FloatRef g$2;
            private final FloatRef b$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.r$2.elem += (float)(-i >> 16 & 0xFF) / 255.0f;
                this.g$2.elem += (float)(-i >> 8 & 0xFF) / 255.0f;
                this.b$2.elem += (float)(-i & 0xFF) / 255.0f;
            }
            {
                this.r$2 = r$2;
                this.g$2 = g$2;
                this.b$2 = b$2;
            }
        });
        r.elem /= (float)matrix.length;
        g.elem /= (float)matrix.length;
        b.elem /= (float)matrix.length;
        return (int)(r.elem * (float)255) << 16 | (int)(g.elem * (float)255) << 8 | (int)(b.elem * (float)255);
    }

    private BufferedImage readIcon(IIcon icon) {
        String iconName = icon.func_94215_i();
        String iconDomain = "minecraft";
        String iconPath = iconName;
        int index = iconPath.indexOf(58);
        if (index >= 0) {
            iconPath = iconName.substring(index + 1, iconName.length());
            if (index > 1) {
                iconDomain = iconName.substring(0, index);
            }
        }
        try {
            ResourceLocation resourceLocation = new ResourceLocation(iconDomain.toLowerCase(), new StringOps(Predef$.MODULE$.augmentString("textures/blocks/%s.png")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{iconPath})));
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
            return ImageIO.read(resource.func_110527_b());
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private FluidColorAnalyzer$() {
        MODULE$ = this;
        this.colors = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.groupColors = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

