/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.fluidconverters.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import org.cyclops.fluidconverters.FluidColorAnalyzer$;
import org.cyclops.fluidconverters.config.FluidGroup;
import org.cyclops.fluidconverters.config.FluidGroupRegistry$;
import org.cyclops.fluidconverters.tileentity.TileEntityFluidConverter;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class BlockFluidConverter$
extends BlockContainer {
    public static final BlockFluidConverter$ MODULE$;
    private final String NAMEDID;
    private final String NBTKEY_GROUP;
    private final String NBTKEY_SIDE;
    private final String NBTKEY_UNITS;
    private NBTTagCompound NBT_CACHE;
    private int COLOR_CACHE;

    static {
        new BlockFluidConverter$();
    }

    public final String NAMEDID() {
        return "FluidConverter";
    }

    public final String NBTKEY_GROUP() {
        return "fluidGroupId";
    }

    public final String NBTKEY_SIDE() {
        return "fluidSide%s";
    }

    public final String NBTKEY_UNITS() {
        return "units";
    }

    private NBTTagCompound NBT_CACHE() {
        return this.NBT_CACHE;
    }

    private void NBT_CACHE_$eq(NBTTagCompound x$1) {
        this.NBT_CACHE = x$1;
    }

    public int COLOR_CACHE() {
        return this.COLOR_CACHE;
    }

    public void COLOR_CACHE_$eq(int x$1) {
        this.COLOR_CACHE = x$1;
    }

    private String getUniqueName() {
        return "blocks.fluidConverter";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        ((Block)this).field_149761_L = iconRegister.func_94245_a(new StringBuilder().append((Object)this.func_149641_N()).append((Object)"_open").toString());
    }

    public String func_149641_N() {
        return new StringOps(Predef$.MODULE$.augmentString("%s:%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fluidconverters", "fluidConverter"}));
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFluidConverter();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void addGroupInfo(ItemStack itemStack, FluidGroup fluidGroup) {
        String groupId = fluidGroup.getGroupId();
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74778_a("fluidGroupId", groupId);
        itemStack.func_77982_d(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List<?> list) {
        List<?> itemList = list;
        FluidGroupRegistry$.MODULE$.getGroups().foreach((Function1)new Serializable(itemList){
            private final List itemList$1;

            public final boolean apply(FluidGroup fluidGroup) {
                ItemStack itemStack = new ItemStack((Block)BlockFluidConverter$.MODULE$);
                BlockFluidConverter$.MODULE$.addGroupInfo(itemStack, fluidGroup);
                return this.itemList$1.add(itemStack);
            }
            {
                this.itemList$1 = itemList$1;
            }
        });
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (world.func_147438_o(x, y, z) != null) {
            TileEntityFluidConverter tile = (TileEntityFluidConverter)world.func_147438_o(x, y, z);
            if (stack.func_77978_p() != null) {
                tile.readConverterDataFromNBT(stack.func_77978_p());
                tile.sendUpdate();
            }
        }
        super.func_149689_a(world, x, y, z, entity, stack);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float xPos, float yPos, float zPos) {
        ItemStack item = player.field_71071_by.func_70448_g();
        TileEntityFluidConverter tile = (TileEntityFluidConverter)world.func_147438_o(x, y, z);
        if (item != null && FluidContainerRegistry.isFilledContainer((ItemStack)item)) {
            Fluid fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item).getFluid();
            if (tile.getFluidGroup() != null && tile.getFluidGroup().getFluidElement(fluid) != null) {
                tile.setFluid(ForgeDirection.getOrientation((int)side), fluid);
            }
        } else {
            tile.setFluid(ForgeDirection.getOrientation((int)side), null);
        }
        return true;
    }

    private void onPreBlockDestroyed(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityFluidConverter) {
            this.NBT_CACHE_$eq(((TileEntityFluidConverter)tile).getNBTTagCompound());
        } else {
            this.NBT_CACHE_$eq(null);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        this.onPreBlockDestroyed(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        this.onPreBlockDestroyed(world, x, y, z);
        super.func_149723_a(world, x, y, z, explosion);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileEntityFluidConverter tile = (TileEntityFluidConverter)world.func_147438_o(x, y, z);
        return FluidColorAnalyzer$.MODULE$.getAverageColor(tile.getFluidGroup());
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return this.COLOR_CACHE();
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack itemStack = new ItemStack(this.func_149650_a(metadata, world.field_73012_v, fortune), 1, this.func_149692_a(metadata));
        if (this.NBT_CACHE() != null) {
            itemStack.func_77982_d(this.NBT_CACHE());
        }
        drops.add(itemStack);
        return drops;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (world.func_147438_o(x, y, z) == null) {
            return super.getLightValue(world, x, y, z);
        }
        return ((TileEntityFluidConverter)world.func_147438_o(x, y, z)).luminosity();
    }

    private BlockFluidConverter$() {
        super(Material.field_151573_f);
        MODULE$ = this;
        this.func_149663_c(this.getUniqueName());
        this.func_149711_c(5.0f);
        this.NBT_CACHE = null;
        this.COLOR_CACHE = 0;
    }
}

