/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.fluidconverters.command;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CommandGetFluids
implements ICommand {
    private Collection<Fluid> getFluids() {
        return FluidRegistry.getRegisteredFluids().values();
    }

    public String func_71517_b() {
        return "getfluids";
    }

    public String func_71518_a(ICommandSender commandSender) {
        StringBuilder builder = new StringBuilder();
        for (Fluid fluid : this.getFluids()) {
            builder.append(fluid.getName());
        }
        return builder.toString();
    }

    public List func_71514_a() {
        return new LinkedList();
    }

    protected String getFluidName(Fluid fluid) {
        return fluid.getLocalizedName(new FluidStack(fluid, 1));
    }

    public void func_71515_b(ICommandSender commandSender, String[] astring) {
        if (astring.length == 1) {
            Fluid fluid = FluidRegistry.getFluid((String)astring[0]);
            if (fluid != null) {
                commandSender.func_145747_a((IChatComponent)new ChatComponentText(fluid.getName() + " (" + this.getFluidName(fluid) + ")"));
            }
        } else {
            StringBuilder builder = new StringBuilder();
            for (Fluid fluid : this.getFluids()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(fluid.getName());
                builder.append(" (");
                builder.append(this.getFluidName(fluid));
                builder.append(")");
            }
            commandSender.func_145747_a((IChatComponent)new ChatComponentText(builder.toString()));
        }
    }

    public boolean func_71519_b(ICommandSender commandSender) {
        return true;
    }

    public List func_71516_a(ICommandSender commandSender, String[] astring) {
        LinkedList<String> list = new LinkedList<String>();
        for (Fluid fluid : this.getFluids()) {
            if (astring.length != 0 && !fluid.getName().startsWith(astring[0])) continue;
            list.add(fluid.getName());
        }
        return list;
    }

    public boolean func_82358_a(String[] commandSender, int i) {
        return false;
    }

    public int compareTo(Object o) {
        return 0;
    }
}

