/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.fluidconverters.config;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.cyclops.fluidconverters.LoggerHelper$;
import org.cyclops.fluidconverters.config.FluidGroup;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConfigLoader$ {
    public static final ConfigLoader$ MODULE$;
    private final String BLOOD_TEMPLATE;
    private final String AQUALAVA_TEMPLATE;
    private final String RESOURCE_TEMPLATE_PATH_BLOOD;
    private final String RESOURCE_TEMPLATE_PATH_AQUALAVA;
    private final Pattern CONFIG_PATTERN;

    static {
        new ConfigLoader$();
    }

    public final String BLOOD_TEMPLATE() {
        return "blood.json";
    }

    public final String AQUALAVA_TEMPLATE() {
        return "_aqualava.json";
    }

    public final String RESOURCE_TEMPLATE_PATH_BLOOD() {
        return "/assets/fluidconverters/blood.json";
    }

    public final String RESOURCE_TEMPLATE_PATH_AQUALAVA() {
        return "/assets/fluidconverters/_aqualava.json";
    }

    public final Pattern CONFIG_PATTERN() {
        return this.CONFIG_PATTERN;
    }

    private void createTemplate(String configDirectory, String name, String path) {
        File template = new File(configDirectory, name);
        if (!template.exists()) {
            InputStream is = this.getClass().getResourceAsStream(path);
            FileUtils.copyInputStreamToFile((InputStream)is, (File)template);
        }
    }

    /*
     * WARNING - void declaration
     */
    public File init(String configDirectory) {
        void var2_2;
        File rootFolder = new File(configDirectory);
        Object object = rootFolder.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)rootFolder.mkdir());
        this.createTemplate(configDirectory, "blood.json", "/assets/fluidconverters/blood.json");
        this.createTemplate(configDirectory, "_aqualava.json", "/assets/fluidconverters/_aqualava.json");
        return var2_2;
    }

    public ListBuffer<FluidGroup> findFluidGroups(File rootFolder) {
        return this.findFluidGroups(rootFolder, rootFolder);
    }

    /*
     * WARNING - void declaration
     */
    private ListBuffer<FluidGroup> findFluidGroups(File rootFolder, File currentFolder) {
        void var3_3;
        ListBuffer configs = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])currentFolder.listFiles()).foreach((Function1)new Serializable(configs){
            private final ListBuffer configs$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object apply(File file) {
                ListBuffer listBuffer;
                if (file.isFile() && ConfigLoader$.MODULE$.CONFIG_PATTERN().matcher(file.getName()).matches()) {
                    try {
                        this.configs$1.$plus$eq((Object)ConfigLoader$.MODULE$.loadFluidGroup(file));
                        LoggerHelper$.MODULE$.log(new StringOps(Predef$.MODULE$.augmentString("Loaded config %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getName()})));
                        listBuffer = BoxedUnit.UNIT;
                        return listBuffer;
                    }
                    catch (JsonIOException jsonIOException) {
                        LoggerHelper$.MODULE$.log(Level.ERROR, new StringOps(Predef$.MODULE$.augmentString("Something went wrong while reading %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getName()})));
                        System.err.print((Object)((Object)jsonIOException));
                        listBuffer = BoxedUnit.UNIT;
                        return listBuffer;
                    }
                    catch (JsonSyntaxException jsonSyntaxException) {
                        LoggerHelper$.MODULE$.log(Level.ERROR, new StringOps(Predef$.MODULE$.augmentString("The config %s has an invalid syntax.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getName()})));
                        System.err.print((Object)((Object)jsonSyntaxException));
                        listBuffer = BoxedUnit.UNIT;
                        return listBuffer;
                    }
                } else {
                    if (file.isDirectory()) {
                        listBuffer = this.configs$1.$plus$plus$eq(ConfigLoader$.MODULE$.findFluidGroups(file));
                        return listBuffer;
                    }
                    LoggerHelper$.MODULE$.log(new StringOps(Predef$.MODULE$.augmentString("Skipped config %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getName()})));
                    listBuffer = BoxedUnit.UNIT;
                    return listBuffer;
                }
            }
            {
                this.configs$1 = configs$1;
            }
        });
        return var3_3;
    }

    public FluidGroup loadFluidGroup(File file) {
        Gson gson = new Gson();
        return (FluidGroup)gson.fromJson((Reader)new BufferedReader(new FileReader(file)), FluidGroup.class);
    }

    private ConfigLoader$() {
        MODULE$ = this;
        this.CONFIG_PATTERN = Pattern.compile("^[^_].*\\.json");
    }
}

