/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.fluidconverters.config;

import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Level;
import org.cyclops.fluidconverters.LoggerHelper$;
import org.cyclops.fluidconverters.block.BlockFluidConverter$;
import org.cyclops.fluidconverters.config.FluidElement;
import org.cyclops.fluidconverters.config.FluidGroup;
import org.cyclops.fluidconverters.config.FluidGroupRegistry$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;

public final class FluidGroupRegistry$ {
    public static final FluidGroupRegistry$ MODULE$;
    private final Map<String, FluidGroup> groups;

    static {
        new FluidGroupRegistry$();
    }

    public Map<String, FluidGroup> groups() {
        return this.groups;
    }

    public boolean registerGroup(FluidGroup group) {
        BooleanRef foundOne = BooleanRef.create((boolean)false);
        Predef$.MODULE$.refArrayOps((Object[])group.getFluidElements()).foreach((Function1)new Serializable(group, foundOne){
            private final FluidGroup group$1;
            private final BooleanRef foundOne$1;

            public final void apply(FluidElement element) {
                if (FluidRegistry.isFluidRegistered((String)element.getFluidName())) {
                    this.foundOne$1.elem = true;
                } else {
                    LoggerHelper$.MODULE$.log(Level.WARN, new StringOps(Predef$.MODULE$.augmentString("The fluid %s in group %s is not registered because it does not exist.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element.getFluidName(), this.group$1.getGroupId()})));
                }
            }
            {
                this.group$1 = group$1;
                this.foundOne$1 = foundOne$1;
            }
        });
        if (foundOne.elem) {
            this.groups().put((Object)group.getGroupId(), (Object)group);
            return true;
        }
        return false;
    }

    public FluidGroup getGroup(String groupId) {
        Option option;
        block4: {
            FluidGroup fluidGroup;
            block3: {
                block2: {
                    FluidGroup i;
                    option = this.groups().get((Object)groupId);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    fluidGroup = i = (FluidGroup)some.x();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                fluidGroup = null;
            }
            return fluidGroup;
        }
        throw new MatchError((Object)option);
    }

    public Iterable<FluidGroup> getGroups() {
        return this.groups().values();
    }

    public boolean isFluidRegistered(String fluidName) {
        return BoxesRunTime.unboxToBoolean((Object)this.groups().values().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new Serializable(fluidName){
            public final String fluidName$1;

            public final boolean apply(boolean prev, FluidGroup group) {
                return prev || BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.refArrayOps((Object[])group.getFluidElements()).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new Serializable(this){
                    private final /* synthetic */ anonfun.isFluidRegistered.1 $outer;

                    public final boolean apply(boolean prev2, FluidElement fluidElement) {
                        return prev2 || fluidElement.getFluidName().equals(this.$outer.fluidName$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.fluidName$1 = fluidName$1;
            }
        }));
    }

    public void registerRecipes() {
        this.groups().values().foreach((Function1)new Serializable(){

            public final void apply(FluidGroup group) {
                if (group.hasRecipe()) {
                    ItemStack result = new ItemStack((Block)BlockFluidConverter$.MODULE$);
                    BlockFluidConverter$.MODULE$.addGroupInfo(result, group);
                    Predef$.MODULE$.refArrayOps((Object[])group.getFluidElements()).foreach((Function1)new Serializable(this, result, group){
                        private final ItemStack result$1;
                        private final FluidGroup group$2;

                        public final void apply(FluidElement element) {
                            ItemStack container;
                            if (element.getFluid() != null && (container = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(element.getFluid(), 1000), (ItemStack)new ItemStack(Items.field_151133_ar))) != null) {
                                this.group$2.registerRecipe(this.result$1, container);
                            }
                        }
                        {
                            this.result$1 = result$1;
                            this.group$2 = group$2;
                        }
                    });
                }
            }
        });
    }

    private FluidGroupRegistry$() {
        MODULE$ = this;
        this.groups = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

