/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.API.Power;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.RotaryCraft.API.IOMachine;
import Reika.RotaryCraft.API.Interfaces.ComplexIO;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PowerTransferHelper {
    public static boolean checkPowerFrom(TileEntity tile, ForgeDirection dir) {
        WorldRift sr;
        WorldLocation loc;
        if (tile == null) {
            return false;
        }
        int x = tile.field_145851_c;
        int dx = x + dir.offsetX;
        int y = tile.field_145848_d;
        int dy = y + dir.offsetY;
        int z = tile.field_145849_e;
        int dz = z + dir.offsetZ;
        TileEntity toCheck = tile.field_145850_b.func_147438_o(dx, dy, dz);
        if (toCheck instanceof WorldRift && (loc = (sr = (WorldRift)toCheck).getLinkTarget()) != null) {
            return PowerTransferHelper.checkPowerFrom(loc.getTileEntity(), dir);
        }
        if (toCheck instanceof PowerGenerator || toCheck instanceof IOMachine) {
            if (toCheck instanceof ComplexIO) {
                int omega;
                ComplexIO cio = (ComplexIO)toCheck;
                int torque = cio.getTorqueToSide(dir.getOpposite());
                return torque * (omega = cio.getSpeedToSide(dir.getOpposite())) != 0;
            }
            if (toCheck instanceof IOMachine) {
                int wx = ((IOMachine)toCheck).getWriteX();
                int wy = ((IOMachine)toCheck).getWriteY();
                int wz = ((IOMachine)toCheck).getWriteZ();
                int wx2 = ((IOMachine)toCheck).getWriteX2();
                int wy2 = ((IOMachine)toCheck).getWriteY2();
                int wz2 = ((IOMachine)toCheck).getWriteZ2();
                return wx == x && wy == y && wz == z || wx2 == x && wy2 == y && wz2 == z;
            }
            int wx = ((PowerGenerator)toCheck).getEmittingX();
            int wy = ((PowerGenerator)toCheck).getEmittingY();
            int wz = ((PowerGenerator)toCheck).getEmittingZ();
            return wx == x && wy == y && wz == z;
        }
        return false;
    }

    public static boolean checkPowerFromAllSides(TileEntity tile, boolean vertical) {
        int i;
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        int n = i = vertical ? 0 : 2;
        while (i < 6) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            if (PowerTransferHelper.checkPowerFrom(tile, dir)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

