/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary;

import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class MachineEnchantmentHandler {
    private final HashMap<Enchantment, Integer> data = new HashMap();
    private final HashSet<Integer> filters = new HashSet();

    public MachineEnchantmentHandler addFilter(Enchantment e) {
        return this.addFilter(e.field_77352_x);
    }

    public MachineEnchantmentHandler addFilter(int id) {
        this.filters.add(id);
        return this;
    }

    public boolean hasEnchantment(Enchantment e) {
        return this.getEnchantment(e) > 0;
    }

    public int getEnchantment(Enchantment e) {
        Integer get = this.data.get(e);
        return get != null ? get : 0;
    }

    public boolean hasEnchantments() {
        return !this.data.isEmpty();
    }

    public boolean setEnchantment(Enchantment e, int level) {
        if (this.isEnchantValid(e)) {
            this.data.put(e, level);
            return true;
        }
        return false;
    }

    public void clear() {
        this.data.clear();
    }

    public NBTTagList writeToNBT() {
        NBTTagList li = new NBTTagList();
        for (Map.Entry<Enchantment, Integer> e : this.data.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("id", e.getKey().field_77352_x);
            tag.func_74768_a("lvl", e.getValue().intValue());
            li.func_74742_a((NBTBase)tag);
        }
        return li;
    }

    public void readFromNBT(NBTTagList NBT) {
        this.data.clear();
        for (Object o : NBT.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            Enchantment e = Enchantment.field_77331_b[tag.func_74762_e("id")];
            int lvl = tag.func_74762_e("lvl");
            this.data.put(e, lvl);
        }
    }

    public boolean isEnchantValid(Enchantment e) {
        return this.filters.isEmpty() || this.filters.contains(e.field_77352_x);
    }

    public boolean applyEnchants(ItemStack is) {
        boolean flag = false;
        for (Map.Entry e : ReikaEnchantmentHelper.getEnchantments((ItemStack)is).entrySet()) {
            Enchantment ec = (Enchantment)e.getKey();
            int has = this.getEnchantment(ec);
            if (has >= (Integer)e.getValue()) continue;
            flag |= this.setEnchantment(ec, (Integer)e.getValue());
        }
        return flag;
    }

    public ArrayList<Enchantment> getValidEnchantments() {
        ArrayList<Enchantment> li = new ArrayList<Enchantment>();
        for (int id : this.filters) {
            li.add(Enchantment.field_77331_b[id]);
        }
        return li;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return Collections.unmodifiableMap(this.data);
    }
}

