/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Instantiable.BasicModEntry;
import Reika.DragonAPI.Instantiable.Data.Collections.ChancedOutputList;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.IO.CustomRecipeList;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.HarvestCraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MagicCropHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.OreBerryBushHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModInteract.RecipeHandlers.ForestryRecipeHelper;
import Reika.DragonAPI.ModInteract.ReikaXPFluidHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.RotaryCraft.API.RecipeInterface;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.ExtractorModOres;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.Loader;
import forestry.api.recipes.ISqueezerRecipe;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.aspects.Aspect;

public class RecipesCentrifuge
extends RecipeHandler
implements RecipeInterface.CentrifugeManager {
    private static final RecipesCentrifuge CentrifugeBase = new RecipesCentrifuge();
    private ItemHashMap<CentrifugeRecipe> recipeList = new ItemHashMap().enableNBT();
    private ArrayList<ItemStack> outputs = new ArrayList();

    public static final RecipesCentrifuge getRecipes() {
        return CentrifugeBase;
    }

    private RecipesCentrifuge() {
        super(MachineRegistry.CENTRIFUGE);
        RecipeInterface.centrifuge = this;
        this.addRecipe(Items.field_151064_bs, null, RecipeHandler.RecipeLevel.PERIPHERAL, Items.field_151123_aH, 100, Items.field_151065_br, 100);
        this.addRecipe(Items.field_151127_ba, null, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack(Items.field_151081_bc, 4), 100);
        this.addRecipe(Blocks.field_150423_aK, null, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack(Items.field_151080_bb, 12), 100);
        this.addRecipe(Items.field_151015_O, null, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack(Items.field_151014_N, 4), 100);
        this.addRecipe(Blocks.field_150351_n, null, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack(Items.field_151145_ak), 50, new ItemStack((Block)Blocks.field_150354_m), 75);
        this.addRecipe(ItemStacks.netherrackdust, null, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack(Items.field_151114_aO), 25, new ItemStack(Items.field_151016_H), 80, ExtractorModOres.getSmeltedIngot(ModOreList.SULFUR), 40);
        this.addRecipe(Blocks.field_150346_d, null, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack((Block)Blocks.field_150354_m), 80, new ItemStack(Blocks.field_150435_aG), 10, new ItemStack(Items.field_151014_N), Float.valueOf(2.0f), new ItemStack(Items.field_151080_bb), Float.valueOf(0.125f), new ItemStack(Items.field_151081_bc), Float.valueOf(0.125f), new ItemStack(Blocks.field_150345_g), Float.valueOf(0.03125f), new ItemStack((Block)Blocks.field_150329_H, 1, 1), Float.valueOf(0.0625f));
        this.addRecipe(Items.field_151065_br, null, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack(Items.field_151016_H), 100, ExtractorModOres.getSmeltedIngot(ModOreList.SULFUR), 75);
        this.addRecipe(ItemStacks.sludge, (FluidOut)null, RecipeHandler.RecipeLevel.CORE, 2, new Object[]{ItemStacks.cleansludge, 80, ItemStacks.cleansludge, 20, ItemStacks.compost, 25});
        this.addRecipe(ItemStacks.slipperyComb, new FluidStack(FluidRegistry.getFluid((String)"rc lubricant"), 50), 60.0f, RecipeHandler.RecipeLevel.PROTECTED, ItemStacks.slipperyPropolis, 80);
        this.addRecipe(ItemStacks.slipperyPropolis, new FluidStack(FluidRegistry.getFluid((String)"rc lubricant"), 150), 100.0f, RecipeHandler.RecipeLevel.PROTECTED, new Object[0]);
        int amt = ReikaMathLibrary.roundUpToX((int)10, (int)((int)((float)DifficultyEffects.CANOLA.getAverageAmount() * 0.75f)));
        this.addRecipe(ItemStacks.canolaHusks, new FluidStack(FluidRegistry.getFluid((String)"rc lubricant"), amt), 100.0f, RecipeHandler.RecipeLevel.CORE, new Object[0]);
    }

    public void addRecipe(ItemStack in, ChancedOutputList out, FluidOut fs, RecipeHandler.RecipeLevel rl) {
        this.addRecipe(in, out, fs, rl, 1);
    }

    public void addRecipe(ItemStack in, ChancedOutputList out, FluidOut fs, RecipeHandler.RecipeLevel rl, int stack) {
        in = in.func_77946_l();
        in.field_77990_d = null;
        this.addDirectStackRecipe(in, out, fs, rl, stack);
    }

    private void addDirectStackRecipe(ItemStack in, ChancedOutputList out, FluidOut fs, RecipeHandler.RecipeLevel rl, int stack) {
        if (out.size() > 9) {
            throw new IllegalArgumentException("Too many output items for " + in.func_82833_r() + " centrifuge recipe; only 9 inventory slots!");
        }
        out.lock();
        for (ChancedOutputList.ItemWithChance isout : out.keySet()) {
            if (ReikaItemHelper.collectionContainsItemStack(this.outputs, (ItemStack)isout.getItem())) continue;
            this.outputs.add(isout.getItem());
        }
        CentrifugeRecipe rec = new CentrifugeRecipe(in, out, fs, stack);
        this.recipeList.put(in, (Object)rec);
        this.onAddRecipe(rec, rl);
    }

    private void addRecipe(ItemStack in, FluidOut fs, RecipeHandler.RecipeLevel rl, int stack, Object ... items) {
        this.addRecipe(in, ChancedOutputList.parseFromArray((boolean)true, (Object[])items), fs, rl, stack);
    }

    private void addRecipe(ItemStack in, FluidOut fs, RecipeHandler.RecipeLevel rl, Object ... items) {
        this.addRecipe(in, ChancedOutputList.parseFromArray((boolean)true, (Object[])items), fs, rl);
    }

    @Override
    public void addAPIRecipe(ItemStack item, FluidStack fs, float fc, Object ... items) {
        this.addRecipe(item, fs != null ? new FluidOut(fs, fc) : null, RecipeHandler.RecipeLevel.API, items);
    }

    private void addRecipe(ItemStack item, FluidStack fs, float fc, RecipeHandler.RecipeLevel rl, Object ... items) {
        this.addRecipe(item, new FluidOut(fs, fc), rl, items);
    }

    private void addRecipe(Block item, FluidOut fs, RecipeHandler.RecipeLevel rl, Object ... items) {
        this.addRecipe(new ItemStack(item), fs, rl, items);
    }

    private void addRecipe(Item item, FluidOut fs, RecipeHandler.RecipeLevel rl, Object ... items) {
        this.addRecipe(new ItemStack(item), fs, rl, items);
    }

    public CentrifugeRecipe getRecipeResult(ItemStack item) {
        if (item == null) {
            return null;
        }
        ItemStack in = item.func_77946_l();
        CentrifugeRecipe cr = (CentrifugeRecipe)this.recipeList.get(in);
        if (cr != null && cr.hasNBT && !ItemStack.func_77970_a((ItemStack)item, (ItemStack)cr.in)) {
            return null;
        }
        return cr;
    }

    private Collection<ItemStack> getRecipeOutputs(ItemStack item) {
        CentrifugeRecipe cr = item != null ? (CentrifugeRecipe)this.recipeList.get(item) : null;
        return cr != null ? cr.out.itemSet() : null;
    }

    public ArrayList<ItemStack> getSources(ItemStack result) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemStack in : this.recipeList.keySet()) {
            Collection<ItemStack> out = this.getRecipeOutputs(in);
            if (!ReikaItemHelper.collectionContainsItemStack(out, (ItemStack)result)) continue;
            li.add(in.func_77946_l());
        }
        return li;
    }

    public ArrayList<ItemStack> getSources(Fluid result) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemStack in : this.recipeList.keySet()) {
            FluidOut fo = ((CentrifugeRecipe)this.recipeList.get(in)).fluid;
            if (fo == null || !fo.fluid.getFluid().equals(result)) continue;
            li.add(in.func_77946_l());
        }
        return li;
    }

    public boolean isProduct(ItemStack result) {
        return ReikaItemHelper.collectionContainsItemStack(this.outputs, (ItemStack)result);
    }

    public boolean isCentrifugable(ItemStack ingredient) {
        return this.getRecipeResult(ingredient) != null;
    }

    public Collection<ItemStack> getAllCentrifugables() {
        return Collections.unmodifiableCollection(this.recipeList.keySet());
    }

    @Override
    public void addPostLoadRecipes() {
        ItemStack phial;
        FluidStack fs;
        Object drop;
        if (ModList.FORESTRY.isLoaded()) {
            Fluid f;
            FluidStack fs2;
            ISqueezerRecipe out;
            for (ItemStack in : ForestryRecipeHelper.getInstance().getSqueezerRecipes()) {
                String n;
                out = ForestryRecipeHelper.getInstance().getSqueezerOutput(in);
                FluidStack fs3 = out.getFluidOutput();
                if (fs3 != null && ((n = fs3.getFluid().getName()).equals("seedoil") || n.equals("juice"))) continue;
                ChancedOutputList co = null;
                if (out.getRemnants() != null) {
                    co = new ChancedOutputList(false);
                    co.addItem(out.getRemnants(), out.getRemnantsChance() * 100.0f);
                }
                if (co != null) {
                    co.manipulateChances((ChancedOutputList.ChanceManipulator)new ChancedOutputList.ChanceExponentiator(2.5));
                    co.manipulateChances((ChancedOutputList.ChanceManipulator)new ChanceRounder());
                } else {
                    co = new ChancedOutputList(false);
                }
                if (fs3 != null) {
                    fs3 = fs3.copy();
                    fs3.amount = (int)((double)fs3.amount * 1.25);
                }
                this.addRecipe(in, co, fs3 != null ? new FluidOut(fs3, 100.0f) : null, RecipeHandler.RecipeLevel.MODINTERACT);
            }
            for (ItemStack in : ForestryRecipeHelper.getInstance().getCentrifugeRecipes()) {
                out = ForestryRecipeHelper.getInstance().getCentrifugeOutput(in);
                out.manipulateChances((ChancedOutputList.ChanceManipulator)new ChancedOutputList.ChanceExponentiator(3.0));
                out.manipulateChances((ChancedOutputList.ChanceManipulator)new ChanceRounder());
                this.addRecipe(in, (ChancedOutputList)out, null, RecipeHandler.RecipeLevel.MODINTERACT);
            }
            drop = new ItemStack(ForestryHandler.ItemEntry.HONEY.getItem());
            ChancedOutputList out2 = new ChancedOutputList(true);
            out2.addItem(new ItemStack(ForestryHandler.ItemEntry.PROPOLIS.getItem()), 25.0f);
            this.addRecipe((ItemStack)drop, out2, new FluidOut(new FluidStack(FluidRegistry.getFluid((String)"for.honey"), 150), 100.0f), RecipeHandler.RecipeLevel.MODINTERACT);
            drop = new ItemStack(ForestryHandler.ItemEntry.HONEYDEW.getItem());
            this.addRecipe((ItemStack)drop, new FluidStack(FluidRegistry.getFluid((String)"for.honey"), 150), 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
            drop = ReikaItemHelper.lookupItem((String)"MagicBees", (String)"drop", (int)0);
            if (drop != null && ReikaXPFluidHelper.fluidsExist()) {
                fs2 = ReikaXPFluidHelper.getFluid((int)30);
                this.addRecipe((ItemStack)drop, fs2, 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, ItemStacks.lapisoreflakes, 2);
            }
            if ((drop = ReikaItemHelper.lookupItem((String)"MagicBees", (String)"drop", (int)1)) != null && ReikaXPFluidHelper.fluidsExist()) {
                fs2 = ReikaXPFluidHelper.getFluid((int)15);
                this.addRecipe((ItemStack)drop, fs2, 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
            }
            if ((drop = ReikaItemHelper.lookupItem((String)"MagicBees", (String)"drop", (int)2)) != null && (f = FluidRegistry.getFluid((String)"redstone")) != null) {
                this.addRecipe((ItemStack)drop, new FluidStack(f, 50), 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
            }
            if ((drop = ReikaItemHelper.lookupItem((String)"MagicBees", (String)"drop", (int)3)) != null && (f = FluidRegistry.getFluid((String)"coal")) != null) {
                this.addRecipe((ItemStack)drop, new FluidStack(f, 50), 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
            }
            if ((drop = ReikaItemHelper.lookupItem((String)"MagicBees", (String)"drop", (int)4)) != null && (f = FluidRegistry.getFluid((String)"glowstone")) != null) {
                this.addRecipe((ItemStack)drop, new FluidStack(f, 50), 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
            }
            if ((drop = ReikaItemHelper.lookupItem((String)"MagicBees", (String)"drop", (int)5)) != null && (f = FluidRegistry.getFluid((String)"ender")) != null) {
                this.addRecipe((ItemStack)drop, new FluidStack(f, 50), 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
            }
        }
        if (ReikaItemHelper.oreItemsExist((String[])new String[]{"dustLead", "dustSilver"})) {
            ItemStack lead = (ItemStack)OreDictionary.getOres((String)"dustLead").get(0);
            ItemStack silver = (ItemStack)OreDictionary.getOres((String)"dustSilver").get(0);
            this.addRecipe(ExtractorModOres.getSmeltedIngot(ModOreList.GALENA), null, RecipeHandler.RecipeLevel.PERIPHERAL, lead, 100, silver, 100);
        }
        if (ModList.TINKERER.isLoaded()) {
            ItemStack berry = OreBerryBushHandler.BerryTypes.XP.getStack();
            if (berry != null && ReikaXPFluidHelper.fluidsExist()) {
                fs = ReikaXPFluidHelper.getFluid((int)30);
                this.addRecipe(berry, fs, 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
            }
            ItemStack chaff = ModList.IC2.isLoaded() && IC2Handler.IC2Stacks.BIOCHAFF.getItem() != null ? IC2Handler.IC2Stacks.BIOCHAFF.getItem() : ReikaItemHelper.tallgrass.asItemStack();
            ItemStack blueslime = ReikaItemHelper.lookupItem((String)"TConstruct:strangeFood");
            this.addRecipe(ModWoodList.SLIME.getSaplingID(), null, RecipeHandler.RecipeLevel.MODINTERACT, new ItemStack(Items.field_151123_aH), 70, blueslime, 20, chaff, 100);
        }
        if (ModList.MAGICCROPS.isLoaded() && (drop = MagicCropHandler.EssenceType.XP.getEssence()) != null && ReikaXPFluidHelper.fluidsExist()) {
            fs = ReikaXPFluidHelper.getFluid((int)5);
            this.addRecipe((ItemStack)drop, fs, 100.0f, RecipeHandler.RecipeLevel.MODINTERACT, new Object[0]);
        }
        if (ModList.THAUMCRAFT.isLoaded()) {
            for (Aspect a : ReikaThaumHelper.getAllAspects()) {
                ItemStack in = ThaumItemHelper.getPhialEssentia((Aspect)a);
                ChancedOutputList co = new ChancedOutputList(false);
                co.addItem(ThaumItemHelper.ItemEntry.PHIAL.getItem(), 100.0f);
                for (int i = 0; i < 8; ++i) {
                    co.addItem(ThaumItemHelper.getCrystallizedEssentia((Aspect)a), 100.0f);
                }
                this.addDirectStackRecipe(in, co, null, RecipeHandler.RecipeLevel.MODINTERACT, 1);
            }
        }
        if (Loader.isModLoaded((String)"Automagy") && (phial = ReikaItemHelper.lookupItem((String)"Automagy:phialExtra")) != null && ReikaXPFluidHelper.fluidsExist()) {
            try {
                Class<?> c = phial.func_77973_b().getClass();
                Method m = c.getMethod("getXPValue", new Class[0]);
                int val = (Integer)m.invoke((Object)phial.func_77973_b(), new Object[0]);
                FluidStack fs4 = ReikaXPFluidHelper.getFluid((int)val);
                ChancedOutputList co = new ChancedOutputList(false);
                co.addItem(ThaumItemHelper.ItemEntry.PHIAL.getItem(), 100.0f);
                co.addItem(ThaumItemHelper.getCrystallizedEssentia((Aspect)Aspect.WATER), 10.0f);
                co.addItem(ThaumItemHelper.getCrystallizedEssentia((Aspect)Aspect.ORDER), 10.0f);
                co.addItem(ThaumItemHelper.getCrystallizedEssentia((Aspect)Aspect.MAGIC), 5.0f);
                co.addItem(ThaumItemHelper.getCrystallizedEssentia((Aspect)Aspect.MIND), 4.0f);
                co.addItem(ThaumItemHelper.getCrystallizedEssentia((Aspect)Aspect.CRAFT), 2.0f);
                this.addRecipe(phial, co, new FluidOut(fs4, 100.0f), RecipeHandler.RecipeLevel.MODINTERACT);
            }
            catch (Exception e) {
                RotaryCraft.logger.logError((Object)"Could not determine XP value of enchanting phial!");
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)new BasicModEntry("Automagy"), e);
            }
        }
        ItemStack is = ModList.IC2.isLoaded() && IC2Handler.IC2Stacks.BIOCHAFF.getItem() != null ? IC2Handler.IC2Stacks.BIOCHAFF.getItem() : ReikaItemHelper.tallgrass.asItemStack();
        this.addRecipe(new ItemStack(Blocks.field_150435_aG), new FluidStack(FluidRegistry.WATER, 20), 40.0f, RecipeHandler.RecipeLevel.PERIPHERAL, new ItemStack(Blocks.field_150346_d), 100, ItemStacks.silicondust, 75, ItemStacks.ironoreflakes, Float.valueOf(0.5f), ItemStacks.goldoreflakes, Float.valueOf(0.2f), is, Float.valueOf(2.5f));
        this.addGrassToSeeds();
    }

    private void addGrassToSeeds() {
        ChancedOutputList c = new ChancedOutputList(false);
        ItemHashMap weights = new ItemHashMap();
        float total = 0.0f;
        List li = (List)ReikaObfuscationHelper.get((String)"seedList", null);
        for (WeightedRandom.Item wi : li) {
            ItemStack seed = (ItemStack)ReikaObfuscationHelper.get((String)"seed", (Object)wi);
            if (HarvestCraftHandler.getInstance().isSeedItem(seed) || weights.size() >= (weights.containsKey(ItemRegistry.CANOLA.getItemInstance(), 0) ? 9 : 8)) continue;
            total += (float)wi.field_76292_a;
            weights.put(seed, (Object)wi.field_76292_a);
        }
        for (ItemStack is : weights.keySet()) {
            int wt = (Integer)weights.get(is);
            c.addItem(is, ItemRegistry.CANOLA.matchItem(is) ? 10.0f : (float)wt / total);
        }
        this.addRecipe(ReikaItemHelper.tallgrass.asItemStack(), c, null, RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(ReikaItemHelper.fern.asItemStack(), c, null, RecipeHandler.RecipeLevel.PERIPHERAL);
    }

    @Override
    protected boolean removeRecipe(RecipeHandler.MachineRecipe recipe) {
        return this.recipeList.removeValue((Object)((CentrifugeRecipe)recipe));
    }

    @Override
    protected boolean addCustomRecipe(String n, LuaBlock lb, CustomRecipeList crl) throws Exception {
        ItemStack in = CustomRecipeList.parseItemString((String)lb.getString("input"), null, (boolean)false);
        FluidOut fo = null;
        ChancedOutputList co = new ChancedOutputList(false);
        if (lb.hasChild("output_fluid")) {
            LuaBlock fluid = lb.getChild("output_fluid");
            String s = fluid.getString("type");
            Fluid f = FluidRegistry.getFluid((String)s);
            if (f == null) {
                throw new IllegalArgumentException("Fluid '" + s + "' does not exist!");
            }
            this.verifyOutputFluid(f);
            FluidStack fs = new FluidStack(f, fluid.getInt("amount"));
            fo = new FluidOut(fs, (float)fluid.getDouble("chance"));
        }
        if (lb.hasChild("output_items")) {
            LuaBlock items = lb.getChild("output_items");
            for (LuaBlock entry : items.getChildren()) {
                ItemStack is = CustomRecipeList.parseItemString((String)entry.getString("item"), (LuaBlock)entry.getChild("nbt"), (boolean)true);
                this.verifyOutputItem(is);
                if (is == null) continue;
                co.addItem(is, (float)entry.getDouble("chance"));
            }
        }
        this.addRecipe(in, co, fo, RecipeHandler.RecipeLevel.CUSTOM);
        return true;
    }

    private static class FluidOut {
        private final FluidStack fluid;
        private final float chance;

        private FluidOut(FluidStack fs, float c) {
            this.fluid = fs;
            this.chance = c;
        }

        public int getRandomAmount(Random r) {
            return (int)(r.nextFloat() * (float)this.fluid.amount);
        }

        public int getAmount() {
            return this.fluid.amount;
        }

        public final String toString() {
            return this.fluid.amount + " mB of " + this.fluid.getFluid().getName() + " (" + this.chance + "%)";
        }
    }

    private static class ChanceRounder
    implements ChancedOutputList.ChanceManipulator {
        private ChanceRounder() {
        }

        public float getChance(float original) {
            return (float)Math.round(2.0 * (double)original) / 2.0f;
        }
    }

    public static class CentrifugeRecipe
    implements RecipeHandler.MachineRecipe {
        private final ItemStack in;
        public final int maxStack;
        private final ChancedOutputList out;
        private final FluidOut fluid;
        public final boolean hasNBT;

        private CentrifugeRecipe(ItemStack is, ChancedOutputList li, FluidOut fs, int cycles) {
            this.in = is;
            this.out = li;
            this.fluid = fs;
            this.maxStack = cycles;
            this.hasNBT = is.field_77990_d != null;
        }

        @Override
        public String getUniqueID() {
            return RecipeHandler.fullID(this.in) + ">" + this.out.toString() + "&" + (this.fluid != null ? this.fluid.toString() : "X") + " {x" + this.maxStack + "}";
        }

        @Override
        public String getAllInfo() {
            return "Centrifuge " + RecipeHandler.fullID(this.in) + " to items[" + this.out + "] and fluid " + this.fluid + "; can stack up to " + this.maxStack + "x";
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>(this.out.keySet());
            li.add(this.in);
            return li;
        }

        public FluidStack getFluid() {
            return this.fluid != null ? this.fluid.fluid.copy() : null;
        }

        public FluidStack rollFluid() {
            return this.fluid != null ? (ReikaRandomHelper.doWithChance((double)this.fluid.chance) ? this.fluid.fluid.copy() : null) : null;
        }

        public Collection<ChancedOutputList.ItemWithChance> getItems() {
            return this.out.keySet();
        }

        public Collection<ItemStack> rollItems() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (ChancedOutputList.ItemWithChance is : this.getItems()) {
                double ch;
                for (ch = (double)is.getNormalizedChance(); ch >= 1.0; ch -= 1.0) {
                    li.add(is.getItem());
                }
                if (!ReikaRandomHelper.doWithChance((double)ch)) continue;
                li.add(is.getItem());
            }
            return li;
        }

        public ItemStack getInput() {
            return this.in.func_77946_l();
        }

        public float getFluidChance() {
            return this.fluid != null ? this.fluid.chance : 0.0f;
        }
    }
}

