/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.IO.CustomRecipeList;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.API.RecipeInterface;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class RecipesCompactor
extends RecipeHandler
implements RecipeInterface.CompactorManager {
    private static final RecipesCompactor CompactorBase = new RecipesCompactor();
    private ItemHashMap<CompactingRecipe> recipes = new ItemHashMap();

    public static final RecipesCompactor getRecipes() {
        return CompactorBase;
    }

    private RecipesCompactor() {
        super(MachineRegistry.COMPACTOR);
        RecipeInterface.compactor = this;
        int rp = 550000;
        int rt = 800;
        this.addRecipe(new ItemStack(Items.field_151044_h), ItemRegistry.COMPACTS.getCraftedMetadataProduct(this.getNumberPerStep(), 0), rp, rt, RecipeHandler.RecipeLevel.CORE);
        this.addRecipe(ReikaItemHelper.charcoal, ItemRegistry.COMPACTS.getCraftedMetadataProduct(this.getNumberPerStep() * 3 / 2, 0), rp, rt, RecipeHandler.RecipeLevel.CORE);
        this.addRecipe(ItemStacks.anthracite, ItemRegistry.COMPACTS.getCraftedMetadataProduct(this.getNumberPerStep(), 1), rp, rt, RecipeHandler.RecipeLevel.CORE);
        this.addRecipe(ItemStacks.prismane, ItemRegistry.COMPACTS.getCraftedMetadataProduct(this.getNumberPerStep(), 2), rp, rt, RecipeHandler.RecipeLevel.CORE);
        this.addRecipe(ItemStacks.lonsda, new ItemStack(Items.field_151045_i, this.getNumberPerStep(), 0), rp, rt, RecipeHandler.RecipeLevel.CORE);
        this.addRecipe(new ItemStack(Items.field_151065_br), new ItemStack(Blocks.field_150426_aN, 1, 0), 2000, 600, RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(new ItemStack(Blocks.field_150432_aD), new ItemStack(Blocks.field_150403_cj), 24000, -80, RecipeHandler.RecipeLevel.PERIPHERAL);
    }

    public final int getNumberPerStep() {
        return DifficultyEffects.COMPACTOR.getInt();
    }

    @Override
    public void addAPIRecipe(ItemStack in, ItemStack itemstack, int pressure, int temperature) {
        this.addRecipe(in, itemstack, pressure, temperature, RecipeHandler.RecipeLevel.API);
    }

    public void addRecipe(ItemStack in, ItemStack itemstack, int pressure, int temperature) {
        this.addRecipe(in, itemstack, pressure, temperature, RecipeHandler.RecipeLevel.CORE);
    }

    private void addRecipe(ItemStack in, ItemStack itemstack, int pressure, int temperature, RecipeHandler.RecipeLevel rl) {
        CompactingRecipe rec = new CompactingRecipe(in, itemstack, temperature, pressure);
        this.recipes.put(in, (Object)rec);
        this.onAddRecipe(rec, rl);
    }

    public ItemStack getCompactingResult(ItemStack item) {
        if (item == null) {
            return null;
        }
        CompactingRecipe ret = (CompactingRecipe)this.recipes.get(item);
        return ret != null ? ret.out.func_77946_l() : null;
    }

    public boolean isCompactable(ItemStack item) {
        return this.getCompactingResult(item) != null;
    }

    public int getReqPressure(ItemStack item) {
        CompactingRecipe ret = (CompactingRecipe)this.recipes.get(item);
        return ret != null ? ret.pressure : 0;
    }

    public ItemStack getSource(ItemStack result) {
        for (ItemStack in : this.recipes.keySet()) {
            ItemStack out = this.getCompactingResult(in);
            if (!ReikaItemHelper.matchStacks((ItemStack)result, (ItemStack)out)) continue;
            return in.func_77946_l();
        }
        return null;
    }

    public int getReqTemperature(ItemStack item) {
        CompactingRecipe ret = (CompactingRecipe)this.recipes.get(item);
        return ret != null ? ret.temperature : 0;
    }

    public Collection<ItemStack> getAllCompactables() {
        return Collections.unmodifiableCollection(this.recipes.keySet());
    }

    @Override
    public void addPostLoadRecipes() {
        ItemStack plantball;
        if (ModList.IC2.isLoaded() && (plantball = IC2Handler.IC2Stacks.PLANTBALL.getItem()) != null) {
            Object[] items;
            for (Object in : items = new Object[]{Items.field_151015_O, Items.field_151172_bF, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N}) {
                this.addRecipe(ReikaItemHelper.parseItem((Object)in, (boolean)true), ReikaItemHelper.getSizedItemStack((ItemStack)plantball, (int)1), 500, 0, RecipeHandler.RecipeLevel.MODINTERACT);
            }
        }
    }

    @Override
    protected boolean removeRecipe(RecipeHandler.MachineRecipe recipe) {
        return this.recipes.removeValue((Object)((CompactingRecipe)recipe));
    }

    @Override
    protected boolean addCustomRecipe(String n, LuaBlock lb, CustomRecipeList crl) throws Exception {
        ItemStack in = CustomRecipeList.parseItemString((String)lb.getString("input"), (LuaBlock)lb.getChild("input_nbt"), (boolean)false);
        ItemStack out = CustomRecipeList.parseItemString((String)lb.getString("output"), (LuaBlock)lb.getChild("output_nbt"), (boolean)false);
        this.verifyOutputItem(out);
        this.addRecipe(in, out, lb.getInt("pressure"), lb.getInt("temperature"), RecipeHandler.RecipeLevel.CUSTOM);
        return true;
    }

    private static class CompactingRecipe
    implements RecipeHandler.MachineRecipe {
        private final ItemStack in;
        private final ItemStack out;
        private final int temperature;
        private final int pressure;

        private CompactingRecipe(ItemStack is, ItemStack is2, int t, int p) {
            this.in = is;
            this.out = is2;
            this.temperature = t;
            this.pressure = p;
        }

        @Override
        public String getUniqueID() {
            return RecipeHandler.fullID(this.in) + ">" + RecipeHandler.fullID(this.out) + "@" + this.temperature + "&" + this.pressure;
        }

        @Override
        public String getAllInfo() {
            return "Compacting " + RecipeHandler.fullID(this.in) + " to " + RecipeHandler.fullID(this.out) + " @ " + this.temperature + "C & " + this.pressure + " kPa";
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            return ReikaJavaLibrary.makeListFrom((Object[])new ItemStack[]{this.in, this.out});
        }
    }
}

