/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Instantiable.Data.Maps.FluidHashMap;
import Reika.DragonAPI.Instantiable.IO.CustomRecipeList;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.RotaryCraft.API.RecipeInterface;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipesDryingBed
extends RecipeHandler
implements RecipeInterface.DryingBedManager {
    private static final RecipesDryingBed DryingBase = new RecipesDryingBed();
    private final FluidHashMap<DryingRecipe> recipeList = new FluidHashMap();

    public static final RecipesDryingBed getRecipes() {
        return DryingBase;
    }

    private RecipesDryingBed() {
        super(MachineRegistry.DRYING);
        RecipeInterface.dryingbed = this;
        this.addRecipe(FluidRegistry.WATER, 250, ItemStacks.salt, RecipeHandler.RecipeLevel.CORE);
        this.addRecipe(FluidRegistry.LAVA, 1000, new ItemStack(Items.field_151074_bl), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe("oil", 200, ItemStacks.tar, RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe("for.honey", 400, new ItemStack(Items.field_151123_aH), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe("honey", 400, new ItemStack(Items.field_151123_aH), RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe("chroma", 2000, new ItemStack(Items.field_151166_bC), RecipeHandler.RecipeLevel.MODINTERACT);
    }

    @Override
    public void addAPIRecipe(Fluid f, int amount, ItemStack out) {
        this.addRecipe(f, amount, out, RecipeHandler.RecipeLevel.API);
    }

    private void addRecipe(Fluid f, int amount, ItemStack out, RecipeHandler.RecipeLevel rl) {
        DryingRecipe rec = new DryingRecipe(new FluidStack(f, amount), out);
        this.recipeList.put(f, amount, (Object)rec);
        this.onAddRecipe(rec, rl);
    }

    private void addRecipe(String s, int amount, ItemStack out, RecipeHandler.RecipeLevel rl) {
        Fluid f = FluidRegistry.getFluid((String)s);
        if (f != null) {
            this.addRecipe(f, amount, out, rl);
        }
    }

    public ItemStack getDryingResult(FluidStack liquid) {
        Fluid f = liquid.getFluid();
        DryingRecipe cr = (DryingRecipe)this.recipeList.getForValue(liquid);
        if (cr == null) {
            return null;
        }
        int req = ((DryingRecipe)cr).input.amount;
        if (req > liquid.amount) {
            return null;
        }
        return cr.output.func_77946_l();
    }

    public DryingRecipe getRecipe(ItemStack result) {
        for (DryingRecipe cr : this.recipeList.values()) {
            if (!ReikaItemHelper.matchStacks((ItemStack)result, (ItemStack)cr.output)) continue;
            return cr;
        }
        return null;
    }

    public int getRecipeConsumption(ItemStack result) {
        DryingRecipe cr = this.getRecipe(result);
        return cr != null ? ((DryingRecipe)cr).input.amount : 0;
    }

    public boolean isValidFluid(Fluid f) {
        return this.recipeList.containsKey(f);
    }

    public Collection<DryingRecipe> getAllRecipes() {
        HashSet<DryingRecipe> c = new HashSet<DryingRecipe>();
        for (DryingRecipe cr : this.recipeList.values()) {
            c.add(cr);
        }
        return c;
    }

    @Override
    public void addPostLoadRecipes() {
        ArrayList li = OreDictionary.getOres((String)"rubber");
        if (li == null || li.isEmpty()) {
            li = OreDictionary.getOres((String)"itemRubber");
        }
        if (li != null && !li.isEmpty()) {
            this.addRecipe("rc lubricant", 100, (ItemStack)li.get(0), RecipeHandler.RecipeLevel.MODINTERACT);
        }
    }

    @Override
    protected boolean removeRecipe(RecipeHandler.MachineRecipe recipe) {
        return this.recipeList.removeValue((Object)((DryingRecipe)recipe));
    }

    @Override
    protected boolean addCustomRecipe(String n, LuaBlock lb, CustomRecipeList crl) throws Exception {
        ItemStack out = CustomRecipeList.parseItemString((String)lb.getString("output"), (LuaBlock)lb.getChild("output_nbt"), (boolean)false);
        this.verifyOutputItem(out);
        String fluid = lb.getString("input_fluid");
        Fluid f = FluidRegistry.getFluid((String)fluid);
        if (f == null) {
            throw new IllegalArgumentException("Fluid '" + fluid + "' does not exist!");
        }
        int amt = lb.getInt("input_amount");
        this.addRecipe(f, amt, out, RecipeHandler.RecipeLevel.CUSTOM);
        return true;
    }

    public static class DryingRecipe
    implements RecipeHandler.MachineRecipe {
        private final FluidStack input;
        private final ItemStack output;

        private DryingRecipe(FluidStack fs, ItemStack is) {
            this.input = fs;
            this.output = is;
        }

        @Override
        public String getUniqueID() {
            return this.input.getFluid().getName() + ":" + this.input.amount + ">" + RecipeHandler.fullID(this.output);
        }

        @Override
        public String getAllInfo() {
            return "Drying " + this.input.amount + " of " + this.input.getLocalizedName() + " into " + RecipeHandler.fullID(this.output);
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            return ReikaJavaLibrary.makeListFrom((Object)ReikaFluidHelper.getFluidStackAsItem((FluidStack)this.input));
        }

        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        public FluidStack getFluid() {
            return this.input.copy();
        }
    }
}

