/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base.TileEntity;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.RotaryCraft.API.IOMachine;
import Reika.RotaryCraft.API.Power.AdvancedShaftPowerReceiver;
import Reika.RotaryCraft.API.Power.ShaftPowerReceiver;
import Reika.RotaryCraft.API.Power.SimpleShaftPowerReceiver;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityIOMachine
extends RotaryCraftTileEntity
implements IOMachine,
PowerSourceTracker {
    public int iotick = 512;
    protected ForgeDirection write;
    protected ForgeDirection write2;
    public long power = 0L;
    public int torque = 0;
    public int omega = 0;
    protected ForgeDirection read;
    protected ForgeDirection read2;
    protected ForgeDirection read3;
    protected ForgeDirection read4;
    private int pointoffsetx = 0;
    private int pointoffsety = 0;
    private int pointoffsetz = 0;
    public boolean isOmniSided = false;
    protected int torquein;
    protected int omegain;
    private boolean superCalled = false;

    public void updateTileEntity() {
        if (this.iotick > 0) {
            this.iotick -= 8;
        }
        this.superCalled = true;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("torque", this.torque);
        NBT.func_74768_a("omega", this.omega);
        NBT.func_74772_a("power", this.power);
        NBT.func_74768_a("io", this.iotick);
        NBT.func_74768_a("read1", this.read != null ? this.read.ordinal() : -1);
        NBT.func_74768_a("read2", this.read2 != null ? this.read2.ordinal() : -1);
        NBT.func_74768_a("read3", this.read3 != null ? this.read3.ordinal() : -1);
        NBT.func_74768_a("read4", this.read4 != null ? this.read4.ordinal() : -1);
        NBT.func_74768_a("write1", this.write != null ? this.write.ordinal() : -1);
        NBT.func_74768_a("write2", this.write2 != null ? this.write2.ordinal() : -1);
        NBT.func_74757_a("omni", this.isOmniSided);
        NBT.func_74768_a("pox", this.pointoffsetx);
        NBT.func_74768_a("poy", this.pointoffsety);
        NBT.func_74768_a("poz", this.pointoffsetz);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.torque = NBT.func_74762_e("torque");
        this.omega = NBT.func_74762_e("omega");
        this.power = NBT.func_74763_f("power");
        this.iotick = NBT.func_74762_e("io");
        if (this.torque < 0 || (double)this.torque == Double.POSITIVE_INFINITY || (double)this.torque == Double.NaN) {
            this.torque = 0;
        }
        if (this.omega < 0 || (double)this.omega == Double.POSITIVE_INFINITY || (double)this.omega == Double.NaN) {
            this.omega = 0;
        }
        int r1 = NBT.func_74762_e("read1");
        int r2 = NBT.func_74762_e("read2");
        int r3 = NBT.func_74762_e("read3");
        int r4 = NBT.func_74762_e("read4");
        this.read = r1 != -1 ? this.dirs[r1] : null;
        this.read2 = r2 != -1 ? this.dirs[r2] : null;
        this.read3 = r3 != -1 ? this.dirs[r3] : null;
        this.read4 = r4 != -1 ? this.dirs[r4] : null;
        int w1 = NBT.func_74762_e("write1");
        int w2 = NBT.func_74762_e("write2");
        this.write = w1 != -1 ? this.dirs[w1] : null;
        this.write2 = w2 != -1 ? this.dirs[w2] : null;
        this.isOmniSided = NBT.func_74767_n("omni");
        this.pointoffsetx = NBT.func_74762_e("pox");
        this.pointoffsety = NBT.func_74762_e("poy");
        this.pointoffsetz = NBT.func_74762_e("poz");
    }

    public final ForgeDirection getReadDirection() {
        return this.read;
    }

    public final ForgeDirection getReadDirection2() {
        return this.read2;
    }

    public final ForgeDirection getReadDirection3() {
        return this.read3;
    }

    public final ForgeDirection getReadDirection4() {
        return this.read4;
    }

    public final ForgeDirection getWriteDirection() {
        return this.write;
    }

    public final ForgeDirection getWriteDirection2() {
        return this.write2;
    }

    protected boolean isProvider(TileEntity te) {
        if (te instanceof ShaftPowerEmitter) {
            return true;
        }
        if (!(te instanceof TileEntityIOMachine)) {
            return false;
        }
        return ((TileEntityIOMachine)te).canProvidePower();
    }

    public final TileEntity getReadTileEntity() {
        return this.read != null ? this.getAdjacentTileEntity(this.read) : null;
    }

    public final TileEntity getReadTileEntity2() {
        return this.read2 != null ? this.getAdjacentTileEntity(this.read2) : null;
    }

    public final TileEntity getReadTileEntity3() {
        return this.read3 != null ? this.getAdjacentTileEntity(this.read3) : null;
    }

    public final TileEntity getReadTileEntity4() {
        return this.read4 != null ? this.getAdjacentTileEntity(this.read4) : null;
    }

    public final TileEntity getWriteTileEntity() {
        return this.write != null ? this.getAdjacentTileEntity(this.write) : null;
    }

    public final TileEntity getWriteTileEntity2() {
        return this.write2 != null ? this.getAdjacentTileEntity(this.write2) : null;
    }

    public final WorldLocation getReadLocation() {
        return this.read != null ? this.getAdjacentLocation(this.read) : null;
    }

    public final WorldLocation getReadLocation2() {
        return this.read2 != null ? this.getAdjacentLocation(this.read2) : null;
    }

    public final WorldLocation getReadLocation3() {
        return this.read3 != null ? this.getAdjacentLocation(this.read3) : null;
    }

    public final WorldLocation getReadLocation4() {
        return this.read4 != null ? this.getAdjacentLocation(this.read4) : null;
    }

    public final WorldLocation getWriteLocation() {
        return this.write != null ? this.getAdjacentLocation(this.write) : null;
    }

    public final WorldLocation getWriteLocation2() {
        return this.write2 != null ? this.getAdjacentLocation(this.write2) : null;
    }

    public abstract boolean canProvidePower();

    public final int getPointingOffsetX() {
        return this.pointoffsetx;
    }

    public final int getPointingOffsetY() {
        return this.pointoffsety;
    }

    public final int getPointingOffsetZ() {
        return this.pointoffsetz;
    }

    protected final void setPointingOffset(int x, int y, int z) {
        this.pointoffsetx = x;
        this.pointoffsety = y;
        this.pointoffsetz = z;
    }

    public final boolean isWritingToCoordinate(int x, int y, int z) {
        if (this.write == null) {
            return false;
        }
        boolean wx = this.field_145851_c + this.write.offsetX == x;
        boolean wy = this.field_145848_d + this.write.offsetY == y;
        boolean wz = this.field_145849_e + this.write.offsetZ == z;
        return wx && wy && wz;
    }

    public final boolean isWritingToCoordinate2(int x, int y, int z) {
        if (this.write2 == null) {
            return false;
        }
        boolean wx = this.field_145851_c + this.write2.offsetX == x;
        boolean wy = this.field_145848_d + this.write2.offsetY == y;
        boolean wz = this.field_145849_e + this.write2.offsetZ == z;
        return wx && wy && wz;
    }

    protected final boolean matchTile(PowerSourceTracker te, ForgeDirection dir) {
        if (dir == null) {
            return false;
        }
        int dim = te.getWorld().field_73011_w.field_76574_g;
        int tx = te.getX() + te.getIoOffsetX();
        int ty = te.getY() + te.getIoOffsetY();
        int tz = te.getZ() + te.getIoOffsetZ();
        TileEntity out = this.getAdjacentTileEntity(dir);
        while (out instanceof WorldRift) {
            out = ((WorldRift)out).getTileEntityFrom(dir);
        }
        if (out == null) {
            return false;
        }
        return !out.func_145837_r() && out.field_145850_b.field_73011_w.field_76574_g == dim && out.field_145851_c == tx && out.field_145848_d == ty && out.field_145849_e == tz;
    }

    public boolean isWritingTo(PowerSourceTracker te) {
        return this.matchTile(te, this.write);
    }

    public final boolean isWritingTo2(PowerSourceTracker te) {
        return this.matchTile(te, this.write2);
    }

    public final boolean isReadingFrom(PowerSourceTracker te) {
        return this.matchTile(te, this.read);
    }

    public final boolean isReadingFrom2(PowerSourceTracker te) {
        return this.matchTile(te, this.read2);
    }

    public final boolean isReadingFrom3(PowerSourceTracker te) {
        return this.matchTile(te, this.read3);
    }

    public final boolean isReadingFrom4(PowerSourceTracker te) {
        return this.matchTile(te, this.read4);
    }

    protected final void copyStandardPower(TileEntity te) {
        this.copyStandardPower((TileEntityIOMachine)te);
    }

    protected final void copyStandardPower(TileEntityIOMachine te) {
        if (te instanceof TileEntityShaft) {
            return;
        }
        if (!te.isWritingTo(this) && !te.isWritingTo2(this)) {
            this.omegain = 0;
            this.torquein = 0;
            return;
        }
        this.torquein = te.torque;
        this.omegain = te.omega;
    }

    private void setPower(TileEntity te, ForgeDirection from, int om, int tq) {
        if (te instanceof SimpleShaftPowerReceiver) {
            if (this.isBlacklistedReceiver(te)) {
                if (this.omega > 0 && this.torque > 0) {
                    this.affectBlacklistedReceiver(te);
                }
            } else {
                SimpleShaftPowerReceiver sp;
                sp.setPowered((sp = (SimpleShaftPowerReceiver)te).canReadFrom(from.getOpposite()) && tq > 0 && om > 0);
            }
        } else if (te instanceof ShaftPowerReceiver) {
            if (this.isBlacklistedReceiver(te)) {
                if (this.omega > 0 && this.torque > 0) {
                    this.affectBlacklistedReceiver(te);
                }
            } else {
                ShaftPowerReceiver sp = (ShaftPowerReceiver)te;
                if (sp.isReceiving() && sp.canReadFrom(from.getOpposite())) {
                    sp.setOmega(om);
                    sp.setTorque(tq);
                    sp.setPower((long)om * (long)tq);
                } else {
                    sp.setOmega(0);
                    sp.setTorque(0);
                    sp.setPower(0L);
                }
            }
        } else if (te instanceof AdvancedShaftPowerReceiver) {
            if (this.isBlacklistedReceiver(te)) {
                if (this.omega > 0 && this.torque > 0) {
                    this.affectBlacklistedReceiver(te);
                }
            } else {
                AdvancedShaftPowerReceiver sp = (AdvancedShaftPowerReceiver)te;
                if (sp.canReadFrom(from.getOpposite())) {
                    sp.addPower(tq, om, (long)tq * (long)om, from.getOpposite());
                }
            }
        } else if (te instanceof WorldRift) {
            this.setPower(((WorldRift)te).getTileEntityFrom(from), from, om, tq);
        }
    }

    protected final void basicPowerReceiver() {
        this.writeToReceiver(this.write);
    }

    private void writeToReceiver(ForgeDirection dir) {
        this.writeToReceiver(dir, this.omega, this.torque);
    }

    private void writeToReceiver(ForgeDirection dir, int om, int tq) {
        TileEntity te = this.getAdjacentTileEntity(dir);
        this.setPower(te, dir, om, tq);
    }

    protected void writeToPowerReceiver(ForgeDirection dir, int om, int tq) {
        this.writeToReceiver(dir, om, tq);
    }

    private void writePowerToReciever(ShaftPowerReceiver sp) {
    }

    private boolean isBlacklistedReceiver(TileEntity te) {
        return RotaryAux.isBlacklistedIOMachine(te);
    }

    private void affectBlacklistedReceiver(TileEntity te) {
        te.field_145850_b.func_147468_f(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        te.field_145850_b.func_72876_a(null, (double)te.field_145851_c, (double)te.field_145848_d, (double)te.field_145849_e, 3.0f, true);
    }

    public final ForgeDirection getInputForgeDirection() {
        return this.read;
    }

    @Override
    public int getWriteX() {
        return this.write != null ? this.field_145851_c + this.write.offsetX : Integer.MIN_VALUE;
    }

    @Override
    public int getWriteY() {
        return this.write != null ? this.field_145848_d + this.write.offsetY : Integer.MIN_VALUE;
    }

    @Override
    public int getWriteZ() {
        return this.write != null ? this.field_145849_e + this.write.offsetZ : Integer.MIN_VALUE;
    }

    @Override
    public int getWriteX2() {
        return this.write2 != null ? this.field_145851_c + this.write2.offsetX : Integer.MIN_VALUE;
    }

    @Override
    public int getWriteY2() {
        return this.write2 != null ? this.field_145848_d + this.write2.offsetY : Integer.MIN_VALUE;
    }

    @Override
    public int getWriteZ2() {
        return this.write2 != null ? this.field_145849_e + this.write2.offsetZ : Integer.MIN_VALUE;
    }

    @Override
    public final World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public final int getX() {
        return this.field_145851_c;
    }

    @Override
    public final int getY() {
        return this.field_145848_d;
    }

    @Override
    public final int getZ() {
        return this.field_145849_e;
    }

    @Override
    public final int getIoOffsetX() {
        return this.pointoffsetx;
    }

    @Override
    public final int getIoOffsetY() {
        return this.pointoffsety;
    }

    @Override
    public final int getIoOffsetZ() {
        return this.pointoffsetz;
    }

    public boolean canTransmitPower() {
        return true;
    }

    public void onRotate() {
    }
}

