/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Blocks;

import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Base.BlockModelledMachine;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityAdvancedGear;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAdvGear
extends BlockModelledMachine {
    public BlockAdvGear(Material mat) {
        super(mat);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs xCreativeTabs, List yList) {
        for (int var4 = 0; var4 < 12; ++var4) {
            if (var4 % 4 != 0) continue;
            yList.add(new ItemStack(par1, 1, var4));
        }
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityAdvancedGear();
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harv) {
        if (this.canHarvest(world, player, x, y, z)) {
            // empty if block
        }
        this.func_149636_a(world, player, x, y, z, 0);
        return world.func_147468_f(x, y, z);
    }

    private boolean canHarvest(World world, EntityPlayer ep, int x, int y, int z) {
        return RotaryAux.canHarvestSteelMachine(ep);
    }

    public final void func_149636_a(World world, EntityPlayer ep, int x, int y, int z, int meta) {
        if (!this.canHarvest(world, ep, x, y, z)) {
            return;
        }
        TileEntityAdvancedGear te = (TileEntityAdvancedGear)world.func_147438_o(x, y, z);
        if (te != null) {
            ItemStack is = this.getDrop(te);
            ReikaItemHelper.dropItem((World)world, (double)((double)x + this.par5Random.nextDouble()), (double)((double)y + this.par5Random.nextDouble()), (double)((double)z + this.par5Random.nextDouble()), (ItemStack)is);
        }
    }

    private ItemStack getDrop(TileEntityAdvancedGear te) {
        ItemStack is = MachineRegistry.ADVANCEDGEARS.getCraftedMetadataProduct(te.func_145832_p() / 4);
        if (te.getGearType().storesEnergy()) {
            long e = te.getEnergy();
            if (is.field_77990_d == null) {
                is.field_77990_d = new NBTTagCompound();
            }
            is.field_77990_d.func_74772_a("energy", e);
            is.field_77990_d.func_74757_a("bedrock", te.isBedrockCoil());
        }
        if (te.getGearType().isLubricated()) {
            int lube = te.getLubricant();
            if (is.field_77990_d == null) {
                is.field_77990_d = new NBTTagCompound();
            }
            is.field_77990_d.func_74768_a("lube", lube);
            is.field_77990_d.func_74778_a("bearing", te.getBearingTier().name());
        }
        if (te.isUnHarvestable()) {
            is = ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.scrap, (int)(2 + this.par5Random.nextInt(12)));
        }
        return is;
    }

    @Override
    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        this.setFullBlockBounds();
        if (iba.func_72805_g(x, y, z) >= 8) {
            this.field_149756_F = 0.875;
        }
    }

    public final ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntityAdvancedGear te = (TileEntityAdvancedGear)world.func_147438_o(x, y, z);
        ret.add(this.getDrop(te));
        return ret;
    }
}

