/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Entities;

import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartCollisionEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;

public class EntityGasMinecart
extends EntityMinecart {
    private int fuel = 0;
    private int fueltick = 0;
    public double pushX;
    public double pushZ;

    public EntityGasMinecart(World par1World) {
        super(par1World);
    }

    public EntityGasMinecart(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
    }

    public int func_94087_l() {
        return 200;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.fueltick;
        if (this.fueltick >= EngineType.GAS.getFuelUnitDuration() * 25) {
            this.fueltick = 0;
            if (this.fuel > 0) {
                --this.fuel;
            }
        }
        if (this.fuel <= 0) {
            this.pushZ = 0.0;
            this.pushX = 0.0;
        }
        if (this.isMinecartPowered() && this.field_70146_Z.nextInt(4) == 0) {
            ReikaParticleHelper.SMOKE.spawnAt(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.8, this.field_70161_v);
        }
    }

    public void func_94095_a(DamageSource par1DamageSource) {
        super.func_94095_a(par1DamageSource);
        if (!par1DamageSource.func_94541_c()) {
            this.func_70099_a(EngineType.GAS.getCraftedProduct(), 0.0f);
        }
    }

    protected void func_145821_a(int par1, int par2, int par3, double par4, double par6, Block par8, int par9) {
        super.func_145821_a(par1, par2, par3, par4, par6, par8, par9);
        double d2 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (d2 > 1.0E-4 && this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 0.001) {
            d2 = MathHelper.func_76133_a((double)d2);
            this.pushX /= d2;
            this.pushZ /= d2;
            if (this.pushX * this.field_70159_w + this.pushZ * this.field_70179_y < 0.0) {
                this.pushX = 0.0;
                this.pushZ = 0.0;
            } else {
                this.pushX = this.field_70159_w;
                this.pushZ = this.field_70179_y;
            }
        }
        int futurex = (int)this.field_70165_t;
        int futurez = (int)this.field_70161_v;
        if (this.field_70159_w > 0.0) {
            ++futurex;
        }
        if (this.field_70159_w < 0.0) {
            --futurex;
        }
        if (this.field_70179_y > 0.0) {
            ++futurez;
        }
        if (this.field_70179_y < 0.0) {
            --futurez;
        }
        if (this.headingToCurve(futurex, (int)this.field_70163_u, futurez)) {
            if (this.field_70159_w > 0.0) {
                this.field_70159_w = 0.25;
            }
            if (this.field_70159_w < 0.0) {
                this.field_70159_w = -0.25;
            }
            if (this.field_70179_y > 0.0) {
                this.field_70179_y = 0.25;
            }
            if (this.field_70179_y < 0.0) {
                this.field_70179_y = -0.25;
            }
        }
    }

    private boolean headingToCurve(int futurex, int y, int futurez) {
        int meta;
        Block id = this.field_70170_p.func_147439_a(futurex, y, futurez);
        Block id2 = this.field_70170_p.func_147439_a((int)this.field_70165_t, y, (int)this.field_70161_v);
        if (id != Blocks.field_150448_aq && id2 != Blocks.field_150448_aq) {
            return false;
        }
        if (id == Blocks.field_150448_aq && ((meta = this.field_70170_p.func_72805_g(futurex, y, futurez)) == 6 || meta == 7 || meta == 8 || meta == 9)) {
            return true;
        }
        return id2 == Blocks.field_150448_aq && ((meta = this.field_70170_p.func_72805_g(futurex, y, futurez)) == 6 || meta == 7 || meta == 8 || meta == 9);
    }

    protected void func_94101_h() {
        double d0 = this.pushX * this.pushX + this.pushZ * this.pushZ;
        if (d0 > 1.0E-4) {
            d0 = MathHelper.func_76133_a((double)d0);
            this.pushX /= d0;
            this.pushZ /= d0;
            double d1 = 0.05;
            this.field_70159_w *= 0.9800000011920929;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= 0.9800000011920929;
            this.field_70159_w += this.pushX * d1;
            this.field_70179_y += this.pushZ * d1;
        } else {
            this.field_70159_w *= (double)0.98f;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= (double)0.98f;
        }
        super.func_94101_h();
    }

    public boolean func_130002_c(EntityPlayer par1EntityPlayer) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, par1EntityPlayer))) {
            return true;
        }
        ItemStack itemstack = par1EntityPlayer.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == ItemRegistry.ETHANOL.getItemInstance()) {
            if (--itemstack.field_77994_a == 0) {
                par1EntityPlayer.field_71071_by.func_70299_a(par1EntityPlayer.field_71071_by.field_70461_c, (ItemStack)null);
            }
            ++this.fuel;
        }
        this.pushX = this.field_70165_t - par1EntityPlayer.field_70165_t;
        this.pushZ = this.field_70161_v - par1EntityPlayer.field_70161_v;
        return true;
    }

    protected void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74780_a("PushX", this.pushX);
        par1NBTTagCompound.func_74780_a("PushZ", this.pushZ);
        par1NBTTagCompound.func_74777_a("Fuel", (short)this.fuel);
    }

    protected void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.pushX = par1NBTTagCompound.func_74769_h("PushX");
        this.pushZ = par1NBTTagCompound.func_74769_h("PushZ");
        this.fuel = par1NBTTagCompound.func_74765_d("Fuel");
    }

    protected boolean isMinecartPowered() {
        return this.fuel > 0;
    }

    public void moveMinecartOnRail(int x, int y, int z, double par4) {
        double d12 = this.field_70159_w;
        double d13 = this.field_70179_y;
        par4 *= 2.0;
        if (this.isMinecartPowered()) {
            this.field_70159_w *= 1.1;
            this.field_70179_y *= 1.1;
        }
        if (d12 < -par4) {
            d12 = -par4;
        }
        if (d12 > par4) {
            d12 = par4;
        }
        if (d13 < -par4) {
            d13 = -par4;
        }
        if (d13 > par4) {
            d13 = par4;
        }
        this.func_70091_d(d12, 0.0, d13);
    }

    public void func_70108_f(Entity par1Entity) {
        MinecraftForge.EVENT_BUS.post((Event)new MinecartCollisionEvent((EntityMinecart)this, par1Entity));
        if (EntityGasMinecart.getCollisionHandler() != null) {
            EntityGasMinecart.getCollisionHandler().onEntityCollision((EntityMinecart)this, par1Entity);
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            double d0 = par1Entity.field_70165_t - this.field_70165_t;
            double d1 = par1Entity.field_70161_v - this.field_70161_v;
            if (par1Entity instanceof EntityMinecart) {
                Vec3 vec31;
                double d4 = par1Entity.field_70165_t - this.field_70165_t;
                double d5 = par1Entity.field_70161_v - this.field_70161_v;
                Vec3 vec3 = Vec3.func_72443_a((double)d4, (double)0.0, (double)d5).func_72432_b();
                double d6 = Math.abs(vec3.func_72430_b(vec31 = Vec3.func_72443_a((double)MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)), (double)0.0, (double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f))).func_72432_b()));
                if (d6 < (double)0.8f) {
                    return;
                }
                double d7 = par1Entity.field_70159_w + this.field_70159_w;
                double d8 = par1Entity.field_70179_y + this.field_70179_y;
                if (((EntityMinecart)par1Entity).isPoweredCart() && !this.isPoweredCart()) {
                    par1Entity.field_70159_w *= (double)0.95f;
                    par1Entity.field_70179_y *= (double)0.95f;
                } else if (!((EntityMinecart)par1Entity).isPoweredCart() && this.isPoweredCart()) {
                    par1Entity.field_70159_w *= (double)0.2f;
                    par1Entity.field_70179_y *= (double)0.2f;
                    par1Entity.func_70024_g(this.field_70159_w + d0, 0.0, this.field_70179_y + d1);
                } else {
                    par1Entity.field_70159_w *= (double)0.2f;
                    par1Entity.field_70179_y *= (double)0.2f;
                    par1Entity.func_70024_g((d7 /= 2.0) + d0, 0.0, (d8 /= 2.0) + d1);
                }
            }
        }
    }

    public boolean isPoweredCart() {
        return true;
    }

    public Block func_145820_n() {
        return MachineRegistry.BLASTFURNACE.getBlock();
    }

    public int func_94098_o() {
        return MachineRegistry.BLASTFURNACE.getBlockMetadata();
    }
}

