/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Items.Tools;

import Reika.ChromatiCraft.API.ChromatiAPI;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Auxiliary.Trackers.KeyWatcher;
import Reika.DragonAPI.Interfaces.Item.MultiLayerItemSprite;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.API.Interfaces.Fillable;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.ItemRotaryArmor;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockArmor;
import Reika.RotaryCraft.Items.Tools.Steel.ItemSteelArmor;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IArmorApiarist;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@APIStripper.Strippable(value={"forestry.api.apiculture.IArmorApiarist"})
public class ItemJetPack
extends ItemRotaryArmor
implements Fillable,
MultiLayerItemSprite,
IArmorApiarist {
    public ItemJetPack(ItemArmor.ArmorMaterial mat, int tex, int render) {
        super(mat, render, 1, tex);
    }

    public int getFuel(ItemStack is) {
        NBTTagCompound nbt = is.field_77990_d;
        if (nbt == null) {
            return 0;
        }
        return nbt.func_74762_e("fuel");
    }

    public void use(ItemStack is, int amount) {
        int newFuel = this.getFuel(is) - amount;
        if (newFuel < 0) {
            newFuel = 0;
        }
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        this.setFuel(is, this.getCurrentFluid(is), newFuel);
    }

    @Override
    protected final ItemStack onSneakClicked(ItemStack is, EntityPlayer ep) {
        if (!PackUpgrades.WING.existsOn(is)) {
            return is;
        }
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74757_a("wingon", !is.field_77990_d.func_74767_n("wingon"));
        return is;
    }

    private static final boolean wingEnabled(ItemStack is) {
        return PackUpgrades.WING.existsOn(is) && (is.field_77990_d == null || is.field_77990_d.func_74767_n("wingon"));
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack is) {
        boolean fuel;
        boolean flying = this.useJetpack(player, is);
        boolean bl = fuel = this.getCurrentFillLevel(is) > 0;
        if (!PackUpgrades.COOLING.existsOn(is) && fuel) {
            if (player.func_70058_J() && world.field_73013_u != EnumDifficulty.PEACEFUL) {
                this.explode(world, player);
            } else if (player.func_70027_ad() && world.field_73013_u.ordinal() > 1 && flying) {
                this.explode(world, player);
            }
        }
        if (flying && fuel && world.field_73013_u != EnumDifficulty.PEACEFUL && field_77697_d.nextInt(4) == 0) {
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int y = MathHelper.func_76128_c((double)player.field_70163_u);
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)1);
            int dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)1);
            int dy = ReikaRandomHelper.getRandomBetween((int)(y - 2), (int)y);
            Fluid f = ReikaWorldHelper.getFluid((IBlockAccess)world, (int)dx, (int)dy, (int)dz);
            if (f != null && ReikaFluidHelper.isFlammable((Fluid)f)) {
                ReikaWorldHelper.ignite((World)world, (int)dx, (int)dy, (int)dz);
            }
        }
        player.getEntityData().func_74757_a("jetpack", flying);
    }

    private boolean useJetpack(EntityPlayer ep, ItemStack is) {
        boolean canFly;
        float thrust;
        boolean floatmode;
        boolean isFlying = KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.JUMP);
        boolean hoverMode = isFlying && ep.func_70093_af();
        boolean jetbonus = !ConfigRegistry.JETFUELPACK.getState() && this.isJetFueled(is);
        boolean horiz = KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.FORWARD) || KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.BACK);
        horiz = horiz || KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.LEFT) || KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.RIGHT);
        float maxSpeed = jetbonus ? 3.0f : 1.25f;
        double hspeed = ReikaMathLibrary.py3d((double)ep.field_70159_w, (double)0.0, (double)ep.field_70179_y);
        boolean winged = ItemJetPack.wingEnabled(is);
        boolean propel = PackUpgrades.JET.existsOn(is) && this.isJetFueled(is);
        boolean bl = floatmode = !hoverMode;
        float f = winged ? 0.15f : (thrust = hoverMode ? 0.05f : 0.1f);
        if (propel) {
            thrust *= hoverMode ? 2.0f : 4.0f;
        }
        if (jetbonus) {
            thrust *= 1.25f;
        }
        if (ep.field_70154_o != null) {
            thrust *= 1.25f;
        }
        boolean bl2 = canFly = !hoverMode || !ep.field_70122_E && ep.field_70181_x < 0.0;
        if (isFlying && canFly) {
            if (!(ep.field_70170_p.field_72995_K || ep.field_71075_bZ.field_75098_d || ep.field_71075_bZ.field_75100_b || ep.field_70170_p.func_82737_E() % 2L != 0L)) {
                this.use(is, (hoverMode ? 2 : 1) * this.getFuelUsageMultiplier());
            }
            if (this.getFuel(is) > 0) {
                if (hoverMode) {
                    ep.field_70181_x = ep.field_70181_x > 0.0 ? Math.max(ep.field_70181_x * 0.75, 0.0) : Math.min(ep.field_70181_x + 0.15, 0.0);
                } else {
                    double deltav;
                    double d = deltav = ep.field_70181_x > 0.0 ? Math.min(0.2, Math.max(0.05, ((double)maxSpeed - ep.field_70181_x) * 0.25)) : 0.2;
                    if (jetbonus && !horiz) {
                        deltav *= 1.5;
                    }
                    if (ep.field_70154_o != null) {
                        deltav *= 1.5;
                    }
                    ep.field_70181_x = Math.min(ep.field_70181_x + deltav, (double)maxSpeed);
                }
                if (KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.FORWARD)) {
                    ep.func_70060_a(0.0f, thrust, thrust);
                    if (ep.field_70170_p.func_82737_E() % 2L == 0L && !ep.field_71075_bZ.field_75098_d) {
                        this.use(is, this.getFuelUsageMultiplier());
                    }
                }
                if (KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.BACK)) {
                    ep.func_70060_a(0.0f, -thrust, thrust);
                    if (ep.field_70170_p.func_82737_E() % 2L == 0L && !ep.field_71075_bZ.field_75098_d) {
                        this.use(is, this.getFuelUsageMultiplier());
                    }
                }
                if (KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.LEFT)) {
                    ep.func_70060_a(thrust, 0.0f, thrust);
                    if (ep.field_70170_p.func_82737_E() % 2L == 0L && !ep.field_71075_bZ.field_75098_d) {
                        this.use(is, this.getFuelUsageMultiplier());
                    }
                }
                if (KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.RIGHT)) {
                    ep.func_70060_a(-thrust, 0.0f, thrust);
                    if (ep.field_70170_p.func_82737_E() % 2L == 0L && !ep.field_71075_bZ.field_75098_d) {
                        this.use(is, this.getFuelUsageMultiplier());
                    }
                }
                if (!ep.field_70170_p.field_72995_K) {
                    ep.field_70143_R = -2.0f;
                    if (ConfigRegistry.KICKFLYING.getState() && ep instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)ep).field_71135_a.field_147365_f = 0;
                    }
                }
                float pitch = 1.0f + 0.5f * (float)Math.sin(ep.field_70170_p.func_72820_D() * 2L % 360L);
                SoundRegistry.JETPACK.playSound(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, 0.75f, pitch);
                if (propel) {
                    SoundRegistry.SHORTJET.playSound(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, 0.15f, 1.0f);
                }
            }
        }
        if (ep.field_70181_x < 0.0 && winged && floatmode && !ep.func_70608_bn() && (!ModList.CHROMATICRAFT.isLoaded() || !ChromatiAPI.getAPI().rituals().isPlayerUndergoingRitual(ep))) {
            double d;
            boolean sneak = ep.func_70093_af() != ConfigRegistry.SNEAKWINGS.getState();
            double ang = Math.cos(Math.toRadians(ep.field_70125_A));
            double d2 = ep.field_70181_x <= -2.0 ? 0.0625 : (ep.field_70181_x <= -1.0 ? 0.125 : (d = ep.field_70181_x <= -0.5 ? 0.25 : 0.5));
            if (sneak) {
                d *= 0.125;
            }
            double fac = 1.0 - d * ang;
            ep.field_70181_x *= fac;
            ep.field_70143_R = (float)((double)ep.field_70143_R * (fac *= sneak ? 0.999 : 0.9));
            double dv = 0.05;
            double vh = ep.field_70122_E ? 0.0 : dv * ang;
            double vx = Math.cos(Math.toRadians(ep.field_70759_as + 90.0f)) * vh;
            double vz = Math.sin(Math.toRadians(ep.field_70759_as + 90.0f)) * vh;
            ep.field_70159_w += vx;
            ep.field_70179_y += vz;
        }
        if (isFlying && ep.field_70154_o != null) {
            ep.field_70154_o.field_70159_w = ep.field_70159_w;
            ep.field_70154_o.field_70181_x = ep.field_70181_x;
            ep.field_70154_o.field_70179_y = ep.field_70179_y;
            ep.field_70154_o.field_70143_R = ep.field_70143_R;
        }
        return isFlying;
    }

    public ItemStack getMaterial() {
        return this.isBedrock() ? ItemStacks.bedingot : ItemStacks.steelingot;
    }

    public boolean isBedrock() {
        return this == ItemRegistry.BEDPACK.getItemInstance();
    }

    public boolean isSteel() {
        return this == ItemRegistry.STEELPACK.getItemInstance();
    }

    private int getFuelUsageMultiplier() {
        return this.isBedrock() ? 2 : 1;
    }

    private void explode(World world, EntityPlayer player) {
        ItemStack to = this.isBedrock() ? ItemRegistry.BEDCHEST.getEnchantedStack() : (this.isSteel() ? ItemRegistry.STEELCHEST.getStackOf() : null);
        player.func_70062_b(3, to);
        world.func_72876_a((Entity)player, player.field_70165_t, player.field_70163_u, player.field_70161_v, 2.0f, false);
        double v = 4.0;
        double ang = field_77697_d.nextDouble() * 360.0;
        double vx = v * Math.cos(Math.toRadians(ang));
        double vz = v * Math.sin(Math.toRadians(ang));
        player.func_70024_g(vx, 1.25, vz);
        player.field_70133_I = true;
    }

    public int getMaxFuel(ItemStack is) {
        return 30000;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean par4) {
        for (int i = 0; i < PackUpgrades.list.length; ++i) {
            PackUpgrades pack = PackUpgrades.list[i];
            if (!pack.existsOn(is)) continue;
            li.add(pack.label);
            if (pack != PackUpgrades.WING) continue;
            if (ItemJetPack.wingEnabled(is)) continue;
            li.add(EnumChatFormatting.RED + "[Wing Disabled]");
        }
        int ch = is.field_77990_d != null ? is.field_77990_d.func_74762_e("fuel") : 0;
        li.add(ch > 0 ? String.format("Fuel: %d mB of %s", ch, this.getCurrentFluid(is).getLocalizedName()) : "No Fuel");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs cr, List li) {
        ItemStack is = new ItemStack(id, 1, 0);
        if (this.isBedrock()) {
            HashMap<Enchantment, Integer> ench = ((ItemBedrockArmor)ItemRegistry.BEDCHEST.getItemInstance()).getDefaultEnchantments();
            ReikaEnchantmentHelper.applyEnchantments((ItemStack)is, ench);
        }
        ItemStack is2 = is.func_77946_l();
        ItemStack is3 = is.func_77946_l();
        Fluid f = ConfigRegistry.JETFUELPACK.getState() ? FluidRegistry.getFluid((String)"rc jet fuel") : FluidRegistry.getFluid((String)"rc ethanol");
        this.setFuel(is, f, this.getMaxFuel(is));
        this.setFuel(is3, FluidRegistry.getFluid((String)"rc jet fuel"), this.getMaxFuel(is3));
        ItemStack is5 = is3.func_77946_l();
        PackUpgrades.WING.enable(is3, true);
        for (int i = 0; i < PackUpgrades.list.length; ++i) {
            PackUpgrades pack = PackUpgrades.list[i];
            pack.enable(is3, true);
        }
        ItemRegistry ir = ItemRegistry.getEntry(is);
        if (ir.isAvailableInCreativeInventory()) {
            li.add(is2);
            li.add(is);
            li.add(is5);
            li.add(is3);
        }
    }

    @Override
    public boolean isValidFluid(Fluid f, ItemStack is) {
        Fluid f2 = this.getCurrentFluid(is);
        if (f2 != null && !f.equals(f2)) {
            return false;
        }
        if (f.equals(FluidRegistry.getFluid((String)"rc jet fuel"))) {
            return true;
        }
        if (f.equals(FluidRegistry.getFluid((String)"rocket fuel"))) {
            return true;
        }
        if (f.equals(FluidRegistry.getFluid((String)"rc ethanol"))) {
            return !ConfigRegistry.JETFUELPACK.getState();
        }
        return false;
    }

    @Override
    public int getCapacity(ItemStack is) {
        return this.getMaxFuel(is);
    }

    @Override
    public int getCurrentFillLevel(ItemStack is) {
        return this.getFuel(is);
    }

    private void setFuel(ItemStack is, Fluid f, int amt) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74768_a("fuel", amt);
        if (amt > 0) {
            ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)is.field_77990_d, (Fluid)f);
        } else {
            ReikaNBTHelper.writeFluidToNBT((NBTTagCompound)is.field_77990_d, null);
        }
    }

    @Override
    public int addFluid(ItemStack is, Fluid f, int amt) {
        if (f == null || !this.isValidFluid(f, is)) {
            return 0;
        }
        NBTTagCompound nbt = is.field_77990_d;
        if (nbt == null) {
            is.field_77990_d = new NBTTagCompound();
            this.setFuel(is, f, amt);
            return amt;
        }
        int cap = this.getCapacity(is);
        int cur = nbt.func_74762_e("fuel");
        int sum = cur + amt;
        if (sum > cap) {
            this.setFuel(is, f, cap);
            return cap - cur;
        }
        this.setFuel(is, f, sum);
        return amt;
    }

    @Override
    public boolean providesProtection() {
        return this.isBedrock() || this.isSteel();
    }

    @Override
    public boolean canBeDamaged() {
        return this.isSteel();
    }

    @Override
    public double getDamageMultiplier(DamageSource src) {
        if (this.isBedrock()) {
            return ((ItemBedrockArmor)ItemRegistry.BEDCHEST.getItemInstance()).getDamageMultiplier(src);
        }
        if (this.isSteel()) {
            return ((ItemSteelArmor)ItemRegistry.STEELCHEST.getItemInstance()).getDamageMultiplier(src);
        }
        return 1.0;
    }

    @Override
    public boolean isFull(ItemStack is) {
        return this.getCurrentFillLevel(is) >= this.getCapacity(is);
    }

    @Override
    public Fluid getCurrentFluid(ItemStack is) {
        if (is.field_77990_d == null) {
            return null;
        }
        int lvl = this.getCurrentFillLevel(is);
        Fluid f = ReikaNBTHelper.getFluidFromNBT((NBTTagCompound)is.field_77990_d);
        if (lvl > 0 && f == null) {
            this.setFuel(is, null, 0);
            return null;
        }
        return lvl > 0 ? f : null;
    }

    public boolean isJetFueled(ItemStack is) {
        Fluid f = this.getCurrentFluid(is);
        return f != null && f.equals(FluidRegistry.getFluid((String)"rc jet fuel"));
    }

    public EnumSet<PackUpgrades> getUpgrades(ItemStack is) {
        EnumSet<PackUpgrades> set = EnumSet.noneOf(PackUpgrades.class);
        for (int i = 0; i < PackUpgrades.list.length; ++i) {
            PackUpgrades p = PackUpgrades.list[i];
            if (!p.existsOn(is)) continue;
            set.add(p);
        }
        return set;
    }

    public int[] getIndices(ItemStack is) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        li.add(this.getItemSpriteIndex(is));
        if (PackUpgrades.WING.existsOn(is)) {
            int w = this.isBedrock() ? 59 : (this.isSteel() ? 61 : 60);
            li.add(w);
        }
        return ReikaArrayHelper.intListToArray(li);
    }

    public boolean func_82789_a(ItemStack tool, ItemStack item) {
        return tool.func_77973_b() == this && this.isSteel() && ReikaItemHelper.matchStacks((ItemStack)item, (ItemStack)ItemStacks.steelingot);
    }

    public boolean protectEntity(EntityLivingBase entity, ItemStack armor, String cause, boolean doProtect) {
        ItemStack head = entity.func_71124_b(4);
        return head != null && head.func_77973_b() instanceof IArmorApiarist && ((IArmorApiarist)head.func_77973_b()).protectEntity(entity, head, cause, doProtect);
    }

    @Deprecated
    public boolean protectPlayer(EntityPlayer player, ItemStack armor, String cause, boolean doProtect) {
        return this.protectEntity((EntityLivingBase)player, armor, cause, doProtect);
    }

    public final void setDamage(ItemStack stack, int damage) {
    }

    public static enum PackUpgrades {
        WING("Winged"),
        JET("Thrust Boost"),
        COOLING("Fin-Cooled");

        public final String label;
        private static final PackUpgrades[] list;

        private PackUpgrades(String s) {
            this.label = s;
        }

        public boolean existsOn(ItemStack is) {
            return is.field_77990_d != null && is.field_77990_d.func_74767_n(this.getNBT());
        }

        private String getNBT() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public void enable(ItemStack is, boolean set) {
            if (is.field_77990_d == null) {
                is.field_77990_d = new NBTTagCompound();
            }
            is.field_77990_d.func_74757_a(this.getNBT(), set);
            if (this == WING) {
                is.field_77990_d.func_74757_a("wingon", true);
            }
        }

        static {
            list = PackUpgrades.values();
        }
    }
}

