/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.Minetweaker;

import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesPulseFurnace;
import Reika.RotaryCraft.ModInterface.Minetweaker.MinetweakerHelper;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rotarycraft.PulseJet")
public class PulseJetTweaker {
    private static final RecipesPulseFurnace recipes = RecipesPulseFurnace.getRecipes();

    @ZenMethod
    public static void addRecipe(IIngredient input, IIngredient output) {
        ItemStack out = MinetweakerHelper.getStack(output);
        if (!PulseJetTweaker.isValid(out)) {
            throw new IllegalArgumentException("You cannot add alternate recipes for native RotaryCraft items!");
        }
        MineTweakerAPI.apply((IUndoableAction)new AddRecipe(input, output));
    }

    private static boolean isValid(ItemStack out) {
        return !out.func_77973_b().getClass().getName().startsWith("Reika.RotaryCraft.Items");
    }

    private static class AddRecipe
    implements IUndoableAction {
        private ArrayList<ItemStack> inputs = new ArrayList();
        private ItemStack output;

        public AddRecipe(IIngredient input, IIngredient output) {
            List<ItemStack> toAddRecipe = MinetweakerHelper.getStacks(input);
            for (ItemStack in : toAddRecipe) {
                if (recipes.isSmeltable(in)) continue;
                this.inputs.add(in);
            }
        }

        public void apply() {
            for (ItemStack in : this.inputs) {
                recipes.addCustomRecipe(in, this.output, -1);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (ItemStack in : this.inputs) {
                recipes.removeRecipe(in + ">" + this.output);
            }
        }

        public String describe() {
            return "Adding " + this.inputs.size() + " recipe" + (this.inputs.size() > 1 ? "s" : "") + " to Pulse Jet for " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Removing " + this.inputs.size() + " recipe" + (this.inputs.size() > 1 ? "s" : "") + " to Pulse Jet for " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

