/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.NEI;

import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaLiquidRenderer;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesCrystallizer;
import Reika.RotaryCraft.GUIs.Machine.Inventory.GuiCrystallizer;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Processing.TileEntityCrystallizer;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class CrystallizerHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Fluid Crystallizer";
    }

    public String getGuiTexture() {
        return "/Reika/RotaryCraft/Textures/GUI/crystalgui.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        GL11.glDisable((int)2929);
        ReikaGuiAPI.instance.drawTexturedModalRectWithDepth(0, 1, 5, 11, 166, 70, ReikaGuiAPI.NEI_DEPTH);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        this.drawExtras(recipe);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(23, 23, 46, 18), "rccrystall", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId != null && outputId.equals("rccrystall")) {
            Collection<RecipesCrystallizer.CrystallizerRecipe> li = RecipesCrystallizer.getRecipes().getAllRecipes();
            for (RecipesCrystallizer.CrystallizerRecipe f : li) {
                this.arecipes.add(new CrystallizerNEIRecipe(f));
            }
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId != null && inputId.equals("rccrystall")) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void loadCraftingRecipes(ItemStack result) {
        RecipesCrystallizer.CrystallizerRecipe f = RecipesCrystallizer.getRecipes().getRecipe(result);
        if (f != null) {
            this.arecipes.add(new CrystallizerNEIRecipe(f));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ItemStack is;
        FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)ingredient);
        if (fs != null && (is = RecipesCrystallizer.getRecipes().getFreezingResult(fs)) != null) {
            this.arecipes.add(new CrystallizerNEIRecipe(RecipesCrystallizer.getRecipes().getRecipe(is)));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrystallizer.class;
    }

    public void drawExtras(int recipe) {
        this.drawFluids(recipe);
        this.drawTemperatures(recipe);
    }

    private void drawTemperatures(int recipe) {
        CrystallizerNEIRecipe r = (CrystallizerNEIRecipe)((Object)this.arecipes.get(recipe));
        FluidStack fs = r.input.getFluid();
        if (fs != null) {
            int freeze = TileEntityCrystallizer.getFreezingPoint(fs);
            FontRenderer f = Minecraft.func_71410_x().field_71466_p;
            String s = String.format("%dC", freeze);
            ReikaGuiAPI.instance.drawCenteredStringNoShadow(f, s, 45, 20, 0);
        }
    }

    private void drawFluids(int recipe) {
        CrystallizerNEIRecipe r = (CrystallizerNEIRecipe)((Object)this.arecipes.get(recipe));
        FluidStack fs = r.input.getFluid();
        if (fs != null) {
            Fluid f = fs.getFluid();
            IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)f);
            float u = ico.func_94209_e();
            float v = ico.func_94206_g();
            float du = ico.func_94212_f();
            float dv = ico.func_94210_h();
            ReikaTextureHelper.bindTerrainTexture();
            Tessellator v5 = Tessellator.field_78398_a;
            v5.func_78382_b();
            for (int i = 0; i < 4; ++i) {
                int y = 2 + i * 16;
                v5.func_78374_a(3.0, (double)y, 0.0, (double)u, (double)v);
                v5.func_78374_a(3.0, (double)(y + 16), 0.0, (double)u, (double)dv);
                v5.func_78374_a(19.0, (double)(y + 16), 0.0, (double)du, (double)dv);
                v5.func_78374_a(19.0, (double)y, 0.0, (double)du, (double)v);
            }
            float v2 = v + (dv - v) * 5.0f / 16.0f;
            v5.func_78374_a(3.0, 64.0, 0.0, (double)u, (double)v2);
            v5.func_78374_a(3.0, 69.0, 0.0, (double)u, (double)v);
            v5.func_78374_a(19.0, 69.0, 0.0, (double)du, (double)v);
            v5.func_78374_a(19.0, 64.0, 0.0, (double)du, (double)v2);
            v5.func_78381_a();
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            String s = f.getLocalizedName() + " (" + fs.amount + " mB)";
            fr.func_78276_b(s, 22, 56, 0);
        }
    }

    public class CrystallizerNEIRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final RecipesCrystallizer.CrystallizerRecipe input;

        public CrystallizerNEIRecipe(RecipesCrystallizer.CrystallizerRecipe in) {
            super((TemplateRecipeHandler)CrystallizerHandler.this);
            this.input = in;
        }

        public PositionedStack getResult() {
            if (this.input != null) {
                return new PositionedStack((Object)this.input.getOutput(), 75, 25);
            }
            return null;
        }

        public PositionedStack getIngredient() {
            return null;
        }
    }
}

