/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.NEI;

import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesFrictionHeater;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.item.ItemStack;

public class FrictionHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Friction Heater";
    }

    public String getGuiTexture() {
        return "textures/gui/container/furnace.png";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 23, 18), "rcfriction", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId != null && outputId.equals("rcfriction")) {
            Collection<ItemStack> li = RecipesFrictionHeater.getRecipes().getAllSmeltables();
            for (ItemStack is : li) {
                this.arecipes.add(new FrictionHeaterRecipe(is));
            }
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId != null && inputId.equals("rcfriction")) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void loadCraftingRecipes(ItemStack result) {
        Collection<RecipesFrictionHeater.FrictionRecipe> rec = RecipesFrictionHeater.getRecipes().getRecipesByOutput(result);
        if (rec != null) {
            for (RecipesFrictionHeater.FrictionRecipe f : rec) {
                this.arecipes.add(new FrictionHeaterRecipe(f.getInput()));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        RecipesFrictionHeater.FrictionRecipe rec = RecipesFrictionHeater.getRecipes().getRecipeByInput(ingredient);
        if (rec != null) {
            this.arecipes.add(new FrictionHeaterRecipe(ingredient));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiFurnace.class;
    }

    public void drawExtras(int recipe) {
        FrictionHeaterRecipe rec = (FrictionHeaterRecipe)((Object)this.arecipes.get(recipe));
        String temp = String.format("Requires %dC", rec.temperature);
        String time = String.format("Time: %.2fs", (double)rec.duration / 20.0);
        ReikaGuiAPI.instance.drawCenteredStringNoShadow(Minecraft.func_71410_x().field_71466_p, temp, 83, 65, 0);
        ReikaGuiAPI.instance.drawCenteredStringNoShadow(Minecraft.func_71410_x().field_71466_p, time, 83, 80, 0);
    }

    public class FrictionHeaterRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final ItemStack input;
        private final ItemStack output;
        public final int temperature;
        public final int duration;

        private FrictionHeaterRecipe(ItemStack in) {
            super((TemplateRecipeHandler)FrictionHandler.this);
            this.input = in;
            RecipesFrictionHeater.FrictionRecipe rec = RecipesFrictionHeater.getRecipes().getRecipeByInput(in);
            this.output = rec != null ? rec.getOutput() : null;
            this.temperature = rec != null ? rec.requiredTemperature : Integer.MIN_VALUE;
            this.duration = rec != null ? rec.duration : Integer.MIN_VALUE;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.output, 111, 24);
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)ReikaItemHelper.getSizedItemStack((ItemStack)this.input, (int)1), 51, 6);
        }
    }
}

