/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.NEI;

import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaLiquidRenderer;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesLavaMaker;
import Reika.RotaryCraft.GUIs.Machine.Inventory.GuiRockMelter;
import Reika.RotaryCraft.RotaryCraft;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class LavaMakerHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Rock Melter";
    }

    public String getGuiTexture() {
        return "/Reika/RotaryCraft/Textures/GUI/basicstorage.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        GL11.glDisable((int)2929);
        ReikaGuiAPI.instance.drawTexturedModalRectWithDepth(0, 1, 5, 11, 166, 70, ReikaGuiAPI.NEI_DEPTH);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        ReikaTextureHelper.bindTexture(RotaryCraft.class, (String)this.getGuiTexture());
        this.drawExtras(recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(77, 10, 50, 60), "rcrockmelt", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId != null && outputId.equals("rcrockmelt")) {
            Collection<ItemStack> li = RecipesLavaMaker.getRecipes().getAllRecipes();
            for (ItemStack is : li) {
                this.arecipes.add(new LavaMakerRecipe(is));
            }
        } else if (outputId != null && outputId.equals("liquid")) {
            FluidStack fs = (FluidStack)results[0];
            ArrayList<ItemStack> li = RecipesLavaMaker.getRecipes().getSourceItems(fs.getFluid());
            if (li != null && !li.isEmpty()) {
                this.arecipes.add(new LavaMakerRecipe(li));
            }
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId != null && inputId.equals("rcrockmelt")) {
            this.loadCraftingRecipes(inputId, ingredients);
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void loadCraftingRecipes(ItemStack result) {
        ArrayList<ItemStack> li;
        FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)result);
        if (fs != null && (li = RecipesLavaMaker.getRecipes().getSourceItems(fs.getFluid())) != null && !li.isEmpty()) {
            this.arecipes.add(new LavaMakerRecipe(li));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        FluidStack fs = RecipesLavaMaker.getRecipes().getMelting(ingredient);
        if (fs != null) {
            this.arecipes.add(new LavaMakerRecipe(ingredient));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiRockMelter.class;
    }

    public void drawExtras(int recipe) {
        this.drawFluids(recipe);
        this.drawTemperatures(recipe);
    }

    private void drawTemperatures(int recipe) {
        LavaMakerRecipe r = (LavaMakerRecipe)((Object)this.arecipes.get(recipe));
        ItemStack is = r.getInput();
        if (is != null) {
            FluidStack fs = RecipesLavaMaker.getRecipes().getMelting(is);
            int melt = RecipesLavaMaker.getRecipes().getMeltTemperature(is);
            FontRenderer f = Minecraft.func_71410_x().field_71466_p;
            String s = String.format("%dmB @ %dC", fs.amount, melt);
            f.func_78276_b(s, 165 - f.func_78256_a(s), 73, 0);
            s = String.format("%s", fs.getLocalizedName());
            f.func_78276_b(s, 165 - f.func_78256_a(s), 83, 0);
        }
    }

    private void drawFluids(int recipe) {
        LavaMakerRecipe r = (LavaMakerRecipe)((Object)this.arecipes.get(recipe));
        ItemStack in = r.getInput();
        FluidStack fs = RecipesLavaMaker.getRecipes().getMelting(in);
        if (fs != null) {
            Fluid f = fs.getFluid();
            IIcon ico = ReikaLiquidRenderer.getFluidIconSafe((Fluid)f);
            float u = ico.func_94209_e();
            float v = ico.func_94206_g();
            float du = ico.func_94212_f();
            float dv = ico.func_94210_h();
            ReikaTextureHelper.bindTerrainTexture();
            Tessellator v5 = Tessellator.field_78398_a;
            v5.func_78382_b();
            for (int i = 0; i < 4; ++i) {
                int x = 147;
                int y = 7 + i * 16;
                v5.func_78374_a((double)x, (double)y, 0.0, (double)u, (double)v);
                v5.func_78374_a((double)x, (double)(y + 16), 0.0, (double)u, (double)dv);
                v5.func_78374_a((double)(x + 16), (double)(y + 16), 0.0, (double)du, (double)dv);
                v5.func_78374_a((double)(x + 16), (double)y, 0.0, (double)du, (double)v);
            }
            v5.func_78381_a();
        }
    }

    public class LavaMakerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private ArrayList<ItemStack> input;

        private LavaMakerRecipe(ArrayList<ItemStack> in) {
            super((TemplateRecipeHandler)LavaMakerHandler.this);
            this.input = in;
        }

        private LavaMakerRecipe(ItemStack in) {
            super((TemplateRecipeHandler)LavaMakerHandler.this);
            this.input = new ArrayList();
            this.input.add(in);
        }

        public ItemStack getInput() {
            int index = (int)(System.currentTimeMillis() / 1000L % (long)this.input.size());
            return this.input.get(index);
        }

        public PositionedStack getResult() {
            return null;
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)this.getInput(), 3, 8);
        }
    }
}

