/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.Auxiliary.EnumDifficulty;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public enum GearboxTypes {
    WOOD(1, MaterialRegistry.WOOD),
    STONE(2, MaterialRegistry.STONE),
    STEEL(0, MaterialRegistry.STEEL),
    TUNGSTEN(7, MaterialRegistry.TUNGSTEN),
    DIAMOND(3, MaterialRegistry.DIAMOND),
    BEDROCK(4, MaterialRegistry.BEDROCK),
    LIVINGWOOD(5, MaterialRegistry.WOOD, ModList.BOTANIA),
    LIVINGROCK(6, MaterialRegistry.STONE, ModList.BOTANIA);

    public final int metaOffset;
    public final MaterialRegistry material;
    private final ModList dependency;
    public static final GearboxTypes[] typeList;

    private GearboxTypes(int row, MaterialRegistry mat) {
        this(row, mat, null);
    }

    private GearboxTypes(int row, MaterialRegistry mat, ModList mod) {
        this.metaOffset = row;
        this.material = mat;
        this.dependency = mod;
    }

    public boolean isLoadable() {
        return this.dependency == null || this.dependency.isLoaded();
    }

    public boolean needsLubricant() {
        return this != WOOD && this.isDamageableGear();
    }

    public boolean consumesLubricant() {
        return this.needsLubricant() && this != DIAMOND;
    }

    public boolean acceptsDiamondUpgrade() {
        return this.consumesLubricant() && this != STONE;
    }

    public float getLubricantConsumeRate(int omegain) {
        switch (this) {
            case STONE: {
                return Math.max(1.0f, 1.0f + (float)omegain / 8192.0f);
            }
            case TUNGSTEN: {
                return Math.min(1.0f, 0.5f + Math.max(0.0f, 0.03125f * (float)(ReikaMathLibrary.logbase2((long)omegain) - 2)));
            }
        }
        return 1.0f;
    }

    public boolean generatesHeat(int omega, int Tamb) {
        switch (this) {
            case WOOD: {
                return true;
            }
            case LIVINGWOOD: {
                return omega >= 2048 || Tamb >= 100;
            }
            case STONE: {
                return omega >= 8192;
            }
        }
        return false;
    }

    public boolean takesTemperatureDamage() {
        return this == WOOD || this == STONE;
    }

    public boolean isDamageableGear() {
        return !this.material.isInfiniteStrength();
    }

    public String getBaseGearboxTexture() {
        String tex = "geartex";
        switch (this) {
            case BEDROCK: {
                tex = tex + "b";
                break;
            }
            case DIAMOND: {
                tex = tex + "d";
                break;
            }
            case STONE: {
                tex = tex + "s";
                break;
            }
            case TUNGSTEN: {
                tex = tex + "t";
                break;
            }
            case WOOD: {
                tex = tex + "w";
                break;
            }
            case LIVINGROCK: {
                tex = tex + "s_living";
                break;
            }
            case LIVINGWOOD: {
                tex = tex + "w_living";
                break;
            }
        }
        return tex + ".png";
    }

    public ItemStack getPart(GearPart part) {
        return ItemRegistry.GEARCRAFT.getStackOfMetadata(this.metaOffset * 16 + part.ordinal());
    }

    public ItemStack getShaftUnitItem() {
        if (this == WOOD) {
            return new ItemStack(Items.field_151055_y);
        }
        if (this == TUNGSTEN && DifficultyEffects.getDifficulty() == EnumDifficulty.EASY) {
            return STEEL.getShaftUnitItem();
        }
        return ItemRegistry.GEARCRAFT.getStackOfMetadata(this.metaOffset * 16);
    }

    public Object getBaseItem() {
        switch (this) {
            case WOOD: {
                return "plankWood";
            }
            case STONE: {
                return new ItemStack(Blocks.field_150348_b);
            }
            case LIVINGWOOD: {
                return new ItemStack(GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"livingwood"));
            }
            case LIVINGROCK: {
                return new ItemStack(GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"livingrock"));
            }
            case STEEL: {
                return ItemStacks.steelingot;
            }
            case TUNGSTEN: {
                return ItemStacks.springtungsten;
            }
            case DIAMOND: {
                return Items.field_151045_i;
            }
            case BEDROCK: {
                return ItemStacks.bedingot;
            }
        }
        return Blocks.field_150350_a;
    }

    public Object getMountItem() {
        switch (this) {
            case WOOD: {
                return "plankWood";
            }
            case STONE: {
                return ReikaItemHelper.stoneSlab.asItemStack();
            }
            case LIVINGWOOD: {
                return new ItemStack(GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"livingwood0Slab"));
            }
            case LIVINGROCK: {
                return new ItemStack(GameRegistry.findBlock((String)ModList.BOTANIA.modLabel, (String)"livingrock0Slab"));
            }
        }
        return ItemStacks.mount;
    }

    public int getMaxLubricant() {
        switch (this) {
            case BEDROCK: {
                return 0;
            }
            case DIAMOND: {
                return 1000;
            }
            case TUNGSTEN: 
            case STEEL: {
                return 24000;
            }
            case STONE: {
                return 8000;
            }
            case LIVINGROCK: {
                return 3000;
            }
            case WOOD: 
            case LIVINGWOOD: {
                return 0;
            }
        }
        return 0;
    }

    public boolean acceptsBearingUpgrade(GearboxTypes mat) {
        switch (this) {
            case LIVINGWOOD: 
            case BEDROCK: 
            case LIVINGROCK: {
                return false;
            }
            case WOOD: {
                return false;
            }
        }
        return mat != WOOD && mat.material.ordinal() <= this.material.ordinal() + 2 && !mat.isSpecialType();
    }

    private boolean isSpecialType() {
        switch (this) {
            case LIVINGWOOD: 
            case LIVINGROCK: {
                return true;
            }
        }
        return false;
    }

    public ItemStack getGearboxItemByIndex(int index) {
        ItemStack is = MachineRegistry.GEARBOX.getCraftedMetadataProduct(index);
        is.field_77990_d = new NBTTagCompound();
        is.field_77990_d.func_74778_a("type", this.name());
        return is;
    }

    public ItemStack getGearboxItem(int ratio) {
        return this.getGearboxItemByIndex(ReikaMathLibrary.logbase2((long)ratio) - 1);
    }

    public String getLocalizedGearboxName(int ratio) {
        return StatCollector.func_74838_a((String)("material." + this.name().toLowerCase(Locale.ENGLISH))) + " " + ratio + ":1 " + MachineRegistry.GEARBOX.getName();
    }

    public static GearboxTypes getMaterialFromGearboxItem(ItemStack is) {
        if (is.field_77990_d != null && is.field_77990_d.func_74764_b("type")) {
            return GearboxTypes.valueOf(is.field_77990_d.func_74779_i("type"));
        }
        int idx = is.func_77960_j() % MaterialRegistry.matList.length - 1;
        if (idx >= MaterialRegistry.TUNGSTEN.ordinal()) {
            ++idx;
        }
        if (idx < 0) {
            is.func_77964_b(0);
            is.func_150996_a(Item.func_150898_a((Block)Blocks.field_150348_b));
            return WOOD;
        }
        return GearboxTypes.getFromMaterial(MaterialRegistry.matList[idx]);
    }

    public static GearboxTypes getMaterialFromCraftingItem(ItemStack is) {
        int idx = is.func_77960_j() / 16;
        for (GearboxTypes g : typeList) {
            if (g.metaOffset != idx) continue;
            return g;
        }
        return null;
    }

    public static GearboxTypes getFromMaterial(MaterialRegistry mat) {
        switch (mat) {
            case BEDROCK: {
                return BEDROCK;
            }
            case DIAMOND: {
                return DIAMOND;
            }
            case STEEL: {
                return STEEL;
            }
            case STONE: {
                return STONE;
            }
            case WOOD: {
                return WOOD;
            }
            case TUNGSTEN: {
                return TUNGSTEN;
            }
        }
        return null;
    }

    public static int getRatioFromPartItem(ItemStack is) {
        if (is == null) {
            return 0;
        }
        if (is.func_77973_b() == Items.field_151055_y) {
            return 1;
        }
        if (!ItemRegistry.GEARCRAFT.matchItem(is)) {
            return 0;
        }
        int meta = is.func_77960_j() % 16;
        switch (meta) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 16;
            }
        }
        return 0;
    }

    public double getOmegaForRotFailure(int omega, int omegain) {
        return ReikaMathLibrary.doubpow((double)Math.max(omega, omegain), (double)this.material.getSpeedForceExponent());
    }

    static {
        typeList = GearboxTypes.values();
    }

    public static enum GearPart {
        SHAFT,
        GEAR,
        UNIT2,
        UNIT4,
        UNIT8,
        UNIT16,
        BEARING,
        SHAFTCORE;

        public static final GearPart[] list;

        public int getMetaOffset() {
            return this.ordinal();
        }

        public String getLocalizedName(GearboxTypes material) {
            String s = "";
            switch (this) {
                case SHAFT: {
                    s = "crafting.shaft";
                    break;
                }
                case GEAR: {
                    s = "crafting.gear";
                    break;
                }
                case UNIT2: {
                    s = "crafting.gear2x";
                    break;
                }
                case UNIT4: {
                    s = "crafting.gear4x";
                    break;
                }
                case UNIT8: {
                    s = "crafting.gear8x";
                    break;
                }
                case UNIT16: {
                    s = "crafting.gear16x";
                    break;
                }
                case BEARING: {
                    s = "crafting.bearing";
                    break;
                }
                case SHAFTCORE: {
                    s = "crafting.shaftcore";
                }
            }
            return StatCollector.func_74838_a((String)("material." + material.name().toLowerCase(Locale.ENGLISH))) + " " + StatCollector.func_74838_a((String)s);
        }

        public static GearPart getGearUnitPartItemFromRatio(int r) {
            switch (r) {
                case 2: {
                    return UNIT2;
                }
                case 4: {
                    return UNIT4;
                }
                case 8: {
                    return UNIT8;
                }
                case 16: {
                    return UNIT16;
                }
            }
            throw new IllegalArgumentException("Invalid gear ratio!");
        }

        public boolean isItemOfType(ItemStack is) {
            for (GearboxTypes type : typeList) {
                if (!ReikaItemHelper.matchStacks((ItemStack)type.getPart(this), (ItemStack)is)) continue;
                return true;
            }
            return false;
        }

        static {
            list = GearPart.values();
        }
    }
}

