/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.Auxiliary.Trackers.PackModificationTracker;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.GUI.ImagedGuiButton;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.HandbookAuxData;
import Reika.RotaryCraft.Auxiliary.HandbookNotifications;
import Reika.RotaryCraft.Auxiliary.Interfaces.HandbookEntry;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesBlastFurnace;
import Reika.RotaryCraft.Auxiliary.RotaryDescriptions;
import Reika.RotaryCraft.Base.TileEntity.RotaryCraftTileEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.GearboxTypes;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.RotaryNames;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public enum HandbookRegistry implements HandbookEntry
{
    TOC("Table of Contents", "TOC"),
    INFO("Information"),
    ENGINES("Engines"),
    TRANS("Transmission"),
    CONVERTER("Converters"),
    PRODMACHINES("Production"),
    PROCMACHINES("Processing"),
    FARMMACHINES("Farming"),
    PIPEMACHINES("Piping"),
    ACCMACHINES("Accessory"),
    WEPMACHINES("Weaponry"),
    SURVMACHINES("Surveying"),
    COSMACHINES("Cosmetic"),
    UTILMACHINES("Utility"),
    TOOLS("Tools"),
    RESOURCE("Resources"),
    TERMS("Basic Terms", "Terms and Physics Explanations"),
    PHYSICS("Relevant Physics"),
    MATERIAL("Material Properties"),
    SHAFTS("Shaft Load Limits"),
    FLYWHEELS("Flywheel Load Limits"),
    TRANSFER("Basics of Power Transfer"),
    TIERS("Machine Tiers"),
    TIMING("Duration Time"),
    MUFFLING("Sounds and Muffling"),
    INTERDIM("Interdimensional Power Transport"),
    ALERTS("Config Alerts"),
    PACKMODS("Modpack Changes"),
    INFODESC("Important Notes", "Important Notes"),
    LUBE("Lubricant"),
    BEARINGS("Gearbox Bearings"),
    CANOLA("Canola", ItemRegistry.CANOLA),
    METER("Angular Transducer", ItemRegistry.METER),
    SCREW("Screwdriver", ItemRegistry.SCREWDRIVER),
    ENCHANTING("Enchanting Machines"),
    MODINTERFACE("Inter-Mod Interactions"),
    COMPUTERCRAFT("ComputerCraft"),
    ENGINEDESC("Power Supply", "Engines"),
    DCENGINE(MachineRegistry.ENGINE, EngineType.DC),
    WINDENGINE(MachineRegistry.ENGINE, EngineType.WIND),
    STEAMENGINE(MachineRegistry.ENGINE, EngineType.STEAM),
    GASENGINE(MachineRegistry.ENGINE, EngineType.GAS),
    ACENGINE(MachineRegistry.ENGINE, EngineType.AC),
    PERFENGINE(MachineRegistry.ENGINE, EngineType.SPORT),
    HYDROENGINE(MachineRegistry.ENGINE, EngineType.HYDRO),
    MICROTURB(MachineRegistry.ENGINE, EngineType.MICRO),
    JETENGINE(MachineRegistry.ENGINE, EngineType.JET),
    SOLAR(MachineRegistry.SOLARTOWER),
    TRANSDESC("Power Transfer", "Transmission"),
    SHAFT(MachineRegistry.SHAFT),
    GEARBOX(MachineRegistry.GEARBOX),
    BEVEL(MachineRegistry.BEVELGEARS),
    SPLITTER(MachineRegistry.SPLITTER),
    CLUTCH(MachineRegistry.CLUTCH),
    DYNA(MachineRegistry.DYNAMOMETER),
    FLYWHEEL(MachineRegistry.FLYWHEEL),
    WORM(MachineRegistry.ADVANCEDGEARS, 0),
    CVT(MachineRegistry.ADVANCEDGEARS, 1),
    COIL(MachineRegistry.ADVANCEDGEARS, 2),
    HIGEAR(MachineRegistry.ADVANCEDGEARS, 3),
    MULTI(MachineRegistry.MULTICLUTCH),
    BELT(MachineRegistry.BELT),
    BUSCONTROLLER(MachineRegistry.BUSCONTROLLER),
    BUS(MachineRegistry.POWERBUS),
    CHAIN(MachineRegistry.CHAIN),
    DISTRIBCLUTCH(MachineRegistry.DISTRIBCLUTCH),
    CONVERTERDESC("Conversion Engines", "Converters"),
    STATIC(MachineRegistry.DYNAMO),
    GENERATOR(MachineRegistry.GENERATOR),
    BOILER(MachineRegistry.BOILER),
    AIRCOMPRESSOR(MachineRegistry.COMPRESSOR),
    DYNAMO(MachineRegistry.MAGNETIC),
    MOTOR(MachineRegistry.ELECTRICMOTOR),
    STEAMTURB(MachineRegistry.STEAMTURBINE),
    PNEUMATIC(MachineRegistry.PNEUENGINE),
    FUELENGINE(MachineRegistry.FUELENGINE),
    PRODMACHINEDESC("Production Machines", "Production"),
    BLAST(MachineRegistry.BLASTFURNACE),
    WORKTABLE(MachineRegistry.WORKTABLE),
    FERMENTER(MachineRegistry.FERMENTER),
    FRACTION(MachineRegistry.FRACTIONATOR),
    BEDROCK(MachineRegistry.BEDROCKBREAKER),
    BORER(MachineRegistry.BORER),
    PUMP(MachineRegistry.PUMP),
    OBSIDIAN(MachineRegistry.OBSIDIAN),
    LAVAMAKER(MachineRegistry.LAVAMAKER),
    AGGREGATOR(MachineRegistry.AGGREGATOR),
    FRIDGE(MachineRegistry.REFRIGERATOR),
    PROCMACHINEDESC("Processing Machines", "Processing"),
    GRINDER(MachineRegistry.GRINDER),
    EXTRACTOR(MachineRegistry.EXTRACTOR),
    PULSEJET(MachineRegistry.PULSEJET),
    COMPACTOR(MachineRegistry.COMPACTOR),
    PURIFIER(MachineRegistry.PURIFIER),
    ENHANCER(MachineRegistry.FUELENHANCER),
    MAGNET(MachineRegistry.MAGNETIZER),
    DISTILER(MachineRegistry.DISTILLER),
    FURNACE(MachineRegistry.BIGFURNACE),
    CRYSTAL(MachineRegistry.CRYSTALLIZER),
    COMPOST(MachineRegistry.COMPOSTER),
    CENTRIFUGE(MachineRegistry.CENTRIFUGE),
    DRYING(MachineRegistry.DRYING),
    WETTER(MachineRegistry.WETTER),
    DROPS(MachineRegistry.DROPS),
    FARMMACHINEDESC("Farming Machines", "Farming"),
    FAN(MachineRegistry.FAN),
    BREEDER(MachineRegistry.AUTOBREEDER),
    BAITBOX(MachineRegistry.BAITBOX),
    SPAWNER(MachineRegistry.SPAWNERCONTROLLER),
    SPRINKLER(MachineRegistry.SPRINKLER),
    WOODCUTTER(MachineRegistry.WOODCUTTER),
    HARVESTER(MachineRegistry.MOBHARVESTER),
    FERTILIZER(MachineRegistry.FERTILIZER),
    LAWNSPRINKLER(MachineRegistry.LAWNSPRINKLER),
    HYDRATOR(MachineRegistry.HYDRATOR),
    PIPEMACHINEDESC("Piping", "Piping"),
    HOSE(MachineRegistry.HOSE.getName(), MachineRegistry.HOSE),
    PIPE(MachineRegistry.PIPE.getName(), MachineRegistry.PIPE),
    FUELLINE(MachineRegistry.FUELLINE.getName(), MachineRegistry.FUELLINE),
    VALVE(MachineRegistry.VALVE.getName(), MachineRegistry.VALVE),
    BYPASS(MachineRegistry.BYPASS.getName(), MachineRegistry.BYPASS),
    SEPARATOR(MachineRegistry.SEPARATION.getName(), MachineRegistry.SEPARATION),
    SUCTION(MachineRegistry.SUCTION.getName(), MachineRegistry.SUCTION),
    BEDPIPE(MachineRegistry.BEDPIPE.getName(), MachineRegistry.BEDPIPE),
    ACCMACHINEDESC("Accessory Machines", "Aux Machines"),
    FURNACEHEATER(MachineRegistry.FRICTION),
    HEATER(MachineRegistry.HEATER),
    VACUUM(MachineRegistry.VACUUM),
    ECU(MachineRegistry.ECU),
    WINDER(MachineRegistry.WINDER),
    REFRESHER(MachineRegistry.REFRESHER),
    CCTVSCREEN(MachineRegistry.SCREEN),
    MIRROR(MachineRegistry.MIRROR),
    COOLINGFIN(MachineRegistry.COOLINGFIN),
    SORTING(MachineRegistry.SORTING),
    FILLING(MachineRegistry.FILLINGSTATION),
    PIPEPUMP(MachineRegistry.PIPEPUMP),
    ITEMFILTER(MachineRegistry.ITEMFILTER),
    WEPMACHINEDESC("Defence/Offence Machines", "Defence/Offense"),
    ARROWGUN(MachineRegistry.ARROWGUN),
    HEATRAY(MachineRegistry.HEATRAY),
    TNT(MachineRegistry.TNTCANNON),
    SONIC(MachineRegistry.SONICWEAPON),
    FORCE(MachineRegistry.FORCEFIELD),
    ANTIAIR(MachineRegistry.ANTIAIR),
    RAILGUN(MachineRegistry.RAILGUN),
    FREEZE(MachineRegistry.FREEZEGUN),
    CONTAIN(MachineRegistry.CONTAINMENT),
    LASERGUN(MachineRegistry.LASERGUN),
    LANDMINE(MachineRegistry.LANDMINE),
    BLOCKCANNON(MachineRegistry.BLOCKCANNON),
    SELFDESTRUCT(MachineRegistry.SELFDESTRUCT),
    EMP(MachineRegistry.EMP),
    AIRGUN(MachineRegistry.AIRGUN),
    VDG(MachineRegistry.VANDEGRAFF),
    GATLING(MachineRegistry.GATLING),
    FLAMETURRET(MachineRegistry.FLAMETURRET),
    SURVMACHINEDESC("Surveying Machines", "Surveying"),
    GPR(MachineRegistry.GPR),
    RADAR(MachineRegistry.MOBRADAR),
    SCANNER(MachineRegistry.CAVESCANNER),
    CCTV(MachineRegistry.CCTV),
    SPYCAM(MachineRegistry.SPYCAM),
    COSMACHINEDESC("Cosmetic Machines", "Cosmetic"),
    FIREWORK(MachineRegistry.FIREWORK),
    MUSIC(MachineRegistry.MUSICBOX),
    PROJECTOR(MachineRegistry.PROJECTOR),
    WEATHER(MachineRegistry.WEATHERCONTROLLER),
    DISPLAY(MachineRegistry.DISPLAY),
    PARTICLE(MachineRegistry.PARTICLE),
    UTILMACHINEDESC("Utility Machines", "Utility"),
    FLOODLIGHT(MachineRegistry.FLOODLIGHT),
    PILEDRIVER(MachineRegistry.PILEDRIVER),
    AEROSOL(MachineRegistry.AEROSOLIZER),
    LIGHTBRID(MachineRegistry.LIGHTBRIDGE),
    RESERVOIR(MachineRegistry.RESERVOIR),
    DETECTOR(MachineRegistry.PLAYERDETECTOR),
    CHEST(MachineRegistry.SCALECHEST),
    SPILLER(MachineRegistry.SPILLER),
    SMOKE(MachineRegistry.SMOKEDETECTOR),
    FIRESTARTER(MachineRegistry.IGNITER),
    ITEMCANNON(MachineRegistry.ITEMCANNON),
    BUCKETFILLER(MachineRegistry.BUCKETFILLER),
    LAMP(MachineRegistry.LAMP),
    TERRA(MachineRegistry.TERRAFORMER),
    LINE(MachineRegistry.LINEBUILDER),
    BEAMMIRROR(MachineRegistry.BEAMMIRROR),
    SONICBORER(MachineRegistry.SONICBORER),
    DEFOLIATOR(MachineRegistry.DEFOLIATOR),
    GRINDSTONE(MachineRegistry.GRINDSTONE),
    BLOWER(MachineRegistry.BLOWER),
    GASTANK(MachineRegistry.GASTANK),
    CRAFTER(MachineRegistry.CRAFTER),
    CHUNKLOADER(MachineRegistry.CHUNKLOADER),
    FILLER(MachineRegistry.FILLER),
    SPILLWAY(MachineRegistry.SPILLWAY),
    BUNDLEDBUS(MachineRegistry.BUNDLEDBUS),
    TOOLDESC("Tool Items", "Tools"),
    SPRING(ItemRegistry.SPRING),
    STRONGSPRING(ItemRegistry.STRONGCOIL),
    ULTRA(ItemRegistry.ULTRASOUND),
    MOTION(ItemRegistry.MOTION),
    VAC(ItemRegistry.VACUUM),
    STUN(ItemRegistry.STUNGUN),
    GRAVEL(ItemRegistry.GRAVELGUN),
    FIREBALL(ItemRegistry.FIREBALL),
    HANDCRAFT(ItemRegistry.HANDCRAFT),
    NVG(ItemRegistry.NVG),
    BUCKETS(ItemRegistry.BUCKET),
    BEDTOOLS("Bedrock Tools"),
    BEDARMOR("Bedrock Armor"),
    TARGETER(ItemRegistry.TARGET),
    IOGOGGLES(ItemRegistry.IOGOGGLES),
    CKEY(ItemRegistry.KEY),
    MINECART(ItemRegistry.MINECART),
    TILESELECT(ItemRegistry.TILESELECTOR),
    JETPACK("Jetpacks"),
    STEELTOOLS("Steel Tools"),
    STEELARMOR("Steel Armor"),
    ITEMPUMP(ItemRegistry.PUMP),
    JUMPBOOTS("Spring Boots"),
    TANKS(ItemRegistry.FUEL),
    DISK(ItemRegistry.DISK),
    RESOURCEDESC("Resource Items", "Resource Items"),
    STEELINGOT("Steel Ingot"),
    COKE("Coal Coke"),
    NETHERDUST("Netherrack Dust and Tar"),
    SAWDUST("Sawdust"),
    BEDDUST("Bedrock Dust"),
    EXTRACTS("Dust/Slurry/Solution"),
    FLAKES("Ore Flakes"),
    COMPACTS("Anthracite/Prismane/Lonsdaleite"),
    DECOBLOCKS("Decorative Blocks"),
    GLASS("Blast Glass"),
    SPAWNERS("Monster Spawners"),
    YEAST("Yeast"),
    ETHANOL("Ethanol"),
    ALLOYING("Alloying"),
    SILVERINGOT("Silver Ingot"),
    SALT("Salt"),
    AMMONIUM("Ammonium Nitrate"),
    SILVERIODIDE("Silver Iodide"),
    ALUMINUM("Aluminum Powder"),
    RAILGUNAMMO("Railgun Ammunition"),
    SLIDES("Projector Slides"),
    EXPLOSIVES("Explosive Shells"),
    TUNGSTEN("Tungsten");

    private MachineRegistry machine;
    private ItemRegistry item;
    private int offset;
    private int parentindex;
    private int basescreen;
    private boolean isParent;
    private String title;
    private ItemStack crafted;
    private String name;
    private EngineType engine;
    public static final HandbookRegistry[] tabList;
    private static Comparator<HandbookRegistry> tabSorter;

    private HandbookRegistry(MachineRegistry m, int o) {
        this.machine = m;
        this.offset = o;
        this.isParent = false;
        this.item = null;
        this.crafted = m.getCraftedMetadataProduct(this.offset);
    }

    private HandbookRegistry(MachineRegistry m, EngineType o) {
        this.machine = m;
        this.engine = o;
        this.offset = o != null ? o.ordinal() : -1;
        this.isParent = false;
        this.item = null;
        this.crafted = this.offset >= 0 ? m.getCraftedMetadataProduct(this.offset) : m.getCraftedProduct();
    }

    private HandbookRegistry(MachineRegistry m) {
        this.machine = m;
        this.offset = -1;
        this.isParent = false;
        this.item = null;
        this.crafted = m.getCraftedProduct();
    }

    private HandbookRegistry(ItemRegistry i) {
        this.offset = -1;
        this.isParent = false;
        this.item = i;
        this.crafted = i.getStackOf();
    }

    private HandbookRegistry(String s) {
        this.machine = null;
        this.offset = -1;
        this.isParent = false;
        this.item = null;
        this.title = s;
        this.crafted = null;
    }

    private HandbookRegistry(ItemStack is) {
        this.machine = null;
        this.offset = -1;
        this.isParent = false;
        this.crafted = is.func_77946_l();
    }

    private HandbookRegistry(String s, MachineRegistry m) {
        this.machine = m;
        this.offset = -1;
        this.isParent = false;
        this.item = null;
        this.title = s;
        this.crafted = m.getCraftedProduct();
    }

    private HandbookRegistry(String s, ItemRegistry m) {
        this.machine = null;
        this.offset = -1;
        this.isParent = false;
        this.item = m;
        this.title = s;
        this.crafted = m.getStackOf();
    }

    private HandbookRegistry() {
        this.machine = null;
        this.offset = -1;
        this.isParent = false;
        this.item = null;
    }

    private HandbookRegistry(String s, String toc) {
        this.machine = null;
        this.offset = -1;
        this.parentindex = RotaryDescriptions.getCategoryCount();
        this.isParent = true;
        this.item = null;
        this.title = s;
        this.crafted = null;
        this.name = toc;
        RotaryDescriptions.addCategory(this);
    }

    public static int getScreen(MachineRegistry m, TileEntity te) {
        if (m == MachineRegistry.ENGINE) {
            return HandbookRegistry.getEngineScreen(te);
        }
        if (m == MachineRegistry.ADVANCEDGEARS) {
            return TRANSDESC.getBaseScreen() + 1;
        }
        for (int i = ENGINEDESC.ordinal(); i < TOOLDESC.ordinal(); ++i) {
            if (HandbookRegistry.tabList[i].machine != m) continue;
            return tabList[i].getScreen();
        }
        return -1;
    }

    public static List<HandbookRegistry> getEngineTabs() {
        ArrayList<HandbookRegistry> li = HandbookRegistry.getSubList(ENGINEDESC);
        Collections.sort(li, tabSorter);
        return li;
    }

    public static List<HandbookRegistry> getTransTabs() {
        ArrayList<HandbookRegistry> li = HandbookRegistry.getSubList(TRANSDESC);
        Collections.sort(li, tabSorter);
        return li;
    }

    public static List<HandbookRegistry> getConverterTabs() {
        ArrayList<HandbookRegistry> li = HandbookRegistry.getSubList(CONVERTERDESC);
        Collections.sort(li, tabSorter);
        return li;
    }

    public static List<HandbookRegistry> getMachineTabs() {
        ArrayList<HandbookRegistry> tabs = new ArrayList<HandbookRegistry>();
        for (int i = 0; i < tabList.length; ++i) {
            HandbookRegistry h = tabList[i];
            if (!h.isMachine() || h.isParent) continue;
            tabs.add(h);
        }
        return tabs;
    }

    public static List<HandbookRegistry> getToolTabs() {
        ArrayList<HandbookRegistry> li = HandbookRegistry.getSubList(TOOLDESC);
        return li;
    }

    public static List<HandbookRegistry> getResourceTabs() {
        ArrayList<HandbookRegistry> li = HandbookRegistry.getSubList(RESOURCEDESC);
        return li;
    }

    public static List<HandbookRegistry> getMiscTabs() {
        ArrayList<HandbookRegistry> li = HandbookRegistry.getSubList(INFODESC);
        return li;
    }

    public static List<HandbookRegistry> getInfoTabs() {
        ArrayList<HandbookRegistry> li = HandbookRegistry.getSubList(TERMS);
        li.add(0, TERMS);
        return li;
    }

    private static ArrayList<HandbookRegistry> getSubList(HandbookRegistry parent) {
        HandbookRegistry h;
        ArrayList<HandbookRegistry> li = new ArrayList<HandbookRegistry>();
        for (int i = parent.ordinal(); !(i >= tabList.length || (h = tabList[i]) != parent && h.isParent); ++i) {
            if (h.isParent) continue;
            li.add(h);
        }
        return li;
    }

    public static List<HandbookRegistry> getCategoryTabs(boolean info) {
        ArrayList<HandbookRegistry> li = new ArrayList<HandbookRegistry>();
        for (int i = 0; i < tabList.length; ++i) {
            if (!HandbookRegistry.tabList[i].isParent || tabList[i] == TOC || !info && tabList[i] == TERMS) continue;
            li.add(tabList[i]);
        }
        return li;
    }

    public static List<HandbookRegistry> getTOCTabs() {
        ArrayList<HandbookRegistry> li = new ArrayList<HandbookRegistry>();
        for (int i = 0; i < tabList.length; ++i) {
            if (!HandbookRegistry.tabList[i].isParent || tabList[i] == TOC) continue;
            li.add(tabList[i]);
        }
        return li;
    }

    public String getTOCTitle() {
        return this.name;
    }

    public EngineType getEngine() {
        return this.engine;
    }

    public boolean isMachine() {
        if (this.getParent() == PROCMACHINEDESC) {
            return true;
        }
        if (this.getParent() == UTILMACHINEDESC) {
            return true;
        }
        if (this.getParent() == WEPMACHINEDESC) {
            return true;
        }
        if (this.getParent() == SURVMACHINEDESC) {
            return true;
        }
        if (this.getParent() == PRODMACHINEDESC) {
            return true;
        }
        if (this.getParent() == FARMMACHINEDESC) {
            return true;
        }
        if (this.getParent() == COSMACHINEDESC) {
            return true;
        }
        if (this.getParent() == ACCMACHINEDESC) {
            return true;
        }
        return this.getParent() == PIPEMACHINEDESC;
    }

    public boolean isEngine() {
        return this.getParent() == ENGINEDESC;
    }

    public boolean isTrans() {
        return this.getParent() == TRANSDESC;
    }

    public MachineRegistry getMachine() {
        return this.machine;
    }

    public ItemRegistry getItem() {
        return this.item;
    }

    public int getBaseScreen() {
        int sc = 0;
        for (int i = 0; i < this.ordinal(); ++i) {
            HandbookRegistry h = tabList[i];
            if (!h.isParent) continue;
            sc += h.getNumberChildren() / 8 + 1;
        }
        return sc;
    }

    public int getNumberChildren() {
        if (!this.isParent) {
            return 0;
        }
        int ch = 0;
        for (int i = this.ordinal() + 1; i < tabList.length; ++i) {
            HandbookRegistry h = tabList[i];
            if (h.isParent) {
                return ch;
            }
            ++ch;
        }
        return ch;
    }

    @Override
    public int getScreen() {
        return this.getParent().getBaseScreen() + this.getRelativeScreen();
    }

    @Override
    public int getPage() {
        return (this.ordinal() - this.getParent().ordinal()) % 8;
    }

    public boolean hasOffset() {
        return this.offset > -1;
    }

    public int getOffset() {
        return this.offset;
    }

    public static int getPage(MachineRegistry m, TileEntity te) {
        if (m == MachineRegistry.ENGINE) {
            return HandbookRegistry.getEnginePage(te);
        }
        if (m == MachineRegistry.ADVANCEDGEARS) {
            return HandbookRegistry.getAdvGearPage(te);
        }
        for (int i = 0; i < tabList.length; ++i) {
            if (HandbookRegistry.tabList[i].machine != m) continue;
            return tabList[i].getPage();
        }
        return -1;
    }

    public int getShiftedOrdinal() {
        return this.getParent().getBaseScreen() + this.ordinal() - this.getParent().ordinal();
    }

    private static int getAdvGearPage(TileEntity te) {
        return ((RotaryCraftTileEntity)te).func_145832_p() / 4;
    }

    private static int getEnginePage(TileEntity te) {
        EngineType e = ((TileEntityEngine)te).getEngineType();
        return 1 + e.ordinal() - (HandbookRegistry.getEngineScreen(te) - ENGINEDESC.getBaseScreen()) * 8;
    }

    private static int getEngineScreen(TileEntity te) {
        EngineType e = ((TileEntityEngine)te).getEngineType();
        int ei = (1 + e.ordinal()) / 8;
        return ENGINEDESC.getBaseScreen() + ei;
    }

    public String getTabImageFile() {
        return "/Reika/RotaryCraft/Textures/GUI/Handbook/tabs_" + TOC.getParent().name().toLowerCase(Locale.ENGLISH) + ".png";
    }

    public int getTabRow() {
        return this.getRelativePage() / 12 * 20;
    }

    public int getTabColumn() {
        return this.getRelativePage() % 12 * 20;
    }

    public int getRelativePage() {
        int offset = this.ordinal() - this.getParent().ordinal();
        return offset;
    }

    public int getRelativeTabPosn() {
        int offset = this.ordinal() - this.getParent().ordinal();
        return offset - this.getRelativeScreen() * 8;
    }

    public int getRelativeScreen() {
        int offset = this.ordinal() - this.getParent().ordinal();
        return offset / 8;
    }

    public HandbookRegistry getParent() {
        HandbookRegistry parent = null;
        for (int i = 0; i < tabList.length; ++i) {
            if (!HandbookRegistry.tabList[i].isParent || this.ordinal() < tabList[i].ordinal()) continue;
            parent = tabList[i];
        }
        return parent;
    }

    public static void addRelevantButtons(int j, int k, int screen, List<GuiButton> li) {
        int id = 0;
        for (int i = 0; i < tabList.length; ++i) {
            if (tabList[i].getScreen() != screen) continue;
            li.add((GuiButton)new ImagedGuiButton(id, j - 20, k + tabList[i].getRelativeTabPosn() * 20, 20, 20, 0, 0, tabList[i].getTabImageFile(), RotaryCraft.class));
            ++id;
        }
    }

    public static HandbookRegistry getEntry(int screen, int page) {
        if (screen < TERMS.getScreen()) {
            return TOC;
        }
        HandbookRegistry h = HandbookAuxData.getMapping(screen, page);
        return h != null ? h : TOC;
    }

    public static List<HandbookRegistry> getEntriesForScreen(int screen) {
        ArrayList<HandbookRegistry> li = new ArrayList<HandbookRegistry>();
        for (int i = 0; i < tabList.length; ++i) {
            if (tabList[i].getScreen() != screen) continue;
            li.add(tabList[i]);
        }
        return li;
    }

    public boolean isPlainGui() {
        if (this == TOC) {
            return true;
        }
        if (this == TIERS) {
            return false;
        }
        if (this == TIMING) {
            return false;
        }
        if (this == ALERTS) {
            return false;
        }
        if (this == PACKMODS) {
            return false;
        }
        if (this.getParent() == TERMS) {
            return true;
        }
        if (this.isParent) {
            return true;
        }
        if (this == MODINTERFACE) {
            return true;
        }
        if (this == ENCHANTING) {
            return true;
        }
        if (this == BEDDUST) {
            return true;
        }
        if (this == SPAWNERS) {
            return true;
        }
        if (this == LUBE) {
            return true;
        }
        if (this == BEARINGS) {
            return true;
        }
        if (this == CANOLA) {
            return true;
        }
        if (this == ALUMINUM) {
            return true;
        }
        return this == COMPUTERCRAFT;
    }

    @Override
    public String getTitle() {
        if (this == TOC) {
            return "Table Of Contents";
        }
        if (this.isParent) {
            return this.title;
        }
        if (this.getParent() == ENGINEDESC) {
            if (this == SOLAR) {
                return MachineRegistry.SOLARTOWER.getName();
            }
            return RotaryNames.getEngineName(this.offset);
        }
        if (this.isMachine() || this.getParent() == CONVERTERDESC) {
            return this.machine.getName();
        }
        if (this.machine == MachineRegistry.ADVANCEDGEARS) {
            return RotaryNames.getAdvGearName(this.offset);
        }
        if (this.getParent() == TRANSDESC) {
            return this.machine.getName();
        }
        if (this.getParent() == TOOLDESC && this.item != null) {
            return this.item.getBasicName();
        }
        return this.title;
    }

    public boolean isCrafting() {
        if (this.isParent) {
            return false;
        }
        if (this.isSmelting()) {
            return false;
        }
        if (this.getParent() == TOC || this.getParent() == TERMS) {
            return false;
        }
        if (this == MODINTERFACE) {
            return false;
        }
        if (this == COMPUTERCRAFT) {
            return false;
        }
        if (this == ENCHANTING) {
            return false;
        }
        if (this == LUBE) {
            return false;
        }
        if (this == BEARINGS) {
            return false;
        }
        if (this == STEELINGOT) {
            return false;
        }
        if (this == NETHERDUST) {
            return false;
        }
        if (this == GLASS) {
            return false;
        }
        if (this == EXTRACTS) {
            return false;
        }
        if (this == COMPACTS) {
            return false;
        }
        if (this == BEDDUST) {
            return false;
        }
        if (this == SAWDUST) {
            return false;
        }
        if (this == SPAWNERS) {
            return false;
        }
        if (this == YEAST) {
            return false;
        }
        if (this == ALUMINUM) {
            return false;
        }
        if (this == RAILGUNAMMO) {
            return false;
        }
        if (this == CANOLA) {
            return false;
        }
        if (this == FLAKES) {
            return false;
        }
        if (this == SILVERINGOT) {
            return false;
        }
        if (this == JETPACK) {
            return false;
        }
        if (this == JUMPBOOTS) {
            return false;
        }
        if (this == BEDTOOLS) {
            return false;
        }
        if (this == BEDARMOR) {
            return false;
        }
        if (this == STRONGSPRING) {
            return false;
        }
        if (this == ALLOYING) {
            return false;
        }
        return this != COKE;
    }

    public List<ItemStack> getCrafting() {
        if (!this.isCrafting()) {
            return null;
        }
        if (this == SHAFT) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < MaterialRegistry.values().length; ++i) {
                li.add(MachineRegistry.SHAFT.getCraftedMetadataProduct(i));
            }
            return li;
        }
        if (this == GEARBOX) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < MaterialRegistry.values().length; ++i) {
                li.add(MachineRegistry.GEARBOX.getCraftedMetadataProduct(i));
            }
            return li;
        }
        if (this == COIL) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            ItemStack is = MachineRegistry.ADVANCEDGEARS.getCraftedMetadataProduct(2);
            li.add(is);
            is = is.func_77946_l();
            is.field_77990_d = new NBTTagCompound();
            is.field_77990_d.func_74757_a("bedrock", true);
            li.add(is);
            return li;
        }
        if (this == FLYWHEEL) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < 4; ++i) {
                li.add(MachineRegistry.FLYWHEEL.getCraftedMetadataProduct(i));
            }
            return li;
        }
        if (this.crafted != null) {
            return ReikaJavaLibrary.makeListFrom((Object)this.crafted);
        }
        if (this.machine != null && this.machine.isPipe()) {
            return ReikaJavaLibrary.makeListFrom((Object)this.machine.getCraftedProduct());
        }
        if (this == BEDTOOLS) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ItemRegistry.BEDPICK.getStackOf());
            li.add(ItemRegistry.BEDSHOVEL.getStackOf());
            li.add(ItemRegistry.BEDAXE.getStackOf());
            li.add(ItemRegistry.BEDSWORD.getStackOf());
            li.add(ItemRegistry.BEDHOE.getStackOf());
            li.add(ItemRegistry.BEDSHEARS.getStackOf());
            li.add(ItemRegistry.BEDSICKLE.getStackOf());
            return li;
        }
        if (this == BEDARMOR) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ItemRegistry.BEDHELM.getStackOf());
            li.add(ItemRegistry.BEDCHEST.getStackOf());
            li.add(ItemRegistry.BEDLEGS.getStackOf());
            li.add(ItemRegistry.BEDBOOTS.getStackOf());
            return li;
        }
        if (this == STEELTOOLS) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ItemRegistry.STEELPICK.getStackOf());
            li.add(ItemRegistry.STEELSHOVEL.getStackOf());
            li.add(ItemRegistry.STEELAXE.getStackOf());
            li.add(ItemRegistry.STEELSWORD.getStackOf());
            li.add(ItemRegistry.STEELHOE.getStackOf());
            li.add(ItemRegistry.STEELSHEARS.getStackOf());
            li.add(ItemRegistry.STEELSICKLE.getStackOf());
            return li;
        }
        if (this == STEELARMOR) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ItemRegistry.STEELHELMET.getStackOf());
            li.add(ItemRegistry.STEELCHEST.getStackOf());
            li.add(ItemRegistry.STEELLEGS.getStackOf());
            li.add(ItemRegistry.STEELBOOTS.getStackOf());
            return li;
        }
        if (this == SOLAR) {
            return ReikaJavaLibrary.makeListFrom((Object)MachineRegistry.SOLARTOWER.getCraftedProduct());
        }
        if (this.getParent() == ENGINEDESC) {
            return ReikaJavaLibrary.makeListFrom((Object)EngineType.engineList[this.offset].getCraftedProduct());
        }
        if (this.machine == MachineRegistry.ADVANCEDGEARS) {
            return ReikaJavaLibrary.makeListFrom((Object)MachineRegistry.ADVANCEDGEARS.getCraftedMetadataProduct(this.offset));
        }
        if (this.getParent() == TRANSDESC || this.isMachine()) {
            if (this.machine.hasCustomPlacerItem()) {
                return ReikaJavaLibrary.makeListFrom((Object)this.machine.getCraftedMetadataProduct(0));
            }
            return ReikaJavaLibrary.makeListFrom((Object)this.machine.getCraftedProduct());
        }
        if (this == DECOBLOCKS) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ItemStacks.steelblock);
            li.add(ItemStacks.anthrablock);
            li.add(ItemStacks.lonsblock);
            return li;
        }
        if (this == SLIDES) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < ItemRegistry.SLIDE.getNumberMetadatas(); ++i) {
                li.add(ItemRegistry.SLIDE.getStackOfMetadata(i));
            }
            return li;
        }
        if (this == ALLOYING) {
            ArrayList<ItemStack> is = new ArrayList<ItemStack>();
            ArrayList<RecipesBlastFurnace.BlastFurnacePattern> li = RecipesBlastFurnace.getRecipes().getAllAlloyingRecipes();
            for (RecipesBlastFurnace.BlastFurnacePattern p : li) {
                is.add(p.outputItem());
            }
            return is;
        }
        if (this == COKE) {
            return ReikaJavaLibrary.makeListFrom((Object)ItemStacks.coke);
        }
        if (this == AMMONIUM) {
            return ReikaJavaLibrary.makeListFrom((Object)ItemStacks.nitrate);
        }
        if (this == SALT) {
            return ReikaJavaLibrary.makeListFrom((Object)ItemStacks.salt);
        }
        if (this == SILVERIODIDE) {
            return ReikaJavaLibrary.makeListFrom((Object)ItemStacks.silveriodide);
        }
        if (this == EXPLOSIVES) {
            return ReikaJavaLibrary.makeListFrom((Object)ItemRegistry.SHELL.getStackOf());
        }
        if (this == MINECART) {
            return ReikaJavaLibrary.makeListFrom((Object)ItemRegistry.MINECART.getStackOf());
        }
        return ReikaJavaLibrary.makeListFrom((Object)ItemStacks.basepanel);
    }

    public boolean isCustomRecipe() {
        if (this.getParent() == ENGINEDESC) {
            return true;
        }
        if (this.getParent() == TRANSDESC) {
            return true;
        }
        if (this.getParent() == CONVERTERDESC) {
            return true;
        }
        if (this.isMachine()) {
            return true;
        }
        return this.machine != null && this.machine.isPipe();
    }

    public int getTabIconIndex() {
        if (this == SHAFT) {
            return MaterialRegistry.STEEL.ordinal();
        }
        if (this == GEARBOX) {
            return MaterialRegistry.STEEL.ordinal();
        }
        if (this == FLYWHEEL) {
            return 3;
        }
        if (this == DECOBLOCKS) {
            return 1;
        }
        return 0;
    }

    public boolean isSmelting() {
        if (this == ETHANOL) {
            return true;
        }
        return this == TUNGSTEN;
    }

    public ItemStack getSmelting() {
        if (!this.isSmelting()) {
            return null;
        }
        if (this == ETHANOL) {
            return ItemRegistry.ETHANOL.getStackOf();
        }
        if (this == TUNGSTEN) {
            return ItemStacks.tungsteningot;
        }
        return ItemStacks.barrel;
    }

    @Override
    public ItemStack getTabIcon() {
        if (this == TOC) {
            return ItemRegistry.HANDBOOK.getStackOf();
        }
        if (this == TERMS) {
            return ItemRegistry.HANDBOOK.getStackOf();
        }
        if (this == PHYSICS) {
            return new ItemStack(Items.field_151122_aG);
        }
        if (this == MATERIAL) {
            return ItemStacks.steelingot;
        }
        if (this == SHAFTS) {
            return MachineRegistry.SHAFT.getCraftedMetadataProduct(3);
        }
        if (this == FLYWHEELS) {
            return MachineRegistry.FLYWHEEL.getCraftedMetadataProduct(0);
        }
        if (this == TIERS) {
            return MachineRegistry.EMP.getCraftedProduct();
        }
        if (this == LUBE) {
            return ItemStacks.lubebucket;
        }
        if (this == BEARINGS) {
            return GearboxTypes.TUNGSTEN.getPart(GearboxTypes.GearPart.BEARING);
        }
        if (this == MODINTERFACE) {
            return MachineRegistry.COMPRESSOR.getCraftedProduct();
        }
        if (this == ENCHANTING) {
            return new ItemStack((Item)Items.field_151134_bR);
        }
        if (this == TIMING) {
            return new ItemStack(Items.field_151113_aN);
        }
        if (this == MUFFLING) {
            return ReikaItemHelper.whiteWool.asItemStack();
        }
        if (this == INTERDIM) {
            return new ItemStack((Block)Blocks.field_150427_aO);
        }
        if (this == COMPUTERCRAFT) {
            return ItemStacks.pcb;
        }
        if (this == TRANSFER) {
            return ItemStacks.gearunit;
        }
        if (this == ENGINES) {
            return EngineType.AC.getCraftedProduct();
        }
        if (this == INFO) {
            return ItemRegistry.SCREWDRIVER.getStackOf();
        }
        if (this == TRANS) {
            return GearboxTypes.STEEL.getGearboxItem(8);
        }
        if (this == CONVERTER) {
            return MachineRegistry.MAGNETIC.getCraftedProduct();
        }
        if (this == PRODMACHINES) {
            return MachineRegistry.BEDROCKBREAKER.getCraftedProduct();
        }
        if (this == PROCMACHINES) {
            return MachineRegistry.EXTRACTOR.getCraftedProduct();
        }
        if (this == FARMMACHINES) {
            return MachineRegistry.FAN.getCraftedProduct();
        }
        if (this == PIPEMACHINES) {
            return MachineRegistry.FUELLINE.getCraftedProduct();
        }
        if (this == ACCMACHINES) {
            return MachineRegistry.FRICTION.getCraftedProduct();
        }
        if (this == WEPMACHINES) {
            return MachineRegistry.RAILGUN.getCraftedProduct();
        }
        if (this == COSMACHINES) {
            return MachineRegistry.MUSICBOX.getCraftedProduct();
        }
        if (this == SURVMACHINES) {
            return MachineRegistry.GPR.getCraftedProduct();
        }
        if (this == UTILMACHINES) {
            return MachineRegistry.FLOODLIGHT.getCraftedProduct();
        }
        if (this == TOOLS) {
            return ItemRegistry.MOTION.getStackOf();
        }
        if (this == RESOURCE) {
            return ItemStacks.bedrockdust;
        }
        if (this == FLAKES) {
            return ItemStacks.goldoreflakes;
        }
        if (this == BEDTOOLS) {
            return ItemRegistry.BEDPICK.getEnchantedStack();
        }
        if (this == BEDARMOR) {
            return ItemRegistry.BEDHELM.getEnchantedStack();
        }
        if (this == STEELTOOLS) {
            return ItemRegistry.STEELPICK.getEnchantedStack();
        }
        if (this == STEELARMOR) {
            return ItemRegistry.STEELHELMET.getEnchantedStack();
        }
        if (this == JETPACK) {
            return ItemRegistry.BEDPACK.getEnchantedStack();
        }
        if (this == JUMPBOOTS) {
            return ItemRegistry.JUMP.getStackOf();
        }
        if (this.isCrafting()) {
            return this.getCrafting().get(this.getTabIconIndex());
        }
        if (this.isSmelting()) {
            return this.getSmelting();
        }
        if (this == STEELINGOT) {
            return ItemStacks.steelingot;
        }
        if (this == NETHERDUST) {
            return ItemStacks.netherrackdust;
        }
        if (this == SAWDUST) {
            return ItemStacks.sawdust;
        }
        if (this == BEDDUST) {
            return ItemStacks.bedrockdust;
        }
        if (this == EXTRACTS) {
            return ItemStacks.goldoredust;
        }
        if (this == COMPACTS) {
            return ItemStacks.prismane;
        }
        if (this == GLASS) {
            return BlockRegistry.BLASTGLASS.getStackOf();
        }
        if (this == SPAWNERS) {
            return ItemRegistry.SPAWNER.getStackOf();
        }
        if (this == YEAST) {
            return ItemStacks.sludge;
        }
        if (this == SALT) {
            return ItemStacks.salt;
        }
        if (this == ALUMINUM) {
            return ItemStacks.aluminumpowder;
        }
        if (this == RAILGUNAMMO) {
            return ItemRegistry.RAILGUN.getStackOf();
        }
        if (this == CANOLA) {
            return ItemStacks.canolaSeeds;
        }
        if (this == SILVERINGOT) {
            return ItemStacks.silveringot;
        }
        if (this == STRONGSPRING) {
            return ItemRegistry.STRONGCOIL.getStackOf();
        }
        if (this == ALLOYING) {
            return ItemStacks.bedingot;
        }
        if (this == COKE) {
            return ItemStacks.coke;
        }
        if (this == ALERTS || this == PACKMODS) {
            // empty if block
        }
        return null;
    }

    @Override
    public String getData() {
        if (this == TOC) {
            return RotaryDescriptions.getTOC();
        }
        if (this == ALERTS || this == PACKMODS) {
            return "";
        }
        return RotaryDescriptions.getData(this);
    }

    @Override
    public String getNotes(int subpage) {
        return RotaryDescriptions.getNotes(this, subpage);
    }

    @Override
    public boolean hasSubpages() {
        if (this.isParent) {
            return false;
        }
        if (this.getParent() == ENGINEDESC) {
            return true;
        }
        if (this.getParent() == CONVERTERDESC) {
            return true;
        }
        if (this.isMachine()) {
            return true;
        }
        if (this == TIERS) {
            return true;
        }
        if (this == COMPUTERCRAFT) {
            return true;
        }
        if (this == ENCHANTING) {
            return true;
        }
        if (this == ALERTS) {
            return !HandbookNotifications.instance.getNewAlerts().isEmpty();
        }
        if (this == PACKMODS) {
            return PackModificationTracker.instance.modificationsExist((DragonAPIMod)RotaryCraft.instance);
        }
        return false;
    }

    @Override
    public boolean sameTextAllSubpages() {
        return this == TIERS;
    }

    @Override
    public boolean hasMachineRender() {
        return this.isEngine() || this.isTrans() || this.isMachine() || this.getParent() == CONVERTERDESC;
    }

    @Override
    public boolean isConfigDisabled() {
        return this.machine != null && this.machine.isConfigDisabled();
    }

    public int getBonusSubpages() {
        return RotaryDescriptions.getNotesLength(this) - 1;
    }

    static {
        tabList = HandbookRegistry.values();
        tabSorter = new Comparator<HandbookRegistry>(){

            @Override
            public int compare(HandbookRegistry o1, HandbookRegistry o2) {
                if (o1.isParent != o2.isParent) {
                    if (o1.isParent) {
                        return Integer.MIN_VALUE;
                    }
                    return Integer.MAX_VALUE;
                }
                if (o1.machine != null && o2.machine != null) {
                    return o1.machine.compareTo(o2.machine);
                }
                if (o1.machine != null) {
                    return Integer.MIN_VALUE;
                }
                if (o2.machine != null) {
                    return Integer.MAX_VALUE;
                }
                return o1.compareTo(o2);
            }
        };
    }
}

