/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Registry;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Extras.ItemSpawner;
import Reika.DragonAPI.Interfaces.Registry.ItemEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.RotaryCraft.Auxiliary.CustomExtractLoader;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesBlastFurnace;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.WorktableRecipes;
import Reika.RotaryCraft.Base.ItemBasic;
import Reika.RotaryCraft.Base.ItemBlockPlacer;
import Reika.RotaryCraft.Base.ItemChargedArmor;
import Reika.RotaryCraft.Base.ItemChargedTool;
import Reika.RotaryCraft.Base.ItemMulti;
import Reika.RotaryCraft.Base.ItemRotaryTool;
import Reika.RotaryCraft.CommonProxy;
import Reika.RotaryCraft.Items.ItemCanolaSeed;
import Reika.RotaryCraft.Items.ItemCoil;
import Reika.RotaryCraft.Items.ItemDisk;
import Reika.RotaryCraft.Items.ItemEthanolMinecart;
import Reika.RotaryCraft.Items.ItemExplosiveShell;
import Reika.RotaryCraft.Items.ItemHandBook;
import Reika.RotaryCraft.Items.ItemModOre;
import Reika.RotaryCraft.Items.ItemRailGunAmmo;
import Reika.RotaryCraft.Items.ItemSlide;
import Reika.RotaryCraft.Items.ItemVoidMetalRailgunAmmo;
import Reika.RotaryCraft.Items.Placers.ItemAdvGearPlacer;
import Reika.RotaryCraft.Items.Placers.ItemEnginePlacer;
import Reika.RotaryCraft.Items.Placers.ItemFlywheelPlacer;
import Reika.RotaryCraft.Items.Placers.ItemGearPlacer;
import Reika.RotaryCraft.Items.Placers.ItemMachinePlacer;
import Reika.RotaryCraft.Items.Placers.ItemShaftPlacer;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedReveal;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockArmor;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockAxe;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockChisel;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockDrillHead;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockGrafter;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockHoe;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockPickaxe;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockSaw;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockShears;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockShovel;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockSickle;
import Reika.RotaryCraft.Items.Tools.Bedrock.ItemBedrockSword;
import Reika.RotaryCraft.Items.Tools.Charged.ItemChargedGrafter;
import Reika.RotaryCraft.Items.Tools.Charged.ItemFireballLauncher;
import Reika.RotaryCraft.Items.Tools.Charged.ItemFlamethrower;
import Reika.RotaryCraft.Items.Tools.Charged.ItemGravelGun;
import Reika.RotaryCraft.Items.Tools.Charged.ItemHandheldPiston;
import Reika.RotaryCraft.Items.Tools.Charged.ItemMotionTracker;
import Reika.RotaryCraft.Items.Tools.Charged.ItemNightVisionGoggles;
import Reika.RotaryCraft.Items.Tools.Charged.ItemPump;
import Reika.RotaryCraft.Items.Tools.Charged.ItemRangeFinder;
import Reika.RotaryCraft.Items.Tools.Charged.ItemSpringBoots;
import Reika.RotaryCraft.Items.Tools.Charged.ItemStunGun;
import Reika.RotaryCraft.Items.Tools.Charged.ItemUltrasound;
import Reika.RotaryCraft.Items.Tools.Charged.ItemVacuum;
import Reika.RotaryCraft.Items.Tools.ItemCannonKey;
import Reika.RotaryCraft.Items.Tools.ItemCraftPattern;
import Reika.RotaryCraft.Items.Tools.ItemDebug;
import Reika.RotaryCraft.Items.Tools.ItemEngineUpgrade;
import Reika.RotaryCraft.Items.Tools.ItemFuelLubeBucket;
import Reika.RotaryCraft.Items.Tools.ItemFuelTank;
import Reika.RotaryCraft.Items.Tools.ItemHandheldCrafting;
import Reika.RotaryCraft.Items.Tools.ItemIOGoggles;
import Reika.RotaryCraft.Items.Tools.ItemIntegratedGearbox;
import Reika.RotaryCraft.Items.Tools.ItemJetPack;
import Reika.RotaryCraft.Items.Tools.ItemMatchFilter;
import Reika.RotaryCraft.Items.Tools.ItemMeter;
import Reika.RotaryCraft.Items.Tools.ItemScrewdriver;
import Reika.RotaryCraft.Items.Tools.ItemTarget;
import Reika.RotaryCraft.Items.Tools.ItemTileSelector;
import Reika.RotaryCraft.Items.Tools.ItemWorldEdit;
import Reika.RotaryCraft.Items.Tools.Steel.ItemSteelArmor;
import Reika.RotaryCraft.Items.Tools.Steel.ItemSteelAxe;
import Reika.RotaryCraft.Items.Tools.Steel.ItemSteelHoe;
import Reika.RotaryCraft.Items.Tools.Steel.ItemSteelPick;
import Reika.RotaryCraft.Items.Tools.Steel.ItemSteelShears;
import Reika.RotaryCraft.Items.Tools.Steel.ItemSteelShovel;
import Reika.RotaryCraft.Items.Tools.Steel.ItemSteelSickle;
import Reika.RotaryCraft.Items.Tools.Steel.ItemSteelSword;
import Reika.RotaryCraft.ModInterface.ItemCustomModOre;
import Reika.RotaryCraft.ModInterface.ItemScrewdriverFocus;
import Reika.RotaryCraft.Registry.Flywheels;
import Reika.RotaryCraft.Registry.GearboxTypes;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.RotaryNames;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.ShapedOreRecipe;

public enum ItemRegistry implements ItemEnum
{
    SCREWDRIVER(0, 1, false, "item.screwdriver", ItemScrewdriver.class),
    METER(16, 1, false, "item.meter", ItemMeter.class),
    DEBUG(112, 1, false, "item.debug", ItemDebug.class),
    WORLDEDIT(114, 115, 1, true, "item.worldedit", ItemWorldEdit.class),
    HANDBOOK(208, 1, false, "item.handbook", ItemHandBook.class),
    YEAST(32, 1, false, "item.yeast", ItemBasic.class),
    ETHANOL(64, 1, false, "item.ethanol", ItemBasic.class),
    CANOLA(80, 1, true, "item.canola", ItemCanolaSeed.class),
    SPRING(96, 1, true, "item.spring", ItemCoil.class),
    ULTRASOUND(128, 1, true, "item.ultrasound", ItemUltrasound.class),
    MOTION(144, 1, true, "item.motion", ItemMotionTracker.class),
    VACUUM(160, 1, true, "item.vacuum", ItemVacuum.class),
    STUNGUN(192, 1, true, "item.stungun", ItemStunGun.class),
    GRAVELGUN(176, 1, true, "item.gravelgun", ItemGravelGun.class),
    FIREBALL(224, 232, 1, true, "item.firelauncher", ItemFireballLauncher.class),
    BEDPICK(101, 1, false, "item.bedpick", ItemBedrockPickaxe.class),
    BEDAXE(100, 1, false, "item.bedaxe", ItemBedrockAxe.class),
    BEDSHOVEL(102, 1, false, "item.bedshovel", ItemBedrockShovel.class),
    NVG(97, 1, true, "item.nvg", ItemNightVisionGoggles.class),
    HANDCRAFT(33, 1, false, "item.handcraft", ItemHandheldCrafting.class),
    RAILGUN(129, 1, true, "item.railgun", ItemRailGunAmmo.class),
    BUCKET(104, 106, 1, true, "item.rcbucket", ItemFuelLubeBucket.class),
    TARGET(98, 1, false, "item.target", ItemTarget.class),
    IOGOGGLES(1, 1, false, "item.iogoggles", ItemIOGoggles.class),
    SLIDE(2, 1, true, "item.slide", ItemSlide.class),
    KEY(4, 1, false, "item.key", ItemCannonKey.class),
    SHELL(5, 1, false, "item.shell", ItemExplosiveShell.class),
    MINECART(6, 1, false, "item.ethacart", ItemEthanolMinecart.class),
    BEDHELM(7, 1, false, "item.bedhelm", ItemBedrockArmor.class),
    BEDCHEST(9, 1, false, "item.bedchest", ItemBedrockArmor.class),
    BEDLEGS(10, 1, false, "item.bedlegs", ItemBedrockArmor.class),
    BEDBOOTS(8, 1, false, "item.bedboots", ItemBedrockArmor.class),
    TILESELECTOR(11, 1, false, "item.tileselector", ItemTileSelector.class),
    BEDPACK(12, 1, false, "item.jetchest", ItemJetPack.class),
    STEELPICK(13, 1, false, "item.steelpick", ItemSteelPick.class),
    STEELAXE(14, 1, false, "item.steelaxe", ItemSteelAxe.class),
    STEELSHOVEL(15, 1, false, "item.steelshovel", ItemSteelShovel.class),
    STEELHELMET(17, 1, false, "item.steelhelmet", ItemSteelArmor.class),
    STEELCHEST(18, 1, false, "item.steelchest", ItemSteelArmor.class),
    STEELLEGS(19, 1, false, "item.steellegs", ItemSteelArmor.class),
    STEELBOOTS(20, 1, false, "item.steelboots", ItemSteelArmor.class),
    STRONGCOIL(99, 1, true, "item.strongcoil", ItemCoil.class),
    JETPACK(28, 1, false, "item.ethanoljetpack", ItemJetPack.class),
    PUMP(29, 1, true, "item.handpump", ItemPump.class),
    JUMP(30, 1, true, "item.jumpboots", ItemSpringBoots.class),
    BEDJUMP(31, 1, false, "item.bedrockjump", ItemSpringBoots.class),
    FUEL(27, 1, false, "item.fueltank", ItemFuelTank.class),
    BEDHOE(21, 1, false, "item.bedrockhoe", ItemBedrockHoe.class),
    STEELHOE(22, 1, false, "item.steelhoe", ItemSteelHoe.class),
    BEDSWORD(23, 1, false, "item.bedrocksword", ItemBedrockSword.class),
    STEELSWORD(24, 1, false, "item.steelsword", ItemSteelSword.class),
    BEDSHEARS(25, 1, false, "item.bedrockshears", ItemBedrockShears.class),
    STEELSHEARS(26, 1, false, "item.steelshears", ItemSteelShears.class),
    FLAMETHROWER(28, 1, false, "item.flamethrower", ItemFlamethrower.class),
    DISK(3, 1, false, "item.musicboxdisc", ItemDisk.class),
    UPGRADE(240, 1, true, "item.engineupgrade", ItemEngineUpgrade.class),
    CRAFTPATTERN(34, 1, false, "item.craftpattern", ItemCraftPattern.class),
    BEDSICKLE(36, 1, false, "item.bedsickle", ItemBedrockSickle.class),
    STEELSICKLE(35, 1, false, "item.steelsickle", ItemSteelSickle.class),
    GRAFTER(37, 1, true, "item.chargedgrafter", ItemChargedGrafter.class, ModList.FORESTRY),
    BEDGRAFTER(38, 1, false, "item.bedgrafter", ItemBedrockGrafter.class, ModList.FORESTRY),
    BEDSAW(39, 1, false, "item.bedsaw", ItemBedrockSaw.class, ModList.MULTIPART),
    BEDREVEAL(40, 1, false, "item.bedreveal", ItemBedReveal.class, ModList.THAUMCRAFT),
    MACHINE(0, true, "item.placer", ItemMachinePlacer.class),
    ENGINE(0, true, "item.engplacer", ItemEnginePlacer.class),
    SHAFT(0, true, "item.shaftplacer", ItemShaftPlacer.class),
    GEARBOX(0, true, "item.gearplacer", ItemGearPlacer.class),
    FLYWHEEL(0, true, "item.flyplacer", ItemFlywheelPlacer.class),
    ADVGEAR(0, true, "item.advplacer", ItemAdvGearPlacer.class),
    SHAFTCRAFT(0, true, "item.shaftcraft", ItemMulti.class),
    GEARCRAFT(0, 3, true, "item.gearcraft", ItemMulti.class),
    FLYWHEELCRAFT(208, true, "crafting.flycore", ItemMulti.class),
    ENGINECRAFT(1, true, "item.enginecraft", ItemMulti.class),
    MISCCRAFT(2, true, "item.misccraft", ItemMulti.class),
    BORECRAFT(3, true, "item.borecraft", ItemMulti.class),
    EXTRACTS(4, true, "item.extracts", ItemMulti.class),
    COMPACTS(6, true, "item.compacts", ItemMulti.class),
    POWDERS(8, true, "item.powder", ItemMulti.class),
    MODINTERFACE(16, 2, true, "item.modinterface", ItemMulti.class),
    MODEXTRACTS(-1, true, "item.modextracts", ItemModOre.class),
    MODINGOTS(-1, true, "item.modingots", ItemModOre.class),
    SPAWNER(0, false, "item.spawner", ItemSpawner.class),
    STEELPACK(44, 1, false, "item.steelpack", ItemJetPack.class),
    CUSTOMEXTRACT(240, true, "item.customextract", ItemCustomModOre.class),
    CUSTOMINGOT(244, true, "item.customingot", ItemCustomModOre.class),
    RANGEFINDER(42, 1, true, "item.rangefinder", ItemRangeFinder.class),
    GEARUPGRADE(65, 1, true, "item.gearupgrade", ItemIntegratedGearbox.class),
    HELDPISTON(43, 1, true, "item.springpiston", ItemHandheldPiston.class),
    VOIDRAIL(133, 1, false, "item.voidrailgun", ItemVoidMetalRailgunAmmo.class),
    MATCHFILTER(50, 1, false, "item.matchfilter", ItemMatchFilter.class),
    BEDDRILL(134, 1, false, "item.beddrill", ItemBedrockDrillHead.class, ModList.IMMERSIVEENG),
    BEDCHISEL(45, 1, false, "item.bedchisel", ItemBedrockChisel.class, ModList.CHISEL),
    SCREWFOCUS(0, 0, false, "item.screwfocus", ItemScrewdriverFocus.class, ModList.THAUMCRAFT);

    private final int index;
    private final int imageSheet;
    private final boolean hasSubtypes;
    private final String name;
    private final Class itemClass;
    private final ModList condition;
    private int maxindex;
    public static final ItemRegistry[] itemList;
    private static final HashMap<Item, ItemRegistry> itemMap;

    private ItemRegistry(int tex, boolean sub, String n2, Class<? extends Item> iCl) {
        this(tex, 0, sub, n2, iCl, null);
    }

    private ItemRegistry(int tex, int sheet, boolean sub, String n2, Class<? extends Item> iCl) {
        this(tex, sheet, sub, n2, iCl, null);
    }

    private ItemRegistry(int tex, int sheet, boolean sub, String n2, Class<? extends Item> iCl, ModList api) {
        this.index = tex;
        this.hasSubtypes = sub;
        this.name = n2;
        this.itemClass = iCl;
        this.condition = api;
        this.imageSheet = sheet;
    }

    private ItemRegistry(int lotex, int hitex, int sheet, boolean sub, String n2, Class<? extends Item> iCl) {
        if (lotex > hitex) {
            throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "Invalid item sprite registration for " + n2 + "! Backwards texture bounds?");
        }
        this.index = lotex;
        this.maxindex = lotex;
        this.hasSubtypes = sub;
        this.name = n2;
        this.itemClass = iCl;
        this.condition = null;
        this.imageSheet = sheet;
    }

    public Class[] getConstructorParamTypes() {
        if (this.isArmor()) {
            if (this.isBedrockArmor() || this.isSteelArmor()) {
                return new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
            }
            if (this.isJetpack() || this.isJumpBoots()) {
                return new Class[]{ItemArmor.ArmorMaterial.class, Integer.TYPE, Integer.TYPE};
            }
            return new Class[]{Integer.TYPE, Integer.TYPE};
        }
        if (this.isPlacer()) {
            return new Class[0];
        }
        if (this.isModOre()) {
            return new Class[0];
        }
        if (this == SPAWNER) {
            return new Class[0];
        }
        if (this == SCREWFOCUS) {
            return new Class[0];
        }
        return new Class[]{Integer.TYPE};
    }

    public boolean isCrafting() {
        return ItemMulti.class.isAssignableFrom(this.itemClass);
    }

    public boolean isPlacer() {
        return ItemBlockPlacer.class.isAssignableFrom(this.itemClass);
    }

    public boolean isModOre() {
        return ItemModOre.class.isAssignableFrom(this.itemClass);
    }

    public boolean isBedrockArmor() {
        if (this == BEDHELM) {
            return true;
        }
        if (this == BEDCHEST) {
            return true;
        }
        if (this == BEDLEGS) {
            return true;
        }
        return this == BEDBOOTS;
    }

    public boolean isBedrockTypeArmor() {
        if (this == BEDJUMP) {
            return true;
        }
        if (this == BEDPACK) {
            return true;
        }
        if (this == BEDREVEAL) {
            return true;
        }
        return this.isBedrockArmor();
    }

    public Object[] getConstructorParams() {
        if (this.isArmor()) {
            if (this.isBedrockArmor() || this.isSteelArmor()) {
                return new Object[]{this.getTextureIndex(), this.getArmorRender(), this.getArmorType()};
            }
            if (this.isJetpack() || this.isJumpBoots()) {
                return new Object[]{this.getArmorMaterial(), this.getTextureIndex(), this.getArmorRender()};
            }
            return new Object[]{this.getTextureIndex(), this.getArmorRender()};
        }
        if (this.isPlacer()) {
            return new Object[0];
        }
        if (this.isModOre()) {
            return new Object[0];
        }
        if (this == SPAWNER) {
            return new Object[0];
        }
        if (this == SCREWFOCUS) {
            return new Object[0];
        }
        return new Object[]{this.getTextureIndex()};
    }

    private ItemArmor.ArmorMaterial getArmorMaterial() {
        if (this.isBedrockTypeArmor()) {
            return RotaryCraft.BEDROCK;
        }
        if (this.isSteelTypeArmor()) {
            return RotaryCraft.HSLA;
        }
        if (this == JETPACK) {
            return RotaryCraft.JETPACK;
        }
        if (this == JUMP) {
            return RotaryCraft.JUMP;
        }
        return null;
    }

    public boolean isJetpack() {
        return this == JETPACK || this == BEDPACK || this == STEELPACK;
    }

    private boolean isJumpBoots() {
        return this == JUMP || this == BEDJUMP;
    }

    public int getArmorType() {
        switch (this) {
            case BEDBOOTS: 
            case STEELBOOTS: 
            case JUMP: 
            case BEDJUMP: {
                return 3;
            }
            case BEDCHEST: 
            case STEELCHEST: 
            case JETPACK: 
            case BEDPACK: 
            case STEELPACK: {
                return 1;
            }
            case BEDHELM: 
            case STEELHELMET: 
            case BEDREVEAL: {
                return 0;
            }
            case BEDLEGS: 
            case STEELLEGS: {
                return 2;
            }
        }
        return 0;
    }

    public int getTextureIndex() {
        return this.index;
    }

    public static boolean isRegistered(ItemStack is) {
        return ItemRegistry.isRegistered(is.func_77973_b());
    }

    public static boolean isRegistered(Item id) {
        return ItemRegistry.getEntryByID(id) != null;
    }

    public static ItemRegistry getEntryByID(Item id) {
        return itemMap.get(id);
    }

    public static ItemRegistry getEntry(ItemStack is) {
        if (is == null) {
            return null;
        }
        return ItemRegistry.getEntryByID(is.func_77973_b());
    }

    public boolean matchItem(ItemStack is) {
        return is != null && this.getItemInstance() == is.func_77973_b();
    }

    public String getName(int dmg) {
        if (this.hasMultiValuedName()) {
            return this.getMultiValuedName(dmg);
        }
        return this.name;
    }

    public String getBasicName() {
        return StatCollector.func_74838_a((String)this.name);
    }

    public String getMultiValuedName(int dmg) {
        if (this.isCharged()) {
            return this.getBasicName() + " (" + String.format("%d", dmg) + " kJ)";
        }
        switch (this) {
            case SLIDE: {
                return this.getBasicName() + " (" + dmg + ")";
            }
            case SPRING: 
            case STRONGCOIL: {
                return this.getBasicName() + " (" + String.format("%d", dmg) + " kJ)";
            }
            case BUCKET: {
                return RotaryNames.getBucketName(dmg);
            }
            case RAILGUN: {
                return this.getBasicName() + " (" + String.format("%d", (int)ReikaMathLibrary.intpow((double)2.0, (int)dmg)) + " kg)";
            }
            case UPGRADE: {
                return ItemEngineUpgrade.Upgrades.list[dmg].getName();
            }
            case MODEXTRACTS: {
                return RotaryNames.getModExtractName(dmg);
            }
            case MODINGOTS: {
                return RotaryNames.getModIngotName(dmg);
            }
            case SHAFTCRAFT: {
                return StatCollector.func_74838_a((String)RotaryNames.shaftPartNames[dmg]);
            }
            case MISCCRAFT: {
                return StatCollector.func_74838_a((String)RotaryNames.miscPartNames[dmg]);
            }
            case BORECRAFT: {
                return StatCollector.func_74838_a((String)RotaryNames.borerPartNames[dmg]);
            }
            case ENGINECRAFT: {
                return StatCollector.func_74838_a((String)RotaryNames.enginePartNames[dmg]);
            }
            case EXTRACTS: {
                return StatCollector.func_74838_a((String)RotaryNames.extractNames[dmg]);
            }
            case COMPACTS: {
                return StatCollector.func_74838_a((String)RotaryNames.compactNames[dmg]);
            }
            case POWDERS: {
                return StatCollector.func_74838_a((String)RotaryNames.powderNames[dmg]);
            }
            case MODINTERFACE: {
                return StatCollector.func_74838_a((String)RotaryNames.interfaceNames[dmg]);
            }
            case GEARCRAFT: {
                return RotaryNames.getGearPartName(dmg);
            }
            case FLYWHEELCRAFT: {
                return Flywheels.list[dmg].getName() + " " + this.getBasicName();
            }
            case SHAFT: {
                return this.getBasicName();
            }
            case ENGINE: {
                return RotaryNames.getEngineName(dmg);
            }
            case GEARBOX: {
                return this.getBasicName();
            }
            case FLYWHEEL: {
                return Flywheels.list[dmg].getName() + " " + MachineRegistry.FLYWHEEL.getName();
            }
            case ADVGEAR: {
                return RotaryNames.getAdvGearName(dmg);
            }
            case MACHINE: {
                return ((MachineRegistry)((Object)MachineRegistry.machineList.get(dmg))).getName();
            }
            case CANOLA: {
                return RotaryNames.getCanolaName(dmg);
            }
        }
        throw new RuntimeException("Item " + this.name + " was called for a multi-name, but it was not registered!");
    }

    public int getArmorRender() {
        if (!this.isArmor()) {
            throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "Item " + this.name + " is not an armor yet was called for its render!");
        }
        if (this == IOGOGGLES) {
            return CommonProxy.IOGoggles;
        }
        if (this == NVG) {
            return CommonProxy.NVGoggles;
        }
        if (this.isBedrockArmor()) {
            return CommonProxy.armor;
        }
        if (this.isSteelArmor()) {
            return CommonProxy.armor;
        }
        if (this.isJetpack()) {
            return CommonProxy.armor;
        }
        if (this.isJumpBoots()) {
            return CommonProxy.armor;
        }
        if (this == BEDREVEAL) {
            return CommonProxy.armor;
        }
        throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "Item " + this.name + " is an armor yet has no specified render!");
    }

    private boolean isSteelTypeArmor() {
        return this == STEELPACK || this.isSteelArmor();
    }

    private boolean isSteelArmor() {
        if (this == STEELHELMET) {
            return true;
        }
        if (this == STEELCHEST) {
            return true;
        }
        if (this == STEELLEGS) {
            return true;
        }
        return this == STEELBOOTS;
    }

    public boolean isSteelTool() {
        return this == STEELPICK || this == STEELAXE || this == STEELSHOVEL || this == STEELSWORD || this == STEELSHEARS || this == STEELHOE || this == STEELSICKLE;
    }

    public String getUnlocalizedName() {
        return ReikaStringParser.stripSpaces((String)this.name).toLowerCase(Locale.ENGLISH);
    }

    public Item getItemInstance() {
        return RotaryCraft.items[this.ordinal()];
    }

    public boolean hasMultiValuedName() {
        if (this.isCharged()) {
            return true;
        }
        if (this == UPGRADE) {
            return true;
        }
        if (this == BUCKET) {
            return true;
        }
        if (this.isTool() || this.isArmor()) {
            return false;
        }
        return this.getNumberMetadatas() > 1;
    }

    public boolean isTool() {
        if (this.isBedrockTool()) {
            return true;
        }
        if (this.isSteelTool()) {
            return true;
        }
        return ItemRotaryTool.class.isAssignableFrom(this.itemClass);
    }

    public boolean isCharged() {
        if (this == BEDJUMP) {
            return false;
        }
        return ItemChargedTool.class.isAssignableFrom(this.itemClass) || ItemChargedArmor.class.isAssignableFrom(this.itemClass);
    }

    public boolean isBedrockTool() {
        return this == BEDPICK || this == BEDAXE || this == BEDSHOVEL || this == BEDSWORD || this == BEDSHEARS || this == BEDHOE || this == BEDSICKLE || this == BEDGRAFTER || this == BEDSAW;
    }

    public boolean isCreativeOnly() {
        if (this == DEBUG) {
            return true;
        }
        return this == WORLDEDIT;
    }

    public int getTextureSheet() {
        return this.imageSheet;
    }

    public boolean isMultiSheet() {
        return this.getTextureIndex() < 0;
    }

    public int getNumberMetadatas() {
        if (!this.hasSubtypes) {
            return 1;
        }
        if (this.isCharged()) {
            return SPRING.getNumberMetadatas();
        }
        if (this.isBedrockTool()) {
            return 1;
        }
        if (this.isBedrockArmor()) {
            return 1;
        }
        if (this.isSteelArmor()) {
            return 600;
        }
        if (this.isSteelTool()) {
            return 600;
        }
        switch (this) {
            case CANOLA: 
            case WORLDEDIT: {
                return 3;
            }
            case SPRING: 
            case STRONGCOIL: {
                return 32000;
            }
            case SLIDE: {
                return 25;
            }
            case RAILGUN: {
                return 16;
            }
            case BUCKET: {
                return 5;
            }
            case UPGRADE: {
                return ItemEngineUpgrade.Upgrades.list.length;
            }
            case MODEXTRACTS: {
                return 4 * ReikaJavaLibrary.getEnumEntriesWithoutInitializing(ModOreList.class).size();
            }
            case MODINGOTS: {
                return ReikaJavaLibrary.getEnumEntriesWithoutInitializing(ModOreList.class).size();
            }
            case CUSTOMEXTRACT: {
                return 4 * CustomExtractLoader.instance.getEntries().size();
            }
            case CUSTOMINGOT: {
                return CustomExtractLoader.instance.getEntries().size();
            }
            case SHAFTCRAFT: {
                return RotaryNames.shaftPartNames.length;
            }
            case MISCCRAFT: {
                return RotaryNames.miscPartNames.length;
            }
            case BORECRAFT: {
                return RotaryNames.borerPartNames.length;
            }
            case ENGINECRAFT: {
                return RotaryNames.enginePartNames.length;
            }
            case EXTRACTS: {
                return RotaryNames.extractNames.length;
            }
            case COMPACTS: {
                return RotaryNames.compactNames.length;
            }
            case POWDERS: {
                return RotaryNames.powderNames.length;
            }
            case MODINTERFACE: {
                return RotaryNames.interfaceNames.length;
            }
            case GEARUPGRADE: {
                return 5;
            }
            case SHAFT: {
                return MaterialRegistry.matList.length;
            }
            case ENGINE: {
                return RotaryNames.getNumberEngineTypes();
            }
            case GEARBOX: {
                return 1;
            }
            case GEARCRAFT: {
                return 16 * GearboxTypes.typeList.length;
            }
            case FLYWHEELCRAFT: 
            case FLYWHEEL: {
                return Flywheels.list.length;
            }
            case ADVGEAR: {
                return RotaryNames.getNumberAdvGearTypes();
            }
            case MACHINE: {
                return ReikaJavaLibrary.getEnumEntriesWithoutInitializing(MachineRegistry.class).size();
            }
        }
        throw new RegistrationException((DragonAPIMod)RotaryCraft.instance, "Item " + (Object)((Object)this) + " has subtypes but the number was not specified!");
    }

    public boolean isArmor() {
        switch (this) {
            case BEDBOOTS: 
            case STEELBOOTS: 
            case JUMP: 
            case BEDJUMP: 
            case BEDCHEST: 
            case STEELCHEST: 
            case JETPACK: 
            case BEDPACK: 
            case STEELPACK: 
            case BEDHELM: 
            case STEELHELMET: 
            case BEDREVEAL: 
            case BEDLEGS: 
            case STEELLEGS: 
            case IOGOGGLES: 
            case NVG: {
                return true;
            }
        }
        return false;
    }

    public ItemStack getCraftedProduct(int amt) {
        return new ItemStack(this.getItemInstance(), amt, 0);
    }

    public ItemStack getCraftedMetadataProduct(int amt, int meta) {
        return new ItemStack(this.getItemInstance(), amt, meta);
    }

    public ItemStack getStackOf() {
        return this.getCraftedProduct(1);
    }

    public ItemStack getStackOfMetadata(int meta) {
        return this.getCraftedMetadataProduct(1, meta);
    }

    public boolean overridesRightClick(ItemStack is) {
        switch (this) {
            case UPGRADE: 
            case GEARUPGRADE: 
            case DEBUG: 
            case METER: 
            case SCREWDRIVER: 
            case KEY: 
            case TILESELECTOR: {
                return true;
            }
            case PUMP: {
                return is.field_77990_d != null;
            }
        }
        return false;
    }

    public Class getObjectClass() {
        return this.itemClass;
    }

    public boolean isDummiedOut() {
        if (this.hasPrerequisite() && !this.getPrerequisite().isLoaded()) {
            return true;
        }
        return this.itemClass == null;
    }

    private boolean hasPrerequisite() {
        return this.condition != null;
    }

    private ModList getPrerequisite() {
        return this.condition;
    }

    public void addRecipe(Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((ItemStack)this.getStackOf(), (Object[])params);
            WorktableRecipes.getInstance().addRecipe(this.getStackOf(), this.isTool() || this.isArmor() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, params);
        }
    }

    public void addSizedRecipe(int num, Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((ItemStack)this.getCraftedProduct(num), (Object[])params);
            WorktableRecipes.getInstance().addRecipe(this.getCraftedProduct(num), this.isTool() || this.isArmor() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, params);
        }
    }

    public void addMetaRecipe(int meta, Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((ItemStack)this.getStackOfMetadata(meta), (Object[])params);
            WorktableRecipes.getInstance().addRecipe(this.getStackOfMetadata(meta), this.isTool() || this.isArmor() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, params);
        }
    }

    public void addSizedMetaRecipe(int meta, int num, Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((ItemStack)this.getCraftedMetadataProduct(num, meta), (Object[])params);
            WorktableRecipes.getInstance().addRecipe(this.getCraftedMetadataProduct(num, meta), this.isTool() || this.isArmor() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, params);
        }
    }

    public void addBlastRecipe(int temperature, int speed, Object ... params) {
        if (!this.isDummiedOut()) {
            ItemStack is = this.getStackOf();
            RecipesBlastFurnace.getRecipes().add3x3Crafting(is, temperature, speed, 0.0f, params);
        }
    }

    public void addMetaBlastRecipe(int temperature, int speed, int meta, Object ... params) {
        if (!this.isDummiedOut()) {
            ItemStack is = this.getStackOfMetadata(meta);
            RecipesBlastFurnace.getRecipes().add3x3Crafting(is, temperature, speed, 0.0f, params);
        }
    }

    public void addEnchantedBlastRecipe(int temperature, int speed, Object ... params) {
        if (!this.isDummiedOut()) {
            ItemStack is = this.getEnchantedStack();
            RecipesBlastFurnace.getRecipes().add3x3Crafting(is, temperature, speed, 0.0f, params);
        }
    }

    public void addEnchantedRecipe(Object ... params) {
        if (!this.isDummiedOut()) {
            ItemStack is = this.getEnchantedStack();
            GameRegistry.addRecipe((ItemStack)is, (Object[])params);
            WorktableRecipes.getInstance().addRecipe(is, this.isTool() || this.isArmor() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, params);
        }
    }

    public void addShapelessEnchantedRecipe(Object ... params) {
        if (!this.isDummiedOut()) {
            ItemStack is = this.getEnchantedStack();
            GameRegistry.addShapelessRecipe((ItemStack)is, (Object[])params);
            WorktableRecipes.getInstance().addShapelessRecipe(is, this.isTool() || this.isArmor() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, params);
        }
    }

    public ItemStack getEnchantedStack() {
        ItemStack is = this.getStackOf();
        if (is == null) {
            return is;
        }
        switch (this) {
            case BEDBOOTS: 
            case BEDCHEST: 
            case BEDHELM: 
            case BEDLEGS: {
                ReikaEnchantmentHelper.applyEnchantments((ItemStack)is, ((ItemBedrockArmor)is.func_77973_b()).getDefaultEnchantments());
                break;
            }
            case BEDPACK: {
                ReikaEnchantmentHelper.applyEnchantments((ItemStack)is, ((ItemBedrockArmor)BEDCHEST.getItemInstance()).getDefaultEnchantments());
                break;
            }
            case BEDPICK: {
                is.func_77966_a(Enchantment.field_77348_q, 1);
                is.func_77966_a(Enchantment.field_77346_s, 5);
                break;
            }
            case BEDJUMP: {
                ReikaEnchantmentHelper.applyEnchantments((ItemStack)is, ((ItemBedrockArmor)BEDBOOTS.getItemInstance()).getDefaultEnchantments());
                break;
            }
            case BEDREVEAL: {
                ReikaEnchantmentHelper.applyEnchantments((ItemStack)is, ((ItemBedrockArmor)BEDHELM.getItemInstance()).getDefaultEnchantments());
                break;
            }
            case BEDSWORD: {
                is.func_77966_a(Enchantment.field_77338_j, 5);
                is.func_77966_a(Enchantment.field_77335_o, 5);
                break;
            }
            case BEDSICKLE: {
                is.func_77966_a(Enchantment.field_77346_s, 5);
            }
        }
        return is;
    }

    public void addShapelessRecipe(Object ... params) {
        if (!this.isDummiedOut()) {
            GameRegistry.addShapelessRecipe((ItemStack)this.getStackOf(), (Object[])params);
            WorktableRecipes.getInstance().addShapelessRecipe(this.getStackOf(), this.isTool() || this.isArmor() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED, params);
        }
    }

    public void addRecipe(IRecipe ir) {
        if (!this.isDummiedOut()) {
            GameRegistry.addRecipe((IRecipe)ir);
            WorktableRecipes.getInstance().addRecipe(ir, this.isTool() || this.isArmor() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED);
        }
    }

    public void addOreRecipe(Object ... in) {
        ItemStack out;
        boolean added;
        if (!this.isDummiedOut() && (added = ReikaRecipeHelper.addOreRecipe((ItemStack)(out = this.getStackOf()), (Object[])in))) {
            WorktableRecipes.getInstance().addRecipe((IRecipe)new ShapedOreRecipe(out, in), this.isTool() || this.isArmor() ? RecipeHandler.RecipeLevel.CORE : RecipeHandler.RecipeLevel.PROTECTED);
        }
    }

    public boolean isAvailableInCreativeInventory() {
        if (RotaryCraft.instance.isLocked()) {
            return false;
        }
        return !this.isDummiedOut();
    }

    public boolean overwritingItem() {
        return false;
    }

    public boolean isContinuousCreativeMetadatas() {
        if (this.isTool()) {
            return false;
        }
        if (this.isArmor()) {
            return false;
        }
        switch (this) {
            case SPRING: 
            case STRONGCOIL: 
            case GEARCRAFT: 
            case GEARBOX: {
                return false;
            }
        }
        return true;
    }

    public static void loadMappings() {
        for (int i = 0; i < itemList.length; ++i) {
            ItemRegistry r = itemList[i];
            itemMap.put(r.getItemInstance(), r);
        }
    }

    static {
        itemList = ItemRegistry.values();
        itemMap = new HashMap();
    }
}

