/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft;

import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.RotaryCraft.Registry.GearboxTypes;
import Reika.RotaryCraft.Registry.ItemRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class RotaryNames {
    private static final String[] engineNames = new String[]{"engine.dc", "engine.wind", "engine.steam", "engine.gas", "engine.ac", "engine.sport", "engine.hydro", "engine.micro", "engine.jet"};
    private static final String[] advGearItemNames = new String[]{"advgear.worm", "advgear.cvt", "advgear.coil", "advgear.hi"};
    private static final String[] hydraulicItemNames = new String[]{"hydraulic.pump", "hydraulic.turbine"};
    private static final String[] liquidNames = new String[]{"fluid.rc lubricant", "fluid.rc jet fuel", "fluid.rc ethanol", "fluid.rc liquid nitrogen", "fluid.molten hsla"};
    private static final String[] canolaNames = new String[]{"canola.seed", "canola.dense", "canola.husk"};
    public static final String[] enginePartNames = new String[]{"crafting.impeller", "crafting.compressor", "crafting.turbine", "crafting.diffuser", "crafting.combustor", "crafting.cylinder", "crafting.radiator", "crafting.condenser", "crafting.goldcoil", "", "", "", "", "crafting.paddle", "", "crafting.ignition", "", "crafting.compoundcompress", "crafting.alucylinder", "crafting.highcombustor"};
    public static final String[] shaftPartNames = new String[]{"crafting.panel", "crafting.ingot", "", "crafting.mount", "", "", "", "", "", "crafting.scrap", "crafting.ironscrap", "", "", "", "", "crafting.worm"};
    public static final String[] miscPartNames = new String[]{"crafting.barrel", "crafting.lens", "crafting.power", "crafting.heatcore", "crafting.lim", "crafting.prop", "crafting.hub", "crafting.mirror", "crafting.generator", "crafting.accel", "crafting.turretbase", "crafting.aiming", "crafting.compound", "crafting.bedcoil", "crafting.chain", "crafting.beddrill"};
    public static final String[] borerPartNames = new String[]{"crafting.drill", "crafting.pressure", "crafting.radar", "crafting.sonar", "crafting.pcb", "crafting.screen", "crafting.mixer", "crafting.saw", "", "crafting.belt", "crafting.ballbearing", "crafting.brake", "crafting.coil"};
    public static final String[] blockNames = new String[]{"block.steel", "block.anthra", "block.lonsda", "block.shield", "block.bedrockingot", "block.coke"};
    public static final String[] powderNames = new String[]{"misc.netherdust", "misc.tar", "misc.sludge", "misc.sawdust", "misc.beddust", "misc.salt", "misc.nh4", "misc.agi", "misc.alum", "misc.flour", "misc.coaldust", "misc.dryice", "misc.redgolddust", "misc.compost", "misc.silicondust", "misc.mulch", "misc.cleansludge"};
    public static final String[] interfaceNames = new String[]{"interface.slipperycomb", "interface.slipperypropolis", "interface.gearcast", "interface.panelcast", "interface.shaftcast", "interface.propcast", "interface.drillcast"};
    public static final String[] extractNames = new String[]{"extract.coaldust", "extract.irondust", "extract.golddust", "extract.reddust", "extract.bluedust", "extract.diadust", "extract.greendust", "extract.quartzdust", "extract.coalslurry", "extract.ironslurry", "extract.goldslurry", "extract.redslurry", "extract.blueslurry", "extract.diaslurry", "extract.greenslurry", "extract.quartzslurry", "extract.coalsolu", "extract.ironsolu", "extract.goldsolu", "extract.redsolu", "extract.bluesolu", "extract.diasolu", "extract.greensolu", "extract.quartzsolu", "extract.coalflakes", "extract.ironflakes", "extract.goldflakes", "extract.redflakes", "extract.blueflakes", "extract.diaflakes", "extract.greenflakes", "extract.quartzflakes", "extract.silverflakes", "extract.tungstenflakes"};
    public static final String[] compactNames = new String[]{"misc.anthra", "misc.prisma", "misc.lonsda", "misc.bedingot", "misc.alingot", "misc.wingot", "misc.redgoldingot", "misc.agingot", "misc.coke", "misc.springingot", "misc.silicon", "misc.alualloy", "misc.tungalloy"};
    public static final String[] pipeNames = new String[]{"machine.hose", "machine.pipe", "machine.fuelline", "machine.spiller", "machine.valve", "machine.bypass", "machine.separation", "machine.bedpipe"};

    private static String getName(String[] names, int i) {
        return StatCollector.func_74838_a((String)names[i]);
    }

    public static String getName(String tag, boolean tech) {
        String sg = StatCollector.func_74838_a((String)tag);
        if (tech && DragonOptions.DEBUGMODE.getState()) {
            sg = sg + " (Technical Block)";
        }
        return sg;
    }

    public static String getBucketName(int i) {
        String liq = StatCollector.func_74838_a((String)liquidNames[i]);
        String item = StatCollector.func_74838_a((String)"item.rcbucket");
        return liq + " " + item;
    }

    public static String getEngineName(int i) {
        return RotaryNames.getName(engineNames, i);
    }

    public static String getAdvGearName(int i) {
        return RotaryNames.getName(advGearItemNames, i);
    }

    public static String getHydraulicName(int i) {
        return RotaryNames.getName(hydraulicItemNames, i);
    }

    public static int getNumberAdvGearTypes() {
        return advGearItemNames.length;
    }

    public static int getNumberEngineTypes() {
        return engineNames.length;
    }

    public static int getNumberHydraulicTypes() {
        return hydraulicItemNames.length;
    }

    public static String getModExtractName(int dmg) {
        String base = ModOreList.oreList[dmg / 4].displayName;
        switch (dmg % 4) {
            case 0: {
                return base + " Dust";
            }
            case 1: {
                return base + " Slurry";
            }
            case 2: {
                return base + " Solution";
            }
            case 3: {
                return base + " Flakes";
            }
        }
        return base;
    }

    public static String getModIngotName(int dmg) {
        return ModOreList.oreList[dmg].displayName + " " + ModOreList.oreList[dmg].getTypeName();
    }

    public static String getCanolaName(int dmg) {
        return RotaryNames.getName(canolaNames, dmg);
    }

    public static String getGearPartName(int dmg) {
        ItemStack is = ItemRegistry.GEARCRAFT.getStackOfMetadata(dmg);
        GearboxTypes material = GearboxTypes.getMaterialFromCraftingItem(is);
        return GearboxTypes.GearPart.list[is.func_77960_j() % 16].getLocalizedName(material);
    }
}

