/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Decorative;

import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.RotaryCraft.API.Event.FireworkLaunchEvent;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.EnchantableMachine;
import Reika.RotaryCraft.Auxiliary.MachineEnchantmentHandler;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityFireworkMachine
extends InventoriedPowerReceiver
implements EnchantableMachine,
DiscreteFunction,
ConditionalOperation {
    private final MachineEnchantmentHandler enchantments = new MachineEnchantmentHandler().addFilter(Enchantment.field_77342_w);
    public boolean idle = false;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        ItemStack star;
        super.updateTileEntity();
        ++this.tickcount;
        this.getSummativeSidedPower();
        if (world.field_72995_K) {
            return;
        }
        if (this.power < this.MINPOWER) {
            return;
        }
        if (this.omega < this.MINSPEED) {
            return;
        }
        if (this.tickcount < this.getOperationTime()) {
            return;
        }
        this.tickcount = 0;
        if (!this.canCraftARocket()) {
            this.idle = true;
            return;
        }
        this.idle = false;
        ItemStack rocket = null;
        boolean hasStar = ReikaInventoryHelper.checkForItem((Item)Items.field_151154_bQ, (ItemStack[])this.inv);
        if (!hasStar) {
            star = this.randomRecipe();
            if (star == null) {
                return;
            }
            rocket = this.starToRocket(star);
        } else if (this.canMakeRocketFromStar()) {
            star = null;
            int slot = rand.nextInt(this.inv.length);
            while (this.inv[slot] == null || this.inv[slot].func_77973_b() != Items.field_151154_bQ) {
                slot = rand.nextInt(this.inv.length);
            }
            star = this.func_70301_a(slot);
            if (this.consumeChance()) {
                this.func_70298_a(slot, 1);
            }
            rocket = this.starToRocket(star);
        }
        if (rocket == null) {
            return;
        }
        EntityFireworkRocket firework = new EntityFireworkRocket(world, (double)x + 0.5, (double)y + 1.25, (double)z + 0.5, rocket);
        world.func_72838_d((Entity)firework);
        MinecraftForge.EVENT_BUS.post((Event)new FireworkLaunchEvent((TileEntity)this, firework));
        if (this.enchantments.hasEnchantments()) {
            for (int i = 0; i < 8; ++i) {
                world.func_72869_a("portal", -0.5 + (double)x + 2.0 * rand.nextDouble(), (double)y + rand.nextDouble(), -0.5 + (double)z + 2.0 * rand.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    private boolean consumeChance() {
        if (this.enchantments.hasEnchantment(Enchantment.field_77342_w)) {
            return false;
        }
        int excess = (int)(this.power / this.MINPOWER);
        int chance = rand.nextInt(1 + excess / 8);
        return chance == 0;
    }

    private boolean canCraftARocket() {
        boolean haveDye = false;
        boolean have2Gunpowder = false;
        boolean havePaper = false;
        boolean haveStar = false;
        boolean have1Gunpowder = false;
        have1Gunpowder = ReikaInventoryHelper.checkForItem((Item)Items.field_151016_H, (ItemStack[])this.inv);
        haveStar = ReikaInventoryHelper.checkForItem((Item)Items.field_151154_bQ, (ItemStack[])this.inv);
        haveDye = ReikaInventoryHelper.checkForItem((Item)Items.field_151100_aR, (ItemStack[])this.inv);
        havePaper = ReikaInventoryHelper.checkForItem((Item)Items.field_151121_aF, (ItemStack[])this.inv);
        int numgunpowder = 0;
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null || this.inv[i].func_77973_b() != Items.field_151016_H || (numgunpowder += this.inv[i].field_77994_a) < 2) continue;
            have2Gunpowder = true;
            i = this.inv.length;
        }
        return havePaper && haveDye && have2Gunpowder || have1Gunpowder && haveStar;
    }

    private boolean canMakeRocketFromStar() {
        boolean hasPaper = ReikaInventoryHelper.checkForItem((Item)Items.field_151121_aF, (ItemStack[])this.inv);
        boolean hasGunpowder = ReikaInventoryHelper.checkForItem((Item)Items.field_151016_H, (ItemStack[])this.inv);
        boolean hasStar = ReikaInventoryHelper.checkForItem((Item)Items.field_151154_bQ, (ItemStack[])this.inv);
        return hasPaper && hasGunpowder && hasStar;
    }

    private ItemStack starToRocket(ItemStack star) {
        ItemStack product = null;
        ItemStack gunpowder = new ItemStack(Items.field_151016_H, 1, 0);
        int numgunpowder = rand.nextInt(3) + 1;
        ItemStack paper = new ItemStack(Items.field_151121_aF, 1, 0);
        ItemStack[] ingredients = new ItemStack[5];
        if (this.getIngredient(Items.field_151016_H, this.canMakeRocketFromStar() && this.consumeChance())) {
            ingredients[1] = gunpowder;
        }
        if (numgunpowder >= 2 && this.getIngredient(Items.field_151016_H, this.consumeChance())) {
            ingredients[2] = gunpowder;
        }
        if (numgunpowder >= 3 && this.getIngredient(Items.field_151016_H, this.consumeChance())) {
            ingredients[3] = gunpowder;
        }
        if (this.getIngredient(Items.field_151121_aF, this.consumeChance())) {
            ingredients[4] = paper;
        }
        ingredients[0] = star;
        product = this.setNBT(ingredients);
        return product;
    }

    private ReikaDyeHelper pickRandomColor(boolean decr) {
        int color = -1;
        boolean[] hasColors = new boolean[16];
        boolean hasDye = false;
        for (int i = 0; i < this.inv.length; ++i) {
            Collection dyes = ReikaDyeHelper.getColorsFromItem((ItemStack)this.inv[i]);
            if (dyes == null) continue;
            hasDye = true;
            for (ReikaDyeHelper dye : dyes) {
                hasColors[dye.ordinal()] = true;
            }
        }
        if (!hasDye) {
            return null;
        }
        while (color == -1) {
            ReikaDyeHelper randcolor = ReikaDyeHelper.getRandomColor();
            while (!hasColors[randcolor.ordinal()]) {
                randcolor = ReikaDyeHelper.getRandomColor();
            }
            for (int j = 0; j < this.inv.length; ++j) {
                ReikaDyeHelper dye2;
                if (this.inv[j] == null || (dye2 = ReikaDyeHelper.getColorFromItem((ItemStack)this.inv[j])) != randcolor) continue;
                if (decr) {
                    ReikaInventoryHelper.decrStack((int)j, (ItemStack[])this.inv);
                }
                return randcolor;
            }
        }
        return null;
    }

    private boolean getIngredient(Item id, boolean decr) {
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null || this.inv[i].func_77973_b() != id) continue;
            if (decr) {
                ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
            }
            return true;
        }
        return false;
    }

    private int getShape() {
        boolean[] hasShape = new boolean[4];
        int shape = rand.nextInt(4);
        if (ReikaInventoryHelper.checkForItem((Item)Items.field_151059_bz, (ItemStack[])this.inv)) {
            hasShape[0] = true;
        }
        if (ReikaInventoryHelper.checkForItem((Item)Items.field_151074_bl, (ItemStack[])this.inv)) {
            hasShape[1] = true;
        }
        if (ReikaInventoryHelper.checkForItem((Item)Items.field_151008_G, (ItemStack[])this.inv)) {
            hasShape[2] = true;
        }
        if (ReikaInventoryHelper.checkForItem((Item)Items.field_151144_bL, (ItemStack[])this.inv)) {
            hasShape[3] = true;
        }
        boolean noShapes = true;
        for (int i = 0; i < hasShape.length; ++i) {
            if (!hasShape[i]) continue;
            noShapes = false;
            i = hasShape.length;
        }
        if (noShapes) {
            return -1;
        }
        while (!hasShape[shape]) {
            shape = rand.nextInt(4);
        }
        int slot = -1;
        Item id = null;
        switch (shape) {
            case 0: {
                id = Items.field_151059_bz;
                break;
            }
            case 1: {
                id = Items.field_151074_bl;
                break;
            }
            case 2: {
                id = Items.field_151008_G;
                break;
            }
            case 3: {
                id = Items.field_151144_bL;
            }
        }
        if (id != null && this.consumeChance()) {
            ReikaInventoryHelper.findAndDecrStack((Item)id, (int)-1, (ItemStack[])this.inv);
        }
        return shape + 1;
    }

    private ItemStack randomRecipe() {
        ReikaDyeHelper dyeColor = this.pickRandomColor(this.consumeChance() && ReikaInventoryHelper.checkForItem((Item)Items.field_151016_H, (ItemStack[])this.inv));
        boolean hasDiamond = false;
        boolean hasGlowstone = false;
        int shape = this.getShape();
        ItemStack gunpowder = new ItemStack(Items.field_151016_H, 1, 64);
        ItemStack diamond = new ItemStack(Items.field_151045_i, 1, 0);
        ItemStack glowstone = new ItemStack(Items.field_151114_aO, 1, 0);
        ItemStack[] inputitems = new ItemStack[5];
        inputitems[1] = dyeColor != null ? new ItemStack(Items.field_151100_aR, 1, dyeColor.ordinal()) : null;
        if (inputitems[1] == null) {
            return null;
        }
        if (this.getIngredient(Items.field_151016_H, this.consumeChance())) {
            inputitems[0] = gunpowder;
        }
        if (inputitems[0] == null) {
            return null;
        }
        if (rand.nextInt(2) == 0 && this.getIngredient(Items.field_151045_i, this.consumeChance())) {
            hasDiamond = true;
        }
        if (rand.nextInt(2) == 0 && this.getIngredient(Items.field_151114_aO, this.consumeChance())) {
            hasGlowstone = true;
        }
        if (hasDiamond) {
            inputitems[2] = diamond;
        }
        if (hasGlowstone) {
            inputitems[3] = glowstone;
        }
        switch (shape) {
            case 1: {
                inputitems[4] = new ItemStack(Items.field_151059_bz, 1, 0);
                break;
            }
            case 2: {
                inputitems[4] = new ItemStack(Items.field_151074_bl, 1, 0);
                break;
            }
            case 3: {
                inputitems[4] = new ItemStack(Items.field_151008_G, 1, 0);
                break;
            }
            case 4: {
                inputitems[4] = new ItemStack(Items.field_151144_bL, 1, 0);
                break;
            }
            default: {
                inputitems[4] = null;
            }
        }
        ItemStack output = this.setNBT(inputitems);
        if (rand.nextInt(2) == 0) {
            ReikaDyeHelper dyeColor2 = this.pickRandomColor(this.consumeChance());
            if (dyeColor2 == null) {
                return output;
            }
            ItemStack newcolor = new ItemStack(Items.field_151100_aR, 1, dyeColor2.ordinal());
            output = this.colorBlend(output, newcolor);
        }
        return output;
    }

    private ItemStack colorBlend(ItemStack base, ItemStack blendcolor) {
        ItemStack[] inputitems = new ItemStack[]{base, blendcolor};
        return this.setNBT(inputitems);
    }

    private ItemStack setNBT(ItemStack[] inputitems) {
        ItemStack field_92102_a = null;
        int var3 = 0;
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        int var7 = 0;
        int var8 = 0;
        for (int var9 = 0; var9 < inputitems.length; ++var9) {
            ItemStack var10 = inputitems[var9];
            if (var10 == null) continue;
            if (var10.func_77973_b() == Items.field_151016_H) {
                ++var4;
                continue;
            }
            if (var10.func_77973_b() == Items.field_151154_bQ) {
                ++var6;
                continue;
            }
            if (var10.func_77973_b() == Items.field_151100_aR) {
                ++var5;
                continue;
            }
            if (var10.func_77973_b() == Items.field_151121_aF) {
                ++var3;
                continue;
            }
            if (var10.func_77973_b() == Items.field_151114_aO) {
                ++var7;
                continue;
            }
            if (var10.func_77973_b() == Items.field_151045_i) {
                ++var7;
                continue;
            }
            if (var10.func_77973_b() == Items.field_151059_bz) {
                ++var8;
                continue;
            }
            if (var10.func_77973_b() == Items.field_151008_G) {
                ++var8;
                continue;
            }
            if (var10.func_77973_b() == Items.field_151074_bl) {
                ++var8;
                continue;
            }
            if (var10.func_77973_b() != Items.field_151144_bL) {
                return field_92102_a;
            }
            ++var8;
        }
        var7 += var5 + var8;
        if (var4 <= 3 && var3 <= 1) {
            NBTTagCompound var18;
            if (var4 >= 1 && var3 == 1 && var7 == 0) {
                field_92102_a = new ItemStack(Items.field_151152_bP);
                NBTTagCompound var15 = new NBTTagCompound();
                if (var6 > 0) {
                    var18 = new NBTTagCompound();
                    NBTTagList var25 = new NBTTagList();
                    for (int var22 = 0; var22 < inputitems.length; ++var22) {
                        ItemStack var26 = inputitems[var22];
                        if (var26 == null || var26.func_77973_b() != Items.field_151154_bQ || !var26.func_77942_o() || !var26.func_77978_p().func_74764_b("Explosion")) continue;
                        var25.func_74742_a((NBTBase)var26.func_77978_p().func_74775_l("Explosion"));
                    }
                    var18.func_74782_a("Explosions", (NBTBase)var25);
                    var18.func_74774_a("Flight", (byte)var4);
                    var15.func_74782_a("Fireworks", (NBTBase)var18);
                }
                field_92102_a.func_77982_d(var15);
                return field_92102_a;
            }
            if (var4 == 1 && var3 == 0 && var6 == 0 && var5 > 0 && var8 <= 1) {
                field_92102_a = new ItemStack(Items.field_151154_bQ);
                NBTTagCompound var15 = new NBTTagCompound();
                var18 = new NBTTagCompound();
                int var21 = 0;
                ArrayList<Integer> var12 = new ArrayList<Integer>();
                for (int var13 = 0; var13 < inputitems.length; ++var13) {
                    ItemStack var14 = inputitems[var13];
                    if (var14 == null) continue;
                    if (var14.func_77973_b() == Items.field_151100_aR) {
                        var12.add(ItemDye.field_150922_c[var14.func_77960_j()]);
                        continue;
                    }
                    if (var14.func_77973_b() == Items.field_151114_aO) {
                        var18.func_74757_a("Flicker", true);
                        continue;
                    }
                    if (var14.func_77973_b() == Items.field_151045_i) {
                        var18.func_74757_a("Trail", true);
                        continue;
                    }
                    if (var14.func_77973_b() == Items.field_151059_bz) {
                        var21 = 1;
                        continue;
                    }
                    if (var14.func_77973_b() == Items.field_151008_G) {
                        var21 = 4;
                        continue;
                    }
                    if (var14.func_77973_b() == Items.field_151074_bl) {
                        var21 = 2;
                        continue;
                    }
                    if (var14.func_77973_b() != Items.field_151144_bL) continue;
                    var21 = 3;
                }
                int[] var24 = new int[var12.size()];
                for (int var27 = 0; var27 < var24.length; ++var27) {
                    var24[var27] = (Integer)var12.get(var27);
                }
                var18.func_74783_a("Colors", var24);
                var18.func_74774_a("Type", (byte)var21);
                var15.func_74782_a("Explosion", (NBTBase)var18);
                field_92102_a.func_77982_d(var15);
                return field_92102_a;
            }
            if (var4 == 0 && var3 == 0 && var6 == 1 && var5 > 0 && var5 == var7) {
                ArrayList<Integer> var16 = new ArrayList<Integer>();
                for (int var20 = 0; var20 < inputitems.length; ++var20) {
                    ItemStack var11 = inputitems[var20];
                    if (var11 == null) continue;
                    if (var11.func_77973_b() == Items.field_151100_aR) {
                        var16.add(ItemDye.field_150922_c[var11.func_77960_j()]);
                        continue;
                    }
                    if (var11.func_77973_b() != Items.field_151154_bQ) continue;
                    field_92102_a = var11.func_77946_l();
                    field_92102_a.field_77994_a = 1;
                }
                int[] var17 = new int[var16.size()];
                for (int var19 = 0; var19 < var17.length; ++var19) {
                    var17[var19] = (Integer)var16.get(var19);
                }
                if (field_92102_a != null && field_92102_a.func_77942_o()) {
                    NBTTagCompound var23 = field_92102_a.func_77978_p().func_74775_l("Explosion");
                    if (var23 == null) {
                        return field_92102_a;
                    }
                    var23.func_74783_a("FadeColors", var17);
                    return field_92102_a;
                }
                return field_92102_a;
            }
            return field_92102_a;
        }
        return field_92102_a;
    }

    public int func_70302_i_() {
        return 27;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74782_a("enchants", (NBTBase)this.enchantments.writeToNBT());
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.enchantments.readFromNBT(NBT.func_150295_c("enchants", ReikaNBTHelper.NBTTypes.COMPOUND.ID));
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.FIREWORK;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return ReikaItemHelper.isFireworkIngredient((Item)is.func_77973_b());
    }

    public int getRedstoneOverride() {
        if (!this.canCraftARocket()) {
            return 15;
        }
        return 0;
    }

    public ArrayList<Enchantment> getValidEnchantments() {
        ArrayList<Enchantment> li = new ArrayList<Enchantment>();
        li.add(Enchantment.field_77342_w);
        return li;
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.FIREWORK.getOperationTime(this.omega);
    }

    @Override
    public boolean areConditionsMet() {
        return !ReikaInventoryHelper.isEmpty((ItemStack[])this.inv);
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Items";
    }

    @Override
    public MachineEnchantmentHandler getEnchantmentHandler() {
        return this.enchantments;
    }
}

