/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Engine;

import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.UpgradeableMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Registry.EngineType;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.RotaryCraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class TileEntityGasEngine
extends TileEntityEngine
implements UpgradeableMachine {
    @Override
    public void upgrade(ItemStack is) {
        NBTTagCompound NBT = new NBTTagCompound();
        this.type = EngineType.SPORT;
        this.func_145841_b(NBT);
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getTileEntityBlockID(), this.type.ordinal(), 3);
        TileEntityEngine te = (TileEntityEngine)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        te.func_145839_a(NBT);
        this.syncAllData(true);
        te.syncAllData(true);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean canUpgradeWith(ItemStack item) {
        return item.func_77973_b() == ItemRegistry.UPGRADE.getItemInstance() && item.func_77960_j() == 0;
    }

    @Override
    protected void consumeFuel(float scale) {
        this.fuel.removeLiquid(scale * (float)this.getConsumedFuel());
    }

    @Override
    protected void internalizeFuel() {
        if (this.inv[0] != null && this.fuel.getLevel() + 1000 <= 240000 && this.inv[0].func_77973_b() == ItemRegistry.ETHANOL.getItemInstance()) {
            ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
            this.fuel.addLiquid(1000, (Fluid)RotaryCraft.ethanolFluid);
        }
    }

    @Override
    protected boolean getRequirements(World world, int x, int y, int z, int meta) {
        return !this.fuel.isEmpty();
    }

    @Override
    protected void playSounds(World world, int x, int y, int z, float pitchMultiplier, float volume) {
        ++this.soundtick;
        if (this.isMuffled(world, x, y, z)) {
            volume *= 0.3125f;
        }
        if (this.soundtick < this.getSoundLength(1.0f / pitchMultiplier) && this.soundtick < 2000) {
            return;
        }
        this.soundtick = 0;
        SoundRegistry.CAR.playSoundAtBlock(world, x, y, z, 0.33f * volume, 0.9f * pitchMultiplier);
    }

    @Override
    public int getFuelLevel() {
        return this.fuel.getLevel();
    }

    @Override
    protected void affectSurroundings(World world, int x, int y, int z, int meta) {
    }
}

