/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Farming;

import Reika.DragonAPI.Instantiable.AI.AITaskAvoidMachine;
import Reika.DragonAPI.Instantiable.AI.AITaskSeekMachine;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.AbstractSearch;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.EntityPathSpline;
import Reika.DragonAPI.Interfaces.EntityPathfinder;
import Reika.DragonAPI.Interfaces.TileEntity.MobAttractor;
import Reika.DragonAPI.Interfaces.TileEntity.MobRepellent;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.MobBait;
import forestry.api.lepidopterology.IEntityButterfly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityBaitBox
extends InventoriedPowerReceiver
implements RangedEffect,
ConditionalOperation,
MobAttractor,
MobRepellent {
    public static final int FALLOFF = 4096;
    private EntityPathSpline pathfinder;
    private static final AbstractSearch.PropagationCondition butterflyPathRule = new AbstractSearch.PropagationCondition(){

        public boolean isValidLocation(World world, int x, int y, int z, Coordinate from) {
            return AbstractSearch.PassablePropagation.instance.isValidLocation(world, x, y, z, from) || world.func_147439_a(x, y, z).isLeaves((IBlockAccess)world, x, y, z);
        }
    };

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        if (ModList.FORESTRY.isLoaded() && !world.field_72995_K) {
            this.pathfinder = new EntityPathSpline((TileEntity)this);
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.getSummativeSidedPower();
        if (this.power < this.MINPOWER) {
            return;
        }
        int range = this.getRange();
        AxisAlignedBB box = this.getBox(x, y, z, range);
        List inbox = world.func_72872_a(EntityLiving.class, box);
        if (!inbox.isEmpty() && (world.func_82737_E() & 3L) == 0L) {
            for (EntityLiving ent : inbox) {
                if (this.canRepel(ent)) {
                    this.applyEffect(world, x, y, z, ent, false);
                } else if (this.canAttract(ent)) {
                    this.applyEffect(world, x, y, z, ent, true);
                }
                if (!ModList.FORESTRY.isLoaded() || this.pathfinder == null || !(ent instanceof IEntityButterfly)) continue;
                this.pathfinder.addEntity((Entity)ent, butterflyPathRule);
            }
        }
        if (ModList.FORESTRY.isLoaded() && ReikaInventoryHelper.checkForItem((Item)ForestryHandler.ItemEntry.POLLEN.getItem(), (ItemStack[])this.inv)) {
            if (this.pathfinder != null) {
                this.pathfinder.removeDeadEntities(world);
            }
            ReikaBeeHelper.attractButterflies((World)world, (double)((double)x + 0.5), (double)((double)y + 1.5), (double)((double)z + 0.5), (double)range, (EntityPathfinder)this.pathfinder);
            ReikaBeeHelper.collectButterflies((World)world, (AxisAlignedBB)ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(4.0, 2.0, 4.0), null);
        }
        if (rand.nextInt(20) == 0) {
            this.doEggIncubation(world, x, y, z);
        }
        this.tickcount = 0;
    }

    private void doEggIncubation(World world, int x, int y, int z) {
        int slot = ReikaInventoryHelper.locateIDInInventory((Item)Items.field_151110_aK, (IInventory)this);
        if (slot >= 0 && ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151581_o) != null) {
            if (ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151587_i) == null) {
                EntityChicken ec = new EntityChicken(world);
                ec.func_70012_b((double)x + rand.nextDouble(), (double)y + rand.nextDouble() + 0.5, (double)z + rand.nextDouble(), rand.nextFloat() * 90.0f, rand.nextFloat() * 360.0f);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)ec);
                }
            } else {
                ReikaInventoryHelper.addToIInv((ItemStack)new ItemStack(Items.field_151077_bg), (IInventory)this, (boolean)true);
            }
            ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
        }
    }

    private int maxMobs() {
        return Math.max(24, ConfigRegistry.BAITMOBS.getValue());
    }

    @Override
    public int getMaxRange() {
        return Math.max(24, ConfigRegistry.BAITRANGE.getValue());
    }

    private void silverfishStone(World world, int x, int y, int z) {
        for (int i = x - 5; i <= x + 5; ++i) {
            for (int j = y - 5; j <= y + 5; ++j) {
                int k = z - 5;
                while (z <= z + 5) {
                    if (world.func_147439_a(i, j, k) == Blocks.field_150418_aU) {
                        world.func_147468_f(i, j, k);
                        world.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "step.stone", 0.5f + 0.5f * rand.nextFloat(), 0.8f + 0.2f * rand.nextFloat());
                    }
                    ++k;
                }
            }
        }
    }

    private void dropHeldItem(World world, int x, int y, int z, EntityLivingBase ent) {
        ItemStack held = ent.func_70694_bm();
        ent.func_70062_b(0, null);
        if (held != null && !world.field_72995_K) {
            EntityItem ei = new EntityItem(world, ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v, held);
            ei.field_70159_w = -0.2f + 0.4f * rand.nextFloat();
            ei.field_70179_y = -0.2f + 0.4f * rand.nextFloat();
            ei.field_70181_x = 0.4f * rand.nextFloat();
            ei.field_145804_b = 200;
            world.func_72838_d((Entity)ei);
        }
    }

    public boolean canRepel(EntityLiving ent) {
        return this.power >= this.MINPOWER && (double)this.getRange() >= ent.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) && MobBait.hasRepelItem((EntityLivingBase)ent, this.inv);
    }

    public boolean canAttract(EntityLiving ent) {
        return this.power >= this.MINPOWER && (double)this.getRange() >= ent.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) && MobBait.hasAttractItem((EntityLivingBase)ent, this.inv);
    }

    private void applyEffect(World world, int x, int y, int z, EntityLiving ent, boolean attract) {
        float var1;
        if (world.field_72995_K) {
            return;
        }
        if (ent instanceof EntityTameable && ((EntityTameable)ent).func_70906_o()) {
            return;
        }
        long time = this.field_145850_b.func_82737_E();
        if (time - ent.getEntityData().func_74763_f("baitbox") < 20L) {
            return;
        }
        ent.getEntityData().func_74772_a("baitbox", time);
        if (attract) {
            ReikaEntityHelper.addAITask((EntityLiving)ent, (EntityAIBase)new AITaskSeekMachine(ent, 1.0, (MobAttractor)this), (int)-1000000);
        } else {
            ReikaEntityHelper.addAITask((EntityLiving)ent, (EntityAIBase)new AITaskAvoidMachine(ent, 1.0, (MobRepellent)this), (int)-1000000);
            this.dropHeldItem(world, x, y, z, (EntityLivingBase)ent);
        }
        if (ent instanceof EntityBlaze || ent instanceof EntitySlime || ent instanceof EntityMagmaCube || ent instanceof EntityGhast || ent instanceof EntitySquid) {
            if (attract) {
                if (!(ent instanceof EntitySlime) || !ent.field_70122_E) {
                    ent.field_70159_w = 0.02 * ((double)x - ent.field_70165_t);
                    if (!(ent instanceof EntityWaterMob) || ent.func_70090_H()) {
                        ent.field_70181_x = 0.02 * ((double)y - ent.field_70163_u);
                    }
                    ent.field_70179_y = 0.02 * ((double)z - ent.field_70161_v);
                }
            } else if (!(ent instanceof EntitySlime) || !ent.field_70122_E) {
                ent.field_70159_w = -0.02 * ((double)x - ent.field_70165_t);
                if (!(ent instanceof EntityWaterMob) || ent.func_70090_H()) {
                    ent.field_70181_x = -0.02 * ((double)y - ent.field_70163_u);
                }
                ent.field_70179_y = -0.02 * ((double)z - ent.field_70161_v);
            }
            if (ent instanceof EntityBlaze) {
                ent.field_70159_w *= 4.0;
                ent.field_70179_y *= 4.0;
            }
            var1 = (float)ReikaMathLibrary.py3d((double)ent.field_70159_w, (double)0.0, (double)ent.field_70179_y);
            ent.field_70761_aq += (-((float)Math.atan2(ent.field_70159_w, ent.field_70179_y)) * 180.0f / (float)Math.PI - ent.field_70761_aq) * 0.1f;
            ent.field_70177_z = ent.field_70761_aq;
            if (!world.field_72995_K) {
                ent.field_70133_I = true;
            }
        }
        if (ent instanceof EntityBat) {
            if (attract) {
                ent.field_70159_w = 0.1 * ((double)x - ent.field_70165_t);
                ent.field_70181_x = 0.1 * ((double)y - ent.field_70163_u);
                ent.field_70179_y = 0.1 * ((double)z - ent.field_70161_v);
            } else {
                ent.field_70159_w = -0.1 * ((double)x - ent.field_70165_t);
                ent.field_70181_x = -0.1 * ((double)y - ent.field_70163_u);
                ent.field_70179_y = -0.1 * ((double)z - ent.field_70161_v);
            }
            var1 = (float)ReikaMathLibrary.py3d((double)ent.field_70159_w, (double)0.0, (double)ent.field_70179_y);
            ent.field_70761_aq += (-((float)Math.atan2(ent.field_70159_w, ent.field_70179_y)) * 180.0f / (float)Math.PI - ent.field_70761_aq) * 0.1f;
            ent.field_70177_z = ent.field_70761_aq;
            if (!world.field_72995_K) {
                ent.field_70133_I = true;
            }
        }
    }

    @Override
    public int getRange() {
        int range = 8 + (int)((this.power - this.MINPOWER) / 4096L);
        if (range > this.getMaxRange()) {
            return this.getMaxRange();
        }
        return range;
    }

    private AxisAlignedBB getBox(int x, int y, int z, int range) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b((double)range, (double)range, (double)range);
        return box;
    }

    public int func_70302_i_() {
        return 27;
    }

    public int getLeftoverSlots() {
        int slots;
        for (slots = this.inv.length; slots >= 9; slots -= 9) {
        }
        return slots;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.BAITBOX;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return true;
    }

    public int getRedstoneOverride() {
        if (ReikaInventoryHelper.isEmpty((ItemStack[])this.inv)) {
            return 15;
        }
        for (int i = 0; i < this.inv.length; ++i) {
            if (!MobBait.isValidItem(this.inv[i])) continue;
            return 0;
        }
        return 15;
    }

    @Override
    public boolean areConditionsMet() {
        return !ReikaInventoryHelper.isEmpty((ItemStack[])this.inv);
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Items";
    }
}

