/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Farming;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Event.BlockTickEvent;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaCropHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaPlantHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModCropList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.ReactorCraft.Entities.EntityRadiation;
import Reika.RotaryCraft.Base.TileEntity.SprinklerBlock;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.PacketRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySprinkler
extends SprinklerBlock {
    private static final String LOGGER_ID = "sprinkler_apple";
    private final FieldCache cache = new FieldCache();

    @Override
    public void performEffects(World world, int x, int y, int z) {
        RotaryAchievements.SPRINKLER.triggerAchievement(this.getPlacer());
        if (!world.field_72995_K) {
            this.hydrate(world, x, y, z);
            if (ModList.REACTORCRAFT.isLoaded() && rand.nextInt(2400) == 0) {
                this.clearRadiation(world, x, y, z);
            }
        } else {
            this.spawnParticles(world, x, y, z);
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.REACTORCRAFT})
    private void clearRadiation(World world, int x, int y, int z) {
        int r = this.getRange();
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72317_d(0.0, -4.0, 0.0).func_72314_b((double)r, 4.0, (double)r);
        List li = world.func_72872_a(EntityRadiation.class, box);
        for (EntityRadiation e : li) {
            e.clean();
            if (!rand.nextBoolean()) continue;
            break;
        }
    }

    public void hydrate(World world, int x, int y, int z) {
        int range = this.getRange();
        boolean flag = false;
        for (int i = -range; i <= range; ++i) {
            for (int k = -range; k <= range; ++k) {
                int dx = x + i;
                int dz = z + k;
                float f = 0.5f + 1.5f * (float)(i * i + k * k) / (float)(range * range);
                FieldColumn fe = this.cache.getOrFindLevel(world, dx, dz, y);
                if (!fe.tick(world, f)) continue;
                fe.recalulateLevel(world);
                flag = true;
            }
        }
        if (this.cache.tickDirty()) {
            this.syncAllData(true);
        }
    }

    private void sendParticle(int dx, int dy, int dz, boolean drip) {
        ReikaPacketHelper.sendDataPacketWithRadius((String)"RotaryCraftData", (int)PacketRegistry.SPRINKLER.ordinal(), (TileEntity)this, (int)48, (int[])new int[]{dx, dy, dz, drip ? 1 : 0});
    }

    @SideOnly(value=Side.CLIENT)
    public void doParticle(World world, int dx, int dy, int dz, boolean drip) {
        int d = Math.max(1, 5 - ConfigRegistry.SPRINKLER.getValue());
        if (rand.nextInt(d) == 0) {
            ReikaParticleHelper.RAIN.spawnAt(world, (double)dx + rand.nextDouble(), (double)(dy + 1), (double)dz + rand.nextDouble());
        }
        if (drip) {
            ReikaParticleHelper.DRIPWATER.spawnAt(world, (double)dx + rand.nextDouble(), (double)dy, (double)dz + rand.nextDouble());
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74782_a("cache", (NBTBase)this.cache.writeToNBT());
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.cache.readFromNBT(NBT.func_150295_c("cache", ReikaNBTHelper.NBTTypes.COMPOUND.ID));
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, int x, int y, int z) {
        int i;
        int d = Math.max(0, ConfigRegistry.SPRINKLER.getValue());
        double ypos = (double)y + 0.125;
        double r = (double)this.getRange() / 10.0;
        double py = (double)y - 0.1875 + 0.5;
        int n = (rand.nextInt(2) == 0 ? 1 : 0) + rand.nextInt(1 + d);
        for (i = 0; i < n; ++i) {
            double px = (float)(x - 1) + 2.0f * rand.nextFloat();
            double pz = (float)(z - 1) + 2.0f * rand.nextFloat();
            world.func_72869_a("splash", px + 0.5, py, pz + 0.5, 0.0, 0.0, 0.0);
        }
        for (double vel = 0.0; vel < r; vel += 0.1) {
            py = (double)y - 0.1875 + 0.5;
            n = (rand.nextInt(2) == 0 ? 1 : 0) + rand.nextInt(1 + d * 4);
            for (i = 0; i < n; ++i) {
                double vx = vel * (double)(-1.0f + rand.nextFloat() * 2.0f);
                double vz = vel * (double)(-1.0f + rand.nextFloat() * 2.0f);
                double px = (float)(x - 1) + 2.0f * rand.nextFloat();
                double pz = (float)(z - 1) + 2.0f * rand.nextFloat();
                world.func_72869_a("splash", px + 0.5, py, pz + 0.5, vx *= 1.05, 0.0, vz *= 1.05);
            }
        }
        this.cache.doParticles(world);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.SPRINKLER;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public int getCapacity() {
        return 180;
    }

    @Override
    public int getWaterConsumption() {
        return 3;
    }

    @Override
    public ForgeDirection getPipeDirection() {
        return ForgeDirection.UP;
    }

    private static boolean isOpaque(Block b) {
        return b.func_149662_c() && !(b instanceof BlockLeavesBase);
    }

    static {
        ModularLogger.instance.addLogger((DragonAPIMod)RotaryCraft.instance, LOGGER_ID);
    }

    private static class ColumnAction {
        private final Block block;
        private final int xCoord;
        private final int yCoord;
        private final int zCoord;
        private final Effects effect;
        private final boolean doDripParticles;
        private final boolean doDripParticlesUp;
        private final boolean doSplashParticles;

        private ColumnAction(Block b, int x, int y, int z, Effects e, boolean drip, boolean drip2, boolean splash) {
            this.block = b;
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            this.effect = e;
            this.doDripParticles = drip;
            this.doDripParticlesUp = drip2;
            this.doSplashParticles = splash;
        }

        private NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("x", this.xCoord);
            tag.func_74768_a("z", this.zCoord);
            tag.func_74768_a("y", this.yCoord);
            tag.func_74768_a("effect", this.effect.ordinal());
            tag.func_74768_a("block", Block.func_149682_b((Block)this.block));
            tag.func_74757_a("drip", this.doDripParticles);
            tag.func_74757_a("drip2", this.doDripParticlesUp);
            tag.func_74757_a("splash", this.doSplashParticles);
            return tag;
        }

        private static ColumnAction readFromNBT(NBTTagCompound tag) {
            return new ColumnAction(Block.func_149729_e((int)tag.func_74762_e("block")), tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"), Effects.list[tag.func_74762_e("effect")], tag.func_74767_n("drip"), tag.func_74767_n("drip2"), tag.func_74767_n("splash"));
        }
    }

    private static class FieldColumn {
        private int age = 0;
        private final int xCoord;
        private final int zCoord;
        private final int sprinklerY;
        private ColumnAction[][] effectMap = new ColumnAction[256][];

        private FieldColumn(int dx, int dz, int y) {
            this.xCoord = dx;
            this.zCoord = dz;
            this.sprinklerY = y;
        }

        private NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("x", this.xCoord);
            tag.func_74768_a("z", this.zCoord);
            tag.func_74768_a("y", this.sprinklerY);
            NBTTagList li = new NBTTagList();
            for (int y = 0; y < 256; ++y) {
                ColumnAction[] cc = this.effectMap[y];
                if (cc == null) continue;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("y", y);
                NBTTagList li2 = new NBTTagList();
                for (ColumnAction ca : cc) {
                    li2.func_74742_a((NBTBase)ca.writeToNBT());
                }
                nbt.func_74782_a("entries", (NBTBase)li2);
                li.func_74742_a((NBTBase)nbt);
            }
            tag.func_74782_a("map", (NBTBase)li);
            return tag;
        }

        private static FieldColumn readFromNBT(NBTTagCompound tag) {
            int x = tag.func_74762_e("x");
            int y = tag.func_74762_e("y");
            int z = tag.func_74762_e("z");
            FieldColumn ret = new FieldColumn(x, z, y);
            NBTTagList li = tag.func_150295_c("map", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            for (Object o : li.field_74747_a) {
                NBTTagCompound nbt = (NBTTagCompound)o;
                int dy = nbt.func_74762_e("y");
                HashSet<ColumnAction> cc = new HashSet<ColumnAction>();
                NBTTagList li2 = nbt.func_150295_c("entries", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
                for (Object o2 : li2.field_74747_a) {
                    NBTTagCompound nbt2 = (NBTTagCompound)o2;
                    cc.add(ColumnAction.readFromNBT(nbt2));
                }
                ret.effectMap[dy] = cc.toArray(new ColumnAction[cc.size()]);
            }
            return ret;
        }

        private void recalulateLevel(World world) {
            this.age = 0;
            int dy = this.sprinklerY;
            boolean flag = false;
            this.effectMap = new ColumnAction[256][];
            while (dy > 0 && this.sprinklerY - dy < 12 && !flag) {
                Block b = world.func_147439_a(this.xCoord, dy, this.zCoord);
                if (!b.isAir((IBlockAccess)world, this.xCoord, dy, this.zCoord)) {
                    String n;
                    boolean stopMoving = false;
                    if (b == Blocks.field_150480_ab) {
                        this.addEffectValue(dy, new ColumnAction(b, this.xCoord, dy, this.zCoord, Effects.FIREEXTINGUISH, false, false, false));
                        stopMoving = true;
                    } else if (b == Blocks.field_150458_ak) {
                        this.addEffectValue(dy, new ColumnAction(b, this.xCoord, dy, this.zCoord, Effects.HYDRATEFARMLAND, false, false, true));
                        stopMoving = true;
                    }
                    if (!stopMoving) {
                        ReikaCropHelper crop = ReikaCropHelper.getCrop((Block)b);
                        int meta = world.func_72805_g(this.xCoord, dy, this.zCoord);
                        if (crop == null) {
                            crop = ModCropList.getModCrop((Block)b, (int)meta);
                        }
                        if (crop != null) {
                            this.addEffectValue(dy, new ColumnAction(b, this.xCoord, dy, this.zCoord, Effects.CROPTICK, false, false, true));
                        } else {
                            ReikaPlantHelper p = ReikaPlantHelper.getPlant((Block)b);
                            if (p != null && p.grows()) {
                                this.addEffectValue(dy, new ColumnAction(b, this.xCoord, dy, this.zCoord, Effects.CROPTICK, false, p == ReikaPlantHelper.SUGARCANE, true));
                                stopMoving = p == ReikaPlantHelper.CACTUS || p == ReikaPlantHelper.SUGARCANE;
                            } else if (p == null && (b instanceof BlockSapling || ModWoodList.isModSapling((Block)b, (int)meta))) {
                                BlockTickEvent.fire((Block)b, (World)world, (int)this.xCoord, (int)dy, (int)this.zCoord, (Random)rand, (BlockTickEvent.UpdateFlags)BlockTickEvent.UpdateFlags.FORCED);
                                stopMoving = true;
                            }
                        }
                    }
                    if (!stopMoving && (b.func_149688_o() == Material.field_151584_j || b.func_149688_o() == Material.field_151585_k) && (n = b.getClass().getName().toLowerCase(Locale.ENGLISH)).startsWith("growthcraft.apples")) {
                        if (b.func_149688_o() == Material.field_151584_j && n.endsWith("leaves")) {
                            Block b2;
                            if (ModularLogger.instance.isEnabled(TileEntitySprinkler.LOGGER_ID)) {
                                ModularLogger.instance.log(TileEntitySprinkler.LOGGER_ID, "Found leaf @ " + this.xCoord + ", " + dy + ", " + this.zCoord);
                            }
                            if (TileEntitySprinkler.isOpaque(b2 = world.func_147439_a(this.xCoord, dy - 1, this.zCoord))) {
                                stopMoving = true;
                            } else if (b2.isAir((IBlockAccess)world, this.xCoord, dy - 1, this.zCoord)) {
                                this.addEffectValue(dy, new ColumnAction(b, this.xCoord, dy, this.zCoord, Effects.APPLETICK, true, false, true));
                                if (ModularLogger.instance.isEnabled(TileEntitySprinkler.LOGGER_ID)) {
                                    ModularLogger.instance.log(TileEntitySprinkler.LOGGER_ID, "Ticked apple leaf @ " + this.xCoord + ", " + dy + ", " + this.zCoord);
                                }
                                stopMoving = true;
                            }
                        } else if (b.func_149688_o() == Material.field_151585_k && n.endsWith("apple")) {
                            this.addEffectValue(dy, new ColumnAction(b, this.xCoord, dy, this.zCoord, Effects.APPLETICK, false, true, false));
                            stopMoving = true;
                            if (ModularLogger.instance.isEnabled(TileEntitySprinkler.LOGGER_ID)) {
                                ModularLogger.instance.log(TileEntitySprinkler.LOGGER_ID, "Ticked apple block @ " + this.xCoord + ", " + dy + ", " + this.zCoord);
                            }
                        }
                        if (ModularLogger.instance.isEnabled(TileEntitySprinkler.LOGGER_ID)) {
                            ModularLogger.instance.log(TileEntitySprinkler.LOGGER_ID, "Read GC block '" + n + "', flag2=" + stopMoving);
                        }
                    }
                    boolean bl = flag = TileEntitySprinkler.isOpaque(b) || stopMoving;
                }
                if (flag) continue;
                --dy;
            }
        }

        private void addEffectValue(int dy, ColumnAction ca) {
            ColumnAction[] set = this.effectMap[dy];
            int len = set == null ? 0 : set.length;
            ColumnAction[] ret = new ColumnAction[len + 1];
            if (set != null) {
                System.arraycopy(set, 0, ret, 0, len);
            }
            ret[ret.length - 1] = ca;
            this.effectMap[dy] = ret;
        }

        private boolean tick(World world, float chanceFactor) {
            boolean flag = this.age >= 20;
            for (int y = 0; y < this.effectMap.length; ++y) {
                ColumnAction[] map = this.effectMap[y];
                if (map == null) continue;
                Block b = world.func_147439_a(this.xCoord, y, this.zCoord);
                for (ColumnAction ca : map) {
                    if (ca.block == b) {
                        if (!ca.effect.doChance(rand, chanceFactor)) continue;
                        ca.effect.doEffect(world, this.xCoord, y, this.zCoord, b);
                        continue;
                    }
                    flag = true;
                }
            }
            return flag;
        }

        @SideOnly(value=Side.CLIENT)
        private void doParticles(World world) {
            for (int y = 0; y < this.effectMap.length; ++y) {
                ColumnAction[] map = this.effectMap[y];
                if (map == null) continue;
                for (ColumnAction ca : map) {
                    if (ca.doDripParticles && rand.nextInt(8) == 0) {
                        ReikaParticleHelper.DRIPWATER.spawnAt(world, (double)ca.xCoord + rand.nextDouble(), (double)ca.yCoord, (double)ca.zCoord + rand.nextDouble());
                    }
                    if (ca.doDripParticlesUp && rand.nextInt(8) == 0) {
                        ReikaParticleHelper.DRIPWATER.spawnAt(world, (double)ca.xCoord + rand.nextDouble(), (double)ca.yCoord + 0.9375, (double)ca.zCoord + rand.nextDouble());
                    }
                    if (!ca.doSplashParticles) continue;
                    int d = Math.max(1, 5 - ConfigRegistry.SPRINKLER.getValue());
                    if (rand.nextInt(d) != 0) continue;
                    ReikaParticleHelper.RAIN.spawnAt(world, (double)ca.xCoord + rand.nextDouble(), (double)(ca.yCoord + 1), (double)ca.zCoord + rand.nextDouble());
                }
            }
        }
    }

    private static class FieldCache {
        private final HashMap<Coordinate, FieldColumn> levels = new HashMap();
        private int dirtyRate;

        private FieldCache() {
        }

        private FieldColumn getOrFindLevel(World world, int dx, int dz, int y) {
            Coordinate c = new Coordinate(dx, 0, dz);
            FieldColumn f = this.levels.get(c);
            if (f == null || f.age >= 20) {
                if (f == null) {
                    f = new FieldColumn(dx, dz, y);
                    this.levels.put(c, f);
                }
            } else {
                f.age++;
            }
            return f;
        }

        private void clear() {
            this.levels.clear();
        }

        @SideOnly(value=Side.CLIENT)
        private void doParticles(World world) {
            for (FieldColumn f : this.levels.values()) {
                f.doParticles(world);
            }
        }

        private NBTTagList writeToNBT() {
            NBTTagList li = new NBTTagList();
            for (Coordinate c : this.levels.keySet()) {
                FieldColumn f = this.levels.get(c);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74782_a("location", (NBTBase)c.writeToTag());
                tag.func_74782_a("data", (NBTBase)f.writeToNBT());
                li.func_74742_a((NBTBase)tag);
            }
            return li;
        }

        private void readFromNBT(NBTTagList li) {
            this.clear();
            for (Object o : li.field_74747_a) {
                NBTTagCompound tag = (NBTTagCompound)o;
                Coordinate c = Coordinate.readFromNBT((String)"location", (NBTTagCompound)tag);
                FieldColumn f = FieldColumn.readFromNBT(tag.func_74775_l("data"));
                this.levels.put(c, f);
            }
        }

        private boolean tickDirty() {
            ++this.dirtyRate;
            if (this.dirtyRate >= 8) {
                this.dirtyRate = 0;
                return true;
            }
            return false;
        }
    }

    private static enum Effects {
        FIREEXTINGUISH(20),
        CROPTICK(80),
        HYDRATEFARMLAND(15),
        APPLETICK(40);

        private final int randomChance;
        private static final Effects[] list;

        private Effects(int c) {
            this.randomChance = c;
        }

        private boolean doChance(Random rand, float factor) {
            return rand.nextInt(Math.max(1, (int)((float)this.randomChance * factor))) == 0;
        }

        private void doEffect(World world, int x, int y, int z, Block b) {
            switch (this) {
                case APPLETICK: {
                    if (b.func_149688_o() == Material.field_151584_j) {
                        Block b2;
                        if (ModularLogger.instance.isEnabled(TileEntitySprinkler.LOGGER_ID)) {
                            ModularLogger.instance.log(TileEntitySprinkler.LOGGER_ID, "Found leaf @ " + x + ", " + y + ", " + z);
                        }
                        if (!(b2 = world.func_147439_a(x, y - 1, z)).isAir((IBlockAccess)world, x, y - 1, z)) break;
                        BlockTickEvent.fire((Block)b, (World)world, (int)x, (int)y, (int)z, (Random)rand, (int)BlockTickEvent.UpdateFlags.getForcedUnstoppableTick());
                        if (!ModularLogger.instance.isEnabled(TileEntitySprinkler.LOGGER_ID)) break;
                        ModularLogger.instance.log(TileEntitySprinkler.LOGGER_ID, "Ticked apple leaf @ " + x + ", " + y + ", " + z);
                        break;
                    }
                    if (b.func_149688_o() != Material.field_151585_k) break;
                    BlockTickEvent.fire((Block)b, (World)world, (int)x, (int)y, (int)z, (Random)rand, (int)BlockTickEvent.UpdateFlags.getForcedUnstoppableTick());
                    if (!ModularLogger.instance.isEnabled(TileEntitySprinkler.LOGGER_ID)) break;
                    ModularLogger.instance.log(TileEntitySprinkler.LOGGER_ID, "Ticked apple block @ " + x + ", " + y + ", " + z);
                    break;
                }
                case CROPTICK: {
                    ReikaCropHelper crop = ReikaCropHelper.getCrop((Block)b);
                    int meta = world.func_72805_g(x, y, z);
                    if (crop == null) {
                        crop = ModCropList.getModCrop((Block)b, (int)meta);
                    }
                    if (crop != null) {
                        BlockTickEvent.fire((Block)b, (World)world, (int)x, (int)y, (int)z, (Random)rand, (int)BlockTickEvent.UpdateFlags.getForcedUnstoppableTick());
                        break;
                    }
                    ReikaPlantHelper p = ReikaPlantHelper.getPlant((Block)b);
                    if (p != null && p.grows()) {
                        BlockTickEvent.fire((Block)b, (World)world, (int)x, (int)y, (int)z, (Random)rand, (int)BlockTickEvent.UpdateFlags.getForcedUnstoppableTick());
                        break;
                    }
                    if (p != null || !(b instanceof BlockSapling) && !ModWoodList.isModSapling((Block)b, (int)meta)) break;
                    BlockTickEvent.fire((Block)b, (World)world, (int)x, (int)y, (int)z, (Random)rand, (int)BlockTickEvent.UpdateFlags.getForcedUnstoppableTick());
                    break;
                }
                case FIREEXTINGUISH: {
                    world.func_72908_a((double)x, (double)y, (double)z, "random.fizz", 0.6f + 0.4f * rand.nextFloat(), 0.5f + 0.5f * rand.nextFloat());
                    world.func_147468_f(x, y, z);
                    break;
                }
                case HYDRATEFARMLAND: {
                    ReikaWorldHelper.hydrateFarmland((World)world, (int)x, (int)y, (int)z, (boolean)false);
                }
            }
        }

        static {
            list = Effects.values();
        }
    }
}

