/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.XPProducer;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ProcessingMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerLiquidReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityBigFurnace
extends InventoriedPowerLiquidReceiver
implements TemperatureTE,
XPProducer,
ProcessingMachine {
    public static final int HEIGHT = 2;
    public static final int WIDTH = 9;
    public static final int MAXTEMP = 1200;
    public static final int SMELT_TEMP = 400;
    private float xp;
    private int temperature;
    public int smeltTick;
    private StepTimer smelter = new StepTimer(200);
    private StepTimer tempTimer = new StepTimer(20);

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        this.tempTimer.update();
        if (this.tempTimer.checkCap()) {
            this.updateTemperature(world, x, y, z, meta);
        }
        this.smelter.setCap(this.getOperationTime());
        if (!this.field_145850_b.field_72995_K) {
            if (this.canSmelt()) {
                this.smelter.update();
                if (this.smelter.checkCap() && !this.field_145850_b.field_72995_K) {
                    this.smelt();
                }
            } else {
                this.smelter.reset();
            }
        }
        this.smeltTick = this.smelter.getTick();
    }

    public int getNumberInputSlots() {
        return 18;
    }

    private void smelt() {
        int n = this.getNumberInputSlots();
        for (int i = 0; i < n; ++i) {
            ItemStack to;
            ItemStack is = this.inv[i];
            if (is == null || (to = FurnaceRecipes.func_77602_a().func_151395_a(is)) == null) continue;
            boolean add = false;
            if (this.inv[i + n] == null) {
                this.inv[i + n] = to.func_77946_l();
                add = true;
            } else if (ReikaItemHelper.areStacksCombinable((ItemStack)to, (ItemStack)this.inv[i + n], (int)this.func_70297_j_())) {
                add = true;
                this.inv[i + n].field_77994_a += to.field_77994_a;
            }
            if (!add) continue;
            ReikaInventoryHelper.decrStack((int)i, (ItemStack[])this.inv);
        }
    }

    private boolean canSmelt() {
        if (this.temperature < 400) {
            return false;
        }
        if (this.power < this.MINPOWER) {
            return false;
        }
        int n = this.getNumberInputSlots();
        for (int i = 0; i < n; ++i) {
            ItemStack to;
            ItemStack is = this.inv[i];
            if (is == null || (to = FurnaceRecipes.func_77602_a().func_151395_a(is)) == null) continue;
            return true;
        }
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i >= this.getNumberInputSlots();
    }

    public int func_70302_i_() {
        return 36;
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (!this.tank.isEmpty()) {
            this.tank.removeLiquid(15);
            Fluid f = this.tank.getActualFluid();
            if (f.equals(FluidRegistry.LAVA)) {
                Tamb += 600;
            } else if (f.equals(FluidRegistry.getFluid((String)"pyrotheum"))) {
                Tamb += 1000;
            }
        }
        if (this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > Tamb * 2) {
            --this.temperature;
        }
        if (this.temperature < Tamb) {
            ++this.temperature;
        }
        if (this.temperature * 2 < Tamb) {
            ++this.temperature;
        }
        if (this.temperature > 1200) {
            this.temperature = 1200;
            this.overheat(world, x, y, z);
        }
        if (this.temperature > 100) {
            ForgeDirection side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150433_aE);
            if (side != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150350_a, (int)0);
            }
            if ((side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150358_i, (int)0);
            }
        }
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public int getThermalDamage() {
        return this.temperature / 200;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        return slot < this.getNumberInputSlots();
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.BIGFURNACE;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        if (f == null) {
            return false;
        }
        return f == FluidRegistry.LAVA || f == FluidRegistry.getFluid((String)"pyrotheum");
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from.offsetY == 0;
    }

    @Override
    public int getCapacity() {
        return 16000;
    }

    public void clearXP() {
        this.xp = 0.0f;
    }

    public float getXP() {
        return this.xp;
    }

    public int getCookScaled(int i) {
        return this.smeltTick * i / this.smelter.getCap();
    }

    public int getLavaScaled(int i) {
        return this.tank.getLevel() * i / this.tank.getCapacity();
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.temperature = NBT.func_74762_e("temp");
        this.xp = NBT.func_74760_g("xp");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("temp", this.temperature);
        NBT.func_74776_a("xp", this.xp);
    }

    @Override
    public int getOperationTime() {
        int base = this.temperature >= 600 ? 150 : 200;
        return this.temperature >= 1000 ? base / 2 : base;
    }

    @Override
    public boolean areConditionsMet() {
        return this.canSmelt();
    }

    @Override
    public String getOperationalStatus() {
        if (this.temperature < 400) {
            return "Insufficient Temperature";
        }
        return this.areConditionsMet() ? "Operational" : "No Smeltable Items";
    }

    @Override
    public boolean canBeCooledWithFins() {
        return false;
    }

    @Override
    public boolean allowHeatExtraction() {
        return false;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public int getMaxTemperature() {
        return 1200;
    }

    public boolean hasWork() {
        return this.areConditionsMet();
    }
}

