/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Base.OneSlotMachine;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.MagnetizationCore;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipesMagnetizer;
import Reika.RotaryCraft.Auxiliary.RedstoneCycleTracker;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Items.Tools.ItemEngineUpgrade;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityMagnetizer
extends InventoriedPowerReceiver
implements OneSlotMachine,
DiscreteFunction,
ConditionalOperation,
MagnetizationCore {
    public static final int MIN_DURATION = 2;
    private final RedstoneCycleTracker redstone = new RedstoneCycleTracker(3);
    private boolean hasLodestone = false;

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return j == 0;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.MAGNETIZER;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        RecipesMagnetizer.MagnetizerRecipe r;
        super.updateTileEntity();
        this.getIOSidesDefault(world, x, y, z, meta);
        this.getPower(false);
        if (this.power < this.MINPOWER) {
            this.tickcount = 0;
            return;
        }
        if (this.omega < this.MINSPEED) {
            this.tickcount = 0;
            return;
        }
        this.redstone.update(world, x, y, z);
        if (!this.redstone.isAlternating()) {
            return;
        }
        ++this.tickcount;
        if (this.tickcount < this.getOperationTime()) {
            return;
        }
        this.tickcount = 0;
        if (this.inv[0] != null && (r = RecipesMagnetizer.getRecipes().getRecipe(this.inv[0])) != null && this.canRunRecipe(r)) {
            this.magnetize(r);
        }
    }

    private boolean hasRecipe() {
        return this.inv[0] != null && RecipesMagnetizer.getRecipes().getRecipe(this.inv[0]) != null;
    }

    private boolean canRunRecipe(RecipesMagnetizer.MagnetizerRecipe r) {
        int ms = r.minSpeed;
        if (this.hasLodestoneUpgrade()) {
            ms /= 2;
        }
        return this.omega >= ms && (r.allowStacking || this.inv[0].field_77994_a == 1);
    }

    private void magnetize(RecipesMagnetizer.MagnetizerRecipe r) {
        if (rand.nextInt(r.timeFactor) > 0) {
            return;
        }
        ItemStack is = this.inv[0];
        if (r.action != null) {
            r.action.step(this.hasLodestoneUpgrade() ? this.omega * 2 : this.omega, this.inv[0]);
        } else if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
            is.field_77990_d.func_74768_a("magnet", 1);
        } else if (is.field_77990_d.func_74764_b("magnet")) {
            int m = is.field_77990_d.func_74762_e("magnet");
            if (m < this.getMaxCharge(r)) {
                ++m;
            }
            is.field_77990_d.func_74768_a("magnet", m);
        } else {
            is.field_77990_d.func_74768_a("magnet", 1);
        }
    }

    private int getMaxCharge(RecipesMagnetizer.MagnetizerRecipe r) {
        return this.omega / r.speedPeruT;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        RecipesMagnetizer.MagnetizerRecipe rec = RecipesMagnetizer.getRecipes().getRecipe(is);
        return rec != null && (this.inv[0] == null && is.field_77994_a == 1 || rec.allowStacking);
    }

    public int getRedstoneOverride() {
        if (!this.hasRecipe()) {
            return 15;
        }
        return 0;
    }

    @Override
    public int getOperationTime() {
        int base = DurationRegistry.MAGNETIZER.getOperationTime(this.omega);
        return Math.max(2, this.hasLodestoneUpgrade() ? base / 2 : base);
    }

    @Override
    public boolean areConditionsMet() {
        return this.hasRecipe();
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Shaft Core";
    }

    @Override
    public int getCoreMagnetization() {
        return this.inv[0] != null && this.inv[0].field_77990_d != null ? this.inv[0].field_77990_d.func_74762_e("magnet") : 0;
    }

    @Override
    public void addRedstoneUpgrade() {
        this.redstone.addIntegrated();
    }

    @Override
    public boolean hasRedstoneUpgrade() {
        return this.redstone.hasIntegrated();
    }

    public void addLodestoneUpgrade() {
        this.hasLodestone = true;
    }

    public boolean hasLodestoneUpgrade() {
        return this.hasLodestone;
    }

    @Override
    public void upgrade(ItemStack is) {
        switch (ItemEngineUpgrade.Upgrades.list[is.func_77960_j()]) {
            case REDSTONE: {
                this.addRedstoneUpgrade();
                break;
            }
            case LODESTONE: {
                this.addLodestoneUpgrade();
                break;
            }
        }
    }

    @Override
    public boolean canUpgradeWith(ItemStack item) {
        if (ItemRegistry.UPGRADE.matchItem(item)) {
            switch (ItemEngineUpgrade.Upgrades.list[item.func_77960_j()]) {
                case REDSTONE: {
                    return !this.hasRedstoneUpgrade();
                }
                case LODESTONE: {
                    return !this.hasLodestoneUpgrade();
                }
            }
            return false;
        }
        return false;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("redstoneUpgrade", this.redstone.hasIntegrated());
        NBT.func_74757_a("lodestoneUpgrade", this.hasLodestone);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.redstone.reset();
        if (NBT.func_74767_n("redstoneUpgrade")) {
            this.redstone.addIntegrated();
        }
        this.hasLodestone = NBT.func_74767_n("lodestoneUpgrade");
    }

    public void breakBlock() {
        if (this.hasRedstoneUpgrade()) {
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)ItemRegistry.UPGRADE.getStackOfMetadata(ItemEngineUpgrade.Upgrades.REDSTONE.ordinal()));
        }
        if (this.hasLodestoneUpgrade()) {
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)ItemRegistry.UPGRADE.getStackOfMetadata(ItemEngineUpgrade.Upgrades.LODESTONE.ordinal()));
        }
    }

    public boolean hasCore() {
        return ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)ItemStacks.shaftcore) || ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)ItemStacks.tungstenshaftcore);
    }
}

