/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Production;

import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.Interpolation;
import Reika.DragonAPI.Instantiable.Math.MovingAverage;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiOperational;
import Reika.RotaryCraft.Auxiliary.Interfaces.PressureTE;
import Reika.RotaryCraft.Auxiliary.Interfaces.ProcessingMachine;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPoweredLiquidIO;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.RotaryCraft;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityFractionator
extends InventoriedPoweredLiquidIO
implements MultiOperational,
ProcessingMachine,
PressureTE {
    public int mixTime;
    private int pressure;
    public static final int CAPACITY = 240000;
    public static final int MINTIME = 10;
    public static int MAXPRESSURE = 1000;
    public boolean idle = false;
    private static final HashMap<KeyedItemStack, Float> ingredients = new HashMap();
    private static final Interpolation yield = new Interpolation(false);
    private MovingAverage torqueInput = new MovingAverage(20);

    private static KeyedItemStack key(Item i) {
        return TileEntityFractionator.key(new ItemStack(i));
    }

    private static KeyedItemStack key(ItemStack is) {
        return new KeyedItemStack(is).setSimpleHash(true).setIgnoreMetadata(!is.func_77981_g());
    }

    public static boolean isJetFuelIngredient(ItemStack is) {
        return ingredients.containsKey(TileEntityFractionator.key(is));
    }

    public static Collection<KeyedItemStack> getIngredients() {
        return Collections.unmodifiableCollection(ingredients.keySet());
    }

    public void testIdle() {
        this.idle = !this.hasAllIngredients();
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public int getFuelScaled(int par1) {
        return this.output.getLevel() * par1 / this.getOutputCapacity();
    }

    public int getEthanolScaled(int par1) {
        return this.input.getLevel() * par1 / this.getInputCapacity();
    }

    public int getPressureScaled(int par1) {
        return this.pressure * par1 / MAXPRESSURE;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        this.power = (long)this.omega * (long)this.torque;
        this.torqueInput.addValue((double)this.torque);
        if (!world.field_72995_K && this.getTicksExisted() % 20 == 0) {
            this.updatePressure(world, x, y, z, meta);
        }
        this.testIdle();
        if (this.power < this.MINPOWER || this.omega < this.MINSPEED) {
            this.mixTime = 0;
            return;
        }
        int n = this.getNumberConsecutiveOperations();
        for (int i = 0; i < n; ++i) {
            this.doOperation(n > 1);
        }
    }

    @Override
    public void updatePressure(World world, int x, int y, int z, int meta) {
        int local = this.pressure;
        double Pamb = ReikaWorldHelper.getAmbientPressureAt((World)world, (int)x, (int)y, (int)z, (boolean)false);
        if (Pamb > 101.3) {
            Pamb = 101.3 + 0.02 * (Pamb - 101.3);
        }
        int dp = local - (int)Pamb;
        int sub = (int)(Math.signum(dp) * (float)Math.max(1, Math.abs(dp / 16)));
        int avg = (int)this.torqueInput.getAverage();
        if (avg <= 0) {
            sub *= 8;
        }
        local -= sub;
        if (avg > 0) {
            local = (int)((double)local + 1.8 * Math.sqrt(avg));
        }
        if (local > MAXPRESSURE) {
            this.overpressure(world, x, y, z);
            local = MAXPRESSURE;
        }
        this.pressure = this.pressure < local ? (this.pressure += Math.max(1, Math.min(ReikaRandomHelper.getRandomPlusMinus((int)6, (int)13), (local - this.pressure) / 4))) : local;
    }

    private void doOperation(boolean multiple) {
        if (this.process()) {
            ++this.mixTime;
            if (multiple || this.mixTime >= this.getOperationTime()) {
                this.mixTime = 0;
                this.make();
            }
        } else {
            this.mixTime = 0;
        }
    }

    private void make() {
        RotaryAchievements.JETFUEL.triggerAchievement(this.getPlacer());
        if (!this.field_145850_b.field_72995_K) {
            float consume = (float)ingredients.size() * DifficultyEffects.CONSUMEFRAC.getChance();
            WeightedRandom wr = new WeightedRandom();
            for (int i = 0; i < ingredients.size(); ++i) {
                ItemStack is = this.inv[i];
                KeyedItemStack ks = TileEntityFractionator.key(is);
                float wt = ingredients.get(ks).floatValue();
                wr.addEntry((Object)i, (double)wt);
            }
            while (consume > 0.0f) {
                int slot = (Integer)wr.getRandomEntry();
                if (consume >= 1.0f || ReikaRandomHelper.doWithChance((double)consume)) {
                    ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
                }
                wr.remove((Object)slot);
                consume -= 1.0f;
            }
        }
        float amt = 1000.0f * DifficultyEffects.CONSUMEFRAC.getChance();
        this.input.removeLiquid((int)amt);
        this.output.addLiquid((int)(this.getYieldRatio() * (float)DifficultyEffects.PRODUCEFRAC.getInt()), FluidRegistry.getFluid((String)"rc jet fuel"));
    }

    public float getYieldRatio() {
        return (float)yield.getValue((double)this.pressure);
    }

    private boolean process() {
        if (this.output.getLevel() + DifficultyEffects.PRODUCEFRAC.getMaxAmount() >= 240000) {
            return false;
        }
        if (this.inv[ingredients.size()] == null) {
            return false;
        }
        if (this.inv[ingredients.size()].func_77973_b() != Items.field_151073_bk) {
            return false;
        }
        return this.hasAllIngredients();
    }

    private boolean hasAllIngredients() {
        HashSet<KeyedItemStack> check = new HashSet<KeyedItemStack>(ingredients.keySet());
        for (int i = 0; i < ingredients.size(); ++i) {
            if (this.inv[i] == null) {
                return false;
            }
            KeyedItemStack ks = TileEntityFractionator.key(this.inv[i]);
            if (!check.contains(ks)) {
                return false;
            }
            check.remove(ks);
        }
        return (float)this.input.getLevel() >= 1000.0f * DifficultyEffects.CONSUMEFRAC.getChance();
    }

    public int func_70302_i_() {
        return ingredients.size() + 1 + 1;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("mix", this.mixTime);
        NBT.func_74768_a("press", this.pressure);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.mixTime = NBT.func_74762_e("mix");
        this.pressure = NBT.func_74762_e("press");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBTTagCompound tag = new NBTTagCompound();
        this.torqueInput.writeToNBT(tag);
        NBT.func_74782_a("torquevals", (NBTBase)tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        if (NBT.func_74764_b("torquevals")) {
            this.torqueInput = MovingAverage.readFromNBT((NBTTagCompound)NBT.func_74775_l("torquevals"));
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.FRACTIONATOR;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        if (slot == ingredients.size() + 1) {
            return is.func_77973_b() == Items.field_151133_ar;
        }
        if (slot == ingredients.size()) {
            return is.func_77973_b() == Items.field_151073_bk;
        }
        if (!TileEntityFractionator.isJetFuelIngredient(is)) {
            return false;
        }
        HashSet slots = ReikaInventoryHelper.getSlotsBetweenWithItemStack((ItemStack)is, (IInventory)this, (int)0, (int)(ingredients.size() - 1), (boolean)false);
        return slots.isEmpty() || slots.contains(slot);
    }

    public int getRedstoneOverride() {
        return (int)((double)this.getYieldRatio() / yield.getFinalValue() * 15.0);
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.FUELLINE || m == MachineRegistry.BEDPIPE;
    }

    public int getFuelLevel() {
        return this.output.getLevel();
    }

    @Override
    public boolean canOutputTo(ForgeDirection to) {
        return to == ForgeDirection.UP;
    }

    @Override
    public int getInputCapacity() {
        return 16000;
    }

    @Override
    public int getCapacity() {
        return 240000;
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.FRACTIONATOR.getOperationTime(this.omega);
    }

    @Override
    public int getNumberConsecutiveOperations() {
        return DurationRegistry.FRACTIONATOR.getNumberOperations(this.omega);
    }

    @Override
    public boolean areConditionsMet() {
        int nslots = ReikaInventoryHelper.countEmptySlots((ItemStack[])this.inv);
        return nslots == 0 || nslots == 1 && this.inv[7] == null;
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "Missing Ingredients";
    }

    @Override
    public int getPressure() {
        return this.pressure;
    }

    @Override
    public int getMaxPressure() {
        return MAXPRESSURE;
    }

    @Override
    public void addPressure(int press) {
        this.pressure += press;
    }

    @Override
    public void overpressure(World world, int x, int y, int z) {
    }

    @Override
    public Fluid getInputFluid() {
        return RotaryCraft.ethanolFluid;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from.offsetY == 0;
    }

    @Override
    public boolean canIntakeFromPipe(MachineRegistry p) {
        return this.canOutputToPipe(p);
    }

    @Override
    public boolean canOutputToPipe(MachineRegistry p) {
        return p == MachineRegistry.FUELLINE || p == MachineRegistry.BEDPIPE;
    }

    public boolean hasWork() {
        return this.areConditionsMet();
    }

    static {
        ingredients.put(TileEntityFractionator.key(Items.field_151065_br), Float.valueOf(1.5f));
        ingredients.put(TileEntityFractionator.key(ItemStacks.coaldust), Float.valueOf(1.0f));
        ingredients.put(TileEntityFractionator.key(Items.field_151064_bs), Float.valueOf(0.75f));
        ingredients.put(TileEntityFractionator.key(ReikaItemHelper.pinkDye), Float.valueOf(0.5f));
        ingredients.put(TileEntityFractionator.key(ItemStacks.netherrackdust), Float.valueOf(2.0f));
        ingredients.put(TileEntityFractionator.key(ItemStacks.tar), Float.valueOf(1.5f));
        yield.addPoint(0.0, 0.01);
        yield.addPoint(100.0, 0.05);
        yield.addPoint(180.0, 0.1);
        yield.addPoint(500.0, 0.4);
        yield.addPoint(720.0, 1.0);
        yield.addPoint(850.0, 1.5);
        yield.addPoint(1000.0, 2.5);
    }
}

