/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import appeng.api.implementations.ICraftingPatternItem;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TileEntityBlower
extends TileEntityPowerReceiver {
    private ForgeDirection facing;
    public ItemStack[] matchingItems = new ItemStack[18];
    public boolean isWhitelist = false;
    public boolean useOreDict = true;
    public boolean checkMeta = false;
    public boolean checkNBT = false;
    private static Method getPatterns;
    private static Field dualityField;

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.BLOWER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.getIOSides(world, x, y, z, meta);
        this.getSummativeSidedPower();
        if (this.MINPOWER > this.power || this.MINSPEED > this.omega) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        ForgeDirection dir = this.getFacingDir();
        ForgeDirection from = dir.getOpposite();
        TileEntity source = this.getAdjacentTileEntity(from);
        if (source instanceof IInventory) {
            TileEntity target = this.getAdjacentTileEntity(dir);
            if (target instanceof WorldRift) {
                target = this.getRelayedTarget(target, dir);
            }
            if (target != null) {
                WorldLocation tg = new WorldLocation(target);
                ArrayList<TileEntity> li = new ArrayList<TileEntity>();
                while (target instanceof TileEntityBlower) {
                    TileEntityBlower te = (TileEntityBlower)target;
                    dir = te.getFacingDir();
                    target = te.getAdjacentTileEntity(dir);
                    tg = tg.move(dir, 1);
                    if (target instanceof WorldRift) {
                        target = this.getRelayedTarget(target, dir);
                        tg = new WorldLocation(target);
                    }
                    if (li.contains(target)) {
                        return;
                    }
                    li.add(target);
                    if (this.equals(target)) {
                        return;
                    }
                    if (!source.equals(target)) continue;
                    return;
                }
                InventoryType src = this.getTypeForInventory(source);
                if (target instanceof IInventory) {
                    InventoryType tgt = this.getTypeForInventory(target);
                    if (!this.tryPatternInsertion((IInventory)source, target)) {
                        this.transferItems(source, target, src, tgt, from, dir);
                    }
                } else if (target == null && ConfigRegistry.BLOWERSPILL.getState() && tg.isEmpty()) {
                    this.dumpItems(source, src, tg, from);
                }
            }
        }
    }

    private TileEntity getRelayedTarget(TileEntity te, ForgeDirection dir) {
        WorldRift wr = (WorldRift)te;
        TileEntity te2 = wr.getTileEntityFrom(dir);
        return te2 != null ? te2 : te;
    }

    private boolean tryPatternInsertion(IInventory source, TileEntity target) {
        if (InterfaceCache.MEINTERFACE.instanceOf((Object)target)) {
            for (int i = 0; i < source.func_70302_i_(); ++i) {
                ItemStack is = source.func_70301_a(i);
                if (is == null || !(is.func_77973_b() instanceof ICraftingPatternItem)) continue;
                try {
                    IInventory patterns = TileEntityBlower.getPatterns(target);
                    if (!ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)patterns)) continue;
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public static IInventory getPatterns(TileEntity target) throws Exception {
        return (IInventory)getPatterns.invoke(dualityField.get(target), new Object[0]);
    }

    private void printTEs(TileEntity source, TileEntity target) {
        if (source == null && target == null) {
            ReikaJavaLibrary.pConsole((Object)"null >> null", (Side)Side.SERVER);
        } else if (source == null) {
            ReikaJavaLibrary.pConsole((Object)("null >> " + target.getClass().getSimpleName()), (Side)Side.SERVER);
        } else if (target == null) {
            ReikaJavaLibrary.pConsole((Object)(source.getClass().getSimpleName() + " >> null"), (Side)Side.SERVER);
        } else {
            ReikaJavaLibrary.pConsole((Object)(source.getClass().getSimpleName() + " >> " + target.getClass().getSimpleName()), (Side)Side.SERVER);
        }
    }

    private int getNumberTransferrableItems() {
        return (int)(this.power / 1024L);
    }

    private void transferItems(TileEntity source, TileEntity target, InventoryType src, InventoryType tgt, ForgeDirection from, ForgeDirection dir) {
        int max = this.getNumberTransferrableItems();
        if (max <= 0) {
            return;
        }
        if (src == InventoryType.DSU) {
            IDeepStorageUnit dsu = (IDeepStorageUnit)source;
            ItemStack is = dsu.getStoredItemType();
            if (is != null && this.isItemTransferrable(is)) {
                int has = src.removeItem(source, max, -1, false);
                int added = tgt.insertItem(target, is, has, dir);
                src.removeItem(source, added, -1, true);
            }
        } else {
            HashMap<Integer, ItemStack> map = src.getMovableSlots(from, source);
            for (int slot : map.keySet()) {
                ItemStack is = map.get(slot);
                if (max <= 0 || !this.isItemTransferrable(is)) continue;
                int has = src.removeItem(source, max, slot, false);
                int added = tgt.insertItem(target, is, has, dir);
                src.removeItem(source, added, slot, true);
                max -= added;
            }
        }
    }

    private void dumpItems(TileEntity source, InventoryType src, WorldLocation loc, ForgeDirection from) {
        int max = this.getNumberTransferrableItems();
        if (max <= 0) {
            return;
        }
        if (src == InventoryType.DSU) {
            IDeepStorageUnit dsu = (IDeepStorageUnit)source;
            ItemStack is = dsu.getStoredItemType();
            if (is != null && this.isItemTransferrable(is)) {
                int has = src.removeItem(source, max, -1, true);
                this.dropItem(is, has, loc);
            }
        } else {
            HashMap<Integer, ItemStack> map = src.getMovableSlots(from, source);
            for (int slot : map.keySet()) {
                ItemStack is = map.get(slot);
                if (max <= 0 || !this.isItemTransferrable(is)) continue;
                int has = src.removeItem(source, max, slot, true);
                this.dropItem(is, has, loc);
                max -= has;
            }
        }
    }

    private void dropItem(ItemStack is, int amt, WorldLocation loc) {
        for (int i = 0; i < amt; ++i) {
            loc.dropItem(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)1), 2.0 + rand.nextDouble() * 4.0);
        }
    }

    private InventoryType getTypeForInventory(TileEntity te) {
        for (InventoryType t : InventoryType.values()) {
            if (!t.isValid(te)) continue;
            return t;
        }
        return null;
    }

    public boolean isIntake() {
        return this.getAdjacentTileEntity(this.getFacingDir().getOpposite()) instanceof IInventory;
    }

    private void getIOSides(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 4: {
                this.facing = ForgeDirection.DOWN;
                break;
            }
            case 5: {
                this.facing = ForgeDirection.UP;
                break;
            }
            case 3: {
                this.facing = ForgeDirection.NORTH;
                break;
            }
            case 1: {
                this.facing = ForgeDirection.WEST;
                break;
            }
            case 2: {
                this.facing = ForgeDirection.SOUTH;
                break;
            }
            case 0: {
                this.facing = ForgeDirection.EAST;
            }
        }
    }

    public ForgeDirection getFacingDir() {
        return this.facing != null ? this.facing : ForgeDirection.UP;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("ore", this.useOreDict);
        NBT.func_74757_a("metac", this.checkMeta);
        NBT.func_74757_a("cnbt", this.checkNBT);
        NBT.func_74757_a("white", this.isWhitelist);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.matchingItems.length; ++i) {
            if (this.matchingItems[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.matchingItems[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        NBT.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.isWhitelist = NBT.func_74767_n("white");
        this.checkMeta = NBT.func_74767_n("metac");
        this.checkNBT = NBT.func_74767_n("cnbt");
        this.useOreDict = NBT.func_74767_n("ore");
        NBTTagList nbttaglist = NBT.func_150295_c("Items", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        this.matchingItems = new ItemStack[18];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.matchingItems.length) continue;
            this.matchingItems[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
    }

    public boolean isItemTransferrable(ItemStack is) {
        boolean match = this.isItemStackMatched(is);
        return this.isWhitelist ? match : !match;
    }

    private boolean isItemStackMatched(ItemStack is) {
        for (int i = 0; i < this.matchingItems.length; ++i) {
            ItemStack is1 = this.matchingItems[i];
            if (is1 == null || !this.doStacksMatch(is, is1)) continue;
            return true;
        }
        return false;
    }

    private boolean doStacksMatch(ItemStack is, ItemStack is1) {
        int oreID;
        if (this.checkMeta && is.func_77960_j() != is1.func_77960_j()) {
            return false;
        }
        if (this.checkNBT && !ItemStack.func_77970_a((ItemStack)is, (ItemStack)is1)) {
            return false;
        }
        if (ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)is1)) {
            return true;
        }
        if (this.useOreDict && (oreID = OreDictionary.getOreID((ItemStack)is)) > -1 && oreID == OreDictionary.getOreID((ItemStack)is1)) {
            return true;
        }
        return is.func_77973_b() == is1.func_77973_b();
    }

    @Override
    public int getTextureStateForSide(int s) {
        TileEntity source = this.getAdjacentTileEntity(this.getFacingDir().getOpposite());
        if (source instanceof TileEntityBlower) {
            TileEntityBlower te = (TileEntityBlower)source;
            return te.getFacingDir() != this.getFacingDir() ? 0 : 1;
        }
        return 0;
    }

    static {
        if (ModList.APPENG.isLoaded()) {
            try {
                Class c = Class.forName("appeng.helpers.DualityInterface");
                getPatterns = c.getDeclaredMethod("getPatterns", new Class[0]);
                getPatterns.setAccessible(true);
                c = InterfaceCache.MEINTERFACE.getClassType();
                dualityField = c.getDeclaredField("duality");
                dualityField.setAccessible(true);
            }
            catch (Exception e) {
                RotaryCraft.logger.logError((Object)"Could not add Item Pump AE pattern interfacing!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.APPENG, e);
            }
        }
    }

    public static enum InventoryType {
        CHEST,
        DSU;


        public boolean isValid(TileEntity te) {
            switch (this) {
                case CHEST: {
                    return te instanceof IInventory && !DSU.isValid(te);
                }
                case DSU: {
                    return InterfaceCache.DSU.instanceOf((Object)te);
                }
            }
            return false;
        }

        public HashMap<Integer, ItemStack> getMovableSlots(ForgeDirection dir, TileEntity te) {
            switch (this) {
                case CHEST: {
                    return ReikaInventoryHelper.getLocatedTransferrables((ForgeDirection)dir, (IInventory)((IInventory)te));
                }
                case DSU: {
                    return null;
                }
            }
            return null;
        }

        public int removeItem(TileEntity te, int amt, int slot, boolean remove) {
            switch (this) {
                case CHEST: {
                    IInventory ii = (IInventory)te;
                    int items = 0;
                    if (remove) {
                        boolean flag = true;
                        while (flag && amt > 0) {
                            ReikaInventoryHelper.decrStack((int)slot, (IInventory)ii, (int)1);
                            --amt;
                            flag = ii.func_70301_a(slot) != null;
                            ++items;
                        }
                        return items;
                    }
                    return ii.func_70301_a(slot) != null ? Math.min(ii.func_70301_a((int)slot).field_77994_a, amt) : 0;
                }
                case DSU: {
                    IDeepStorageUnit dsu = (IDeepStorageUnit)te;
                    int has = dsu.getStoredItemType().field_77994_a;
                    int rem = Math.min(amt, has);
                    if (remove) {
                        dsu.setStoredItemCount(has - rem);
                    }
                    return rem;
                }
            }
            return 0;
        }

        public int insertItem(TileEntity te, ItemStack is, int amt, ForgeDirection dir) {
            switch (this) {
                case CHEST: {
                    IInventory ii = (IInventory)te;
                    int items = 0;
                    boolean flag = true;
                    is = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)1);
                    while (flag && amt > 0) {
                        if (this.addToIInv(is, ii, dir)) {
                            --amt;
                            ++items;
                            continue;
                        }
                        flag = false;
                    }
                    return items;
                }
                case DSU: {
                    IDeepStorageUnit dsu = (IDeepStorageUnit)te;
                    int has = dsu.getStoredItemType().field_77994_a;
                    int space = dsu.getMaxStoredCount() - has;
                    int add = Math.min(amt, space);
                    dsu.setStoredItemCount(has + add);
                    return add;
                }
            }
            return 0;
        }

        private boolean addToIInv(ItemStack is, IInventory ii, ForgeDirection dir) {
            if (ii instanceof ISidedInventory) {
                for (int k = 0; k < ii.func_70302_i_(); ++k) {
                    if (!((ISidedInventory)ii).func_102007_a(k, is, dir.getOpposite().ordinal()) || !ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)ii)) continue;
                    return true;
                }
            } else if (ReikaInventoryHelper.addToIInv((ItemStack)is, (IInventory)ii)) {
                return true;
            }
            return false;
        }
    }
}

