/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Transmission;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.Connectable;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.Interfaces.TransmissionReceiver;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBeltHub
extends TileEntityPowerReceiver
implements PowerGenerator,
SimpleProvider,
TransmissionReceiver,
Connectable<Coordinate> {
    public boolean isEmitting;
    private int wetTimer = 0;
    private boolean isSlippingTorque;
    private boolean isSlippingOmega;
    private Coordinate otherEnd = null;
    private StepTimer sound = new StepTimer(26);

    public boolean isSplitting() {
        return this.func_145832_p() >= 6;
    }

    public final void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSidesDefault(world, x, y, z, meta % 6);
        this.sound.update();
        if (this.isEmitting) {
            this.write = this.read;
            this.write2 = this.isSplitting() ? this.read.getOpposite() : null;
            this.read = null;
            this.copyPower();
        } else {
            this.write = this.isSplitting() ? this.read.getOpposite() : null;
            this.getPower(false);
            if (this.isSplitting()) {
                this.power /= 2L;
                this.torque /= 2;
            }
        }
        if (this.power > 0L) {
            this.playSound(world, x, y, z);
        }
        if (world.func_72896_J() && world.func_72951_B(x, y + 1, z) && world.func_82737_E() % 1024L == 0L) {
            this.makeWet();
        }
        if (this.wetTimer > 0 && this.power > 0L) {
            --this.wetTimer;
        }
    }

    private void playSound(World world, int x, int y, int z) {
        if (this.sound.checkCap()) {
            SoundRegistry.BELT.playSoundAtBlock(world, x, y, z, 0.6f, 1.0f);
        }
    }

    public final boolean areInSamePlane(TileEntityBeltHub belt) {
        int meta = this.func_145832_p() % 6;
        int meta2 = belt.func_145832_p() % 6;
        if (meta == 0 || meta == 1) {
            return meta2 == 0 || meta2 == 1;
        }
        if (meta == 2 || meta == 3) {
            return meta2 == 2 || meta2 == 3;
        }
        if (meta == 4 || meta == 5) {
            return meta2 == 4 || meta2 == 5;
        }
        return false;
    }

    public final void reset() {
        this.otherEnd = null;
    }

    public final void resetOther() {
        if (this.otherEnd == null) {
            return;
        }
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)this.field_145850_b, this.otherEnd.xCoord, this.otherEnd.yCoord, this.otherEnd.zCoord);
        if (m == this.getMachine()) {
            TileEntityBeltHub te = (TileEntityBeltHub)this.otherEnd.getTileEntity((IBlockAccess)this.field_145850_b);
            te.reset();
        }
    }

    private final boolean canConnect(World world, int x, int y, int z) {
        int dx = x - this.field_145851_c;
        int dy = y - this.field_145848_d;
        int dz = z - this.field_145849_e;
        boolean[] blArray = new boolean[3];
        blArray[0] = dx != 0;
        blArray[1] = dy != 0;
        boolean bl = blArray[2] = dz != 0;
        if (!ReikaMathLibrary.nBoolsAreTrue((int)1, (boolean[])blArray)) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.UNKNOWN;
        if (dx > 0) {
            dir = ForgeDirection.EAST;
        }
        if (dx < 0) {
            dir = ForgeDirection.WEST;
        }
        if (dy > 0) {
            dir = ForgeDirection.UP;
        }
        if (dy < 0) {
            dir = ForgeDirection.DOWN;
        }
        if (dz > 0) {
            dir = ForgeDirection.SOUTH;
        }
        if (dz < 0) {
            dir = ForgeDirection.NORTH;
        }
        if (dir == null) {
            return false;
        }
        if (!this.isValidDirection(dir)) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityBeltHub) {
            TileEntityBeltHub tb = (TileEntityBeltHub)te;
            if (tb.isEmitting == this.isEmitting) {
                return false;
            }
            if (!this.areInSamePlane(tb)) {
                return false;
            }
            for (int i = 1; i < Math.abs(dx + dy + dz); ++i) {
                int xi = this.field_145851_c + dir.offsetX * i;
                int yi = this.field_145848_d + dir.offsetY * i;
                int zi = this.field_145849_e + dir.offsetZ * i;
                if (ReikaWorldHelper.softBlocks((IBlockAccess)this.field_145850_b, (int)xi, (int)yi, (int)zi)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean hasValidConnection() {
        if (this.otherEnd == null) {
            return false;
        }
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)this.field_145850_b, this.otherEnd.xCoord, this.otherEnd.yCoord, this.otherEnd.zCoord);
        return m == this.getMachine() && this.canConnect(this.field_145850_b, this.otherEnd.xCoord, this.otherEnd.yCoord, this.otherEnd.zCoord);
    }

    public final boolean tryConnect(World world, int x, int y, int z) {
        if (this.otherEnd != null) {
            return false;
        }
        if (x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e) {
            return false;
        }
        if (!this.canConnect(world, x, y, z)) {
            return false;
        }
        this.otherEnd = new Coordinate(x, y, z);
        return true;
    }

    public int getMaxTorque() {
        return 8192;
    }

    public int getMaxSmoothSpeed() {
        return 8192;
    }

    public int getTorque(int input) {
        int max = this.isWet() ? this.getMaxTorque() / 4 : this.getMaxTorque();
        this.isSlippingTorque = input > max;
        int torque = Math.min(input, max);
        return this.isSplitting() ? torque / 2 : torque;
    }

    public int getOmega(int input) {
        int s = this.isWet() ? this.getMaxSmoothSpeed() / 4 : this.getMaxSmoothSpeed();
        this.isSlippingOmega = input > s;
        int speed = input <= s ? input : (int)((double)s + Math.sqrt(input - s));
        return speed;
    }

    private void copyPower() {
        if (this.hasValidConnection()) {
            TileEntityBeltHub tile = (TileEntityBeltHub)this.otherEnd.getTileEntity((IBlockAccess)this.field_145850_b);
            this.omega = this.getOmega(tile.omega);
            this.torque = this.getTorque(tile.torque);
            this.power = (long)this.omega * (long)this.torque;
        } else {
            if (this.omega > 0) {
                this.omega = (int)((double)this.omega * 0.98);
            } else {
                this.torque = 0;
            }
            this.power = (long)this.omega * (long)this.torque;
        }
    }

    public final ForgeDirection getBeltDirection() {
        if (this.otherEnd == null) {
            return ForgeDirection.UNKNOWN;
        }
        int dx = 0;
        int dy = 0;
        int dz = 0;
        dx = this.field_145851_c - this.otherEnd.xCoord;
        dy = this.field_145848_d - this.otherEnd.yCoord;
        dz = this.field_145849_e - this.otherEnd.zCoord;
        ForgeDirection dir = ForgeDirection.UNKNOWN;
        if (dx < 0) {
            dir = ForgeDirection.EAST;
        }
        if (dx > 0) {
            dir = ForgeDirection.WEST;
        }
        if (dy < 0) {
            dir = ForgeDirection.UP;
        }
        if (dy > 0) {
            dir = ForgeDirection.DOWN;
        }
        if (dz < 0) {
            dir = ForgeDirection.SOUTH;
        }
        if (dz > 0) {
            dir = ForgeDirection.NORTH;
        }
        return dir;
    }

    public final int getDistanceToTarget() {
        return this.otherEnd == null ? -1 : this.otherEnd.getTaxicabDistanceTo((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    public final boolean isValidDirection(ForgeDirection dir) {
        switch (this.func_145832_p() % 6) {
            case 0: 
            case 1: {
                return dir.offsetX == 0;
            }
            case 2: 
            case 3: {
                return dir.offsetZ == 0;
            }
            case 4: 
            case 5: {
                return dir.offsetY == 0;
            }
        }
        return false;
    }

    @Override
    public final boolean canProvidePower() {
        return this.isEmitting || this.isSplitting();
    }

    @Override
    public final PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        if (this.isEmitting) {
            TileEntityBeltHub tile = (TileEntityBeltHub)this.otherEnd.getTileEntity((IBlockAccess)this.field_145850_b);
            return tile != null ? tile.getPowerSources(io, caller) : new PowerSourceList();
        }
        return PowerSourceList.getAllFrom(this.field_145850_b, this.read, this.field_145851_c + this.read.offsetX, this.field_145848_d + this.read.offsetY, this.field_145849_e + this.read.offsetZ, this, caller);
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.BELT;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public final long getMaxPower() {
        return this.isSplitting() ? this.power / 2L : this.power;
    }

    @Override
    public final long getCurrentPower() {
        return this.isSplitting() ? this.power / 2L : this.power;
    }

    public final boolean isWet() {
        return this.wetTimer > 0;
    }

    public final void makeWet() {
        this.wetTimer = Math.min(this.wetTimer + 3600, 18000);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("emit", this.isEmitting);
        if (this.otherEnd != null) {
            this.otherEnd.writeToNBT("endpoint", NBT);
        }
        NBT.func_74768_a("wet", this.wetTimer);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.isEmitting = NBT.func_74767_n("emit");
        this.otherEnd = Coordinate.readFromNBT((String)"endpoint", (NBTTagCompound)NBT);
        this.wetTimer = NBT.func_74762_e("wet");
    }

    public final AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public final Coordinate getConnection() {
        return this.otherEnd;
    }

    @Override
    public final int getEmittingX() {
        return this.field_145851_c + this.write.offsetX;
    }

    @Override
    public final int getEmittingY() {
        return this.field_145848_d + this.write.offsetY;
    }

    @Override
    public final int getEmittingZ() {
        return this.field_145849_e + this.write.offsetZ;
    }

    public int[] getBeltColor() {
        return new int[]{192, 120, 70};
    }

    public ItemStack getBeltItem() {
        return ItemStacks.belt.func_77946_l();
    }

    public boolean isEmitting() {
        return this.isEmitting;
    }

    public final void breakBlock() {
        if (!this.field_145850_b.field_72995_K) {
            int num = this.getDistanceToTarget() - 1;
            num = Math.min(num, ItemStacks.belt.func_77976_d());
            if (!this.hasValidConnection()) {
                num = 0;
            }
            for (int i = 0; i < num; ++i) {
                ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)this.getBeltItem());
            }
            this.resetOther();
        }
    }

    @Override
    public final void getOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        TileEntity te;
        if (this.otherEnd != null && (te = this.otherEnd.getTileEntity((IBlockAccess)this.field_145850_b)) instanceof TileEntityBeltHub) {
            TileEntityBeltHub belt = (TileEntityBeltHub)te;
            c.add(belt.getAdjacentTileEntity(belt.write));
            c.add(belt.getAdjacentTileEntity(belt.write2));
        }
    }

    public boolean isSlipping() {
        return this.isSlippingOmega || this.isSlippingTorque;
    }
}

