/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry.Turret;

import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.RotaryCraft.API.Interfaces.FlyingMob;
import Reika.RotaryCraft.API.Interfaces.TargetEntity;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.TileEntityInventoriedCannon;
import Reika.RotaryCraft.Entities.EntityFlakShot;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityAAGun
extends TileEntityInventoriedCannon
implements ISidedInventory {
    @Override
    public int getRange() {
        return 128;
    }

    @Override
    public int getMaxRange() {
        return 128;
    }

    @Override
    public boolean hasAmmo() {
        return ReikaInventoryHelper.checkForItemStack((ItemStack)ItemStacks.scrap, (ItemStack[])this.inv, (boolean)false);
    }

    @Override
    protected float getAimingSpeed() {
        return 2.0f;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        if (this.power < this.MINPOWER || this.torque < this.MINTORQUE) {
            return;
        }
        if (!this.hasAmmo()) {
            return;
        }
        if (!this.isAimingAtTarget(world, x, y, z, this.target)) {
            return;
        }
        if (this.tickcount < this.getOperationTime()) {
            return;
        }
        this.tickcount = 0;
        if (this.target[3] == 1.0) {
            this.fire(world, this.target);
        }
    }

    @Override
    public int getOperationTime() {
        return 6;
    }

    @Override
    protected double[] getTarget(World world, int x, int y, int z) {
        double[] xyzb = new double[4];
        int r = this.getRange();
        AxisAlignedBB range = AxisAlignedBB.func_72330_a((double)(x - r), (double)(y - r), (double)(z - r), (double)(x + 1 + r), (double)(y + 1 + r), (double)(z + 1 + r));
        List inrange = world.func_72872_a(Entity.class, range);
        double mindist = this.getRange() + 2;
        Entity i_at_min = null;
        for (Entity ent : inrange) {
            double dy;
            double reqtheta;
            double dist = ReikaMathLibrary.py3d((double)(ent.field_70165_t - (double)x - 0.5), (double)(ent.field_70163_u - (double)y - 0.5), (double)(ent.field_70161_v - (double)z - 0.5));
            if (!this.isValidTarget(ent) || !ReikaWorldHelper.canBlockSee((World)world, (int)x, (int)y, (int)z, (double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v, (double)this.getRange()) || !((reqtheta = -90.0 + Math.toDegrees(Math.abs(Math.acos((dy = -(ent.field_70163_u - (double)y)) / dist)))) <= (double)(this.dir * -10) && this.dir == -1) && (!(reqtheta >= (double)(this.dir * -10)) || this.dir != 1) || !(dist < mindist)) continue;
            mindist = dist;
            i_at_min = ent;
        }
        if (i_at_min == null) {
            return xyzb;
        }
        this.closestMob = i_at_min;
        xyzb[0] = this.closestMob.field_70165_t + this.randomOffset();
        xyzb[1] = this.closestMob.field_70163_u + (double)this.closestMob.func_70047_e() * 0.25 + this.randomOffset();
        xyzb[2] = this.closestMob.field_70161_v + this.randomOffset();
        xyzb[3] = 1.0;
        return xyzb;
    }

    @Override
    public void fire(World world, double[] xyz) {
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.explode", (float)1.0f, (float)1.3f);
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.explode", (float)1.0f, (float)0.5f);
        if (rand.nextBoolean()) {
            int slot = ReikaInventoryHelper.locateInInventory((ItemStack)ItemStacks.scrap, (ItemStack[])this.inv, (boolean)false);
            ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
        }
        double speed = 2.0;
        double[] v = new double[]{xyz[0] - (double)this.field_145851_c, xyz[1] - (double)this.field_145848_d, xyz[2] - (double)this.field_145849_e};
        double dd = ReikaMathLibrary.py3d((double)v[0], (double)v[1], (double)v[2]);
        int i = 0;
        while (i < 3) {
            int n = i++;
            v[n] = v[n] / dd;
        }
        i = 0;
        while (i < 3) {
            int n = i++;
            v[n] = v[n] * speed;
        }
        dd = ReikaMathLibrary.py3d((double)v[0], (double)v[1], (double)v[2]);
        double dx = v[0] / dd;
        double dy = v[1] / dd;
        double dz = v[2] / dd;
        if (!world.field_72995_K) {
            double y = this.getFiringPositionY(dy);
            EntityFlakShot flak = new EntityFlakShot(world, (double)this.field_145851_c + 0.5 + dx, y, (double)this.field_145849_e + 0.5 + dz, 3.0 * v[0], 3.0 * v[1], 3.0 * v[2], this);
            world.func_72838_d((Entity)flak);
        }
    }

    @Override
    protected double randomOffset() {
        return -1.0;
    }

    @Override
    protected boolean isValidTarget(Entity ent) {
        if (ent instanceof TargetEntity) {
            return ((TargetEntity)ent).shouldTarget((TileEntity)this, this.placerUUID);
        }
        if (!(ent instanceof EntityLivingBase)) {
            return false;
        }
        EntityLivingBase elb = (EntityLivingBase)ent;
        if (elb.field_70128_L || elb.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (ent.field_70122_E || ent.func_70090_H() || ent.func_70055_a(Material.field_151587_i)) {
            return false;
        }
        if (elb instanceof EntityFlying && ReikaEntityHelper.isHostile((EntityLivingBase)elb)) {
            return ReikaMathLibrary.py3d((double)(ent.field_70165_t - (double)this.field_145851_c - 0.5), (double)(ent.field_70163_u - (double)this.field_145848_d - 0.5), (double)(ent.field_70161_v - (double)this.field_145849_e - 0.5)) > 2.0;
        }
        if (ent instanceof EntityBlaze || ent instanceof EntityWither || ent instanceof EntityDragon) {
            return ReikaMathLibrary.py3d((double)(ent.field_70165_t - (double)this.field_145851_c - 0.5), (double)(ent.field_70163_u - (double)this.field_145848_d - 0.5), (double)(ent.field_70161_v - (double)this.field_145849_e - 0.5)) > 2.0;
        }
        if (ent instanceof FlyingMob) {
            FlyingMob fm = (FlyingMob)ent;
            return fm.isCurrentlyFlying() && fm.isHostile() && ReikaMathLibrary.py3d((double)(ent.field_70165_t - (double)this.field_145851_c - 0.5), (double)(ent.field_70163_u - (double)this.field_145848_d - 0.5), (double)(ent.field_70161_v - (double)this.field_145849_e - 0.5)) > 2.0;
        }
        return InterfaceCache.BCROBOT.instanceOf((Object)ent);
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.ANTIAIR;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public int func_70302_i_() {
        return 27;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return ReikaItemHelper.matchStacks((ItemStack)itemstack, (ItemStack)ItemStacks.scrap);
    }
}

