/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry.Turret;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Interfaces.TargetEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityInventoriedCannon;
import Reika.RotaryCraft.Entities.EntityFreezeGunShot;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityFreezeGun
extends TileEntityInventoriedCannon {
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        if (!this.isAimingAtTarget(world, x, y, z, this.target)) {
            return;
        }
        this.convertSnow();
        if (!this.hasAmmo()) {
            return;
        }
        if (this.tickcount < this.getOperationTime()) {
            return;
        }
        if (this.power < this.MINPOWER) {
            return;
        }
        this.tickcount = 0;
        if (this.target[3] == 1.0) {
            this.fire(world, this.target);
        }
    }

    public static PotionEffect getFreezeEffect(int duration) {
        PotionEffect pot = new PotionEffect(RotaryCraft.freeze.field_76415_H, duration, 0);
        pot.setCurativeItems(new ArrayList());
        return pot;
    }

    private void convertSnow() {
        int slot = ReikaInventoryHelper.locateInInventory((Block)Blocks.field_150433_aE, (ItemStack[])this.inv);
        if (slot != -1 && ReikaInventoryHelper.canAcceptMoreOf((Item)Items.field_151126_ay, (int)0, (int)4, (IInventory)this)) {
            ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
            ReikaInventoryHelper.addToIInv((ItemStack)new ItemStack(Items.field_151126_ay, 4, 0), (IInventory)this);
        }
        if ((slot = ReikaInventoryHelper.locateInInventory((Block)Blocks.field_150432_aD, (ItemStack[])this.inv)) != -1 && ReikaInventoryHelper.canAcceptMoreOf((Item)Items.field_151126_ay, (int)0, (int)16, (IInventory)this)) {
            ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
            ReikaInventoryHelper.addToIInv((ItemStack)new ItemStack(Items.field_151126_ay, 16, 0), (IInventory)this);
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    public int getRange() {
        return 64;
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.FREEZEGUN;
    }

    @Override
    public int getMaxRange() {
        return 256;
    }

    public int func_70302_i_() {
        return 27;
    }

    @Override
    public boolean hasAmmo() {
        return ReikaInventoryHelper.checkForItem((Block)Blocks.field_150432_aD, (ItemStack[])this.inv) || ReikaInventoryHelper.checkForItem((Item)Items.field_151126_ay, (ItemStack[])this.inv);
    }

    @Override
    protected double[] getTarget(World world, int x, int y, int z) {
        double[] xyzb = new double[4];
        int r = this.getRange();
        AxisAlignedBB range = AxisAlignedBB.func_72330_a((double)(x - r), (double)(y - r), (double)(z - r), (double)(x + 1 + r), (double)(y + 1 + r), (double)(z + 1 + r));
        List inrange = world.func_72872_a(Entity.class, range);
        double mindist = this.getRange() + 2;
        Entity i_at_min = null;
        for (Entity ent : inrange) {
            double dy;
            double reqtheta;
            double dist = ReikaMathLibrary.py3d((double)(ent.field_70165_t - (double)x - 0.5), (double)(ent.field_70163_u - (double)y - 0.5), (double)(ent.field_70161_v - (double)z - 0.5));
            if (!this.isValidTarget(ent) || !ReikaWorldHelper.canBlockSee((World)world, (int)x, (int)y, (int)z, (double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v, (double)this.getRange()) || !((reqtheta = -90.0 + Math.toDegrees(Math.abs(Math.acos((dy = -(ent.field_70163_u - (double)y)) / dist)))) <= (double)(this.dir * -10) && this.dir == -1) && (!(reqtheta >= (double)(this.dir * -10)) || this.dir != 1) || !(dist < mindist)) continue;
            mindist = dist;
            i_at_min = ent;
        }
        if (i_at_min == null) {
            return xyzb;
        }
        this.closestMob = i_at_min;
        xyzb[0] = this.closestMob.field_70165_t + this.randomOffset();
        xyzb[1] = this.closestMob.field_70163_u + (double)this.closestMob.func_70047_e() * 0.25 + this.randomOffset();
        xyzb[2] = this.closestMob.field_70161_v + this.randomOffset();
        xyzb[3] = 1.0;
        return xyzb;
    }

    @Override
    public void fire(World world, double[] xyz) {
        double speed = 1.0;
        int slot = ReikaInventoryHelper.locateInInventory((Item)Items.field_151126_ay, (ItemStack[])this.inv);
        ReikaInventoryHelper.decrStack((int)slot, (ItemStack[])this.inv);
        double[] v = new double[]{xyz[0] - (double)this.field_145851_c, xyz[1] - (double)this.field_145848_d, xyz[2] - (double)this.field_145849_e};
        double dd = ReikaMathLibrary.py3d((double)v[0], (double)v[1], (double)v[2]);
        int i = 0;
        while (i < 3) {
            int n = i++;
            v[n] = v[n] / dd;
        }
        i = 0;
        while (i < 3) {
            int n = i++;
            v[n] = v[n] * speed;
        }
        dd = ReikaMathLibrary.py3d((double)v[0], (double)v[1], (double)v[2]);
        double dx = v[0] / dd;
        double dy = v[1] / dd;
        double dz = v[2] / dd;
        if (!world.field_72995_K) {
            double y = this.getFiringPositionY(dy);
            EntityFreezeGunShot snow = new EntityFreezeGunShot(world, (double)this.field_145851_c + 0.5 + dx, y, (double)this.field_145849_e + 0.5 + dz, 3.0 * v[0], 3.0 * v[1], 3.0 * v[2], this);
            world.func_72838_d((Entity)snow);
        }
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150432_aD) || ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150433_aE) || is.func_77973_b() == Items.field_151126_ay;
    }

    @Override
    protected double randomOffset() {
        return 0.0;
    }

    public int getRedstoneOverride() {
        if (!this.hasAmmo()) {
            return 15;
        }
        return 0;
    }

    @Override
    protected boolean isValidTarget(Entity ent) {
        if (ent.field_70128_L) {
            return false;
        }
        if (ent instanceof TargetEntity) {
            return ((TargetEntity)ent).shouldTarget((TileEntity)this, this.placerUUID);
        }
        if (!(ent instanceof EntityLivingBase)) {
            return false;
        }
        EntityLivingBase elb = (EntityLivingBase)ent;
        return elb.func_110143_aJ() > 0.0f && this.isMobOrUnlistedPlayer(elb) && elb.func_70660_b((Potion)RotaryCraft.freeze) == null;
    }
}

