/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.World;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.ReikaSpawnerHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import Reika.GeoStrata.Registry.RockShapes;
import Reika.GeoStrata.Registry.RockTypes;
import Reika.RotaryCraft.API.Event.PileDriverImpactEvent;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPileDriver
extends TileEntityPowerReceiver {
    public int step = 0;
    private int step2 = 0;
    private boolean climbing = false;
    private boolean active = false;
    private boolean smashed = false;
    public static final int BASEPOWER = 16384;
    public static final int MINTIME = 1;
    public static final int BASESPEED = 300;
    private static final BlockMap<Integer> HITS_PER_BLOCK = new BlockMap();
    private static final BlockMap<BlockKey> BLOCK_CONVERSION = new BlockMap();
    private final HashMap<Coordinate, HitCount> numHits = new HashMap();
    private static int BITMETA = 4;

    private static int getHitCount(Block b, int meta) {
        Integer get = (Integer)HITS_PER_BLOCK.get(b, meta);
        return get != null ? get : 0;
    }

    private void addNausea(World world, int x, int y, int z) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(15.0, 15.0, 15.0);
        List sick = world.func_72872_a(EntityPlayer.class, box);
        for (EntityPlayer ep : sick) {
            if (ep.field_71075_bZ.field_75098_d) continue;
            ep.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 150, 10));
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        this.getPower(true);
        int speed = 300;
        int minpower = 16384 * (this.step + 1);
        if (this.power < (long)minpower || this.torque < this.MINTORQUE) {
            return;
        }
        if (this.power > (long)minpower) {
            speed = Math.max(300 / (int)(this.power / (long)minpower), 1);
        }
        ++this.tickcount;
        if (!this.drawPile3(world, x, y, z, speed) && this.step != 0) {
            return;
        }
        this.climbing = true;
        this.tickcount = 0;
        if (this.smash(world, x, y - this.step - 1, z)) {
            ++this.step;
        }
        this.bounce(world, x, y - this.step - 1, z);
        this.dealDamage(world, x, y - this.step - 1, z);
        this.addNausea(world, x, y - this.step - 1, z);
        SoundRegistry.PILEDRIVER.playSoundAtBlock(world, x, y, z, 1.0f, 1.0f);
    }

    private void bounce(World world, int x, int y, int z) {
        AxisAlignedBB zone = AxisAlignedBB.func_72330_a((double)(x - 2), (double)y, (double)(z - 2), (double)(x + 3), (double)(y + 1), (double)(z + 3)).func_72314_b(24.0, 24.0, 24.0);
        List inzone = world.func_72872_a(Entity.class, zone);
        for (Entity ent : inzone) {
            if (ent == null) continue;
            if (ent.field_70122_E && !world.field_72995_K) {
                ent.field_70181_x += 0.5 / ReikaMathLibrary.doubpow((double)ReikaMathLibrary.py3d((double)(ent.field_70165_t - (double)x), (double)(ent.field_70163_u - (double)y), (double)(ent.field_70161_v - (double)z)), (double)0.5);
            }
            ent.field_70133_I = true;
        }
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        switch (metadata) {
            case 1: {
                this.read = ForgeDirection.EAST;
                this.read2 = ForgeDirection.WEST;
                break;
            }
            case 0: {
                this.read = ForgeDirection.NORTH;
                this.read2 = ForgeDirection.SOUTH;
            }
        }
    }

    private void dealDamage(World world, int x, int y, int z) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(0.5, 2.0, 0.5);
        List killed = world.func_72872_a(EntityLivingBase.class, box);
        for (int i = 0; i < killed.size(); ++i) {
            EntityLivingBase el = (EntityLivingBase)killed.get(i);
            if (el == null) continue;
            float dmg = el.func_110138_aP() * (float)el.func_70658_aO();
            if (dmg <= 0.0f) {
                dmg = Float.MAX_VALUE;
            }
            el.func_70097_a(DamageSource.field_76368_d, dmg);
        }
    }

    private void breakGlass(World world, int x, int y, int z) {
        int range = 5;
        for (int i = -range; i <= range; ++i) {
            for (int j = -range; j <= range; ++j) {
                for (int k = -range; k <= range; ++k) {
                    Block b = world.func_147439_a(x + i, y + j, z + k);
                    if (b == Blocks.field_150350_a) continue;
                    this.breakGlass_do(world, x + i, y + j, z + k, b);
                }
            }
        }
        AxisAlignedBB nearby = AxisAlignedBB.func_72330_a((double)(x - range), (double)(y - range), (double)(z - range), (double)(x + 1 + range), (double)(y + 1 + range), (double)(z + 1 + range));
        List inzone = world.func_72872_a(EntityHanging.class, nearby);
        for (EntityHanging ep : inzone) {
            ep.func_70097_a(DamageSource.field_76380_i, 100.0f);
        }
    }

    private void breakGlass_do(World world, int x, int y, int z, Block id) {
        ItemStack drop = null;
        int meta = world.func_72805_g(x, y, z);
        if (id == Blocks.field_150359_w || id == Blocks.field_150410_aZ || id == Blocks.field_150426_aN) {
            id.func_149697_b(world, x, y, z, meta, 0);
            world.func_147468_f(x, y, z);
        }
        if (id == Blocks.field_150434_aF || id == Blocks.field_150436_aH || id == Blocks.field_150395_bd || id == Blocks.field_150392_bi || id == Blocks.field_150329_H || id == Blocks.field_150345_g || id == Blocks.field_150457_bL || id == Blocks.field_150465_bP) {
            id.func_149697_b(world, x, y, z, meta, 0);
            world.func_147468_f(x, y, z);
        }
        if (id == Blocks.field_150432_aD) {
            world.func_147449_b(x, y, z, (Block)Blocks.field_150358_i);
            drop = new ItemStack(Blocks.field_150432_aD);
        }
        if (id == Blocks.field_150321_G) {
            world.func_147468_f(x, y, z);
            drop = new ItemStack(Items.field_151007_F);
        }
        if (id instanceof BlockFalling) {
            this.makeFall(world, x, y, z, (BlockFalling)id);
        }
        if (drop == null) {
            return;
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return;
        }
        EntityItem ent = new EntityItem(world, (double)x, (double)y, (double)z, drop);
        world.func_72838_d((Entity)ent);
    }

    private void makeFall(World world, int x, int y, int z, BlockFalling id) {
        BlockFalling tofall = id;
        if (BlockFalling.func_149831_e((World)world, (int)x, (int)(y - 1), (int)z)) {
            int var8 = 32;
            if (!BlockFalling.field_149832_M && world.func_72904_c(x - var8, y - var8, z - var8, x + var8, y + var8, z + var8)) {
                if (!world.field_72995_K) {
                    EntityFallingBlock var9 = new EntityFallingBlock(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), (Block)tofall, world.func_72805_g(x, y, z));
                    world.func_72838_d((Entity)var9);
                }
            } else {
                world.func_147468_f(x, y, z);
                while (true) {
                    if (!BlockFalling.func_149831_e((World)world, (int)x, (int)(y - 1), (int)z) || y <= 0) break;
                    --y;
                }
                if (y > 0) {
                    world.func_147449_b(x, y, z, (Block)tofall);
                }
            }
        }
    }

    private ArrayList<ItemStack> getDrops(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        return b != null ? b.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0) : new ArrayList();
    }

    private BlockKey getBlockProduct(World world, int x, int y, int z, Block id, int meta) {
        BlockKey to = (BlockKey)BLOCK_CONVERSION.get(id, meta);
        if (to == null) {
            to = new BlockKey(Blocks.field_150350_a);
        }
        if (ReikaBlockHelper.isLiquid((Block)id)) {
            to = new BlockKey(id, meta);
        }
        return to;
    }

    private boolean drawPile3(World world, int x, int y, int z, int speed) {
        if (this.climbing && this.tickcount > speed) {
            if (world.func_147439_a(x, y - this.step2 - 2, z) == BlockRegistry.MININGPIPE.getBlockInstance()) {
                world.func_147468_f(x, y - this.step2 - 2, z);
            }
            --this.step2;
            if (world.func_147439_a(x, y - this.step2, z) == this.func_145838_q()) {
                this.climbing = false;
                this.smashed = false;
            } else {
                world.func_147468_f(x, y - this.step2 - 1, z);
            }
            this.tickcount = 0;
        }
        if (this.climbing && this.tickcount <= speed) {
            if (this.step2 >= this.step) {
                --this.step2;
            }
            if (world.func_147439_a(x, y - this.step2, z) == this.func_145838_q()) {
                this.climbing = false;
                this.smashed = false;
            } else {
                world.func_147468_f(x, y - this.step2 - 1, z);
            }
        }
        world.func_147471_g(x, y - this.step2 - 1, z);
        if (!this.climbing) {
            if (ReikaWorldHelper.getMaterial((IBlockAccess)world, (int)x, (int)(y - this.step2 - 1), (int)z) == Material.field_151586_h) {
                world.func_72869_a("splash", (double)x, (double)(y - this.step2 + 1), (double)z, -0.2, 0.4, -0.2);
                world.func_72869_a("splash", (double)x + 0.5, (double)(y - this.step2 + 1), (double)z, 0.0, 0.4, -0.2);
                world.func_72869_a("splash", (double)(x + 1), (double)(y - this.step2 + 1), (double)z, 0.2, 0.4, -0.2);
                world.func_72869_a("splash", (double)x, (double)(y - this.step2 + 1), (double)z + 0.5, -0.2, 0.4, 0.0);
                world.func_72869_a("splash", (double)x, (double)(y - this.step2 + 1), (double)(z + 1), -0.2, 0.4, 0.2);
                world.func_72869_a("splash", (double)x + 0.5, (double)(y - this.step2 + 1), (double)(z + 1), 0.0, 0.4, 0.2);
                world.func_72869_a("splash", (double)(x + 1), (double)(y - this.step2 + 1), (double)z + 0.5, 0.2, 0.4, 0.0);
                world.func_72869_a("splash", (double)(x + 1), (double)(y - this.step2 + 1), (double)(z + 1), 0.2, 0.4, 0.2);
                world.func_72869_a("splash", (double)x, (double)(y - this.step2 + 1), (double)z, -0.2 + 0.4 * (double)rand.nextFloat(), 0.4, -0.2 + 0.4 * (double)rand.nextFloat());
                world.func_72869_a("splash", (double)x + 0.5, (double)(y - this.step2 + 1), (double)z, 0.0, 0.4, -0.2 + 0.4 * (double)rand.nextFloat());
                world.func_72869_a("splash", (double)(x + 1), (double)(y - this.step2 + 1), (double)z, 0.2 - 0.4 * (double)rand.nextFloat(), 0.4, -0.2 + 0.4 * (double)rand.nextFloat());
                world.func_72869_a("splash", (double)x, (double)(y - this.step2 + 1), (double)z + 0.5, -0.2 + 0.4 * (double)rand.nextFloat(), 0.4, 0.0);
                world.func_72869_a("splash", (double)x, (double)(y - this.step2 + 1), (double)(z + 1), -0.2 + 0.4 * (double)rand.nextFloat(), 0.4, 0.2 - 0.4 * (double)rand.nextFloat());
                world.func_72869_a("splash", (double)x + 0.5, (double)(y - this.step2 + 1), (double)(z + 1), 0.0, 0.4, 0.2 + 0.4 * (double)rand.nextFloat());
                world.func_72869_a("splash", (double)(x + 1), (double)(y - this.step2 + 1), (double)z + 0.5, 0.2 - 0.4 * (double)rand.nextFloat(), 0.4, 0.0);
                world.func_72869_a("splash", (double)(x + 1), (double)(y - this.step2 + 1), (double)(z + 1), 0.2 - 0.4 * (double)rand.nextFloat(), 0.4, 0.2 - 0.4 * (double)rand.nextFloat());
                world.func_72869_a("splash", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72869_a("splash", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72869_a("splash", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72869_a("splash", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72869_a("splash", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72869_a("splash", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72869_a("splash", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72869_a("splash", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72908_a((double)x + 0.5, (double)(y - this.step2), (double)z + 0.5, "random.splash", 1.0f, 1.0f);
            }
            if (ReikaWorldHelper.getMaterial((IBlockAccess)world, (int)x, (int)(y - this.step2 - 1), (int)z) == Material.field_151587_i) {
                world.func_72869_a("lava", (double)x, (double)(y - this.step2 + 1), (double)z, -0.2, 0.4, -0.2);
                world.func_72869_a("lava", (double)x + 0.5, (double)(y - this.step2 + 1), (double)z, 0.0, 0.4, -0.2);
                world.func_72869_a("lava", (double)(x + 1), (double)(y - this.step2 + 1), (double)z, 0.2, 0.4, -0.2);
                world.func_72869_a("lava", (double)x, (double)(y - this.step2 + 1), (double)z + 0.5, -0.2, 0.4, 0.0);
                world.func_72869_a("lava", (double)x, (double)(y - this.step2 + 1), (double)(z + 1), -0.2, 0.4, 0.2);
                world.func_72869_a("lava", (double)x + 0.5, (double)(y - this.step2 + 1), (double)(z + 1), 0.0, 0.4, 0.2);
                world.func_72869_a("lava", (double)(x + 1), (double)(y - this.step2 + 1), (double)z + 0.5, 0.2, 0.4, 0.0);
                world.func_72869_a("lava", (double)(x + 1), (double)(y - this.step2 + 1), (double)(z + 1), 0.2, 0.4, 0.2);
                world.func_72869_a("lava", (double)x, (double)(y - this.step2 + 1), (double)z, -0.2 + 0.4 * (double)rand.nextFloat(), 0.4, -0.2 + 0.4 * (double)rand.nextFloat());
                world.func_72869_a("lava", (double)x + 0.5, (double)(y - this.step2 + 1), (double)z, 0.0, 0.4, -0.2 + 0.4 * (double)rand.nextFloat());
                world.func_72869_a("lava", (double)(x + 1), (double)(y - this.step2 + 1), (double)z, 0.2 - 0.4 * (double)rand.nextFloat(), 0.4, -0.2 + 0.4 * (double)rand.nextFloat());
                world.func_72869_a("lava", (double)x, (double)(y - this.step2 + 1), (double)z + 0.5, -0.2 + 0.4 * (double)rand.nextFloat(), 0.4, 0.0);
                world.func_72869_a("lava", (double)x, (double)(y - this.step2 + 1), (double)(z + 1), -0.2 + 0.4 * (double)rand.nextFloat(), 0.4, 0.2 - 0.4 * (double)rand.nextFloat());
                world.func_72869_a("lava", (double)x + 0.5, (double)(y - this.step2 + 1), (double)(z + 1), 0.0, 0.4, 0.2 + 0.4 * (double)rand.nextFloat());
                world.func_72869_a("lava", (double)(x + 1), (double)(y - this.step2 + 1), (double)z + 0.5, 0.2 - 0.4 * (double)rand.nextFloat(), 0.4, 0.0);
                world.func_72869_a("lava", (double)(x + 1), (double)(y - this.step2 + 1), (double)(z + 1), 0.2 - 0.4 * (double)rand.nextFloat(), 0.4, 0.2 - 0.4 * (double)rand.nextFloat());
                world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)(y - this.step2 + 1), (double)((float)z + rand.nextFloat()), (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat());
                world.func_72908_a((double)x + 0.5, (double)(y - this.step2), (double)z + 0.5, "random.fizz", 1.0f, 1.0f);
            }
            world.func_147465_d(x, y - this.step2 - 1, z, BlockRegistry.MININGPIPE.getBlockInstance(), BITMETA, 3);
            ++this.step2;
        }
        if (world.func_147439_a(x, y - this.step2 - 1, z) == Blocks.field_150350_a) {
            while (world.func_147439_a(x, y - this.step2 - 2, z) == Blocks.field_150350_a && y - this.step2 - 2 > 0 && this.step == this.step2) {
                this.step2 = ++this.step;
            }
        }
        return this.step2 == this.step;
    }

    private boolean smash(World world, int x, int y, int z) {
        int j;
        int i;
        MinecraftForge.EVENT_BUS.post((Event)new PileDriverImpactEvent((TileEntity)this, x, y, z));
        boolean cleared = true;
        this.smashed = true;
        for (i = -2; i < 3; ++i) {
            for (j = -2; j < 3; ++j) {
                TileEntityMobSpawner spw;
                Block id = world.func_147439_a(x + i, y, z + j);
                int meta = world.func_72805_g(x + i, y, z + j);
                if (world.field_72995_K || !ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)world), (int)(x + i), (int)y, (int)(z + j), (Block)id, (int)meta, (EntityPlayerMP)this.getServerPlacer()) || id == Blocks.field_150350_a || i * j == 4 || i * j == -4) continue;
                if (id == Blocks.field_150474_ac && (spw = (TileEntityMobSpawner)world.func_147438_o(x + i, y, z + j)) != null) {
                    this.spawnSpawner(world, x + i, y, z + j, spw);
                }
                for (int h = 1; h <= 4; ++h) {
                    Block id2 = world.func_147439_a(x + i, y - h, z + j);
                    int meta2 = world.func_72805_g(x + i, y - h, z + j);
                    int hits = TileEntityPileDriver.getHitCount(id2, meta2);
                    if (hits >= 0 || Math.abs(hits) < h) continue;
                    this.checkIncrementAndBreak(world, x + i, y - h, z + j, id2, meta2);
                }
                this.checkIncrementAndBreak(world, x + i, y, z + j, id, meta);
            }
        }
        SoundRegistry.PILEDRIVER.playSoundAtBlock(world, x, y, z, 1.0f, 1.0f);
        for (i = -2; i < 3; ++i) {
            for (j = -2; j < 3; ++j) {
                if (i * j == 4 || i * j == -4 || world.func_147439_a(x + i, y, z + j) == Blocks.field_150350_a || ReikaWorldHelper.getMaterial((IBlockAccess)world, (int)(x + i), (int)y, (int)(z + j)) == Material.field_151586_h || ReikaWorldHelper.getMaterial((IBlockAccess)world, (int)(x + i), (int)y, (int)(z + j)) == Material.field_151587_i) continue;
                cleared = false;
            }
        }
        this.breakGlass(world, x, y, z);
        return cleared;
    }

    private void checkIncrementAndBreak(World world, int x, int y, int z, Block id, int meta) {
        Coordinate loc = new Coordinate(x, y, z);
        HitCount c = this.numHits.get(loc);
        boolean flag = false;
        if (c != null) {
            if (c.hit()) {
                this.numHits.remove(loc);
                flag = true;
            }
        } else {
            int ct = TileEntityPileDriver.getHitCount(id, meta);
            if (ct <= 0) {
                flag = true;
            } else {
                c = new HitCount(ct);
                this.numHits.put(loc, c);
            }
        }
        if (flag) {
            BlockKey blockTo = this.getBlockProduct(world, x, y, z, id, meta);
            ArrayList<ItemStack> li = this.getDrops(world, x, y, z);
            if (!world.field_72995_K) {
                blockTo.place(world, x, y, z);
            }
            if (blockTo.blockID == Blocks.field_150350_a) {
                ReikaItemHelper.dropItems((World)world, (double)x, (double)y, (double)z, li);
            }
            world.func_147471_g(x, y, z);
        }
    }

    private void spawnSpawner(World world, int x, int y, int z, TileEntityMobSpawner spw) {
        if (world.field_72995_K) {
            return;
        }
        ItemStack is = ItemRegistry.SPAWNER.getStackOf();
        ReikaSpawnerHelper.addMobNBTToItem((ItemStack)is, (TileEntityMobSpawner)spw);
        EntityItem ent = new EntityItem(world, (double)x, (double)y, (double)z, is);
        world.func_72838_d((Entity)ent);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("step", this.step);
        NBT.func_74768_a("step2", this.step2);
        NBT.func_74757_a("active", this.active);
        NBT.func_74757_a("climbing", this.climbing);
        NBT.func_74757_a("smashed", this.smashed);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.step = NBT.func_74762_e("step");
        this.step2 = NBT.func_74762_e("step2");
        this.climbing = NBT.func_74767_n("climbing");
        this.active = NBT.func_74767_n("active");
        this.smashed = NBT.func_74767_n("smashed");
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        if (this.power < (long)(16384 * (this.step + 1)) || this.torque < this.MINTORQUE) {
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.PILEDRIVER;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    static {
        HITS_PER_BLOCK.put(Blocks.field_150343_Z, (Object)5);
        HITS_PER_BLOCK.put(Blocks.field_150424_aL, (Object)-2);
        HITS_PER_BLOCK.put(Blocks.field_150359_w, (Object)-4);
        HITS_PER_BLOCK.put(Blocks.field_150426_aN, (Object)-3);
        HITS_PER_BLOCK.put(Blocks.field_150325_L, (Object)-1);
        BlockKey to = new BlockKey(Blocks.field_150350_a);
        BLOCK_CONVERSION.put(Blocks.field_150357_h, (Object)new BlockKey(Blocks.field_150357_h));
        BLOCK_CONVERSION.put(Blocks.field_150348_b, (Object)new BlockKey(Blocks.field_150347_e));
        BLOCK_CONVERSION.put(BlockRegistry.DECO.getBlockInstance(), ItemStacks.shieldblock.func_77960_j(), (Object)new BlockKey(BlockRegistry.DECO.getBlockInstance(), ItemStacks.shieldblock.func_77960_j()));
        BLOCK_CONVERSION.put(BlockRegistry.MININGPIPE.getBlockInstance(), 3, (Object)new BlockKey(BlockRegistry.MININGPIPE.getBlockInstance(), 3));
        BLOCK_CONVERSION.put(Blocks.field_150417_aV, 0, (Object)new BlockKey(Blocks.field_150417_aV, 2));
        if (ModList.GEOSTRATA.isLoaded()) {
            for (int i = 0; i < RockTypes.rockList.length; ++i) {
                RockTypes r = RockTypes.rockList[i];
                for (int k = 0; k < RockShapes.shapeList.length; ++k) {
                    RockShapes s = RockShapes.shapeList[k];
                    ItemStack is = r.getItem(s);
                    Block b = Block.func_149634_a((Item)is.func_77973_b());
                    if (s != RockShapes.COBBLE) {
                        BLOCK_CONVERSION.put(b, is.func_77960_j(), (Object)BlockKey.fromItem((ItemStack)r.getItem(RockShapes.COBBLE)));
                    }
                    if (r == RockTypes.GRANITE || r == RockTypes.HORNFEL) {
                        HITS_PER_BLOCK.put(b, is.func_77960_j(), (Object)3);
                        continue;
                    }
                    if (r == RockTypes.PERIDOTITE || r == RockTypes.GNEISS || r == RockTypes.SCHIST) {
                        HITS_PER_BLOCK.put(b, is.func_77960_j(), (Object)2);
                        continue;
                    }
                    if (r != RockTypes.SHALE && r != RockTypes.LIMESTONE) continue;
                    HITS_PER_BLOCK.put(b, is.func_77960_j(), (Object)-1);
                }
            }
        }
    }

    private static class HitCount {
        private final int maxHits;
        private int hits;

        private HitCount(int max) {
            this.maxHits = max;
        }

        private boolean hit() {
            ++this.hits;
            return this.hits >= this.maxHits;
        }
    }
}

