/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencontainers.client.renderer;

import com.jaquadro.minecraft.gardencontainers.block.BlockLargePot;
import com.jaquadro.minecraft.gardencontainers.block.tile.TileEntityLargePot;
import com.jaquadro.minecraft.gardencontainers.core.ClientProxy;
import com.jaquadro.minecraft.gardencore.client.renderer.support.ModularBoxRenderer;
import com.jaquadro.minecraft.gardencore.util.RenderHelper;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class LargePotRenderer
implements ISimpleBlockRenderingHandler {
    private ModularBoxRenderer boxRenderer = new ModularBoxRenderer();
    private float[] colorScratch = new float[3];

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockLargePot)) {
            return;
        }
        this.renderInventoryBlock((BlockLargePot)block, metadata, modelId, renderer);
    }

    private void renderInventoryBlock(BlockLargePot block, int metadata, int modelId, RenderBlocks renderer) {
        IIcon icon = renderer.func_147787_a((Block)block, 1, metadata & 0xF);
        boolean blendEnabled = GL11.glIsEnabled((int)3042);
        if (blendEnabled) {
            GL11.glDisable((int)3042);
        }
        GL11.glDepthMask((boolean)true);
        this.boxRenderer.setUnit(0.0625);
        this.boxRenderer.setIcon(icon);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.boxRenderer.renderBox(null, (Block)block, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0, 2);
        GL11.glEnable((int)3042);
        if ((metadata & 0xFF00) != 0) {
            int cutFlags = 3;
            this.boxRenderer.setUnit(0.0);
            this.boxRenderer.setIcon(block.getOverlayIcon(metadata >> 8 & 0xFF));
            this.boxRenderer.renderExterior(null, (Block)block, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0, cutFlags);
        }
        if (!blendEnabled) {
            GL11.glDisable((int)3042);
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockLargePot)) {
            return false;
        }
        try {
            if (ClientProxy.renderPass == 0) {
                return this.renderWorldBlockPass0(world, x, y, z, (BlockLargePot)block, modelId, renderer);
            }
            if (ClientProxy.renderPass == 1) {
                return this.renderWorldBlockPass1(world, x, y, z, (BlockLargePot)block, modelId, renderer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean renderWorldBlockPass0(IBlockAccess world, int x, int y, int z, BlockLargePot block, int modelId, RenderBlocks renderer) {
        int metadata = world.func_72805_g(x, y, z);
        this.boxRenderer.setUnit(0.0625);
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        for (int i = 0; i < 6; ++i) {
            this.boxRenderer.setIcon(renderer.func_147787_a((Block)block, i, metadata), i);
        }
        TileEntityLargePot te = block.getTileEntity(world, x, y, z);
        int connectFlags = 0;
        connectFlags |= te.isAttachedNeighbor(x - 1, y, z - 1) ? 16384 : 0;
        connectFlags |= te.isAttachedNeighbor(x, y, z - 1) ? 4 : 0;
        connectFlags |= te.isAttachedNeighbor(x + 1, y, z - 1) ? 32768 : 0;
        connectFlags |= te.isAttachedNeighbor(x - 1, y, z) ? 16 : 0;
        connectFlags |= te.isAttachedNeighbor(x + 1, y, z) ? 32 : 0;
        connectFlags |= te.isAttachedNeighbor(x - 1, y, z + 1) ? 65536 : 0;
        connectFlags |= te.isAttachedNeighbor(x, y, z + 1) ? 8 : 0;
        this.boxRenderer.renderBox(world, (Block)block, x, y, z, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, connectFlags |= te.isAttachedNeighbor(x + 1, y, z + 1) ? 131072 : 0, 2);
        if (te != null && te.getSubstrate() != null && te.getSubstrate().func_77973_b() instanceof ItemBlock) {
            Block substrate = Block.func_149634_a((Item)te.getSubstrate().func_77973_b());
            int substrateData = te.getSubstrate().func_77960_j();
            if (substrate != Blocks.field_150355_j) {
                IIcon substrateIcon = renderer.func_147787_a(substrate, 1, substrateData);
                int color = substrate.func_149720_d(world, x, y, z);
                if (color == Blocks.field_150349_c.func_149720_d(world, x, y, z)) {
                    color = ColorizerGrass.func_77480_a((double)te.getBiomeTemperature(), (double)te.getBiomeHumidity());
                }
                RenderHelper.calculateBaseColor(this.colorScratch, color);
                RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
                RenderHelper.instance.renderFace(1, world, (Block)block, x, y, z, substrateIcon, this.colorScratch[0], this.colorScratch[1], this.colorScratch[2]);
            }
        }
        return true;
    }

    private boolean renderWorldBlockPass1(IBlockAccess world, int x, int y, int z, BlockLargePot block, int modelId, RenderBlocks renderer) {
        TileEntityLargePot tileEntity = block.getTileEntity(world, x, y, z);
        if (tileEntity == null) {
            RenderHelper.instance.renderEmptyPlane(x, y, z);
            return true;
        }
        boolean didRender = false;
        IIcon icon = block.getOverlayIcon(tileEntity.getCarving());
        if (icon != null) {
            int connectFlags = 0;
            int cutFlags = 3;
            connectFlags |= tileEntity.isAttachedNeighbor(x, y, z - 1) ? 4 : 0;
            connectFlags |= tileEntity.isAttachedNeighbor(x - 1, y, z) ? 16 : 0;
            connectFlags |= tileEntity.isAttachedNeighbor(x + 1, y, z) ? 32 : 0;
            if ((connectFlags |= tileEntity.isAttachedNeighbor(x, y, z + 1) ? 8 : 0) != 60) {
                this.boxRenderer.setUnit(0.0);
                this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
                this.boxRenderer.setExteriorIcon(icon);
                this.boxRenderer.renderExterior(world, (Block)block, x, y, z, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, connectFlags, cutFlags);
                didRender = true;
            }
        }
        if (tileEntity.getSubstrate() != null && tileEntity.getSubstrate().func_77973_b() instanceof ItemBlock) {
            Block substrate = Block.func_149634_a((Item)tileEntity.getSubstrate().func_77973_b());
            int substrateData = tileEntity.getSubstrate().func_77960_j();
            if (substrate == Blocks.field_150355_j) {
                IIcon substrateIcon = renderer.func_147787_a(substrate, 1, substrateData);
                RenderHelper.instance.state.setRenderBounds(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
                RenderHelper.instance.renderFace(1, world, (Block)block, x, y, z, substrateIcon);
                didRender = true;
            }
        }
        if (!didRender) {
            RenderHelper.instance.renderEmptyPlane(x, y, z);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ClientProxy.largePotRenderID;
    }
}

