/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.client.renderer;

import com.jaquadro.minecraft.gardentrees.block.BlockThinLogFence;
import com.jaquadro.minecraft.gardentrees.core.ClientProxy;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class ThinLogFenceRenderer
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockThinLogFence)) {
            return;
        }
        this.renderInventoryBlock((BlockThinLogFence)block, metadata, modelId, renderer);
    }

    public void renderInventoryBlock(BlockThinLogFence block, int metadata, int modelId, RenderBlocks renderer) {
        block.func_149683_g();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)0.0f);
        renderer.func_147775_a((Block)block);
        this.renderPostAtOrigin(block, metadata, renderer, tessellator);
        this.renderSideAtOrigin(block, metadata, renderer, tessellator, 0.5f, 1.0f);
        GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.0f);
        renderer.func_147775_a((Block)block);
        this.renderPostAtOrigin(block, metadata, renderer, tessellator);
        this.renderSideAtOrigin(block, metadata, renderer, tessellator, 0.0f, 0.5f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    private void renderSideAtOrigin(BlockThinLogFence block, int metadata, RenderBlocks renderer, Tessellator tessellator, float xs, float xe) {
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147782_a((double)xs, 0.0, 0.0, (double)xe, 1.0, 1.0);
        renderer.func_147761_c((Block)block, 0.0, 0.0, 0.5, block.getSideIcon());
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147782_a((double)xs, 0.0, 0.0, (double)xe, 1.0, 1.0);
        renderer.func_147734_d((Block)block, 0.0, 0.0, -0.5, block.getSideIcon());
        tessellator.func_78381_a();
    }

    private void renderPostAtOrigin(BlockThinLogFence block, int metadata, RenderBlocks renderer, Tessellator tessellator) {
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 0, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 1, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 2, metadata));
        renderer.func_147761_c((Block)block, 0.0, 0.0, 0.5, block.getSideIcon());
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 3, metadata));
        renderer.func_147734_d((Block)block, 0.0, 0.0, -0.5, block.getSideIcon());
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 4, metadata));
        renderer.func_147798_e((Block)block, 0.5, 0.0, 0.0, block.getSideIcon());
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f((Block)block, 0.0, 0.0, 0.0, renderer.func_147787_a((Block)block, 5, metadata));
        renderer.func_147764_f((Block)block, -0.5, 0.0, 0.0, block.getSideIcon());
        tessellator.func_78381_a();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockThinLogFence)) {
            return false;
        }
        return this.renderWorldBlock(world, x, y, z, (BlockThinLogFence)block, modelId, renderer);
    }

    private boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockThinLogFence block, int modelId, RenderBlocks renderer) {
        float margin = block.getMargin();
        renderer.func_147782_a((double)margin, 0.0, (double)margin, (double)(1.0f - margin), 1.0, (double)(1.0f - margin));
        renderer.func_147784_q((Block)block, x, y, z);
        IIcon sideIcon = block.getSideIcon();
        boolean connectedZNeg = block.canConnectFenceTo(world, x, y, z - 1);
        boolean connectedZPos = block.canConnectFenceTo(world, x, y, z + 1);
        boolean connectedXNeg = block.canConnectFenceTo(world, x - 1, y, z);
        boolean connectedXPos = block.canConnectFenceTo(world, x + 1, y, z);
        if (connectedXNeg || connectedXPos) {
            if (connectedXNeg && connectedXPos) {
                renderer.func_147782_a(0.0, 0.0, 0.5, 1.0, 1.0, 0.5);
            } else if (connectedXNeg) {
                renderer.func_147782_a(0.0, 0.0, 0.5, 0.5, 1.0, 0.5);
            } else if (connectedXPos) {
                renderer.func_147782_a(0.5, 0.0, 0.5, 1.0, 1.0, 0.5);
            }
            renderer.field_147842_e = true;
            renderer.func_147761_c((Block)block, (double)x, (double)y, (double)z, sideIcon);
            renderer.field_147842_e = false;
            renderer.func_147734_d((Block)block, (double)x, (double)y, (double)z, sideIcon);
        }
        if (connectedZNeg || connectedZPos) {
            if (connectedZNeg && connectedZPos) {
                renderer.func_147782_a(0.5, 0.0, 0.0, 0.5, 1.0, 1.0);
            } else if (connectedZNeg) {
                renderer.func_147782_a(0.5, 0.0, 0.0, 0.5, 1.0, 0.5);
            } else if (connectedZPos) {
                renderer.func_147782_a(0.5, 0.0, 0.5, 0.5, 1.0, 1.0);
            }
            renderer.field_147842_e = true;
            renderer.func_147764_f((Block)block, (double)x, (double)y, (double)z, sideIcon);
            renderer.field_147842_e = false;
            renderer.func_147798_e((Block)block, (double)x, (double)y, (double)z, sideIcon);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ClientProxy.thinLogFenceRenderID;
    }
}

