/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Base;

import Reika.ElectriCraft.Base.ElectriCable;
import Reika.ElectriCraft.ElectriCommon;
import Reika.ElectriCraft.Registry.ElectriTiles;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockElectriCable
extends Block {
    private IIcon center;
    private IIcon end;

    public BlockElectriCable(Material par2Material) {
        super(par2Material);
        this.func_149752_b(15.0f);
        this.func_149711_c(0.5f);
    }

    public abstract TileEntity createTileEntity(World var1, int var2);

    public final IIcon getCenterIcon() {
        return this.center;
    }

    public final IIcon getEndIcon() {
        return this.end;
    }

    public final IIcon func_149691_a(int s, int meta) {
        return this.center;
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public final boolean func_149662_c() {
        return false;
    }

    public final boolean func_149686_d() {
        return false;
    }

    public final int func_149645_b() {
        return ElectriCommon.cableRender;
    }

    public final AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return this.func_149668_a(world, x, y, z);
    }

    public final AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        double d = 0.25;
        ElectriCable te = (ElectriCable)world.func_147438_o(x, y, z);
        if (te == null) {
            return null;
        }
        float minx = te.isConnectedOnSideAt(world, x, y, z, ForgeDirection.WEST) ? 0.0f : 0.3f;
        float maxx = te.isConnectedOnSideAt(world, x, y, z, ForgeDirection.EAST) ? 1.0f : 0.7f;
        float minz = te.isConnectedOnSideAt(world, x, y, z, ForgeDirection.SOUTH) ? 0.0f : 0.3f;
        float maxz = te.isConnectedOnSideAt(world, x, y, z, ForgeDirection.NORTH) ? 1.0f : 0.7f;
        float miny = te.isConnectedOnSideAt(world, x, y, z, ForgeDirection.UP) ? 0.0f : 0.3f;
        float maxy = te.isConnectedOnSideAt(world, x, y, z, ForgeDirection.DOWN) ? 1.0f : 0.7f;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)((float)x + minx), (double)((float)y + miny), (double)((float)z + minz), (double)((float)x + maxx), (double)((float)y + maxy), (double)((float)z + maxz));
        this.setBounds(box, x, y, z);
        return box;
    }

    protected final void setBounds(AxisAlignedBB box, int x, int y, int z) {
        this.func_149676_a((float)box.field_72340_a - (float)x, (float)box.field_72338_b - (float)y, (float)box.field_72339_c - (float)z, (float)box.field_72336_d - (float)x, (float)box.field_72337_e - (float)y, (float)box.field_72334_f - (float)z);
    }

    public final void func_149695_a(World world, int x, int y, int z, Block id) {
        ElectriCable te = (ElectriCable)world.func_147438_o(x, y, z);
        te.recomputeConnections(world, x, y, z);
    }

    public final void func_149726_b(World world, int x, int y, int z) {
        ElectriCable te = (ElectriCable)world.func_147438_o(x, y, z);
        te.addToAdjacentConnections(world, x, y, z);
        te.recomputeConnections(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldid, int oldmeta) {
        ElectriCable te = (ElectriCable)world.func_147438_o(x, y, z);
        super.func_149749_a(world, x, y, z, oldid, oldmeta);
    }

    public final void func_149651_a(IIconRegister ico) {
        String s = this.getTextureIcoName();
        this.center = ico.func_94245_a("electricraft:" + s);
        this.end = ico.func_94245_a("electricraft:" + s + "_end");
    }

    protected abstract String getTextureIcoName();

    public abstract ElectriTiles getTile();

    public final Item func_149650_a(int id, Random r, int fortune) {
        return this.getTile().getCraftedProduct().func_77973_b();
    }

    public final int func_149692_a(int meta) {
        return this.getTile().getCraftedProduct().func_77960_j();
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack is = this.getTile().getCraftedProduct();
        return is;
    }
}

