/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Base;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.ElectriCraft.Auxiliary.Interfaces.NetworkTile;
import Reika.ElectriCraft.Base.ElectriTileEntity;
import Reika.ElectriCraft.ElectriCraft;
import Reika.ElectriCraft.Network.WireNetwork;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class NetworkTileEntity
extends ElectriTileEntity
implements NetworkTile {
    protected WireNetwork network;
    private boolean isConnectable = true;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!(this.getTicksExisted() != 0 && this.network != null || world.field_72995_K)) {
            this.findAndJoinNetwork(world, x, y, z);
        }
    }

    public final void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        this.isConnectable = false;
        if (this.network != null) {
            this.network.removeElement(this);
        }
    }

    @Override
    public final boolean isConnectable() {
        return this.isConnectable && !this.field_145850_b.field_72995_K && this.field_145850_b.func_72904_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void onNetworkChanged() {
    }

    @Override
    public final void findAndJoinNetwork(World world, int x, int y, int z) {
        this.network = null;
        if (!this.isConnectable) {
            return;
        }
        this.network = new WireNetwork();
        this.network.addElement(this);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            if (!this.canNetworkOnSide(dir) || !this.isChunkLoadedOnSide(dir)) continue;
            TileEntity te = this.getAdjacentTileEntity(dir);
            this.linkTile(te, dir);
        }
        this.onJoinNetwork();
    }

    private void linkTile(TileEntity te, ForgeDirection dir) {
        WorldRift sr;
        WorldLocation loc;
        if (te instanceof NetworkTileEntity) {
            WireNetwork w;
            NetworkTileEntity n = (NetworkTileEntity)te;
            if (n.canNetworkOnSide(dir.getOpposite()) && (w = n.network) != null) {
                w.merge(this.network);
            }
        } else if (te instanceof WorldRift && (loc = (sr = (WorldRift)te).getLinkTarget()) != null) {
            this.linkTile(sr.getTileEntityFrom(dir), dir);
        }
    }

    protected void onJoinNetwork() {
    }

    @Override
    public abstract boolean canNetworkOnSide(ForgeDirection var1);

    @Override
    public final WireNetwork getNetwork() {
        return this.network;
    }

    @Override
    public final void setNetwork(WireNetwork n) {
        if (n == null) {
            ElectriCraft.logger.logError((Object)(this + " was told to join a null network!"));
        } else {
            this.network = n;
            this.network.addElement(this);
        }
    }

    @Override
    public final void removeFromNetwork() {
        if (this.network == null) {
            ElectriCraft.logger.logError((Object)(this + " was removed from a null network!"));
        } else {
            this.network.removeElement(this);
        }
    }

    public final void rebuildNetwork() {
        this.removeFromNetwork();
        this.resetNetwork();
        this.findAndJoinNetwork(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public final void resetNetwork() {
        this.network = null;
    }

    @Override
    public final World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public final int getX() {
        return this.field_145851_c;
    }

    @Override
    public final int getY() {
        return this.field_145848_d;
    }

    @Override
    public final int getZ() {
        return this.field_145849_e;
    }
}

