/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Base;

import Reika.ElectriCraft.Base.WiringTile;
import Reika.RotaryCraft.API.Interfaces.Screwdriverable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityWireComponent
extends WiringTile
implements Screwdriverable {
    private ForgeDirection facing;

    @Override
    public final boolean canNetworkOnSide(ForgeDirection dir) {
        return dir == this.getFacing() || dir == this.getFacing().getOpposite();
    }

    public final ForgeDirection getFacing() {
        return this.facing != null ? this.facing : ForgeDirection.EAST;
    }

    public final void setFacing(ForgeDirection dir) {
        this.facing = dir;
    }

    public abstract boolean canConnect();

    public final AxisAlignedBB getAABB() {
        float minz;
        float miny = 0.0f;
        float maxy = this.getHeight();
        float w = this.getWidth() / 2.0f;
        ForgeDirection dir = this.getFacing();
        float maxx = dir.offsetX != 0 ? 1.0f : 0.5f + w;
        float minx = dir.offsetX != 0 ? 0.0f : 0.5f - w;
        float maxz = dir.offsetZ != 0 ? 1.0f : 0.5f + w;
        float f = minz = dir.offsetZ != 0 ? 0.0f : 0.5f - w;
        if (this.isFlipped) {
            miny = 1.0f - this.getHeight();
            maxy = 1.0f;
        }
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + minx), (double)((float)this.field_145848_d + miny), (double)((float)this.field_145849_e + minz), (double)((float)this.field_145851_c + maxx), (double)((float)this.field_145848_d + maxy), (double)((float)this.field_145849_e + maxz));
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("face", this.getFacing().ordinal());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.setFacing(this.dirs[NBT.func_74762_e("face")]);
    }

    public boolean onShiftRightClick(World world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public boolean onRightClick(World world, int x, int y, int z, ForgeDirection side) {
        this.incrementFacing();
        return true;
    }

    protected void incrementFacing() {
        int o = this.getFacing().ordinal();
        if (o == 5) {
            this.setFacing(this.dirs[2]);
        } else {
            this.setFacing(this.dirs[o + 1]);
        }
        this.rebuildNetwork();
    }

    public abstract float getHeight();

    public abstract float getWidth();
}

