/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Base;

import Reika.ElectriCraft.Base.NetworkTileEntity;
import net.minecraft.nbt.NBTTagCompound;

public abstract class WiringTile
extends NetworkTileEntity {
    private int voltage;
    private int current;

    public abstract int getResistance();

    @Override
    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    protected void onJoinNetwork() {
        this.current = this.network.getPointCurrent(this);
        this.voltage = this.network.getPointVoltage(this);
    }

    @Override
    public void onNetworkChanged() {
        this.current = this.network.getPointCurrent(this);
        this.voltage = this.network.getPointVoltage(this);
    }

    public final int getWireVoltage() {
        return this.voltage;
    }

    public final int getWireCurrent() {
        return this.current;
    }

    public final long getWirePower() {
        return (long)this.current * (long)this.voltage;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.voltage = NBT.func_74762_e("v");
        this.current = NBT.func_74762_e("a");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("a", this.current);
        NBT.func_74768_a("v", this.voltage);
    }
}

