/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Blocks;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.ModList;
import Reika.ElectriCraft.Base.ElectriBlock;
import Reika.ElectriCraft.ElectriCommon;
import Reika.ElectriCraft.Network.WireNetwork;
import Reika.ElectriCraft.Registry.WireType;
import Reika.ElectriCraft.TileEntities.TileEntityWire;
import Reika.RotaryCraft.API.Interfaces.Fillable;
import Reika.RotaryCraft.Entities.EntityDischarge;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.RotaryCraft;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"mcp.mobius.waila.api.IWailaDataProvider"})
public class BlockWire
extends ElectriBlock
implements IWailaDataProvider {
    private static final int nWires = ReikaJavaLibrary.getEnumLengthWithoutInitializing(WireType.class);
    private static final IIcon[] textures = new IIcon[nWires];
    private static final IIcon[] insulTextures = new IIcon[nWires];
    private static final IIcon[] texturesEnd = new IIcon[nWires];
    private static final IIcon[] insulTexturesEnd = new IIcon[nWires];

    public BlockWire(Material par2Material) {
        super(par2Material);
        this.func_149672_a(field_149775_l);
        this.func_149711_c(0.05f);
        this.func_149752_b(2.0f);
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityWire();
    }

    @Override
    public final int func_149645_b() {
        return ElectriCommon.wireRender;
    }

    public Item func_149650_a(int id, Random r, int fortune) {
        return null;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harv) {
        if (!player.field_71075_bZ.field_75098_d && this.canHarvest(world, player, x, y, z)) {
            this.func_149636_a(world, player, x, y, z, world.func_72805_g(x, y, z));
        }
        return world.func_147468_f(x, y, z);
    }

    public void func_149636_a(World world, EntityPlayer ep, int x, int y, int z, int meta) {
        if (!this.canHarvest(world, ep, x, y, z)) {
            return;
        }
        if (world.func_147439_a(x, y, z) == this) {
            ReikaItemHelper.dropItems((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), this.getDrops(world, x, y, z, meta, 0));
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ItemStack is;
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        TileEntityWire te = (TileEntityWire)world.func_147438_o(x, y, z);
        ItemStack itemStack = is = te.insulated ? te.getWireType().getCraftedInsulatedProduct() : te.getWireType().getCraftedProduct();
        if (is.func_77960_j() % 16 == WireType.SUPERCONDUCTOR.ordinal()) {
            is.field_77990_d = new NBTTagCompound();
            is.field_77990_d.func_74757_a("fluid", true);
            is.field_77990_d.func_74768_a("lvl", ((Fillable)is.func_77973_b()).getCapacity(is));
        }
        li.add(is);
        return li;
    }

    @Override
    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < WireType.wireList.length; ++i) {
            WireType wire = WireType.wireList[i];
            BlockWire.textures[i] = ico.func_94245_a("ElectriCraft:wire/" + wire.getIconTexture());
            BlockWire.insulTextures[i] = ico.func_94245_a("ElectriCraft:wire/" + wire.getIconTexture() + "_ins");
            BlockWire.texturesEnd[i] = ico.func_94245_a("ElectriCraft:wire/" + wire.getIconTexture() + "_end");
            BlockWire.insulTexturesEnd[i] = ico.func_94245_a("ElectriCraft:wire/" + wire.getIconTexture() + "_ins_end");
        }
    }

    public IIcon func_149691_a(int s, int meta) {
        return textures[meta];
    }

    public static IIcon getInsulatedEndTexture(WireType type) {
        return insulTexturesEnd[type.ordinal()];
    }

    public static IIcon getEndTexture(WireType type) {
        return texturesEnd[type.ordinal()];
    }

    public static IIcon getInsulatedTexture(WireType type) {
        return insulTextures[type.ordinal()];
    }

    public static IIcon getTexture(WireType type) {
        return textures[type.ordinal()];
    }

    public boolean canRenderInPass(int pass) {
        return pass == 0;
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    private boolean canHarvest(World world, EntityPlayer ep, int x, int y, int z) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block id) {
        super.func_149695_a(world, x, y, z, id);
        TileEntityWire te = (TileEntityWire)world.func_147438_o(x, y, z);
        te.recomputeConnections(world, x, y, z);
        te.checkRiftConnections();
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntityWire te = (TileEntityWire)world.func_147438_o(x, y, z);
        te.addToAdjacentConnections(world, x, y, z);
        te.recomputeConnections(world, x, y, z);
    }

    public final AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        double d = 0.25;
        TileEntityWire te = (TileEntityWire)world.func_147438_o(x, y, z);
        if (te == null) {
            return null;
        }
        float minx = te.isConnectedOnSideAt(world, x, y, z, ForgeDirection.WEST) ? 0.0f : 0.3f;
        float maxx = te.isConnectedOnSideAt(world, x, y, z, ForgeDirection.EAST) ? 1.0f : 0.7f;
        float minz = te.isConnectedOnSideAt(world, x, y, z, ForgeDirection.SOUTH) ? 0.0f : 0.3f;
        float maxz = te.isConnectedOnSideAt(world, x, y, z, ForgeDirection.NORTH) ? 1.0f : 0.7f;
        float miny = te.isConnectedOnSideAt(world, x, y, z, ForgeDirection.UP) ? 0.0f : 0.3f;
        float maxy = te.isConnectedOnSideAt(world, x, y, z, ForgeDirection.DOWN) ? 1.0f : 0.7f;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)((float)x + minx), (double)((float)y + miny), (double)((float)z + minz), (double)((float)x + maxx), (double)((float)y + maxy), (double)((float)z + maxz));
        this.setBounds(box, x, y, z);
        return box;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity e) {
        if (!world.field_72995_K && (!(e instanceof EntityPlayer) || e instanceof EntityPlayer && !((EntityPlayer)e).field_71075_bZ.field_75098_d)) {
            TileEntityWire te = (TileEntityWire)world.func_147438_o(x, y, z);
            WireNetwork net = te.getNetwork();
            if (!te.insulated && net != null && net.isLive()) {
                int v = net.getPointVoltage(te);
                EntityDischarge ed = new EntityDischarge(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, v, e.field_70165_t, e.field_70163_u, e.field_70161_v);
                world.func_72838_d((Entity)ed);
                if (!(e instanceof EntityLivingBase) || !ReikaEntityHelper.isEntityWearingFullSuitOf((EntityLivingBase)((EntityLivingBase)e), (ItemArmor.ArmorMaterial)ItemArmor.ArmorMaterial.CHAIN)) {
                    RotaryCraft.shock.lastMachine = te;
                    e.func_70097_a((DamageSource)RotaryCraft.shock, v > 10000 ? 20.0f : (v > 1000 ? 10.0f : (v > 100 ? 5.0f : (v > 10 ? 1.0f : 0.0f))));
                }
                if (e instanceof EntityCreeper) {
                    world.func_72876_a(e, e.field_70165_t, e.field_70163_u, e.field_70161_v, 3.0f, true);
                    e.func_70097_a(DamageSource.field_76376_m, 2.1474836E9f);
                }
                if (v > 100) {
                    e.func_70024_g((e.field_70165_t - (double)x) / 4.0, 0.33, (e.field_70161_v - (double)z) / 4.0);
                    e.field_70133_I = true;
                }
                SoundRegistry.SPARK.playSoundAtBlock(world, x, y, z, 1.5f, 1.0f);
                te.getNetwork().shortNetwork();
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack is;
        TileEntityWire te = (TileEntityWire)world.func_147438_o(x, y, z);
        ItemStack itemStack = is = te.insulated ? te.getWireType().getCraftedInsulatedProduct() : te.getWireType().getCraftedProduct();
        if (te.getWireType() == WireType.SUPERCONDUCTOR) {
            is.field_77990_d = new NBTTagCompound();
            is.field_77990_d.func_74757_a("fluid", true);
            is.field_77990_d.func_74768_a("lvl", 25);
        }
        return is;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public List<String> getWailaBody(ItemStack is, List<String> tip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        TileEntityWire te = (TileEntityWire)acc.getTileEntity();
        if (te instanceof TileEntityWire) {
            te.syncAllData(false);
            tip.add(String.format("Point Voltage: %dV", te.getWireVoltage()));
            tip.add(String.format("Point Current: %dA", te.getWireCurrent()));
        }
        return tip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }
}

