/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Network;

import Reika.ElectriCraft.Base.WiringTile;
import Reika.ElectriCraft.Network.WireNetwork;
import Reika.ElectriCraft.Network.WirePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraftforge.common.util.ForgeDirection;

public final class NetworkNode {
    public final int x;
    public final int y;
    public final int z;
    private final WiringTile wire;
    private final WireNetwork network;
    private final ArrayList<ForgeDirection> connections = new ArrayList();
    private final ArrayList<WirePath> paths = new ArrayList();

    NetworkNode(WireNetwork w, WiringTile te, Collection<ForgeDirection> sides) {
        this.network = w;
        this.x = te.field_145851_c;
        this.y = te.field_145848_d;
        this.z = te.field_145849_e;
        this.wire = te;
        this.connections.addAll(sides);
    }

    void addPath(WirePath p) {
        this.paths.add(p);
    }

    void removePath(WirePath p) {
        this.paths.remove(p);
    }

    public boolean connectsToSide(ForgeDirection dir) {
        return this.connections.contains(dir);
    }

    public String toString() {
        return "<" + this.x + ":" + this.y + ":" + this.z + ">";
    }

    public boolean equals(Object o) {
        if (o instanceof NetworkNode) {
            NetworkNode n = (NetworkNode)o;
            return n.wire == this.wire && n.network == this.network && n.connections.equals(this.connections);
        }
        return false;
    }

    public Collection<ForgeDirection> getDirections() {
        return Collections.unmodifiableCollection(this.connections);
    }

    public int getPaths() {
        return this.paths.size();
    }
}

