/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Network.RF;

import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.ElectriCraft.Auxiliary.ElectriNetworkEvent;
import Reika.ElectriCraft.ElectriCraft;
import Reika.ElectriCraft.ElectriNetworkManager;
import Reika.ElectriCraft.NetworkObject;
import Reika.ElectriCraft.TileEntities.ModInterface.TileEntityRFCable;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RFNetwork
implements NetworkObject {
    private final Collection<TileEntityRFCable> cables = new ArrayList<TileEntityRFCable>();
    private final HashMap<WorldLocation, EnergyInteraction> endpoints = new HashMap();
    private int energy = 0;
    private int networkLimit;
    private boolean disabled;
    private int tick;

    public void setIOLimit(int limit) {
        if (this.networkLimit != limit) {
            this.networkLimit = limit;
            for (TileEntityRFCable cable : this.cables) {
                if (cable.getRFLimit() == this.networkLimit) continue;
                cable.setRFLimit(this.networkLimit);
            }
        }
    }

    public int getIOLimit() {
        return this.networkLimit;
    }

    public RFNetwork() {
        ElectriNetworkManager.instance.addNetwork(this);
    }

    @Override
    public void tick(ElectriNetworkEvent.ElectriNetworkTickEvent evt) {
        ++this.tick;
        if (this.tick % 1000 == 0) {
            this.checkValidity();
        }
        if (!(this.disabled || this.cables.isEmpty() || this.endpoints.isEmpty())) {
            int i;
            EnergyInteraction ei;
            ArrayList<EnergyInteraction> collectibles = new ArrayList<EnergyInteraction>();
            ArrayList<EnergyInteraction> insertibles = new ArrayList<EnergyInteraction>();
            int maxCanPush = this.energy;
            Iterator<Map.Entry<WorldLocation, EnergyInteraction>> it = this.endpoints.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<WorldLocation, EnergyInteraction> e = it.next();
                ei = e.getValue();
                if (ei.valid()) {
                    maxCanPush += ei.getTotalInsertible();
                    if (ei.isCollectible()) {
                        collectibles.add(ei);
                    }
                    if (!ei.isInsertible()) continue;
                    insertibles.add(ei);
                    continue;
                }
                it.remove();
            }
            maxCanPush = Math.min(this.getIOLimit(), maxCanPush);
            for (i = 0; i < collectibles.size() && this.energy < maxCanPush; ++i) {
                ei = (EnergyInteraction)collectibles.get(i);
                int space = maxCanPush - this.energy;
                this.energy += ei.collectEnergy(space);
            }
            for (i = 0; i < insertibles.size() && this.energy > 0; ++i) {
                ei = (EnergyInteraction)insertibles.get(i);
                int add = Math.min(this.energy, 1 + this.energy / insertibles.size());
                this.energy -= ei.addEnergy(add);
            }
        }
    }

    public void checkValidity() {
        Iterator<TileEntityRFCable> it = this.cables.iterator();
        while (it.hasNext()) {
            TileEntityRFCable te = it.next();
            if (!te.func_145837_r()) continue;
            it.remove();
        }
        if (this.cables.isEmpty()) {
            this.clear(false);
        }
    }

    @Override
    public void repath(ElectriNetworkEvent.ElectriNetworkRepathEvent evt) {
    }

    public void addElement(TileEntityRFCable te) {
        if (!this.cables.contains((Object)te)) {
            this.cables.add(te);
            if (te.getRFLimit() > 0 && te.getRFLimit() != this.networkLimit) {
                this.setIOLimit(Math.min(te.getRFLimit(), this.getIOLimit()));
            }
        }
    }

    public void removeElement(TileEntityRFCable te) {
        this.cables.remove((Object)te);
        this.rebuild();
    }

    private void rebuild() {
        ElectriCraft.logger.debug((Object)("Remapping RF network " + this));
        for (TileEntityRFCable te : this.cables) {
            te.findAndJoinNetwork(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }
        this.clear(true);
    }

    public void addConnection(IEnergyConnection ih, ForgeDirection dir) {
        if (ih instanceof TileEntityRFCable) {
            return;
        }
        EnergyInteraction has = this.getInteractionFor(ih);
        if (has == null) {
            this.endpoints.put(new WorldLocation((TileEntity)ih), new EnergyInteraction(ih, new ForgeDirection[]{dir}));
        } else {
            has.addSide(dir);
        }
    }

    public void merge(RFNetwork n) {
        if (n != this) {
            ArrayList<TileEntityRFCable> li = new ArrayList<TileEntityRFCable>();
            for (TileEntityRFCable wire : n.cables) {
                li.add(wire);
            }
            for (EnergyInteraction ei : n.endpoints.values()) {
                EnergyInteraction has = this.getInteractionFor(ei.getTile());
                if (has == null) {
                    this.endpoints.put(ei.location, ei);
                    continue;
                }
                has.merge(ei);
            }
            n.clear(false);
            for (TileEntityRFCable wire : li) {
                wire.setNetwork(this);
            }
            if (n.getIOLimit() != 0 && n.networkLimit != this.networkLimit) {
                this.setIOLimit(Math.min(n.getIOLimit(), this.getIOLimit()));
            }
        }
        this.updateWires();
    }

    private EnergyInteraction getInteractionFor(IEnergyConnection tile) {
        return this.endpoints.get(new WorldLocation((TileEntity)tile));
    }

    private void updateWires() {
    }

    private void clear(boolean clearTiles) {
        if (clearTiles) {
            for (TileEntityRFCable cable : this.cables) {
                cable.resetNetwork();
            }
        }
        this.cables.clear();
        this.endpoints.clear();
        this.energy = 0;
        this.disabled = true;
        ElectriNetworkManager.instance.scheduleNetworkDiscard(this);
    }

    public String toString() {
        return this.cables.size() + ": " + this.endpoints.toString();
    }

    public int drainEnergy(int maxReceive, boolean simulate) {
        maxReceive = Math.min(maxReceive, this.getIOLimit());
        int drain = Math.min(maxReceive, this.energy);
        if (!simulate) {
            this.energy -= drain;
        }
        return drain;
    }

    public int addEnergy(int maxAdd, boolean simulate) {
        if (this.energy >= this.getIOLimit()) {
            return 0;
        }
        maxAdd = Math.min(this.getIOLimit(), maxAdd);
        if (!simulate) {
            this.energy += maxAdd;
        }
        return maxAdd;
    }

    private static class EnergyInteraction {
        private final WorldLocation location;
        private final ArrayList<ForgeDirection> sides = new ArrayList();
        private final boolean canExtract;
        private final boolean canReceive;

        private EnergyInteraction(IEnergyConnection ih, ForgeDirection ... dirs) {
            this.location = new WorldLocation((TileEntity)ih);
            for (int i = 0; i < dirs.length; ++i) {
                this.addSide(dirs[i]);
            }
            this.canExtract = ih instanceof IEnergyProvider;
            this.canReceive = ih instanceof IEnergyReceiver;
        }

        public boolean isInsertible() {
            return this.getTotalInsertible() > 0;
        }

        public boolean isCollectible() {
            return this.getTotalCollectible() > 0;
        }

        public boolean contains(IEnergyConnection tile) {
            return tile == this.getTile();
        }

        public void addSide(ForgeDirection dir) {
            if (!this.sides.contains(dir)) {
                this.sides.add(dir);
            }
        }

        public void merge(EnergyInteraction ei) {
            for (int i = 0; i < ei.sides.size(); ++i) {
                this.addSide(ei.sides.get(i));
            }
        }

        public int collectEnergy(int max) {
            if (!this.canExtract) {
                return 0;
            }
            int total = 0;
            IEnergyConnection tile = this.getTile();
            for (int i = 0; i < this.sides.size(); ++i) {
                ForgeDirection dir = this.sides.get(i);
                if (!tile.canConnectEnergy(dir)) continue;
                int collect = max - total;
                total += ((IEnergyProvider)tile).extractEnergy(dir, collect, false);
            }
            return total;
        }

        public int addEnergy(int max) {
            if (!this.canReceive) {
                return 0;
            }
            int total = 0;
            IEnergyConnection tile = this.getTile();
            for (int i = 0; i < this.sides.size(); ++i) {
                ForgeDirection dir = this.sides.get(i);
                if (!tile.canConnectEnergy(dir)) continue;
                int add = max - total;
                total += ((IEnergyReceiver)tile).receiveEnergy(dir, add, false);
            }
            return total;
        }

        public int getTotalCollectible() {
            if (!this.canExtract) {
                return 0;
            }
            int total = 0;
            IEnergyConnection tile = this.getTile();
            for (int i = 0; i < this.sides.size(); ++i) {
                ForgeDirection dir = this.sides.get(i);
                if (!tile.canConnectEnergy(dir)) continue;
                total += ((IEnergyProvider)tile).extractEnergy(dir, Integer.MAX_VALUE, true);
            }
            return total;
        }

        public int getTotalInsertible() {
            if (!this.canReceive) {
                return 0;
            }
            int total = 0;
            IEnergyConnection tile = this.getTile();
            for (int i = 0; i < this.sides.size(); ++i) {
                ForgeDirection dir = this.sides.get(i);
                if (!tile.canConnectEnergy(dir)) continue;
                total += ((IEnergyReceiver)tile).receiveEnergy(dir, Integer.MAX_VALUE, true);
            }
            return total;
        }

        public String toString() {
            return this.getTile() + " @ " + this.sides;
        }

        public boolean valid() {
            return this.getTile() != null;
        }

        private IEnergyConnection getTile() {
            TileEntity te = this.location.getTileEntity();
            return te instanceof IEnergyConnection ? (IEnergyConnection)te : null;
        }

        public boolean equals(Object o) {
            if (o instanceof EnergyInteraction) {
                EnergyInteraction ei = (EnergyInteraction)o;
                return ei.location.equals((Object)this.location) && ei.sides.equals(this.sides);
            }
            return false;
        }

        public int hashCode() {
            return this.location.hashCode() ^ this.sides.hashCode();
        }
    }
}

