/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Registry;

import Reika.DragonAPI.Instantiable.GUI.ImagedGuiButton;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.ElectriCraft.Auxiliary.ElectriBookData;
import Reika.ElectriCraft.Auxiliary.ElectriDescriptions;
import Reika.ElectriCraft.Registry.BatteryType;
import Reika.ElectriCraft.Registry.ElectriItems;
import Reika.ElectriCraft.Registry.ElectriTiles;
import Reika.ElectriCraft.Registry.WireType;
import Reika.ElectriCraft.TileEntities.TileEntityWirelessCharger;
import Reika.RotaryCraft.Auxiliary.Interfaces.HandbookEntry;
import Reika.RotaryCraft.RotaryCraft;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public enum ElectriBook implements HandbookEntry
{
    TOC("Table Of Contents", ""),
    INFO("Info", ElectriItems.BOOK.getStackOf()),
    CONVERSION("Conversion", ElectriTiles.GENERATOR.getCraftedProduct()),
    TRANSPORT("Transport", WireType.SUPERCONDUCTOR.getCraftedProduct()),
    STORAGE("Storage", BatteryType.STAR.getCraftedProduct()),
    UTILITY("Utility", ElectriTiles.TRANSFORMER.getCraftedProduct()),
    MODINTERFACE("Mod Interaction", ElectriTiles.CABLE.getCraftedProduct()),
    INTRO("Introduction", ""),
    PHYSICS("Electric Physics", Items.field_151122_aG),
    SOURCESINK("Sources and Sinks", WireType.GOLD.getCraftedInsulatedProduct()),
    NETWORKS("Electric Networks", WireType.SUPERCONDUCTOR.getCraftedInsulatedProduct()),
    LIMITS("Limits", WireType.COPPER.getCraftedProduct()),
    CONVDESC("Conversion Machines", ""),
    GENERATOR(ElectriTiles.GENERATOR),
    MOTOR(ElectriTiles.MOTOR),
    TRANSDESC("Electrical Transport", ""),
    WIRES(ElectriTiles.WIRE),
    RELAY(ElectriTiles.RELAY),
    RESISTOR(ElectriTiles.RESISTOR),
    PRECISERESISTOR(ElectriTiles.PRECISERESISTOR),
    STORAGEDESC("Electrical Storage", ""),
    BATTERY(ElectriTiles.BATTERY),
    UTILDESC("Utility Blocks", ""),
    TRANSFORMER(ElectriTiles.TRANSFORMER),
    METER(ElectriTiles.METER),
    MODDESC("Mod Interaction Devices", ""),
    RFBATT(ElectriTiles.RFBATTERY),
    RFCABLE(ElectriTiles.CABLE),
    EUSPLITTER(ElectriTiles.EUSPLIT),
    EUBATT(ElectriTiles.EUBATTERY),
    WIRELESSPAD(ElectriTiles.WIRELESSPAD);

    private final ItemStack iconItem;
    private final String pageTitle;
    private boolean isParent = false;
    private ElectriTiles machine;
    private ElectriItems item;
    public static final ElectriBook[] tabList;

    private ElectriBook() {
        this("");
    }

    private ElectriBook(ElectriTiles r) {
        this(r.getName(), r.getCraftedProduct());
        this.machine = r;
    }

    private ElectriBook(ElectriItems i) {
        this(i.getBasicName(), i.getStackOf());
        this.item = i;
    }

    private ElectriBook(ItemStack item) {
        this("", item);
    }

    private ElectriBook(String name, String s) {
        this(name);
        this.isParent = true;
    }

    private ElectriBook(String name) {
        this(name, (ItemStack)null);
    }

    private ElectriBook(String name, ElectriItems i) {
        this(name, i.getStackOf());
    }

    private ElectriBook(String name, ElectriTiles r) {
        this(name, r.getCraftedProduct());
    }

    private ElectriBook(String name, Item icon) {
        this(name, new ItemStack(icon));
    }

    private ElectriBook(String name, Block icon) {
        this(name, new ItemStack(icon));
    }

    private ElectriBook(String name, ItemStack icon) {
        this.iconItem = icon;
        this.pageTitle = name;
    }

    public static ElectriBook getFromScreenAndPage(int screen, int page) {
        if (screen < INTRO.getScreen()) {
            return TOC;
        }
        ElectriBook h = ElectriBookData.getMapping(screen, page);
        return h != null ? h : TOC;
    }

    public static void addRelevantButtons(int j, int k, int screen, List<GuiButton> li) {
        int id = 0;
        for (int i = 0; i < tabList.length; ++i) {
            if (tabList[i].getScreen() != screen) continue;
            li.add((GuiButton)new ImagedGuiButton(id, j - 20, k + id * 20, 20, 20, 0, 0, tabList[i].getTabImageFile(), RotaryCraft.class));
            ++id;
        }
    }

    public static List<ElectriBook> getEntriesForScreen(int screen) {
        ArrayList<ElectriBook> li = new ArrayList<ElectriBook>();
        for (int i = 0; i < tabList.length; ++i) {
            if (tabList[i].getScreen() != screen) continue;
            li.add(tabList[i]);
        }
        return li;
    }

    public static List<ElectriBook> getTOCTabs() {
        ArrayList<ElectriBook> li = new ArrayList<ElectriBook>();
        for (int i = 0; i < tabList.length; ++i) {
            if (!ElectriBook.tabList[i].isParent || tabList[i] == TOC) continue;
            li.add(tabList[i]);
        }
        return li;
    }

    public static List<ElectriBook> getMachineTabs() {
        ArrayList<ElectriBook> tabs = new ArrayList<ElectriBook>();
        for (int i = 0; i < tabList.length; ++i) {
            ElectriBook h = tabList[i];
            if (!h.isMachine() || h.isParent) continue;
            tabs.add(h);
        }
        return tabs;
    }

    public static ElectriBook[] getInfoTabs() {
        int size = CONVDESC.ordinal() - INTRO.ordinal() - 1;
        ElectriBook[] tabs = new ElectriBook[size];
        System.arraycopy(tabList, INTRO.ordinal() + 1, tabs, 0, size);
        return tabs;
    }

    public static List<ElectriBook> getCategoryTabs() {
        ArrayList<ElectriBook> li = new ArrayList<ElectriBook>();
        for (int i = 0; i < tabList.length; ++i) {
            if (!ElectriBook.tabList[i].isParent || tabList[i] == TOC) continue;
            li.add(tabList[i]);
        }
        return li;
    }

    public boolean isMachine() {
        return this.machine != null;
    }

    public ElectriTiles getMachine() {
        return this.machine;
    }

    public ElectriItems getItem() {
        return this.item;
    }

    public ItemStack getTabIcon() {
        return this.iconItem;
    }

    public String getData() {
        if (this == TOC) {
            return ElectriDescriptions.getTOC();
        }
        return ElectriDescriptions.getData(this);
    }

    public String getNotes(int subpage) {
        return ElectriDescriptions.getNotes(this);
    }

    public boolean sameTextAllSubpages() {
        return false;
    }

    public String getTitle() {
        if (this == WIRES) {
            return "Wires";
        }
        if (this == BATTERY) {
            return "Batteries";
        }
        return this.pageTitle;
    }

    public boolean hasMachineRender() {
        return this.isMachine();
    }

    public boolean hasSubpages() {
        return this.isMachine();
    }

    public String getTabImageFile() {
        return "/Reika/RotaryCraft/Textures/GUI/Handbook/tabs_" + TOC.name().toLowerCase(Locale.ENGLISH) + ".png";
    }

    public int getRelativeScreen() {
        int offset = this.ordinal() - this.getParent().ordinal();
        return offset / 8;
    }

    public ElectriBook getParent() {
        ElectriBook parent = null;
        for (int i = 0; i < tabList.length; ++i) {
            if (!ElectriBook.tabList[i].isParent || this.ordinal() < tabList[i].ordinal()) continue;
            parent = tabList[i];
        }
        return parent;
    }

    public boolean isParent() {
        return this.isParent;
    }

    public int getBaseScreen() {
        int sc = 0;
        for (int i = 0; i < this.ordinal(); ++i) {
            ElectriBook h = tabList[i];
            if (!h.isParent) continue;
            sc += h.getNumberChildren() / 8 + 1;
        }
        return sc;
    }

    public int getNumberChildren() {
        if (!this.isParent) {
            return 0;
        }
        int ch = 0;
        for (int i = this.ordinal() + 1; i < tabList.length; ++i) {
            ElectriBook h = tabList[i];
            if (h.isParent) {
                return ch;
            }
            ++ch;
        }
        return ch;
    }

    public int getRelativePage() {
        int offset = this.ordinal() - this.getParent().ordinal();
        return offset;
    }

    public int getRelativeTabPosn() {
        int offset = this.ordinal() - this.getParent().ordinal();
        return offset - this.getRelativeScreen() * 8;
    }

    public int getScreen() {
        return this.getParent().getBaseScreen() + this.getRelativeScreen();
    }

    public int getPage() {
        return (this.ordinal() - this.getParent().ordinal()) % 8;
    }

    public boolean isConfigDisabled() {
        return false;
    }

    public List<ItemStack> getItems(int subpage) {
        if (this == WIRES) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < WireType.wireList.length; ++i) {
                WireType w = WireType.wireList[i];
                li.add(w.getCraftedProduct());
                li.add(w.getCraftedInsulatedProduct());
            }
            return li;
        }
        if (this == BATTERY) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < BatteryType.batteryList.length; ++i) {
                BatteryType w = BatteryType.batteryList[i];
                li.add(w.getCraftedProduct());
            }
            return li;
        }
        if (this == EUSPLITTER) {
            return ReikaJavaLibrary.makeListFrom((Object)ElectriTiles.EUSPLIT.getCraftedProduct());
        }
        if (this == EUBATT) {
            return ReikaJavaLibrary.makeListFrom((Object)ElectriTiles.EUBATTERY.getCraftedProduct());
        }
        if (this == WIRELESSPAD) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < TileEntityWirelessCharger.ChargerTiers.tierList.length; ++i) {
                ItemStack is = ElectriTiles.WIRELESSPAD.getCraftedProduct();
                is.field_77990_d = new NBTTagCompound();
                is.field_77990_d.func_74768_a("tier", i);
                li.add(is);
            }
            return li;
        }
        return ReikaJavaLibrary.makeListFrom((Object)this.getMachine().getCraftedProduct());
    }

    static {
        tabList = ElectriBook.values();
    }
}

