/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.Registry;

import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.ElectriCraft.Auxiliary.ElectriStacks;
import Reika.ElectriCraft.Registry.ElectriItems;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.WorktableRecipes;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum WireType {
    STEEL(16, 64, ItemStacks.steelingot, new ModOreList[0]),
    TIN(64, 32, ElectriStacks.tinIngot, ModOreList.TIN),
    NICKEL(256, 16, ElectriStacks.nickelIngot, ModOreList.NICKEL),
    ALUMINUM(1024, 8, ElectriStacks.aluminumIngot, ModOreList.ALUMINUM),
    COPPER(4096, 2, ElectriStacks.copperIngot, ModOreList.COPPER),
    SILVER(32768, 1, ElectriStacks.silverIngot, ModOreList.SILVER),
    GOLD(65536, 4, new ItemStack(Items.field_151043_k), new ModOreList[0]),
    PLATINUM(131072, 16, ElectriStacks.platinumIngot, ModOreList.PLATINUM),
    SUPERCONDUCTOR(Integer.MAX_VALUE, 0, null, new ModOreList[0]);

    private final ItemStack material;
    private final String[] oreTypes;
    public final int maxCurrent;
    public final int resistance;
    public static final int INS_OFFSET = 16;
    public static final WireType[] wireList;

    private WireType(int max, int res, ItemStack mat, ModOreList ... ores) {
        int i;
        if (mat != null && mat.func_77973_b() == null) {
            throw new IllegalArgumentException("Null wire item!");
        }
        this.material = mat;
        this.resistance = res;
        this.maxCurrent = max;
        ArrayList<String> li = new ArrayList<String>();
        if (ores != null) {
            for (i = 0; i < ores.length; ++i) {
                String s = ores[i].getProductOreDictName();
                li.add(s);
            }
        }
        this.oreTypes = new String[li.size()];
        for (i = 0; i < li.size(); ++i) {
            this.oreTypes[i] = (String)li.get(i);
        }
    }

    public static WireType getTypeFromWireDamage(int dmg) {
        return wireList[dmg % 16];
    }

    public String getIconTexture() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public ItemStack getCraftedProduct() {
        return ElectriItems.WIRE.getStackOfMetadata(this.ordinal());
    }

    public ItemStack getCraftedInsulatedProduct() {
        return ElectriItems.WIRE.getStackOfMetadata(this.ordinal() + 16);
    }

    private ArrayList<ItemStack> getAllValidCraftingIngots() {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        li.add(this.material);
        for (int i = 0; i < this.oreTypes.length; ++i) {
            String s = this.oreTypes[i];
            ArrayList li2 = OreDictionary.getOres((String)s);
            for (ItemStack is2 : li2) {
                if (ReikaItemHelper.collectionContainsItemStack(li, (ItemStack)is2)) continue;
                li.add(is2);
            }
        }
        return li;
    }

    public void addCrafting() {
        if (this.material == null) {
            return;
        }
        int amt = DifficultyEffects.PIPECRAFT.getInt();
        ItemStack is = ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedProduct(), (int)amt);
        ItemStack is2 = ReikaItemHelper.getSizedItemStack((ItemStack)this.getCraftedInsulatedProduct(), (int)amt);
        ArrayList<ItemStack> li = this.getAllValidCraftingIngots();
        for (ItemStack in : li) {
            Object[] obj2 = new Object[]{"WIW", "WIW", "WIW", Character.valueOf('W'), Blocks.field_150325_L, Character.valueOf('I'), in};
            Object[] obj = new Object[]{"I", "I", "I", Character.valueOf('I'), in};
            WorktableRecipes.getInstance().addRecipe(is, RecipeHandler.RecipeLevel.CORE, obj);
            WorktableRecipes.getInstance().addRecipe(is2, RecipeHandler.RecipeLevel.CORE, obj2);
            if (!ConfigRegistry.TABLEMACHINES.getState()) continue;
            GameRegistry.addRecipe((ItemStack)is, (Object[])obj);
            GameRegistry.addRecipe((ItemStack)is2, (Object[])obj2);
        }
    }

    public static String getLimitsForDisplay() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < wireList.length; ++i) {
            WireType type = wireList[i];
            if (type.resistance <= 0) continue;
            sb.append(ReikaStringParser.capFirstChar((String)type.name()) + " - Resistance: " + type.resistance + " V/m;   Limit: " + type.maxCurrent + " A");
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean hasGlowLayer() {
        return this == SUPERCONDUCTOR;
    }

    static {
        wireList = WireType.values();
    }
}

