/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.TileEntities.ModInterface;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModInteract.Power.ReikaEUHelper;
import Reika.DragonAPI.ModList;
import Reika.ElectriCraft.Base.BatteryTileBase;
import Reika.ElectriCraft.Registry.ElectriItems;
import Reika.ElectriCraft.Registry.ElectriTiles;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"ic2.api.energy.tile.IEnergySink", "ic2.api.energy.tile.IEnergySource"})
public class TileEntityEUBattery
extends BatteryTileBase
implements IEnergySink,
IEnergySource {
    public static final double CAPACITY = 9.0E9;
    public static final double THROUGHPUT = 1048576.0;
    private double energy;

    @Override
    public String getDisplayEnergy() {
        return String.format("%.3f EU", this.energy);
    }

    @Override
    public long getStoredEnergy() {
        return (long)this.energy;
    }

    @Override
    public long getMaxEnergy() {
        return 9000000000L;
    }

    @Override
    public String getFormattedCapacity() {
        return String.format("%d EU", this.getMaxEnergy());
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74780_a("e", this.energy);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.energy = NBT.func_74769_h("e");
    }

    @Override
    public int getEnergyColor() {
        return 0xFFFF00;
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection dir) {
        return dir == ForgeDirection.UP;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection dir) {
        return dir != ForgeDirection.UP;
    }

    @Override
    public ElectriTiles getMachine() {
        return ElectriTiles.EUBATTERY;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
    }

    public void onFirstTick(World world, int x, int y, int z) {
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.addTileToNet();
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.IC2})
    private void addTileToNet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalidate) {
        if (!world.field_72995_K && ModList.IC2.isLoaded()) {
            this.removeTileFromNet();
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.IC2})
    private void removeTileFromNet() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
    }

    public double getOfferedEnergy() {
        return this.hasRedstoneSignal() ? Math.min(1048576.0, this.energy) : 0.0;
    }

    public void drawEnergy(double amt) {
        this.energy -= amt;
        this.energy = MathHelper.func_151237_a((double)this.energy, (double)0.0, (double)9.0E9);
    }

    public int getSourceTier() {
        return IC2Handler.getInstance().isIC2Classic() ? ReikaEUHelper.getIC2TierFromEUVoltage((double)1048576.0) : 4;
    }

    public double getDemandedEnergy() {
        return 9.0E9 - this.energy;
    }

    public int getSinkTier() {
        return this.getSourceTier();
    }

    public double injectEnergy(ForgeDirection dir, double amt, double voltage) {
        double add = Math.min(9.0E9 - this.energy, amt);
        if (add > 0.0) {
            this.energy += add;
            return amt - add;
        }
        return 0.0;
    }

    @Override
    public String getUnitName() {
        return "EU";
    }

    @Override
    public boolean isDecimalSystem() {
        return true;
    }

    @Override
    protected Item getPlacerItem() {
        return ElectriItems.EUBATTERY.getItemInstance();
    }

    @Override
    protected void setEnergy(long val) {
        this.energy = val;
    }
}

