/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.TileEntities;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ElectriCraft.Auxiliary.Interfaces.Overloadable;
import Reika.ElectriCraft.Auxiliary.Interfaces.WireEmitter;
import Reika.ElectriCraft.Auxiliary.Interfaces.WireReceiver;
import Reika.ElectriCraft.Base.NetworkTileEntity;
import Reika.ElectriCraft.Registry.ElectriTiles;
import Reika.RotaryCraft.API.Interfaces.Screwdriverable;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityTransformer
extends NetworkTileEntity
implements WireEmitter,
WireReceiver,
Screwdriverable,
TemperatureTE,
IFluidHandler,
PipeConnector,
Overloadable {
    private int Vin = 0;
    private int Ain = 0;
    private int Vout = 0;
    private int Aout = 0;
    private int Vold = 0;
    private int Aold = 0;
    private int n1 = 1;
    private int n2 = 1;
    private ForgeDirection facing;
    public static final int MAXTEMP = 1000;
    public static final int MAXCURRENT = 4096;
    private int temperature;
    private StepTimer tempTimer = new StepTimer(20);
    private final HybridTank tank = new HybridTank("transformer", 200);

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K && this.network != null) {
            boolean chg;
            this.Vin = this.network.getTerminalVoltage(this);
            this.Ain = this.network.getTerminalCurrent(this);
            boolean bl = chg = this.Vin != this.Vold || this.Ain != this.Aold;
            if (this.getTicksExisted() == 0 || chg) {
                this.calculateOutput();
                this.network.updateWires();
            }
            this.Vold = this.Vin;
            this.Aold = this.Ain;
            if (this.Ain > this.getMaxCurrent() || this.Aout > this.getMaxCurrent()) {
                this.overload(Math.max(this.Ain, this.Aout));
            }
        }
        this.tempTimer.update();
        if (this.tempTimer.checkCap()) {
            this.updateTemperature(world, x, y, z, meta);
        }
    }

    @Override
    public int getMaxCurrent() {
        return 4096;
    }

    @Override
    public void overload(int current) {
        this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 12.0f, true);
    }

    public double getRatio() {
        return (double)this.n2 / (double)this.n1;
    }

    public boolean isStepUp() {
        return this.n2 > this.n1;
    }

    public int getN1() {
        return this.n1;
    }

    public int getN2() {
        return this.n2;
    }

    public void setRatio(int n1, int n2) {
        if (n1 == 0 || n2 == 0) {
            return;
        }
        boolean f1 = n1 != this.n1;
        boolean f2 = n2 != this.n2;
        this.n1 = n1;
        this.n2 = n2;
        this.onRatioChanged(f1 || f2);
    }

    private void onRatioChanged(boolean full) {
        this.calculateOutput();
        if (full && this.network != null) {
            this.network.updateWires();
        }
    }

    public String getRatioForDisplay() {
        return String.format("%d:%d", this.n1, this.n2);
    }

    private void calculateOutput() {
        double ratio = this.getRatio();
        if (ratio == 0.0) {
            this.Aout = 0;
            this.Vout = 0;
        } else {
            this.Vout = (int)((double)this.Vin * ratio);
            this.Aout = (int)((double)this.Ain / ratio * this.getEfficiency());
        }
    }

    public double getEfficiency() {
        double r = this.getRatio();
        if (r < 1.0) {
            r = 1.0 / r;
        }
        return 1.0 / Math.pow(r, 0.1);
    }

    @Override
    public ElectriTiles getMachine() {
        return ElectriTiles.TRANSFORMER;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public boolean canNetworkOnSide(ForgeDirection dir) {
        return dir == this.getFacing() || dir == this.getFacing().getOpposite();
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("volt", this.Vin);
        NBT.func_74768_a("amp", this.Ain);
        NBT.func_74768_a("volt2", this.Vout);
        NBT.func_74768_a("amp2", this.Aout);
        NBT.func_74768_a("n1", this.n1);
        NBT.func_74768_a("n2", this.n2);
        NBT.func_74768_a("face", this.getFacing().ordinal());
        NBT.func_74768_a("temp", this.temperature);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.Vin = NBT.func_74762_e("volt");
        this.Ain = NBT.func_74762_e("amp");
        this.Vout = NBT.func_74762_e("volt2");
        this.Aout = NBT.func_74762_e("amp2");
        this.n1 = NBT.func_74762_e("n1");
        this.n2 = NBT.func_74762_e("n2");
        this.setFacing(this.dirs[NBT.func_74762_e("face")]);
        this.temperature = NBT.func_74762_e("temp");
    }

    @Override
    public boolean canReceivePowerFromSide(ForgeDirection dir) {
        return dir == this.getFacing().getOpposite();
    }

    @Override
    public boolean canReceivePower() {
        return true;
    }

    @Override
    public int getGenVoltage() {
        return this.Vout;
    }

    @Override
    public int getGenCurrent() {
        return this.Aout;
    }

    @Override
    public boolean canEmitPowerToSide(ForgeDirection dir) {
        return dir == this.getFacing();
    }

    @Override
    public boolean canEmitPower() {
        return true;
    }

    public ForgeDirection getFacing() {
        return this.facing != null ? this.facing : ForgeDirection.EAST;
    }

    public final void setFacing(ForgeDirection dir) {
        this.facing = dir;
    }

    public boolean onShiftRightClick(World world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public boolean onRightClick(World world, int x, int y, int z, ForgeDirection side) {
        this.incrementFacing();
        return true;
    }

    protected void incrementFacing() {
        int o = this.getFacing().ordinal();
        if (o == 5) {
            this.setFacing(this.dirs[2]);
        } else {
            this.setFacing(this.dirs[o + 1]);
        }
        this.rebuildNetwork();
    }

    public AxisAlignedBB getAABB() {
        int dx = Math.abs(this.getFacing().offsetX);
        int dz = Math.abs(this.getFacing().offsetZ);
        double d = 0.2875;
        double d2 = 0.0625;
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        box.field_72340_a += (double)dz * d;
        box.field_72336_d -= (double)dz * d;
        box.field_72339_c += (double)dx * d;
        box.field_72334_f -= (double)dx * d;
        box.field_72340_a += (double)dx * d2;
        box.field_72336_d -= (double)dx * d2;
        box.field_72339_c += (double)dz * d2;
        box.field_72334_f -= (double)dz * d2;
        return box;
    }

    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb;
        if (this.Aout > 0 && this.Vout > 0) {
            double ratio = this.getRatio();
            double r = ratio >= 0.0 ? ratio : 1.0 / ratio;
            double d = this.tank.getLevel() >= 50 ? 0.035 : 0.35;
            this.temperature = (int)((double)this.temperature + (d * Math.sqrt(this.Ain * this.Vin) + Math.max(0.0, ReikaMathLibrary.logbase((double)(r + 1.0), (double)2.0))));
        }
        if (this.tank.getLevel() >= 50) {
            this.tank.removeLiquid(50);
        }
        this.temperature = this.temperature > (Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z)) ? (this.temperature -= (this.temperature - Tamb) / 5) : (this.temperature += (this.temperature - Tamb) / 5);
        if (this.temperature - Tamb <= 4 && this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > 1000) {
            this.temperature = 1000;
            this.overheat(world, x, y, z);
        }
        if (this.temperature < Tamb) {
            this.temperature = Tamb;
        }
    }

    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getThermalDamage() {
        return this.temperature > 600 ? 8 : (this.temperature > 200 ? 4 : 0);
    }

    public void overheat(World world, int x, int y, int z) {
        this.field_145850_b.func_147468_f(x, y, z);
        this.field_145850_b.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, true, true);
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    public boolean canConnectToPipeOnSide(MachineRegistry m, ForgeDirection side) {
        return this.canConnectToPipe(m) && this.canIntake(side);
    }

    private boolean canIntake(ForgeDirection side) {
        return side != this.getFacing() && side != this.getFacing().getOpposite() && side.offsetY == 0;
    }

    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return this.canIntake(side) ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.NONE;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.canFill(from, resource.getFluid()) ? this.tank.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.canIntake(from) && fluid.equals(FluidRegistry.getFluid((String)"rc liquid nitrogen"));
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }

    public boolean canBeCooledWithFins() {
        return true;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    public boolean allowExternalHeating() {
        return false;
    }

    public int getMaxTemperature() {
        return 1000;
    }

    public boolean allowHeatExtraction() {
        return true;
    }

    public double heatEnergyPerDegree() {
        return 0.481 * ReikaBlockHelper.getBlockVolume((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e) * 7800.0;
    }
}

