/*
 * Decompiled with CFR 0.152.
 */
package Reika.ElectriCraft.TileEntities;

import Reika.ElectriCraft.Base.ElectriTileEntity;
import Reika.ElectriCraft.Registry.ElectriTiles;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Registry.BlockRegistry;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import java.util.Locale;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWirelessCharger
extends ElectriTileEntity
implements IEnergyHandler {
    public ForgeDirection getFacing() {
        switch (this.func_145832_p()) {
            case 0: {
                return ForgeDirection.WEST;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
            case 4: {
                return ForgeDirection.UP;
            }
            case 5: {
                return ForgeDirection.DOWN;
            }
        }
        return ForgeDirection.UP;
    }

    private IEnergyReceiver getTileEntity() {
        ForgeDirection dir = this.getFacing();
        int x = this.field_145851_c + dir.offsetX * 2;
        int y = this.field_145848_d + dir.offsetY * 2;
        int z = this.field_145849_e + dir.offsetZ * 2;
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        return te instanceof IEnergyReceiver ? (IEnergyReceiver)te : null;
    }

    public ChargerTiers getTier() {
        return ChargerTiers.tierList[this.getRealBlockMetadata()];
    }

    @Override
    public ElectriTiles getMachine() {
        return ElectriTiles.WIRELESSPAD;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from != this.getFacing();
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        IEnergyReceiver ier = this.getTileEntity();
        float f = this.getTier().efficiency;
        maxReceive = Math.min(maxReceive, this.getTier().maxThroughput);
        return ier != null ? (int)((float)ier.receiveEnergy(this.getFacing().getOpposite(), (int)((float)maxReceive * f), simulate) / f) : 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        IEnergyReceiver ier = this.getTileEntity();
        return ier != null ? ier.getEnergyStored(this.getFacing().getOpposite()) : 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        IEnergyReceiver ier = this.getTileEntity();
        return ier != null ? ier.getMaxEnergyStored(this.getFacing().getOpposite()) : 0;
    }

    public static enum ChargerTiers {
        BASIC(0.4f, 80),
        IMPROVED(0.6f, 800),
        ADVANCED(0.8f, 6000),
        HIGHTECH(0.9f, 40000),
        SUPERCONDUCTING(1.0f, Integer.MAX_VALUE);

        public final float efficiency;
        public final int maxThroughput;
        public static final ChargerTiers[] tierList;

        private ChargerTiers(float f, int th) {
            this.efficiency = f;
            this.maxThroughput = th;
        }

        public Object[] getRecipe() {
            Object[] sides = new Object[]{Blocks.field_150359_w, Blocks.field_150359_w, Blocks.field_150359_w, BlockRegistry.BLASTGLASS.getBlockInstance(), BlockRegistry.BLASTGLASS.getBlockInstance()};
            Object[] cores = new Object[]{Items.field_151137_ax, Items.field_151043_k, Items.field_151045_i, ItemStacks.redgoldingot, ItemStacks.enderium.getItem()};
            Object[] ret = new Object[]{"AEA", "SCS", "PRP", Character.valueOf('A'), ItemStacks.steelingot, Character.valueOf('E'), Items.field_151079_bi, Character.valueOf('P'), ItemStacks.basepanel, Character.valueOf('R'), ItemStacks.silicon, Character.valueOf('S'), sides[this.ordinal()], Character.valueOf('C'), cores[this.ordinal()]};
            return ret;
        }

        public String getLocalizedName() {
            return StatCollector.func_74838_a((String)("electrichargepad." + this.name().toLowerCase(Locale.ENGLISH)));
        }

        public static String getDataForDisplay() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < tierList.length; ++i) {
                ChargerTiers type = tierList[i];
                if (type == SUPERCONDUCTING) {
                    sb.append(type.getLocalizedName() + ": No limit @ 100% efficiency");
                } else {
                    sb.append(String.format("%s: Max %d RF/t @ %.0f%% efficiency", type.getLocalizedName(), type.maxThroughput, Float.valueOf(100.0f * type.efficiency)));
                }
                sb.append("\n\n");
            }
            return sb.toString();
        }

        static {
            tierList = ChargerTiers.values();
        }
    }
}

