/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.crash;

import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CrashHelper {
    static final int range = 3;
    static final char[] validLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz!\u00a3$%^&*()`\u00ac_+\"\\@'{}[]~/|<>,.?:;".toCharArray();
    static final char[] metaLetters = "0123456789ABCDEF".toCharArray();

    public static CrashReport makeDetailedCrashReport(Throwable throwable, String string, Object object, Object ... objectArray) {
        CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)string);
        crashReport.func_85058_a("Calling Thread").func_71500_a("Name", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Thread.currentThread().getName();
            }
        });
        if (object != null) {
            CrashHelper.addCallSection(object, crashReport, "Calling Object");
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object2 = objectArray[i + 1];
            CrashHelper.addCallSection(object2, crashReport, "Additional - " + objectArray[i]);
        }
        return crashReport;
    }

    public static CrashReport addSurroundingDetails(CrashReport crashReport, String string, TileEntity tileEntity) {
        if (tileEntity == null) {
            CrashReportCategory crashReportCategory = crashReport.func_85058_a("Surroundings" + (string == null ? "" : string));
            crashReportCategory.func_71507_a("Tile?", (Object)"Null");
            return crashReport;
        }
        return CrashHelper.addSurroundingDetails(crashReport, string, tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }

    public static CrashReport addSurroundingDetails(CrashReport crashReport, String string, final World world, final int n, final int n2, final int n3) {
        CrashReportCategory crashReportCategory = crashReport.func_85058_a("Surroundings" + (string == null ? "" : string));
        if (world == null) {
            crashReportCategory.func_71507_a("World", (Object)"Null");
            crashReportCategory.func_71507_a("Pos", (Object)(n + "," + n2 + "," + n3));
            return crashReport;
        }
        crashReportCategory.func_71500_a("Dim", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return String.valueOf(world.field_73011_w.field_76574_g);
            }
        });
        crashReportCategory.func_71500_a("Dim_Name", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "" + world.field_73011_w.func_80007_l();
            }
        });
        crashReportCategory.func_71507_a("Pos", (Object)(n + "," + n2 + "," + n3));
        crashReportCategory.func_71500_a("NeighbourBlocks", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                HashBiMap hashBiMap = HashBiMap.create();
                hashBiMap.put((Object)Blocks.field_150350_a, (Object)" ");
                StringBuilder stringBuilder = new StringBuilder("\n\n");
                for (int i = -3; i <= 3; ++i) {
                    for (int j = -3; j <= 3; ++j) {
                        stringBuilder.append("\t\t");
                        if (j == -3) {
                            stringBuilder.append("dy = ").append(i);
                        } else {
                            stringBuilder.append("\t");
                        }
                        stringBuilder.append("[ ");
                        for (int k = -3; k <= 3; ++k) {
                            int n5 = n + j;
                            int n22 = n2 + i;
                            int n32 = n3 + k;
                            if (world.func_72899_e(n5, n22, n32)) {
                                Block block = world.func_147439_a(n5, n22, n32);
                                stringBuilder.append(this.getNameForObject(block, (HashBiMap<Block, String>)hashBiMap));
                                int n4 = world.func_72805_g(n5, n22, n32);
                                if (n4 < 0 || n4 > 15) {
                                    stringBuilder.append('!');
                                } else if (n4 == 0 && block == Blocks.field_150350_a) {
                                    stringBuilder.append(' ');
                                } else {
                                    stringBuilder.append(metaLetters[n4]);
                                }
                            } else {
                                hashBiMap.put(null, (Object)"X");
                                stringBuilder.append("XX");
                            }
                            stringBuilder.append(" ");
                        }
                        stringBuilder.append(']').append('\n');
                    }
                    stringBuilder.append('\n');
                }
                for (Map.Entry entry : hashBiMap.entrySet()) {
                    stringBuilder.append("\t\t'");
                    stringBuilder.append((String)entry.getValue());
                    stringBuilder.append("': ");
                    Block block = (Block)entry.getKey();
                    if (block == null) {
                        stringBuilder.append("No Block Present");
                    } else {
                        stringBuilder.append(Block.field_149771_c.func_148750_c((Object)block));
                    }
                    stringBuilder.append('\n');
                }
                return stringBuilder.toString();
            }

            public String getNameForObject(Block block, HashBiMap<Block, String> hashBiMap) {
                String string = (String)hashBiMap.get((Object)block);
                if (string != null) {
                    return string;
                }
                String string2 = Block.field_149771_c.func_148750_c((Object)block);
                if (string2 != null && string2.length() > 0) {
                    String string3;
                    int n4 = string2.indexOf(58);
                    if (n4 >= 0) {
                        string2 = string2.substring(n4 + 1, string2.length());
                    }
                    if (!hashBiMap.containsValue((Object)(string3 = string2.substring(0, 1).toUpperCase()))) {
                        hashBiMap.put((Object)block, (Object)string3);
                        return string3;
                    }
                    for (char c : string2.toCharArray()) {
                        if (!Character.isUpperCase(c) || hashBiMap.containsValue((Object)String.valueOf(c))) continue;
                        hashBiMap.put((Object)block, (Object)String.valueOf(c));
                        return String.valueOf(c);
                    }
                    for (char c : string2.toCharArray()) {
                        if (hashBiMap.containsValue((Object)String.valueOf(c))) continue;
                        hashBiMap.put((Object)block, (Object)String.valueOf(c));
                        return String.valueOf(c);
                    }
                }
                for (char c : validLetters) {
                    if (hashBiMap.containsValue((Object)String.valueOf(c))) continue;
                    hashBiMap.put((Object)block, (Object)String.valueOf(c));
                    return String.valueOf(c);
                }
                string = "#" + hashBiMap.size();
                hashBiMap.put((Object)block, (Object)string);
                return string;
            }
        });
        return crashReport;
    }

    public static void addCallSection(final Object object, CrashReport crashReport, String string) {
        CrashReportCategory crashReportCategory = crashReport.func_85058_a(string);
        if (object == null) {
            crashReportCategory.func_71507_a("Null?", (Object)"Null");
            return;
        }
        if (object instanceof Enum) {
            crashReportCategory.func_71507_a("Value", (Object)(object.toString() + " . " + ((Enum)object).ordinal()));
            return;
        }
        if (object instanceof Throwable) {
            crashReportCategory.func_71499_a("Throwable", (Throwable)object);
            return;
        }
        crashReportCategory.func_71500_a("Class", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return object.getClass().getName();
            }
        });
        crashReportCategory.func_71500_a("ToString", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return object.toString();
            }
        });
        if (object instanceof TileEntity) {
            final TileEntity tileEntity = (TileEntity)object;
            tileEntity.func_145828_a(crashReportCategory);
            crashReportCategory.func_71500_a("Tile Pos", (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return String.format("%d,%d,%d", tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                }
            });
            crashReportCategory.func_71500_a("Tile NBT", (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    NBTTagCompound nBTTagCompound = new NBTTagCompound();
                    tileEntity.func_145841_b(nBTTagCompound);
                    return nBTTagCompound.toString();
                }
            });
        }
    }

    public static void addInventoryContents(CrashReport crashReport, String string, final IInventory iInventory) {
        CrashReportCategory crashReportCategory = crashReport.func_85058_a(string);
        if (iInventory == null) {
            crashReportCategory.func_71507_a("Null?", (Object)"Null");
            return;
        }
        crashReportCategory.func_71500_a("InventoryContents", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                StringBuilder stringBuilder = new StringBuilder("\n\n");
                stringBuilder.append(iInventory.toString()).append(" - ").append(iInventory.func_70302_i_());
                for (int i = 0; i < iInventory.func_70302_i_(); ++i) {
                    ItemStack itemStack;
                    stringBuilder.append(i).append(" - ");
                    try {
                        itemStack = iInventory.func_70301_a(i);
                    }
                    catch (Exception exception) {
                        stringBuilder.append("Errored - ").append(exception.toString()).append("\n");
                        continue;
                    }
                    stringBuilder.append(itemStack == null ? "Null" : itemStack.toString()).append("\n");
                }
                stringBuilder.append("\n\n");
                return stringBuilder.toString();
            }
        });
    }

    public static CrashReport makeDetailedCrashReport(Exception exception, String string) {
        return CrashHelper.makeDetailedCrashReport(exception, string, null, new Object[0]);
    }
}

